#include "stdafx.h"
#include "PresenterEngine.h"
#include "MediaTypeBuilders.h"
#include "CustomGUID.h"
#include "CMediaSessionNative.h"
#include "Direct3D9\CDirect3DNative.h"
#include "Direct3D9\DrawTexture.h"

namespace FDK
{
// public:

	PresenterEngine::PresenterEngine( HRESULT& hr )
	{
		this->m_hwnd = NULL;
		this->m_szVideo.cx = 0;
		this->m_szVideo.cy = 0;
		this->pTexture = NULL;
		this->b\v = true;
	}
	PresenterEngine::~PresenterEngine()
	{
		SAFE_COM_RELEASE( this->pTexture );
	}

	HRESULT PresenterEngine::GetService( REFGUID guidService, REFIID riid, void** ppv )
	{
		HRESULT hr = S_OK;

		if( riid == __uuidof(IDirect3DDeviceManager9) )	// { guidService == MR_VIDEO_ACCELERATION_SERVICE łȂ΂󂯂Ă͂ȂȂcc
		{
			#pragma region [ D3DDeviceManager9 LȂ炻ԂB]
			//-----------------
			IDirect3DDeviceManager9 *pd3dm = CDirect3DNative::GetDirect3DDeviceManager();
			if( pd3dm == NULL )
			{
				hr = MF_E_UNSUPPORTED_SERVICE;
			}
			else
			{
				*ppv = pd3dm;
			}
			//-----------------
			#pragma endregion
		}
		else
		{
			hr = MF_E_UNSUPPORTED_SERVICE;
		}

		return hr;
	}
	HRESULT PresenterEngine::tw肳ꂽtH[}bgp\ׂ( D3DFORMAT format )
	{
		HRESULT hr = S_OK;

		// Direct3D9Ex 擾B
		IDirect3D9Ex *pd3d9 = CDirect3DNative::GetDirect3DEx();
		if( pd3d9 == NULL )
			return D3DERR_INVALIDCALL;

		UINT uAdapter;				// A_v^
		D3DDEVTYPE type;			// foCX^Cv
		D3DDISPLAYMODE mode;		// [h
		D3DDEVICE_CREATION_PARAMETERS params;

		// foCXr擾B
		HANDLE hDevice = NULL;
		IDirect3DDevice9Ex *pDev = NULL;

		try
		{
			CDirect3DNative::tfoCXbN( true, &hDevice, &pDev );

			// foCXAfoCXA_v^EfoCX^Cv擾B

			if( pDev )
			{
				// (A) D3DfoCXς݂Ȃp[^擾B
				tFAILEDȂA( hr = pDev->GetCreationParameters( &params ) );
				uAdapter = params.AdapterOrdinal;
				type = params.DeviceType;
			}
			else
			{
				// (B) D3DfoCXȂ珉lݒB
				uAdapter = D3DADAPTER_DEFAULT;
				type = D3DDEVTYPE_HAL;
			}


			// D3D9ExAfoCX[h擾B

			tFAILEDȂA( hr = pd3d9->GetAdapterDisplayMode( uAdapter, &mode ) );


			// w肳ꂽtH[}bgÃ݂foCXA_v^AfoCX^CvAfoCX[hŗp\ԂB

			tFAILEDȂA( hr = pd3d9->CheckDeviceType( uAdapter, type, mode.Format, format, TRUE ) );
		}
		finally
		{
			CDirect3DNative::tfoCX̃bN( hDevice );
			SAFE_COM_RELEASE( pd3d9 );
		}

		return hr;	// CheckDeviceType() ̖߂lԂB
	}
	
	HRESULT PresenterEngine::SetVideoWindow( HWND hwnd )
	{
		this->m_hwnd = hwnd;	// G[`FbNȂ
		return S_OK;
	}
	HWND    PresenterEngine::GetVideoWindow()
	{
		return this->m_hwnd;
	}
	void	PresenterEngine::SetVideoSize( LONG width, LONG height )
	{
		AutoLock lock( this->csTexture );	// eNX``撆ɕύXȂ悤bN

		this->m_szVideo.cx = width;
		this->m_szVideo.cy = height;
	}
	SIZE	PresenterEngine::GetVideoSize()
	{
		return this->m_szVideo;
	}

	HRESULT PresenterEngine::CreateVideoSamples( IMFMediaType *pMediaType, CVideoSampleList& videoSampleQueue )
	{
		if( this->m_hwnd == NULL || this->m_szVideo.cx == 0 || this->m_szVideo.cy == 0 )
			return MF_E_INVALIDREQUEST;

		if( pMediaType == NULL )
			return E_INVALIDARG;


		HRESULT hr = S_OK;
		VideoTypeBuilder *pVideoType = NULL;
		UINT32 width = 0, height = 0;
		DWORD d3dFormat = 0;

		
		// eNX`bNB

		AutoLock( this->csTexture );

		try
		{
			// ȑÕ\[XƃeNX`B

			this->ReleaseResources();
			SAFE_COM_RELEASE( this->pTexture );


			// fBA^CvtH[}bg擾B

			tFAILEDȂA( hr = VideoTypeBuilder::Create( pMediaType, &pVideoType ) );	// VideoTypeBuilder 쐬
			tFAILEDȂA( hr = pVideoType->GetFourCC( &d3dFormat ) );					// fBA^CṽtH[}bg擾


			// eNX`TCY擾B

			width = this->m_szVideo.cx;
			height = this->m_szVideo.cy;


			// D3DfoCXbNB

			HANDLE hDevice = NULL;
			IDirect3DDevice9Ex *pdev = NULL;

			try
			{
				CDirect3DNative::tfoCXbN( true, &hDevice, &pdev );

				IMFSample *pVideoSample = NULL;
				IDirect3DTexture9 *pTexture = NULL;
				IDirect3DSurface9 *pSurface = NULL;
				D3DCOLOR clrBlack = D3DCOLOR_ARGB( 0xFF, 0x00, 0x00, 0x00 );

				// rfITv쐬B

				for( int i = 0; i < PRESENTER_BUFFER_COUNT; i++ )
				{
					try
					{
						// v[^peNX`쐬B
						tFAILEDȂA( hr = pdev->CreateTexture( width, height, 1, D3DUSAGE_RENDERTARGET, (D3DFORMAT) d3dFormat, D3DPOOL_DEFAULT, &pTexture, NULL ) );

						// v[^peNX`̃T[tFCX擾B
						tFAILEDȂA( hr = pTexture->GetSurfaceLevel( 0, &pSurface ) );

						// v[^pT[tFCXhԂB
						tFAILEDȂA( hr = pdev->ColorFill( pSurface, NULL, clrBlack ) );

						// v[^pT[tFCXrfITv쐬B
						tFAILEDȂA( hr = ::MFCreateVideoSampleFromSurface( pSurface, &pVideoSample ) );

						// rfITvL[փrfITvǉB
						tFAILEDȂA( hr = videoSampleQueue.InsertBack( pVideoSample ) );

						// rfITv̑փv[^peNX`蓖ĂB
						tFAILEDȂA( hr = pVideoSample->SetUnknown( MFSamplePresenter_Texture, pTexture ) );
					}
					finally
					{
						SAFE_COM_RELEASE( pVideoSample );
						SAFE_COM_RELEASE( pSurface );
						SAFE_COM_RELEASE( pTexture );
					}
				}
			}
			finally
			{
				if( hDevice != NULL )
					CDirect3DNative::tfoCX̃bN( hDevice );
			}
		}
		finally
		{
			SAFE_COM_RELEASE( pVideoType );
		}

		return S_OK;
	}
	HRESULT PresenterEngine::tTv󂯎( IMFSample* pSample, LONGLONG llTarget )
	{
		#pragma region [ \vȂiÕeNX`܂`悳ĂȂjȂ牽ȂŋAB]
		//-----------------
		bool b\v = false;

		this->cs\v.Lock();
		b\v = this->b\v;
		this->cs\v.Unlock();

		if( ! b\v )
			return S_OK;
		//-----------------
		#pragma endregion

		HRESULT hr = S_OK;
		HANDLE hDevice = NULL;
		IDirect3DDevice9 *pDevice = NULL;
		IDirect3DTexture9* pTexture = NULL;
		IUnknown* pUnknown = NULL;

		if( pSample )
		{
			// rfITvv[^peNX` IUnknown Ŏ擾B

			hr = pSample->GetUnknown( MFSamplePresenter_Texture, IID_IUnknown, (void**) &pUnknown );

			if( hr == D3DERR_DEVICELOST || hr == D3DERR_DEVICENOTRESET || hr == D3DERR_DEVICEHUNG )
			{
				this->PaintFrameWithGDI();
				return S_OK;
			}

			if( pUnknown )
			{
				// IUnknown  IDirect3DTexture9 擾B
				
				hr = pUnknown->QueryInterface( __uuidof(IDirect3DTexture9), (void**) &pTexture );

				if( hr == D3DERR_DEVICELOST || hr == D3DERR_DEVICENOTRESET || hr == D3DERR_DEVICEHUNG )
				{
					this->PaintFrameWithGDI( );
					return S_OK;
				}


				// 擾eNX`̃|C^ɕۊǁB

				this->csTexture.Lock();					// eNX``悳Ȃ悤bN

				SAFE_COM_RELEASE( this->pTexture );		// ȑÕ|C^͉B
				this->pTexture = pTexture;				// V|C^ۊǁB
				this->pTexture->AddRef();				// QƃJE^B

				this->csTexture.Unlock();


				// \v OFF B

				this->cs\v.Lock();
				this->b\v = false;
				this->cs\v.Unlock();
			}
		}
		else
		{
			// TvȂƂ͉ȂB
		}

		SAFE_COM_RELEASE( pTexture );
		SAFE_COM_RELEASE( pUnknown );

		return S_OK;
	}
	void	PresenterEngine::t̃Tvv()
	{
		this->cs\v.Lock();
		this->b\v = true;
		this->cs\v.Unlock();
	}
	void	PresenterEngine::tTv`悷( LPRECT prcSrc, LPRECT prcDest, UINT32 ux, UINT32 uZ )
	{
		if( this->pTexture == NULL )
			return;

		AutoLock lock( this->csTexture );		// eNX`ȂтɃTCYύXȂ悤bN

		RECT rcSrc;
		RECT rcDest;


		// ]`

		if( prcSrc )
		{
			rcSrc = *prcSrc;
		}
		else
		{
			rcSrc.left = 0;
			rcSrc.top = 0;
			rcSrc.right = this->m_szVideo.cx;
			rcSrc.bottom = this->m_szVideo.cy;
		}


		// ]` rcDest 

		if( prcDest && !::IsRectEmpty( prcDest ) )
			rcDest = *prcDest;
		else
			rcDest = rcSrc;


		// g嗦

		float fg嗦X = (float)(rcDest.right - rcDest.left) / (float)(rcSrc.right - rcSrc.left);
		float fg嗦Y = (float)(rcDest.bottom - rcDest.top) / (float)(rcSrc.bottom - rcSrc.top);


		// `B

		IDirect3DDevice9Ex *pDevice = CDirect3DNative::GetDirect3DDevice9Ex();		// foCX MF ɂăbNĂƂOB
		try
		{
			DrawTexture::t2D`( pDevice, this->pTexture, (int) ux, ( ( uZ != 0 ) ? true : false ), fg嗦X, fg嗦Y, rcDest.left, rcDest.top );
		}
		finally
		{
			SAFE_COM_RELEASE( pDevice );
		}
	}

	UINT	PresenterEngine::RefreshRate()
	{
		return CDirect3DNative::GetDirect3DDisplayMode().RefreshRate;
	}
	void	PresenterEngine::ReleaseResources()
	{
		// ɂȂB
	}


// protected:

	void PresenterEngine::PaintFrameWithGDI()
	{
		HDC hdc = ::GetDC( this->m_hwnd );

		if( hdc )
		{
			HBRUSH hBrush = ::CreateSolidBrush( RGB( 0, 0, 0 ) );

			if( hBrush )
			{
				RECT rc;
				::GetClientRect( m_hwnd, &rc );
				::FillRect( hdc, &rc, hBrush );
				::DeleteObject( hBrush );
			}

			::ReleaseDC( m_hwnd, hdc );
		}
	}
}
