#pragma once

namespace FDK
{
	// IMFAsyncCallback ̓ȎB
	//
	// R[obN̎̑ɁAuevIuWFNgƂ́u\bhvw肷邱ƂłA
	// IMFAsyncCallback::Invoke ɂ́Áuev́u\bhvĂяoB
	template<class T>	// T ͐eIuWFNǧ^BIUnknown Ă邱ƁB
	private class AsyncCallback : public IMFAsyncCallback
	{
	public: 

		typedef HRESULT( T::*InvokeFn )( IMFAsyncResult *pAsyncResult );

		T *m_pParent;
		InvokeFn m_pInvokeFn;

		// RXgN^ŁAIMFAsyncCallback eCX^XƁAIMFAsyncCallback::Invoke ̌Ăяow肷B
		AsyncCallback( T *pParent, InvokeFn fn )
		{
			Debug::Assert( pParent != NULL );

			this->m_pParent = pParent;
			this->m_pInvokeFn = fn;
		}
		~AsyncCallback()
		{
		}

		#pragma region [ IUnknown ̎ ]
		//-----------------
		STDMETHODIMP_( ULONG ) AddRef()
		{
			// eNX֊ۓB
			return m_pParent->AddRef();
		}
		STDMETHODIMP_( ULONG ) Release()
		{
			// eNX֊ۓB
			return m_pParent->Release();
		}
		STDMETHODIMP QueryInterface( REFIID iid, void** ppv )
		{
			if( ppv == NULL )
				return E_POINTER;

			if( iid == __uuidof( IUnknown ) )
			{
				*ppv = static_cast<IUnknown*>( static_cast<IMFAsyncCallback*>( this ) );
			}
			else if( iid == __uuidof( IMFAsyncCallback ) )
			{
				*ppv = static_cast<IMFAsyncCallback*>( this );
			}
			else
			{
				*ppv = NULL;
				return E_NOINTERFACE;
			}

			this->AddRef();

			return S_OK;
		}
		//-----------------
		#pragma endregion

		#pragma region [ IMFAsyncCallback ̎ ]
		//-----------------
		STDMETHODIMP GetParameters( DWORD *pdwFlags, DWORD *pdwQueue )
		{
			// IvVȂ̂ŖB
			return E_NOTIMPL;
		}
		STDMETHODIMP Invoke( IMFAsyncResult *pAsyncResult )
		{
			return ( m_pParent->*m_pInvokeFn )( pAsyncResult );
		}
		//-----------------
		#pragma endregion
	};
}
