﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.起動
{
	/// <remarks>
	/// 入力：なし
	/// 出力：なし
	/// </remarks>
	class 起動ステージ : SST.ステージ.ステージ
	{
		public enum フェーズ
		{
			初期状態,
			開始,
			フェードイン,
			表示中,
			フェードアウト,
			終了,
		}

		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		public 起動ステージ()
		{
			this.子リスト.Add( this._背景画像 = new 画像( @"$(Static)\images\起動画面.jpg" ) );
			this.子リスト.Add( this._フェードインアウト兼用パネル = new 画像( @"$(Static)\images\パネル黒64x64.png" ) );
			this.子リスト.Add( this._フェードイン = new フェードイン( 総フェード時間sec: 1.0f ) );
			this.子リスト.Add( this._フェードアウト = new フェードアウト( 総フェード時間sec: 1.0f ) );
		}

		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "起動ステージを開始します。" );
			this.現在のフェーズ = フェーズ.開始;
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "起動ステージを終了します。" );
		}

		public override void 進行描画する( デバイスリソース dr )
		{
			if( this.現在のフェーズ == フェーズ.終了 )
				return;

			// 描画。

			switch( this.現在のフェーズ )
			{
				case フェーズ.開始:
					#region " フェードインを開始する。"
					//-----------------
					this._フェーズカウンタ = new FDK.カウンタ.単純増加後不変カウンタ( 最初の値: 0, 最後の値: 1, 値をひとつ増加させるのにかける時間ms: 1000 );
					this._フェードイン.開始する();
					
					// 次のフェーズへ。
					this.現在のフェーズ = フェーズ.フェードイン;
					//-----------------
					#endregion
					break;

				case フェーズ.フェードイン:
					#region " 背景画像とフェードインを描画する。"
					//-----------------
					this._背景画像.描画する( dr, 0f, 0f );
					this._フェードイン.進行描画する( dr, this._フェードインアウト兼用パネル );
					//-----------------
					#endregion
					#region " 持ち時間に達したら次のフェーズへ。"
					//-----------------
					if( this._フェーズカウンタ.終了値に達した )
					{
						this._フェーズカウンタ.開始する( 最初の値: 0, 最後の値: 2, 値をひとつ増加させるのにかける時間ms: 1000 );
						this.現在のフェーズ = フェーズ.表示中;
					}
					//-----------------
					#endregion
					break;

				case フェーズ.表示中:
					#region " 背景画像を表示する。"
					//-----------------
					this._背景画像.描画する( dr, 0f, 0f );
					//-----------------
					#endregion
					#region " 持ち時間に達したら次のフェーズへ。"
					//-----------------
					if( this._フェーズカウンタ.終了値に達した )
					{
						this._フェーズカウンタ.開始する( 最初の値: 0, 最後の値: 2, 値をひとつ増加させるのにかける時間ms: 1000 );
						this._フェードアウト.開始する();
						this.現在のフェーズ = フェーズ.フェードアウト;
					}
					//-----------------
					#endregion
					break;

				case フェーズ.フェードアウト:
					#region " 背景画像とフェードアウトを表示する。"
					//-----------------
					this._背景画像.描画する( dr, 0f, 0f );
					this._フェードアウト.進行描画する( dr, this._フェードインアウト兼用パネル );
					//-----------------
					#endregion
					#region " 持ち時間に達したら実行完了。"
					//-----------------
					if( this._フェーズカウンタ.終了値に達した )
					{
						this.現在のフェーズ = フェーズ.終了;
					}
					//-----------------
					#endregion
					break;
			}

			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// Enter 押下 → このステージを抜ける。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Return ) )
			{
				FDK.Log.Info( "起動ステージをスキップします。" );
				this.現在のフェーズ = フェーズ.終了;
			}
		}

		private FDK.カウンタ.単純増加後不変カウンタ _フェーズカウンタ = null;

		private readonly FDK.メディア.画像 _背景画像;

		private readonly FDK.メディア.画像 _フェードインアウト兼用パネル;

		private readonly SST.ステージ.フェードイン _フェードイン;

		private readonly SST.ステージ.フェードアウト _フェードアウト;
	}
}
