﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.演奏
{
	/// <summary>
	///		羽を回転させる点フラッシュ。
	/// </summary>
	class 回転羽 : FDK.Activity
	{
		public 回転羽( int 最大同時発火数 )
		{
			this.子リスト.Add( this._羽画像 = new 画像( @"$(Static)\images\Chip Fire.png" ) );
			this._羽画像.加算合成 = true;

			this._コンテキスト = new コンテキスト[ 最大同時発火数 * 8 ];  // 1発火につき羽を大小 8 枚使う
		}

		public void 発火する( SSTFormat.チップ種別 chipType )
		{
			lock( this._スレッド間同期 )
			{
				var レーン種別 = chipType.対応するヒットレーン種別を返す();

				if( ヒットレーン種別.Unknown != レーン種別 )
					this.発火する( new SharpDX.Vector2( レーン種別.レーンの中央X位置dpx(), 座標.判定バーの中央Y座標dpx ) );
			}
		}

		public void 発火する( SharpDX.Vector2 中央位置dpx )
		{
			lock( this._スレッド間同期 )
			{
				float 開始角度 = StrokeStyleT.乱数.Next( 360 );

				// 羽を、小羽大羽あわせて 8 枚登録。
				int i = 0;
				for( int 羽番号 = 0; 羽番号 < 8; 羽番号++ ) // 0～3:大羽、4～7:小羽、計８枚。
				{
					for( ; i < this._コンテキスト.Length; i++ )    // 空いているコンテキストを探す。
					{
						if( false == this._コンテキスト[ i ].使用中 )
						{
							this._コンテキスト[ i ].使用中 = true;
							this._コンテキスト[ i ].中央位置dpx = 中央位置dpx;
							this._コンテキスト[ i ].回転開始角度 = SharpDX.MathUtil.DegreesToRadians( 開始角度 + ( 羽番号 * 90.0f ) );  // 回転開始角度 = 0, 90, 180, 270, 0, 90, 180, 270
							this._コンテキスト[ i ].回転速度 = ( 羽番号 < 4 ) ? -1.5f : 1.5f; // 小羽と大羽は反対の方向に回転する
							this._コンテキスト[ i ].サイズ = ( 羽番号 < 4 ) ? 1.0f : 0.6f;   // 小羽は大羽の0.6倍
							this._コンテキスト[ i ].進行カウンタ = new FDK.カウンタ.単純増加後不変カウンタ( 最初の値: 0, 最後の値: 70, 値をひとつ増加させるのにかける時間ms: 3 );    // 0 to 70 (210ms)
							break;
						}
					}
				}
			}
		}

		protected override void On活性化( デバイスリソース dr )
		{
			// 全コンテキストを初期化。
			for( int i = 0; i < this._コンテキスト.Length; i++ )
			{
				this._コンテキスト[ i ] = new コンテキスト() {
					使用中 = false,
					進行カウンタ = null,
				};
			}
		}

		protected override void On非活性化( デバイスリソース dr )
		{
		}

		public void 進行描画する( デバイスリソース dr )
		{
			lock( this._スレッド間同期 )
			{
				for( int i = 0; i < this._コンテキスト.Length; i++ )
				{
					var context = this._コンテキスト[ i ];

					if( false == context.使用中 )
						continue;   // 未使用の羽はスキップする。

					// 進行が終了した羽は未使用状態に戻す。
					if( context.進行カウンタ.終了値に達した )
					{
						context.進行カウンタ.一時停止する();
						context.使用中 = false;
						continue;
					}

					// 現在の進行カウンタの進行割合に応じて、Z軸回転率・幅拡大率・移動量を計算する。
					float 進行割合0to1 = context.進行カウンタ.現在値の割合;
					float Z軸回転率 = context.回転開始角度 + ( context.回転速度 * SharpDX.MathUtil.DegreesToRadians( 60.0f * 進行割合0to1 ) ); // 0→1 のとき 0→60度（等速で）
					float 幅拡大率 = (float) ( ( 0.1 + 0.9 * Math.Cos( 進行割合0to1 * Math.PI / 2.0 ) ) * context.サイズ );    // 0→1 のとき 1.0→0.1（加速しながら）
					float 平行移動量 = (float) ( Math.Sin( 進行割合0to1 * Math.PI / 2.0 ) * context.サイズ * 10.0f ); // 0→1 のとき 0→サイズ（減速しながら）

					// １枚描画する。
					var 変換行列2D =
						dr.拡大行列DPXtoPX  // スケーリング(1) DPX → PX
						* SharpDX.Matrix3x2.Translation( 平行移動量, 平行移動量 )  // 物理単位。
						* SharpDX.Matrix3x2.Scaling( 0.2f + 幅拡大率, 0.2f + context.サイズ )  // スケーリング(2)
						* SharpDX.Matrix3x2.Rotation( Z軸回転率 )   // 画像の左上端が中心。
						* SharpDX.Matrix3x2.Translation( context.中央位置dpx.X * dr.拡大率DPXtoPX横方向, context.中央位置dpx.Y * dr.拡大率DPXtoPX縦方向 );   // 物理単位。

					this._羽画像.描画する( dr, 変換行列2D );
				}
			}
		}

		private class コンテキスト
		{
			public bool 使用中;
			public SharpDX.Vector2 中央位置dpx;
			public float 回転開始角度;
			public float 回転速度;
			public float サイズ;
			public FDK.カウンタ.単純増加後不変カウンタ 進行カウンタ;
		}

		private コンテキスト[] _コンテキスト = null;

		private FDK.メディア.画像 _羽画像 = null;

		private readonly object _スレッド間同期 = new object();
	}
}
