﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK;	// for string 拡張
using FDK.メディア;

namespace SST.ステージ.曲読込
{
	/// <remarks>
	/// 入力：
	/// 　　Func<string> 読込曲のファイルパスを取得する（null 可）
	/// 　　StrokeStyleT.ユーザ管理.現在選択されているユーザ（コンフィグ情報）
	/// 　　
	/// 出力：
	/// 　　StrokeStyleT.演奏スコア（ファイルパスが null だったならこちらも null になる）
	/// </remarks>
	class 曲読込ステージ : SST.ステージ.ステージ
	{
		public Func<string> 読込曲のファイルパスを取得する = null;

		public enum フェーズ { 初期状態, 読込中, 終了 }

		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "曲読込ステージを開始します。" + ( StrokeStyleT.ビュアーモードである ? "(ViewerMode)" : "" ) );
			Trace.Assert( null != this.読込曲のファイルパスを取得する, "[バグあり] 活性化の前に外部依存アクションを接続してください。" );

			// 未解放なら解放する。念のため。
			StrokeStyleT.演奏スコア?.Dispose();

			this.現在のフェーズ = フェーズ.読込中;
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "曲読込ステージを終了します。" );
		}

		public override void 進行描画する( デバイスリソース dr )
		{
			switch( this.現在のフェーズ )
			{
				case フェーズ.読込中:
					{
						// SSTFファイルを読み込んでスコアを構築。
						string 選択曲ファイルパス = this.読込曲のファイルパスを取得する();

						if( 選択曲ファイルパス.Nullでも空でもない() )
						{
							var user = StrokeStyleT.ユーザ管理.現在選択されているユーザ;

							StrokeStyleT.演奏スコア = new SSTFormat.スコア(
								SST.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( 選択曲ファイルパス ),
								user.Rideは左,
								user.Chinaは左,
								user.Splashは左 );

							// サウンドデバイス遅延を全チップの発声時刻へ反映する。
							float 作成時遅延ms = StrokeStyleT.演奏スコア.Header.サウンドデバイス遅延ms;
							if( 0f < 作成時遅延ms )
							{
								float 再生時遅延ms = (float) ( StrokeStyleT.サウンドデバイス.遅延sec * 1000.0 );
								long 加算分ms = (long) ( 作成時遅延ms - 再生時遅延ms );  // 例: 作成時遅延 7ms, 再生時遅延 10ms の場合、発声時刻に 7-10 = -3ms 加算する（3ms 早く発声させる）。

								FDK.Log.Info( $"作成時遅延={作成時遅延ms}ms, 再生時遅延={再生時遅延ms}ms => 加算分 = {加算分ms}ms" );

								foreach( var chip in StrokeStyleT.演奏スコア.チップリスト )
									chip.発声時刻ms += 加算分ms;
							}
							else
							{
								FDK.Log.WARNING( $"この曲ファイルには 作成時遅延(SoundDevice.Delay) の指定がありません。演奏時に音ズレを起こす可能性があります。" );
							}
						}
						else
						{
							// ビュアーモードの起動直後ならこちら。
							StrokeStyleT.演奏スコア = null;
						}

						// フェーズ終了。
						this.現在のフェーズ = フェーズ.終了;
					}
					break;
			}
		}
	}
}
