﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.ServiceModel;

namespace SST
{
	/// <summary>
	///		SST がサービスとして公開するインターフェースを定義する。
	/// </summary>
	[ServiceContract]
	public interface IStrokeStyleTService
	{
		/// <summary>
		///		曲を読み込み、演奏を開始する。
		/// </summary>
		/// <remarks>
		///		ビュアーモードのときのみ有効。
		/// </remarks>
		/// <param name="path">
		///		曲ファイルパス
		///	</param>
		/// <param name="startPart">
		///		演奏開始小節番号(0～)
		///	</param>
		/// <param name="drumsSound">
		///		ドラムチップ音を発声させるなら true。
		/// </param>
		[OperationContract]
		void ViewerPlay( string path, int startPart = 0, bool drumsSound = true );

		/// <summary>
		///		現在の演奏を停止する。
		/// </summary>
		/// <remarks>
		///		ビュアーモードのときのみ有効。
		/// </remarks>
		[OperationContract]
		void ViewerStop();

		/// <summary>
		///		サウンドデバイスの発声遅延[ms]を返す。
		/// </summary>
		/// <returns>
		///		遅延量[ms]
		///	</returns>
		[OperationContract]
		float GetSoundDelay();
	}
}
