﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using FDK.メディア;

namespace SST.曲
{
	/// <summary>
	///		曲ツリーへの参照を受け取り、その曲ツリーに対する様々な操作を提供する。
	/// </summary>
	/// <remarks>
	///		ビュアーモード時は、現在の対象管理ツリー = null とし、現在選択されているノード に直接生成した MusicNode を設定する。
	/// </remarks>
	public class 曲ツリー管理 : FDK.Activity
	{
		/// <summary>
		///		曲ツリー（Nodeのツリー）のルートノード。
		/// </summary>
		/// <remarks>
		///		ツリー自体は、このクラスの外で構築し、保持すること。
		///		ルートノードは、ツリー内で唯一の RootNode 型であること。
		///		ビュアーモード時は null とする。
		/// </remarks>
		public RootNode 現在の管理対象ツリー
		{
			get
			{
				return this._現在の管理対象ツリー;
			}
			set
			{
				this._現在の管理対象ツリー = value;

				// 曲ツリーの子リストの先頭ノードを選択ノードとしてセットする。
				if( null != value )
				{
					this.現在選択されているノード = ( 0 < value.子ノードリスト.Count ) ? value.子ノードリスト[ 0 ] : null;
				}
				else
				{
					// ビュアーモードなら、選択ノードは null 。
					this.現在選択されているノード = null;
				}

			}
		}

		/// <remarks>
		///		ビュアーモード時は、このプロパティに直接ノード(MusicNode)を指定する。
		/// </remarks>
		public Node 現在選択されているノード { get; set; } = null;

		public void 前のノードを選択する()
		{
			this.現在選択されているノード = this.現在選択されているノード?.前のノード;
		}

		public void 次のノードを選択する()
		{
			this.現在選択されているノード = this.現在選択されているノード?.次のノード;
		}

		public static void フォルダから曲を再帰的に検索して子ノードリストに追加する( Node 追加対象ノード, string フォルダパス )
		{
			// フォルダが存在しないなら何もしない。
			if( false == Directory.Exists( フォルダパス ) )
			{
				FDK.Log.WARNING( $"指定されたフォルダが存在しません。無視します。[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( フォルダパス )}]" );
				return;
			}
			var dirInfo = new DirectoryInfo( フォルダパス );

			// (1) このフォルダにあるすべてのsstfファイルから、曲ノードを作成する。
			foreach( var fileInfo in dirInfo.GetFiles( "*.sstf", SearchOption.TopDirectoryOnly ) )
			{
				追加対象ノード.子ノードリスト.Add( new MusicNode( fileInfo.FullName, 追加対象ノード ) );
			}

			// (2) このフォルダのすべてのサブフォルダについて……
			foreach( var subDirInfo in dirInfo.GetDirectories() )
			{
				// box.def を含むフォルダの場合 → BOX ノードを作成する。
				var boxファイルパス = Path.Combine( subDirInfo.FullName, @"box.def" );
				if( File.Exists( boxファイルパス ) )
				{
					追加対象ノード.子ノードリスト.Add( new BoxNode( boxファイルパス, 追加対象ノード ) );
				}

				// サブフォルダへ再帰。（通常フォルダでもBOXフォルダでも。）
				曲ツリー管理.フォルダから曲を再帰的に検索して子ノードリストに追加する( 追加対象ノード, subDirInfo.FullName );
			}
		}

		protected override void On活性化( デバイスリソース dr )
		{
			if( null != this._現在の管理対象ツリー )
			{
				// 子リストに含まれる全ノードを子Activityリストに追加する。
				foreach( var node in this._現在の管理対象ツリー.子ノードリスト )
					this.子リスト.Add( node );
			}
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			if( null != this._現在の管理対象ツリー )
			{
				// 子リストに含まれる全ノードを子Activityリストから削除する。
				foreach( var node in this._現在の管理対象ツリー.子ノードリスト )
					this.子リスト.Remove( node );
			}
		}

		private RootNode _現在の管理対象ツリー = null;
	}
}
