﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using FDK.メディア;

namespace SST.曲
{
	/// <summary>
	///		曲ツリーで「曲」を表すノード。
	/// </summary>
	public class MusicNode : Node
	{
		public string sstfファイルパス { get; protected set; } = null;

		public string 動画ファイルパス { get; protected set; } = null;

		public MusicNode()
		{
		}

		public MusicNode( string sstfファイルパス, Node 親ノード = null )
			: this()
		{
			this.sstfファイルパス = FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( sstfファイルパス );
			this.親ノード = 親ノード;

			#region " sstf ファイルから情報を取得する。"
			//----------------
			using( var score = new SSTFormat.スコア() )
			{
				score.曲データファイルを読み込む_ヘッダだけ( this.sstfファイルパス );
				this.タイトル = score.Header.曲名;
			}
			//----------------
			#endregion
			#region " sstf と同じ場所に画像ファイルがあるなら、それをサムネイル画像として採用する。"
			//----------------
			var サムネイル画像ファイルパス =
				( from ファイル名 in Directory.GetFiles( Path.GetDirectoryName( this.sstfファイルパス ) )
				  where this._対応するサムネイル画像名.Any( thumbファイル名 => ( Path.GetFileName( ファイル名 ).ToLower() == thumbファイル名 ) )
				  select ファイル名 ).FirstOrDefault();

			if( null != サムネイル画像ファイルパス )
				this._サムネイル画像 = new テクスチャ( サムネイル画像ファイルパス );
			//----------------
			#endregion
			#region " sstf と同じ場所に（対応する拡張子を持った）動画ファイルがあるなら、それを背景動画として採用する。"
			//----------------
			this.動画ファイルパス =
				( from ファイル名 in Directory.GetFiles( Path.GetDirectoryName( this.sstfファイルパス ) )
				  where _対応する動画の拡張子.Any( 拡張子名 => ( Path.GetExtension( ファイル名 ).ToLower() == 拡張子名 ) )
				  select ファイル名 ).FirstOrDefault();
			//----------------
			#endregion
		}

		protected override void On活性化( デバイスリソース dr )
		{
			if( null != this._サムネイル画像 )
				this.子リスト.Add( this._サムネイル画像 );  // 子リストに追加。

			base.On活性化( dr );	// Node の活性化
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			if( null != this._サムネイル画像 )
				this.子リスト.Remove( this._サムネイル画像 );	// 子リストから削除。

			base.On非活性化( dr );   // Node の非活性化
		}

		public override void ノード画像を描画する( デバイスリソース dr, SharpDX.Matrix ワールド変換行列 )
		{
			this._サムネイル画像?.描画する( dr, ワールド変換行列 );
		}

		private FDK.メディア.テクスチャ _サムネイル画像 = null;

		private readonly string[] _対応する動画の拡張子 = { ".mp4", ".avi" };

		private readonly string[] _対応するサムネイル画像名 = { "thumb.png", "thumb.bmp", "thumb.jpg", "thumb.jpeg" };
	}
}
