﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.結果
{
	/// <summary>
	/// 入力：
	/// 　Action BGMを終了する
	/// 　Func<SST.ステージ.演奏.演奏ステージ> 演奏ステージインスタンスを取得する
	/// 　
	/// 出力：
	/// 　なし
	/// </summary>
	class 結果ステージ : ステージ
	{
		public enum フェーズ
		{
			初期状態,
			表示中,
			終了,
		}

		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		public Action BGMを停止する = null;

		public Func<SST.ステージ.演奏.演奏ステージ> 演奏ステージインスタンスを取得する = null;

		public 結果ステージ()
		{
			this.子リスト.Add( this._背景動画 = new 動画( @"$(Static)\images\結果画面BGV.mp4", StrokeStyleT.Config.動画デコーダのキューサイズ ) );
			this.子リスト.Add( this._背景画像 = new 画像( @"$(Static)\images\結果画面 背景.png" ) );
			this.子リスト.Add( this._結果表示パラメータパネル = new 画像( @"$(Static)\images\結果画面 パラメータパネル.png" ) );
			this.子リスト.Add( this._結果表示パラメータ = new 画像フォント( @"$(Static)\images\結果画面 パラメータフォント.png", @"$(Static)\images\結果画面 パラメータフォント矩形リスト.xml" ) );
		}

		public override void 進行描画する( デバイスリソース dr )
		{
			if( this._活性化した直後である )
			{
				this._背景動画.再生を開始する( 開始位置sec: 0.0, ループ再生する: true );
				this._活性化した直後である = false;
			}

			// 進行描画。

			this._背景動画.進行描画する( dr, new SharpDX.RectangleF( 0f, 0f, dr.設計画面サイズdpx.Width, dr.設計画面サイズdpx.Height ) );
			this._背景画像.描画する( dr, 0f, 0f );

			#region " 結果表示パラメータ "
			//----------------
			this._結果表示パラメータパネル.描画する( dr, 60f, 196f );

			var 演奏ステージ = this.演奏ステージインスタンスを取得する();
			var hitTypes = new[] { 演奏.ヒット判定種別.PERFECT, 演奏.ヒット判定種別.GREAT, 演奏.ヒット判定種別.GOOD, 演奏.ヒット判定種別.POOR, 演奏.ヒット判定種別.MISS, 演奏.ヒット判定種別.AUTO };

			int 総数 = 0;
			foreach( var hitType in hitTypes )
				総数 += 演奏ステージ.ヒットした回数[ hitType ];

			float Xdpx = 360f;
			float Ydpx = 230f;
			foreach( var hitType in hitTypes )
			{
				int 回数 = 演奏ステージ.ヒットした回数[ hitType ];
				double 割合 = ( 0 < 総数 ) ? ( 回数 * 100.0 / 総数 ) : 0.0;
				this._結果表示パラメータ.描画する( dr, Xdpx, Ydpx, $"{回数:00000}({割合:000.0}%)" );
				Ydpx += 71f;
			}
			//----------------
			#endregion

			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// Enter or ESC 押下 → ステージ終了。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Return ) ||
				StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Escape ) )
			{
				this.現在のフェーズ = フェーズ.終了;
			}
		}

		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "結果ステージを開始します。" );

			this.現在のフェーズ = フェーズ.表示中;
			this._活性化した直後である = true;
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "結果ステージを終了します。" );

			this.BGMを停止する?.Invoke();    // ここでBGMを終了する。
		}

		private bool _活性化した直後である = false;

		private FDK.メディア.動画 _背景動画;

		private FDK.メディア.画像 _背景画像;

		private FDK.メディア.画像 _結果表示パラメータパネル;

		private FDK.メディア.画像フォント _結果表示パラメータ;
	}
}
