﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ
{
	/// <summary>
	///		フェードイン用のタイル画像を表示する。
	/// </summary>
	/// <remarks>
	///		パネル画像（任意）の透明度を徐々に薄くしていくことで、フェードインを実現する。
	/// </remarks>
	class フェードイン : FDK.Activity
	{
		public bool 完了した => this._透明度カウンタ.終了値に達した;

		public bool 完了していない => !this.完了した;

		public フェードイン( float 総フェード時間sec )
		{
			Debug.Assert( 0.0f < 総フェード時間sec );
			this._総フェード時間sec = 総フェード時間sec;
		}

		public void 開始する()
		{
			int 最初の値 = 0;
			int 最後の値 = 100;
			long 値をひとつ増加させるのにかける時間ms = (long) ( this._総フェード時間sec * 1000f / ( 最後の値 - 最初の値 ) );
			this._透明度カウンタ.開始する( 最初の値, 最後の値, 値をひとつ増加させるのにかける時間ms );
		}

		public void 進行描画する( デバイスリソース dr, FDK.メディア.画像 フェードインに使うタイル画像 )
		{
			int タイル枚数X = (int) ( dr.設計画面サイズdpx.Width / フェードインに使うタイル画像.サイズdpx.Width ) + 1;   // 剰余は切り捨てられるので +1 。
			int タイル枚数Y = (int) ( dr.設計画面サイズdpx.Height / フェードインに使うタイル画像.サイズdpx.Height ) + 1;

			for( int x = 0; x < タイル枚数X; x++ )
			{
				for( int y = 0; y < タイル枚数Y; y++ )
				{
					フェードインに使うタイル画像?.描画する(
						dr,
						x * フェードインに使うタイル画像.サイズdpx.Width,
						y * フェードインに使うタイル画像.サイズdpx.Height,
						1f - this._透明度カウンタ.現在値の割合 );
				}
			}
		}

		private float _総フェード時間sec = 1.0f;

		private FDK.カウンタ.単純増加後不変カウンタ _透明度カウンタ = new FDK.カウンタ.単純増加後不変カウンタ();
	}
}
