﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace SST
{
	enum ViewerMessageType
	{
		指示なし,
		演奏開始,
		演奏停止,
	}

	class ViewerMessage
	{
		public ViewerMessageType 種別 { get; set; } = ViewerMessageType.指示なし;

		public string 曲ファイルパス { get; set; } = null;

		public int 演奏開始小節番号 { get; set; } = 0;

		public bool ドラムチップ発声 { get; set; } = true;

		public override string ToString()
		{
			return "ViewerMessage: " +
				$"種別={this.種別}" +
				$", 演奏開始小節番号={this.演奏開始小節番号}" +
				$", ドラムチップ発声={this.ドラムチップ発声}" +
				$", 曲ファイルパス=[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( this.曲ファイルパス )}]";
		}
	}
}
