﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Diagnostics;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace SSTFEditor
{
	public class Config
	{
		// プロパティ（保存される）

		public bool AutoFocus = true;
		public bool ShowRecentUsedFiles = true;
		public int MaxOfUsedRecentFiles = 10;
		public List<string> RecentUsedFiles = new List<string>();
		public string ViewerPath = "";

		// メソッド（保存されない）

		public static Config 読み込む( string ファイル名 )
		{
			Config config = null;

			try
			{
				config = FDK.XML.Serializer.ファイルをデシリアライズしてインスタンスを生成する<Config>( ファイル名 );
			}
			catch( Exception )
			{
				config = new Config();	// 読み込めなかったら新規作成する。
			}

			return config;
		}
		public void 保存する( string ファイル名 )
		{
			try
			{
				FDK.XML.Serializer.インスタンスをシリアライズしてファイルに保存する( ファイル名, this );
			}
			catch( Exception e )
			{
				MessageBox.Show( $"ファイルの保存に失敗しました。[{ファイル名}]\n--------\n{e.ToString()}" );
			}
		}
		public void ファイルを最近使ったファイルの一覧に追加する( string ファイル名 )
		{
			// 絶対パスを取得する。
			ファイル名 = Path.GetFullPath( ファイル名 );

			// 一覧に同じ文字列があったら一覧から削除する。
			this.RecentUsedFiles.RemoveAll( ( path ) => { return path.Equals( ファイル名 ); } );

			// 一覧の先頭に登録する。
			this.RecentUsedFiles.Insert( 0, ファイル名 );

			// 10個以上は記録しない。
			if( this.RecentUsedFiles.Count > 10 )
			{
				int 超えてる数 = this.RecentUsedFiles.Count - 10;

				for( int i = 超えてる数; i > 0; i-- )
					this.RecentUsedFiles.RemoveAt( 10 + i - 1 );
			}
		}
	}
}
