﻿using System;
using System.Collections.Generic;

namespace FDK.入力
{
	/// <summary>
	///		全入力デバイスが実装して提供しなければならないインターフェース。
	/// </summary>
	public interface IInputDevice
	{
		/// <summary>
		///		デバイスの種別。デバイスごとに固定値を返す。
		/// </summary>
		FDK.入力.InputDeviceType 入力デバイス種別 { get; }

		/// <summary>
		///		ポーリングを行い、前回のポーリングからのイベントを取得して内部に上書き保管する。
		/// </summary>
		void ポーリングする();

		/// <summary>
		///		最後にポーリングした結果に対して key の Push イベントを検索し、存在したなら true を返す。
		/// </summary>
		bool キーが押された( int key );
		
		/// <summary>
		///		最後にポーリングした結果に対して key の Push イベントを検索し、最初に見つけた入力イベントを返す。
		///		見つからなかった場合、ev には null が返される。
		/// </summary>
		bool キーが押された( int key, out FDK.入力.InputEvent ev );
		
		/// <summary>
		///		累積されたポーリング結果に対して key が現在押されているか確認する。
		/// </summary>
		bool キーが押されている( int key );

		/// <summary>
		///		最後にポーリングした結果に対して key の Pull イベントを検索し、存在したなら true を返す。
		/// </summary>
		bool キーが離された( int key );
		
		/// <summary>
		///		最後にポーリングした結果に対して key の Pull イベントを検索し、最初に見つけた入力イベントを返す。
		///		見つからなかった場合、ev には null が返される。
		/// </summary>
		bool キーが離された( int key, out FDK.入力.InputEvent ev );
		
		/// <summary>
		///		累積されたポーリング結果に対して key が現在離されているか確認する。
		/// </summary>
		bool キーが離されている( int key );
	}
}
