﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace FDK.メディア
{
	/// <summary>
	///		D3Dテクスチャとメモリを共有するD2Dビットマップを持つテクスチャ。
	///		D2Dビットマップに対して描画を行えば、それをD3Dテクスチャとして表示することができる。
	/// </summary>
	public class ビットマップ付きテクスチャ : FDK.メディア.テクスチャ
	{
		public ビットマップ付きテクスチャ( string 画像ファイルパス )
			: base( 画像ファイルパス, SharpDX.Direct3D11.BindFlags.RenderTarget | SharpDX.Direct3D11.BindFlags.ShaderResource )
		{
		}

		public ビットマップ付きテクスチャ( SharpDX.Size2 サイズdpx )
			: base( サイズdpx, SharpDX.Direct3D11.BindFlags.RenderTarget | SharpDX.Direct3D11.BindFlags.ShaderResource )
		{
		}

		protected override void Onデバイス依存リソースの作成( デバイスリソース dr )
		{
			// テクスチャを作成する。
			base.Onデバイス依存リソースの作成( dr );

			// 作成したテクスチャとデータを共有するビットマップターゲットを作成する。
			using( var dxgiSurface = this.Texture.QueryInterfaceOrNull<SharpDX.DXGI.Surface1>() )
			{
				var bmpProp = new SharpDX.Direct2D1.BitmapProperties1() {
					PixelFormat = new SharpDX.Direct2D1.PixelFormat( dxgiSurface.Description.Format, SharpDX.Direct2D1.AlphaMode.Premultiplied ),
					BitmapOptions = SharpDX.Direct2D1.BitmapOptions.Target | SharpDX.Direct2D1.BitmapOptions.CannotDraw,
				};
				this._BitmapTarget = new SharpDX.Direct2D1.Bitmap1( dr.D2DContext1, dxgiSurface, bmpProp );
			}
		}

		protected override void Onデバイス依存リソースの解放( デバイスリソース dr )
		{
			// ビットマップターゲットを解放する。
			FDK.Utilities.解放する( ref this._BitmapTarget );

			// テクスチャを解放する。
			base.Onデバイス依存リソースの解放( dr );
		}

		public void ビットマップへ描画する( FDK.メディア.デバイスリソース dr, Action<SharpDX.Direct2D1.DeviceContext1, SharpDX.Direct2D1.Bitmap1> 描画アクション )
		{
			using( var 旧ターゲット = dr.D2DContext1.Target )
			{
				try
				{
					dr.D2DContextの設定をリセットする( dr.D2DContext1 );
					dr.D2DContext1.Target = this._BitmapTarget;
					FDK.Utilities.D2DBatchDraw( dr.D2DContext1, () => {
						描画アクション( dr.D2DContext1, this._BitmapTarget );
					} );
				}
				finally
				{
					dr.D2DContext1.Target = 旧ターゲット;
				}
			}
		}

		private SharpDX.Direct2D1.Bitmap1 _BitmapTarget = null;
	}
}
