﻿using System;
using System.Collections.Generic;
using System.Diagnostics;

namespace FDK
{
	public class Log
	{
		/// <summary>
		///		これを設定しておくと、スレッドID の横に (名前) と出力されるようになる。
		/// </summary>
		public static void 現在のスレッドに名前をつける( string 名前 )
		{
			lock( Log._スレッド間同期 )
			{
				var ID = Log.GetCurrentThreadId();

				if( Log._IDto名前.ContainsKey( ID ) )
					Log._IDto名前.Remove( ID );

				Log._IDto名前.Add( ID, 名前 );
			}
		}

		public static void Info( string 出力 )
		{
			lock( Log._スレッド間同期 )
			{
				Log._一定時間が経過していたら区切り線を表示する();
				Trace.TraceInformation( $"{Log._日時とスレッドID}{Log._インデックスを返す( Log._深さ )}{出力}" );
			}
		}

		public static void ERROR( string 出力 )
		{
			lock( Log._スレッド間同期 )
			{
				Log._一定時間が経過していたら区切り線を表示する();
				Trace.TraceError( $"{Log._日時とスレッドID} {出力}" );
			}
		}

		public static void ERRORandTHROW( string 出力, Exception inner = null )
		{
			ERROR( 出力 );
			throw new FDKException( 出力, inner );
		}

		public static void WARNING( string 出力 )
		{
			lock( Log._スレッド間同期 )
			{
				Log._一定時間が経過していたら区切り線を表示する();
				Trace.TraceWarning( $"{Log._日時とスレッドID} {出力}" );
			}
		}

		public static void BeginInfo( string 開始ブロック名 )
		{
			lock( Log._スレッド間同期 )
			{
				Log._一定時間が経過していたら区切り線を表示する();
				Trace.TraceInformation( $"{Log._日時とスレッドID}{Log._インデックスを返す( Log._深さ )}{開始ブロック名} --> 開始" );

				Log._深さ += 4;
			}
		}

		public static void EndInfo( string 終了ブロック名 )
		{
			lock( Log._スレッド間同期 )
			{
				Log._深さ = Math.Max( ( Log._深さ - 4 ), 0 );

				Log._一定時間が経過していたら区切り線を表示する();
				Trace.TraceInformation( $"{Log._日時とスレッドID}{Log._インデックスを返す( Log._深さ )}{終了ブロック名} <-- 終了" );
			}
		}

		/// <summary>
		///		連続して呼び出しても、前回の同一識別キーでの表示から一定時間が経たないと表示しないInfoメソッド。
		/// </summary>
		/// <remarks>
		///		毎秒60回の進行描画の進捗など、連続して呼び出すと膨大な数のログが出力されてしまう場合に使用する。
		/// </remarks>
		/// <param name="識別キー"></param>
		/// <param name="出力"></param>
		public static void 定間隔Info( string 識別キー, string 出力, double 間隔sec = 0.25 )
		{
			lock( Log._スレッド間同期 )
			{
				if( Log._識別キー別最終表示時刻.ContainsKey( 識別キー ) )
				{
					if( ( DateTime.Now - Log._識別キー別最終表示時刻[ 識別キー ] ).TotalSeconds >= 間隔sec )
					{
						Log._識別キー別最終表示時刻[ 識別キー ] = DateTime.Now;
						Trace.TraceInformation( $"{Log._日時とスレッドID} {出力}" );
					}
				}
				else
				{
					Log._識別キー別最終表示時刻.Add( 識別キー, DateTime.Now );
					Trace.TraceInformation( $"{Log._日時とスレッドID} {出力}" );
				}
			}
		}

		private const double _最小区切り時間 = 2.0; // 区切り線を入れる最小の間隔[秒]。

		private static string _日時とスレッドID
		{
			get
			{
				var NETスレッドID = System.Threading.Thread.CurrentThread.ManagedThreadId;
				var Win32スレッドID = Log.GetCurrentThreadId();
				var スレッド識別文字列 = ( Log._IDto名前.ContainsKey( Win32スレッドID ) ) ? $"({Log._IDto名前[ Win32スレッドID ]})" : "";
				return $"{DateTime.Now.ToLongTimeString()} [{NETスレッドID:00},0x{Win32スレッドID:x}{スレッド識別文字列}]";
			}
		}

		private static readonly Dictionary<uint, string> _IDto名前 = new Dictionary<uint, string>();

		private static Dictionary<string, DateTime> _識別キー別最終表示時刻 = new Dictionary<string, DateTime>();

		private static TimeSpan _経過時間
		{
			get
			{
				var 現在時刻 = DateTime.Now;
				var 経過時間 = 現在時刻 - Log._最終表示時刻;
				Log._最終表示時刻 = 現在時刻;  // 更新
				return 経過時間;
			}
		}

		private static DateTime _最終表示時刻 = DateTime.Now;

		private static int _深さ = 0;

		private static readonly object _スレッド間同期 = new object();

		private static void _一定時間が経過していたら区切り線を表示する()
		{
			if( Log._最小区切り時間 < Log._経過時間.TotalSeconds )
				Trace.TraceInformation( "・・・" );
		}

		private static string _インデックスを返す( int 長さ )
		{
			string index = " ";
			int len = 長さ * 2;
			while( 0 < len )
			{
				index += "          ".Substring( 0, Math.Min( len, 10 ) );
				len -= 10;
			}
			return index;
		}

		#region " Win32 API "
		//-----------------
		[System.Runtime.InteropServices.DllImport( "kernel32.dll" )]
		private static extern uint GetCurrentThreadId();
		//-----------------
		#endregion
	}
}
