﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace FDK
{
	public static class Extensions
	{
		/// <summary>
		/// COM オブジェクトの参照カウントを取得して返す。
		/// </summary>
		/// <param name="unknownObject">COMオブジェクト。</param>
		/// <returns>現在の参照カウントの値。</returns>
		public static int GetRefferenceCount( this SharpDX.IUnknown unknownObject )
		{
			try
			{
				unknownObject.AddReference();
			}
			catch( InvalidOperationException )
			{
				// すでに Dispose されている。
				return 0;
			}

			return unknownObject.Release();
		}

		/// <summary>
		/// 文字列が Null でも空でもないなら true を返す。
		/// </summary>
		public static bool Nullでも空でもない( this string 検査対象 )
		{
			return !string.IsNullOrEmpty( 検査対象 );
		}

		/// <summary>
		/// 文字列が Null または空なら true を返す。
		/// </summary>
		public static bool Nullまたは空である( this string 検査対象 )
		{
			return string.IsNullOrEmpty( 検査対象 );
		}
	}
}
