﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX;
using SharpDX.DirectInput;
using FDK;
using FDK.メディア;

namespace SST.ステージ.結果
{
	class 結果ステージ : ステージ
	{
		public enum フェーズ
		{
			表示中,
			完了,
		}

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}

		public 結果ステージ()
		{
			this.子リスト.Add( this._背景画像 = new 画像( @"$(System)images\結果画面 背景.png" ) );
			this.子リスト.Add( this._背景動画 = new 動画( @"$(System)images\結果画面BGV.mp4" ) );
			this.子リスト.Add( this._結果表示パラメータ = new 画像フォント( @"$(System)images\結果画面 パラメータフォント.png", @"$(System)\images\結果画面 パラメータフォント矩形リスト.xml" ) );
			this.子リスト.Add( this._結果表示パラメータパネル = new 画像( @"$(System)images\結果画面 パラメータパネル.png" ) );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.現在のフェーズ = フェーズ.表示中;
				this._活性化した直後である = true;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				// ここでBGMを終了する。
				var stage = (演奏.演奏ステージ) App.ステージ管理.ステージリスト[ nameof( 演奏.演奏ステージ ) ];
				stage.BGMを停止する();

				this.現在のフェーズ = フェーズ.完了;
				this._活性化した直後である = false;
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			if( this._活性化した直後である )
			{
				this._背景動画.再生を開始する( 開始位置sec: 0.0, ループ再生する: true );
				this._活性化した直後である = false;
			}

			switch( this.現在のフェーズ )
			{
				case フェーズ.表示中:
					// 描画
					this._背景動画.描画する( gd, new RectangleF( 0f, 0f, gd.設計画面サイズ.Width, gd.設計画面サイズ.Height ) );
					this._背景画像.描画する( gd, 0f, 0f );
					#region " 結果表示パラメータ "
					//----------------
					this._結果表示パラメータパネル.描画する( gd, 60f, 196f );

					var 演奏ステージ = (演奏.演奏ステージ) App.ステージ管理.ステージリスト[ nameof( 演奏.演奏ステージ ) ];
					var hitRankTypes = new[] { 演奏.ヒットランク種別.PERFECT, 演奏.ヒットランク種別.GREAT, 演奏.ヒットランク種別.GOOD, 演奏.ヒットランク種別.POOR, 演奏.ヒットランク種別.MISS, 演奏.ヒットランク種別.AUTO };

					int 総数 = 0;
					foreach( var type in hitRankTypes )
						総数 += 演奏ステージ.ヒットランク別ヒット回数[ type ];

					float X = 360f;
					float Y = 230f;
					foreach( var type in hitRankTypes )
					{
						int 回数 = 演奏ステージ.ヒットランク別ヒット回数[ type ];
						double 割合 = ( 0 < 総数 ) ? ( 回数 * 100.0 / 総数 ) : 0.0;
						this._結果表示パラメータ.描画する( gd, X, Y, $"{回数:00000}({割合:000.0}%)" );
						Y += 71f;
					}
					//----------------
					#endregion

					// 入力
					App.入力管理.すべての入力デバイスをポーリングする();

					if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Escape ) || App.入力管理.シンバルが入力された() )
					{
						#region " シンバル or ESC → ステージ終了。"
						//----------------
						this.現在のフェーズ = フェーズ.完了;
						//----------------
						#endregion
					}
					break;

				case フェーズ.完了:
					break;
			}
		}

		private bool _活性化した直後である = false;

		private 画像 _背景画像 = null;

		private 動画 _背景動画 = null;

		private 画像フォント _結果表示パラメータ = null;

		private 画像 _結果表示パラメータパネル = null;
	}
}
