﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX.DirectInput;
using FDK;
using FDK.メディア;
using FDK.カウンタ;

namespace SST.ステージ.起動
{
	class 起動ステージ : ステージ
	{
		public enum フェーズ
		{
			開始,
			フェードイン,
			表示,
			フェードアウト,
			完了
		}

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}


		public 起動ステージ()
		{
			this.子リスト.Add( this._背景画像 = new 画像( @"$(System)images\起動画面.jpg" ) );
			this.子リスト.Add( this._フェードインアウト用パネル = new 画像( @"$(System)images\パネル黒64x64.png" ) );
			this.子リスト.Add( this._フェードイン = new フェードイン( 総フェード時間sec: 1.0f ) );
			this.子リスト.Add( this._フェードアウト = new フェードアウト( 総フェード時間sec: 1.0f ) );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				if( this.活性化している )
					return; // 準正常

				this.現在のフェーズ = フェーズ.開始;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				if( this.活性化していない )
					return; // 準正常

				this.現在のフェーズ = フェーズ.完了;
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );
			Debug.Assert( null != gd );

			retry:

			switch( this.現在のフェーズ )
			{
				case フェーズ.開始:
					this._フェーズカウンタ = new Counter( 最初の値: 0, 最後の値: 1, 値をひとつ増加させるのにかける時間ms: 1000 );
					this._フェードイン.開始する();
					this.現在のフェーズ = フェーズ.フェードイン;
					break;

				case フェーズ.フェードイン:
					if( this._フェードイン.完了した )
					{
						this._フェーズカウンタ.開始する( 最初の値: 0, 最後の値: 2, 値をひとつ増加させるのにかける時間ms: 1000 );
						this.現在のフェーズ = フェーズ.表示;
						goto retry;
					}
					else
					{
						this._背景画像.描画する( gd, 0f, 0f );
						this._フェードイン.進行描画する( gd, this._フェードインアウト用パネル );
					}
					break;

				case フェーズ.表示:
					if( this._フェーズカウンタ.終了値に達した )
					{
						this._フェードアウト.開始する();
						this.現在のフェーズ = フェーズ.フェードアウト;
						goto retry;
					}
					else
					{
						this._背景画像.描画する( gd, 0f, 0f );
					}
					break;

				case フェーズ.フェードアウト:
					if( this._フェードアウト.完了した )
					{
						this.現在のフェーズ = フェーズ.完了;
						//goto retry;	--> ちらつきが起きるのでコメントアウト
					}
					this._背景画像.描画する( gd, 0f, 0f );
					this._フェードアウト.進行描画する( gd, this._フェードインアウト用パネル );

					break;

				case フェーズ.完了:
					break;
			}

			// 入力（全フェーズ共通）

			App.入力管理.すべての入力デバイスをポーリングする();

			if( App.入力管理.シンバルが入力された() )
			{
				#region " シンバル類 → 即完了 "
				//----------------
				this.現在のフェーズ = フェーズ.完了;
				//----------------
				#endregion
			}
		}


		private 画像 _背景画像;

		private 画像 _フェードインアウト用パネル;

		private フェードイン _フェードイン;

		private フェードアウト _フェードアウト;

		private Counter _フェーズカウンタ;
	}
}
