﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX;
using SharpDX.Direct2D1;
using SharpDX.Mathematics.Interop;
using FDK;
using FDK.メディア;
using FDK.カウンタ;

using FDKUtilities = FDK.FDKUtilities;

namespace SST.ステージ.選曲
{
	class 曲決定アニメ : FDK.Activity
	{
		public bool アニメが完了した
			=> this._右の三角形用アニメカウンタ.終了値に達した
			&& this._左の三角形用アニメカウンタ.終了値に達した
			&& this._円用アニメカウンタ.終了値に達した
			&& this._決定用アニメカウンタ.終了値に達した;

		public 曲決定アニメ()
		{
			this.子リスト.Add( this._決 = new 画像( @"$(System)images\決定の「決」.png" ) );
			this.子リスト.Add( this._定 = new 画像( @"$(System)images\決定の「定」.png" ) );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			this._三角用ブラシ = new SolidColorBrush( gd.D2DDeviceContext, new Color4( 0xFF2F78DB ) ); // 0xAABBGGRR
			this._円用ブラシ白 = new SolidColorBrush( gd.D2DDeviceContext, new Color4( 0xFFFFFFFF ) );
			this._円用ブラシ赤 = new SolidColorBrush( gd.D2DDeviceContext, new Color4( 0xFF2F78DB ) );

			this._活性化直後である = true;
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			FDKUtilities.解放する( ref this._円用ブラシ赤 );
			FDKUtilities.解放する( ref this._円用ブラシ白 );
			FDKUtilities.解放する( ref this._三角用ブラシ );
		}

		public void 進行描画する( グラフィックデバイス gd )
		{
			if( this._活性化直後である )
			{
				this._右の三角形用アニメカウンタ = new Counter( 0, 200, 1 );
				this._左の三角形用アニメカウンタ = new Counter( 0, 200, 1 );
				this._円用アニメカウンタ = new Counter( 0, (int) ( _ひとつの円の表示時間ms + _円の間隔ms * ( 7 - 1 ) ), 1 );	// 円の数 = 7
				this._決定用アニメカウンタ = new Counter( 0, 200, 1 );
				this._活性化直後である = false;
			}

			#region " 右の三角形の進行描画 "
			//----------------
			using( var 右の三角形 = new PathGeometry( gd.D2DFactory ) )
			{
				using( var sink = 右の三角形.Open() )
				{
					float 割合 = this._右の三角形用アニメカウンタ.現在値の割合;
					Vector2 右上, 右下, 左;

					if( 0.8f > 割合 )
					{
						割合 = 割合 / 0.8f; // 0→1
						右上 = new Vector2( 1.0f + 割合 * 0.5f, 0.0f );
						右下 = new Vector2( 1.0f, 0.9f - 割合 * 0.1f );
						左 = new Vector2( 1.0f - 割合 * 1.2f, 0.75f );
					}
					else if( 0.9f > 割合 )
					{
						割合 = ( 割合 - 0.8f ) / 0.1f; // 0→1
						右上 = new Vector2( 1.5f, 0.0f - 割合 * 0.2f );
						右下 = new Vector2( 1.0f, 0.8f + 割合 * 0.05f );
						左 = new Vector2( -0.2f, 0.75f + 割合 * 0.05f );
					}
					else if( 1.0f > 割合 )
					{
						割合 = ( 割合 - 0.9f ) / 0.1f; // 0→1
						右上 = new Vector2( 1.5f, -0.2f + 割合 * 0.2f );
						右下 = new Vector2( 1.0f, 0.85f - 割合 * 0.05f );
						左 = new Vector2( -0.2f, 0.8f - 割合 * 0.05f );
					}
					else
					{
						右上 = new Vector2( 1.5f, 0.0f );
						右下 = new Vector2( 1.0f, 0.8f );
						左 = new Vector2( -0.2f, 0.75f );
					}
					sink.SetFillMode( FillMode.Winding );
					sink.BeginFigure( 右上, FigureBegin.Filled );
					sink.AddLines( new RawVector2[] { 右下, 左 } );
					sink.EndFigure( FigureEnd.Closed );
					sink.Close();
				}

				gd.D2DBatchDraw( ( dc ) => {
					dc.Transform = ( Matrix3x2.Scaling( gd.物理画面サイズ.Width, gd.物理画面サイズ.Height ) ) * dc.Transform;
					dc.FillGeometry( 右の三角形, this._三角用ブラシ );
				} );
			}
			//----------------
			#endregion

			#region " 左の三角形の進行描画 "
			//----------------
			using( var 左の三角形 = new PathGeometry( gd.D2DFactory ) )
			{
				using( var sink = 左の三角形.Open() )
				{
					float 割合 = this._左の三角形用アニメカウンタ.現在値の割合;
					Vector2 左上, 右, 左下;

					if( 0.7f > 割合 )
					{
						割合 = 割合 / 0.7f; // 0→1
						左上 = new Vector2( -0.1f - 割合 * 0.1f, 0.0f );
						右 = new Vector2( 0.0f + 割合 * 0.8f, 0.1f + 割合 * 0.65f );
						左下 = new Vector2( -0.3f, 0.75f - 割合 * 0.45f );
					}
					else if( 0.8f > 割合 )
					{
						割合 = ( 割合 - 0.7f ) / 0.1f; // 0→1
						左上 = new Vector2( -0.2f, 0.0f - 割合 * 0.05f );
						右 = new Vector2( 0.8f, 0.75f );
						左下 = new Vector2( -0.3f, 0.3f + 割合 * 0.05f );
					}
					else if( 0.9f > 割合 )
					{
						割合 = ( 割合 - 0.8f ) / 0.1f; // 0→1
						左上 = new Vector2( -0.2f, -0.05f + 割合 * 0.05f );
						右 = new Vector2( 0.8f, 0.75f );
						左下 = new Vector2( -0.3f, 0.35f - 割合 * 0.05f );
					}
					else
					{
						左上 = new Vector2( -0.2f, 0.0f );
						右 = new Vector2( 0.8f, 0.75f );
						左下 = new Vector2( -0.3f, 0.3f );
					}
					sink.SetFillMode( FillMode.Winding );
					sink.BeginFigure( 左上, FigureBegin.Filled );
					sink.AddLines( new RawVector2[] { 右, 左下 } );
					sink.EndFigure( FigureEnd.Closed );
					sink.Close();
				}

				gd.D2DBatchDraw( ( dc ) => {
					dc.Transform = ( Matrix3x2.Scaling( gd.物理画面サイズ.Width, gd.物理画面サイズ.Height ) ) * dc.Transform;
					dc.FillGeometry( 左の三角形, this._三角用ブラシ );
				} );
			}
			//----------------
			#endregion

			#region " 円の進行描画1. 白円 "
			//----------------
			if( this._円用アニメカウンタ.終了値に達していない )
			{
				var 中心 = new Vector2( 0.5f, 0.5f );

				for( int i = 0; i < 3; i++ )
				{
					float 時刻ms = this._円用アニメカウンタ.現在値 - i * _円の間隔ms;

					if( ( 0f <= 時刻ms ) && ( _ひとつの円の表示時間ms > 時刻ms ) )
					{
						float 画面の縦横比 = gd.設計画面サイズ.Width / gd.設計画面サイズ.Height;  // 横に長ければ1.0より大きい値。
						float 直径の長いほう = ( 時刻ms / _ひとつの円の表示時間ms ) * 1.5f;    // 0 → 1.5
						var 直径 = ( 1.0 < 画面の縦横比 ) ? new Vector2( 直径の長いほう, 直径の長いほう * 画面の縦横比 ) : new Vector2( 直径の長いほう * 画面の縦横比, 直径の長いほう );

						gd.D2DBatchDraw( ( dc ) => {

							dc.Transform = ( Matrix3x2.Scaling( gd.物理画面サイズ.Width, gd.物理画面サイズ.Height ) ) * dc.Transform;

							if( _円の塗りつぶし[ i ] )
							{
								dc.FillEllipse( new Ellipse( 中心, 直径.X, 直径.Y ), this._円用ブラシ白 );
							}
							else
							{
								dc.DrawEllipse( new Ellipse( 中心, 直径.X, 直径.Y ), this._円用ブラシ白, 0.01f );
							}

						} );
					}
				}
			}
			//----------------
			#endregion

			#region " 「決定」の進行描画 "
			//----------------
			if( this._決定用アニメカウンタ.終了値に達していない )
			{
				float 割合 = this._決定用アニメカウンタ.現在値の割合;

				if( 0.25f > 割合 )
				{
					// 1. 接近
					割合 = 割合 / 0.25f;    // 0 → 1
					this._決.描画する( gd, _決の開始点.X + ( _決の終了点.X - _決の開始点.X ) * 割合, _決の開始点.Y + ( _決の終了点.Y - _決の開始点.Y ) * 割合 );
					this._定.描画する( gd, _定の開始点.X + ( _定の終了点.X - _定の開始点.X ) * 割合, _定の開始点.Y + ( _定の終了点.Y - _定の開始点.Y ) * 割合 );
				}
				else
				{
					// 2. 衝突
					float dx決 = App.乱数.NextFloat( -20f, 20f );
					float dy決 = App.乱数.NextFloat( -10f, 10f );
					this._決.描画する( gd, _決の終了点.X + dx決, _決の終了点.Y + dy決 );

					float dx定 = App.乱数.NextFloat( -20f, 20f );
					float dy定 = App.乱数.NextFloat( -10f, 10f );
					this._定.描画する( gd, _定の終了点.X + dx定, _定の終了点.Y + dy定 );
				}
			}
			else
			{
				// 3. 静止
				this._決.描画する( gd, _決の終了点.X, _決の終了点.Y );
				this._定.描画する( gd, _定の終了点.X, _定の終了点.Y );
			}
			//----------------
			#endregion

			#region " 円の進行描画2. 赤円（「決定」より上に描画される）"
			//----------------
			if( this._円用アニメカウンタ.終了値に達していない )
			{
				var 中心 = new Vector2( 0.5f, 0.5f );

				for( int i = 3; i < 7; i++ )
				{
					float 時刻ms = this._円用アニメカウンタ.現在値 - i * _円の間隔ms;

					if( ( 0f <= 時刻ms ) && ( _ひとつの円の表示時間ms > 時刻ms ) )
					{
						float 画面の縦横比 = gd.設計画面サイズ.Width / gd.設計画面サイズ.Height;  // 横に長ければ1.0より大きい値。
						float 直径の長いほう = ( 時刻ms / _ひとつの円の表示時間ms ) * 1.5f;    // 0 → 1.5
						var 直径 = ( 1.0 < 画面の縦横比 ) ? new Vector2( 直径の長いほう, 直径の長いほう * 画面の縦横比 ) : new Vector2( 直径の長いほう * 画面の縦横比, 直径の長いほう );

						gd.D2DBatchDraw( ( dc ) => {

							dc.Transform = ( Matrix3x2.Scaling( gd.物理画面サイズ.Width, gd.物理画面サイズ.Height ) ) * dc.Transform;

							if( _円の塗りつぶし[ i ] )
							{
								dc.FillEllipse( new Ellipse( 中心, 直径.X, 直径.Y ), this._円用ブラシ赤 );
							}
							else
							{
								dc.DrawEllipse( new Ellipse( 中心, 直径.X, 直径.Y ), this._円用ブラシ赤, 0.01f );
							}

						} );
					}
				}
			}
			else
			{
				// 赤一色ベタ塗り
				gd.D2DBatchDraw( ( dc ) => {
					dc.Transform = ( Matrix3x2.Scaling( gd.物理画面サイズ.Width, gd.物理画面サイズ.Height ) ) * dc.Transform;
					dc.FillRectangle( new RectangleF( 0f, 0f, 1f, 1f ), this._円用ブラシ赤 );
				} );
			}
			//----------------
			#endregion
		}


		private bool _活性化直後である = true;

		private Counter _右の三角形用アニメカウンタ = null;

		private Counter _左の三角形用アニメカウンタ = null;

		private SolidColorBrush _三角用ブラシ = null;

		private Counter _円用アニメカウンタ = null;

		private SolidColorBrush _円用ブラシ白 = null;

		private SolidColorBrush _円用ブラシ赤 = null;

		private readonly bool[] _円の塗りつぶし = new bool[] { false, false, true, false, false, false, true };	// 3つめと7つめの円は塗りつぶし

		private const float _ひとつの円の表示時間ms = 800f;

		private const float _円の間隔ms = 80f;

		private 画像 _決 = null;

		private 画像 _定 = null;

		private Counter _決定用アニメカウンタ = null;

		private readonly Vector2 _決の開始点 = new Vector2( -1500f, -100f );

		private readonly Vector2 _決の終了点 = new Vector2( 550f, 330f );

		private readonly Vector2 _定の開始点 = new Vector2( 2000f, 100f );

		private readonly Vector2 _定の終了点 = new Vector2( 940f, 360f );
	}
}
