﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;

namespace SST.ユーザ
{
	public class ユーザ管理
	{
		public List<ユーザ> ユーザリスト { get; } = new List<ユーザ>();
		public ユーザ 現在選択されているユーザ { get; protected set; } = null;	// 外から設定するにはメソッドを使う。

		public ユーザ管理()
		{
			this.初期化する();
			this.ユーザリスト.Add( new ユーザ( Properties.Resources.AUTOPLAYER ) );  // 既定ユーザ
		}
		public void ユーザを選択する( ユーザ 選択対象ユーザ )
		{
			if( null != 選択対象ユーザ )   // null は OK
			{
				if( null == this.ユーザリスト.Find( user => user == 選択対象ユーザ ) )
				{
					var msg = "存在しないユーザを選択しようとしました。";
					FDK.Log.ERROR( msg );
					throw new SSTException( msg );
				}
			}

			// 選択ユーザを変更する。
			this.現在選択されているユーザ = 選択対象ユーザ;
		}
		public void ユーザを選択する( string ユーザ名 )
		{
			var 名前に該当するユーザ = this.ユーザリスト.Find( user => user.名前 == ユーザ名 );
			if( null == 名前に該当するユーザ )
			{
				var msg = $"存在しない名前「{ユーザ名}」のユーザを選択しようとしました。";
				FDK.Log.ERROR( msg );
				throw new SSTException( msg );
			}

			// 選択ユーザを変更する。
			this.ユーザを選択する( 名前に該当するユーザ );
		}
		public void ユーザを選択する( int index )
		{
			this.ユーザを選択する( this.ユーザリスト[ index ] );
		}

		public void UsersXmlを保存する()
		{
			this.UsersXmlを保存する( FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this.ユーザXmlファイルパス ) );
		}
		public void UsersXmlを保存する( string ファイルパス )
		{
			try
			{
				var XML文書 = new XDocument( new XDeclaration( version: "1.0", encoding: "utf-8", standalone: "yes" ) );

				// <Root>
				var Root要素 = new XElement( nameof( XML.Root ) );
				{
					// <Users>
					var Users要素 = new XElement( nameof( XML.Users ) );
					{
						// ユーザ要素*
						foreach( var user in this.ユーザリスト )
						{
							user.ユーザをXML要素で出力する( 親要素: Users要素 );
						}
					}
					Root要素.Add( Users要素 );
				}
				XML文書.Add( Root要素 );

				// ファイルに保存する。
				XML文書.Save( ファイルパス );
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"ユーザファイルの保存に失敗しました。{e.Message}[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
			}
		}
		public void UsersXmlを読み込む()
		{
			this.UsersXmlを読み込む( FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this.ユーザXmlファイルパス ) );
		}
		public void UsersXmlを読み込む( string ファイルパス )
		{
			this.初期化する();

			if( false == File.Exists( ファイルパス ) )
			{
				FDK.Log.WARNING( $"ユーザファイルが存在しません。作成します。[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
				this.AutoPlayerを追加する();
				this.UsersXmlを保存する( ファイルパス );
				return;
			}

			try
			{
				var XML文書 = XDocument.Load( ファイルパス );

				// <Root>
				var Root要素 = XML文書.Element( nameof( XML.Root ) );
				{
					// <Users>*
					foreach( var Users要素 in Root要素.Elements( nameof( XML.Users ) ) )
					{
						// ユーザ要素*
						foreach( var ユーザ要素 in Users要素.Elements() )
						{
							var 新ユーザ = new ユーザ();
							新ユーザ.ユーザをXML要素から読み込む( 読込対象要素: ユーザ要素 );  // ユーザ要素の解析は向こうに任せる。

							if( false == string.IsNullOrEmpty( 新ユーザ.名前 ) )
							{
								// すでに同じ名前が存在するなら削除する。
								var 同名ユーザ = this.ユーザリスト.FindIndex( user => user.名前 == 新ユーザ.名前 );
								if( 0 <= 同名ユーザ )
									this.ユーザリスト.RemoveAt( 同名ユーザ );

								// リストに追加する。
								this.ユーザリスト.Add( 新ユーザ );
							}
						}
					}
				}
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"ユーザファイルの読み込みに失敗しました。{e.Message}[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
			}

			// AutoPlayer が存在しないなら、追加する。
			if( -1 == this.ユーザリスト.FindIndex( ( user ) => user.名前 == Properties.Resources.AUTOPLAYER ) )
			{
				this.AutoPlayerを追加する();	// 追加して
				this.UsersXmlを保存する();   // 保存。
			}
		}

		protected readonly string ユーザXmlファイルパス = @"$(AppData)\Users.xml";

		private void 初期化する()
		{
			this.ユーザリスト.Clear();
			this.現在選択されているユーザ = null;
		}
		private void AutoPlayerを追加する()
		{
			var autoPlayer = new ユーザ( Properties.Resources.AUTOPLAYER );
			autoPlayer.AutoPlayを一括設定する( true );
			this.ユーザリスト.Add( autoPlayer );
		}
	}
}
