﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;

namespace SST.ユーザ
{
	public class ユーザ
	{
		public string 名前 { get; set; } = null;
		public bool Rideは左 { get; set; } = false;
		public bool Chinaは左 { get; set; } = false;
		public bool Splashは左 { get; set; } = true;
		public class Cヒット範囲sec
		{
			public const double Perfect既定値 = 0.034;
			public double Perfect = Perfect既定値;

			public const double Great既定値 = 0.067;
			public double Great = Great既定値;

			public const double Good既定値 = 0.084;
			public double Good = Good既定値;

			public const double Poor既定値 = 0.117;
			public double Poor = Poor既定値;
		}
		public Cヒット範囲sec ヒット範囲sec { get; } = new Cヒット範囲sec();
		public class CAutoPlay
		{
			public bool LeftCrash = false;
			public bool Ride = false;
			public bool China = false;
			public bool Splash = false;
			public bool HiHat = false;
			public bool Snare = false;
			public bool Bass = false;
			public bool Tom1 = false;
			public bool Tom2 = false;
			public bool Tom3 = false;
			public bool RightCrash = false;
		}
		public CAutoPlay AutoPlay { get; } = new CAutoPlay();
		public double 譜面スクロール速度の倍率 { get; set; } = 1.0;
		public SST.曲.RootNode 曲ツリーのルートノード { get; } = new 曲.RootNode();
		public List<string> 曲の検索元フォルダパスのリスト { get; } = new List<string>();

		public ユーザ()
		{
		}
		public ユーザ( string 名前 )
		{
			this.名前 = 名前;
		}
		public bool チップ種別に対応するAutoPlayを返す( SSTFormat.チップ種別 chipType )
		{
			switch( chipType )
			{
				case SSTFormat.チップ種別.LeftCrash:
				case SSTFormat.チップ種別.LeftCymbal_Mute:
					return this.AutoPlay.LeftCrash;

				case SSTFormat.チップ種別.Ride:
				case SSTFormat.チップ種別.Ride_Cup:
					return ( this.Rideは左 ) ? this.AutoPlay.LeftCrash : this.AutoPlay.RightCrash;

				case SSTFormat.チップ種別.China:
					return ( this.Chinaは左 ) ? this.AutoPlay.LeftCrash : this.AutoPlay.RightCrash;

				case SSTFormat.チップ種別.Splash:
					return ( this.Splashは左 ) ? this.AutoPlay.LeftCrash : this.AutoPlay.RightCrash;

				case SSTFormat.チップ種別.HiHat_Open:
				case SSTFormat.チップ種別.HiHat_HalfOpen:
				case SSTFormat.チップ種別.HiHat_Close:
				case SSTFormat.チップ種別.HiHat_Foot:
					return this.AutoPlay.HiHat;

				case SSTFormat.チップ種別.Snare:
				case SSTFormat.チップ種別.Snare_OpenRim:
				case SSTFormat.チップ種別.Snare_ClosedRim:
				case SSTFormat.チップ種別.Snare_Ghost:
					return this.AutoPlay.Snare;

				case SSTFormat.チップ種別.Bass:
					return this.AutoPlay.Bass;

				case SSTFormat.チップ種別.Tom1:
				case SSTFormat.チップ種別.Tom1_Rim:
					return this.AutoPlay.Tom1;

				case SSTFormat.チップ種別.Tom2:
				case SSTFormat.チップ種別.Tom2_Rim:
					return this.AutoPlay.Tom2;

				case SSTFormat.チップ種別.Tom3:
				case SSTFormat.チップ種別.Tom3_Rim:
					return this.AutoPlay.Tom3;

				case SSTFormat.チップ種別.RightCrash:
				case SSTFormat.チップ種別.RightCymbal_Mute:
					return this.AutoPlay.RightCrash;

				case SSTFormat.チップ種別.背景動画:
					return true;    // 常にAutoPlay
			}

			// 上記以外はみな false。
			return false;
		}
		public void AutoPlayを一括設定する( bool 設定値 )
		{
			this.AutoPlay.LeftCrash =
				this.AutoPlay.Ride =
				this.AutoPlay.China =
				this.AutoPlay.Splash =
				this.AutoPlay.HiHat =
				this.AutoPlay.Snare =
				this.AutoPlay.Bass =
				this.AutoPlay.Tom1 =
				this.AutoPlay.Tom2 =
				this.AutoPlay.Tom3 =
				this.AutoPlay.RightCrash = 設定値;
		}
		public void 曲を検索して曲ツリーを構築する()
		{
			// 曲の検索元フォルダパスが１つもなかったら、exe のあるフォルダを既定値として追加する。
			if( 0 == this.曲の検索元フォルダパスのリスト.Count )
				this.曲の検索元フォルダパスのリスト.Add( FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( @"$(Static)\" ) );

			// すべての曲の検索元フォルダパスについて、曲を検索する。
			foreach( var フォルダパス in this.曲の検索元フォルダパスのリスト )
				SST.曲.曲ツリー管理.フォルダから曲を検索して子ノードリストに追加する( this.曲ツリーのルートノード, フォルダパス );
		}
		public void ユーザをXML要素で出力する( XElement 親要素 )
		{
			// <user name="..." />...</user>
			var user = new XElement( nameof( XML.User ), new XAttribute( nameof( XML.Name ), this.名前 ) );

			// 子要素
			user.Add(
				new XElement( nameof( XML.RidePosition ), this.Rideは左 ? nameof( XML.Left ) : nameof( XML.Right ) ),
				new XElement( nameof( XML.ChinaPosition ), this.Chinaは左 ? nameof( XML.Left ) : nameof( XML.Right ) ),
				new XElement( nameof( XML.SplashPosition ), this.Splashは左 ? nameof( XML.Left ) : nameof( XML.Right ) ),

				new XElement( nameof( XML.ScrollSpeedRate ), this.譜面スクロール速度の倍率 ),

				new XElement( nameof( XML.Range ),
					new XElement( nameof( XML.Perfect ), this.ヒット範囲sec.Perfect ),
					new XElement( nameof( XML.Great ), this.ヒット範囲sec.Great ),
					new XElement( nameof( XML.Good ), this.ヒット範囲sec.Good ),
					new XElement( nameof( XML.Poor ), this.ヒット範囲sec.Poor ) ),

				new XElement( nameof( XML.AutoPlay ),
					new XElement( nameof( XML.LeftCrash ), this.AutoPlay.LeftCrash ),
					new XElement( nameof( XML.Ride ), this.AutoPlay.Ride ),
					new XElement( nameof( XML.China ), this.AutoPlay.China ),
					new XElement( nameof( XML.Splash ), this.AutoPlay.Splash ),
					new XElement( nameof( XML.HiHat ), this.AutoPlay.HiHat ),
					new XElement( nameof( XML.Snare ), this.AutoPlay.Snare ),
					new XElement( nameof( XML.Bass ), this.AutoPlay.Bass ),
					new XElement( nameof( XML.Tom1 ), this.AutoPlay.Tom1 ),
					new XElement( nameof( XML.Tom2 ), this.AutoPlay.Tom2 ),
					new XElement( nameof( XML.Tom3 ), this.AutoPlay.Tom3 ),
					new XElement( nameof( XML.RightCrash ), this.AutoPlay.RightCrash ) )
			);

			親要素.Add( user );
		}
		public void ユーザをXML要素から読み込む( XElement 読込対象要素 )
		{
			// 初期化する。
			this.名前 = null;

			// <user>
			if( 読込対象要素.Name.LocalName.ToLower() == nameof( XML.User ).ToLower() )
			{
				var user要素 = 読込対象要素;

				// name="..."
				var name属性 = user要素.Attribute( nameof( XML.Name ) );
				if( null == name属性 )
				{
					var msg = $"{nameof( XML.User )} タグに {nameof( XML.Name )} 属性が見つかりません。";
					FDK.Log.ERROR( msg );
					throw new SSTException( msg );
				}
				this.名前 = name属性.Value;

				// 子要素。

				#region " <RidePosition> "
				//----------------
				try
				{
					this.Rideは左 = ( user要素.Element( nameof( XML.RidePosition ) )?.Value ?? nameof( XML.Right ) ) == nameof( XML.Left ); // 規定値は Right
				}
				catch( Exception e )
				{
					FDK.Log.ERROR( $"<{XML.User}>.<{XML.RidePosition}> の読み込みに失敗しました。{e.Message}" );
					this.Rideは左 = false;    // 既定値は Right
				}
				//----------------
				#endregion
				#region " <ChinaPosition> "
				//----------------
				try
				{
					this.Chinaは左 = ( user要素.Element( nameof( XML.ChinaPosition ) )?.Value ?? nameof( XML.Right ) ) == nameof( XML.Left );   // 規定値は Right
				}
				catch( Exception e )
				{
					FDK.Log.ERROR( $"<{XML.User}>.<{XML.ChinaPosition}> の読み込みに失敗しました。{e.Message}" );
					this.Chinaは左 = false;    // 既定値は Right
				}
				//----------------
				#endregion
				#region " <SplashPosition> "
				//----------------
				try
				{
					this.Splashは左 = ( user要素.Element( nameof( XML.SplashPosition ) )?.Value ?? nameof( XML.Left ) ) == nameof( XML.Left );  // 規定値は Left
				}
				catch( Exception e )
				{
					FDK.Log.ERROR( $"<{XML.User}>.<{XML.SplashPosition}> の読み込みに失敗しました。{e.Message}" );
					this.Splashは左 = true;    // 既定値は Left
				}
				//----------------
				#endregion

				#region " <Range> "
				//----------------
				var range要素 = user要素.Element( nameof( XML.Range ) );
				if( null != range要素 )
				{
					#region " <Perfect> "
					//----------------
					try
					{
						this.ヒット範囲sec.Perfect = (double) range要素.Element( nameof( XML.Perfect ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.Range}>.<{XML.Perfect}> の読み込みに失敗しました。{e.Message}" );
						this.ヒット範囲sec.Perfect = Cヒット範囲sec.Perfect既定値;
					}
					//----------------
					#endregion
					#region " <Great> "
					//----------------
					try
					{
						this.ヒット範囲sec.Great = (double) range要素.Element( nameof( XML.Great ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.Range}>.<{XML.Great}> の読み込みに失敗しました。{e.Message}" );
						this.ヒット範囲sec.Great = Cヒット範囲sec.Great既定値;
					}
					//----------------
					#endregion
					#region " <Good> "
					//----------------
					try
					{
						this.ヒット範囲sec.Good = (double) range要素.Element( nameof( XML.Good ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.Range}>.<{XML.Good}> の読み込みに失敗しました。{e.Message}" );
						this.ヒット範囲sec.Good = Cヒット範囲sec.Good既定値;
					}
					//----------------
					#endregion
					#region " <Poor> "
					//----------------
					try
					{
						this.ヒット範囲sec.Poor = (double) range要素.Element( nameof( XML.Poor ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.Range}>.<{XML.Poor}> の読み込みに失敗しました。{e.Message}" );
						this.ヒット範囲sec.Poor = Cヒット範囲sec.Poor既定値;
					}
					//----------------
					#endregion
				}
				//----------------
				#endregion
				#region " <AutoPlay> "
				//----------------
				var autoPlay要素 = user要素.Element( nameof( XML.AutoPlay ) );
				if( null != autoPlay要素 )
				{
					#region " <LeftCrash> "
					//----------------
					try
					{
						this.AutoPlay.LeftCrash = (bool) autoPlay要素.Element( nameof( XML.LeftCrash ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.LeftCrash}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.LeftCrash = false;
					}
					//----------------
					#endregion
					#region " <Ride> "
					//----------------
					try
					{
						this.AutoPlay.Ride = (bool) autoPlay要素.Element( nameof( XML.Ride ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Ride}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Ride = false;
					}
					//----------------
					#endregion
					#region " <China> "
					//----------------
					try
					{
						this.AutoPlay.China = (bool) autoPlay要素.Element( nameof( XML.China ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.China}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.China = false;
					}
					//----------------
					#endregion
					#region " <Splash> "
					//----------------
					try
					{
						this.AutoPlay.Splash = (bool) autoPlay要素.Element( nameof( XML.Splash ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Splash}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Splash = false;
					}
					//----------------
					#endregion
					#region " <HiHat> "
					//----------------
					try
					{
						this.AutoPlay.HiHat = (bool) autoPlay要素.Element( nameof( XML.HiHat ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.HiHat}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.HiHat = false;
					}
					//----------------
					#endregion
					#region " <Snare> "
					//----------------
					try
					{
						this.AutoPlay.Snare = (bool) autoPlay要素.Element( nameof( XML.Snare ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Snare}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Snare = false;
					}
					//----------------
					#endregion
					#region " <Bass> "
					//----------------
					try
					{
						this.AutoPlay.Bass = (bool) autoPlay要素.Element( nameof( XML.Bass ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Bass}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Bass = false;
					}
					//----------------
					#endregion
					#region " <Tom1> "
					//----------------
					try
					{
						this.AutoPlay.Tom1 = (bool) autoPlay要素.Element( nameof( XML.Tom1 ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Tom1}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Tom1 = false;
					}
					//----------------
					#endregion
					#region " <Tom2> "
					//----------------
					try
					{
						this.AutoPlay.Tom2 = (bool) autoPlay要素.Element( nameof( XML.Tom2 ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Tom2}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Tom2 = false;
					}
					//----------------
					#endregion
					#region " <Tom3> "
					//----------------
					try
					{
						this.AutoPlay.Tom3 = (bool) autoPlay要素.Element( nameof( XML.Tom3 ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.Tom3}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.Tom3 = false;
					}
					//----------------
					#endregion
					#region " <RightCrash> "
					//----------------
					try
					{
						this.AutoPlay.RightCrash = (bool) autoPlay要素.Element( nameof( XML.RightCrash ) );
					}
					catch( Exception e )
					{
						FDK.Log.ERROR( $"<{XML.User}>.<{XML.AutoPlay}>.<{XML.RightCrash}> の読み込みに失敗しました。{e.Message}" );
						this.AutoPlay.RightCrash = false;
					}
					//----------------
					#endregion
				}
				//----------------
				#endregion

				#region " <ScrollSpeedRate> "
				//----------------
				try
				{
					this.譜面スクロール速度の倍率 = (double) user要素.Element( nameof( XML.ScrollSpeedRate ) );
				}
				catch( Exception e )
				{
					FDK.Log.ERROR( $"<{XML.User}>.<{XML.ScrollSpeedRate}> の読み込みに失敗しました。{e.Message}" );
					this.譜面スクロール速度の倍率 = 1.0;    // 既定値
				}
				//----------------
				#endregion
			}
		}
		public void SourcesXmlを保存する()
		{
			string ユーザフォルダ名 = StrokeStyleT.フォルダ.UserFolder( this.名前 );

			// ユーザフォルダが存在しないなら作成する。
			if( false == Directory.Exists( ユーザフォルダ名 ) )
				Directory.CreateDirectory( ユーザフォルダ名 );

			string ファイル名 = Path.Combine( ユーザフォルダ名, this.ソースXmlファイルパス );
			var xml文書 = new XDocument( new XDeclaration( "1.0", "utf-8", "yes" ) );

			// <Root>
			var Root要素 = new XElement( nameof( XML.Root ) );
			{
				// <Sources>
				var Sources要素 = new XElement( nameof( XML.Sources ) );
				{
					// <Path>*
					foreach( var path in this.曲の検索元フォルダパスのリスト )
					{
						var 変数付きフォルダパス = FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( path );
						Root要素.Add( new XElement( nameof( XML.Path ), 変数付きフォルダパス ) );
					}
				}
				Root要素.Add( Sources要素 );
			}
			xml文書.Add( Root要素 );

			// ファイルに保存する。
			xml文書.Save( ファイル名 );
		}
		public void SourcesXmlを読み込む()
		{
			// 初期化する。
			this.曲の検索元フォルダパスのリスト.Clear();

			string ファイル名 = Path.Combine( StrokeStyleT.フォルダ.UserFolder( this.名前 ), this.ソースXmlファイルパス );

			if( false == File.Exists( ファイル名 ) )
			{
				FDK.Log.WARNING( $"ソースファイルが存在しません。作成します。[{this.ソースXmlファイルパス}]" );
				this.SourcesXmlを保存する();    // ファイルがなかったら新規に作成。中身は空。
				return;
			}

			try
			{
				var xml文書 = XDocument.Load( ファイル名 );

				// <Root>
				var Root要素 = xml文書.Element( nameof( XML.Root ) );
				{
					// <Sources>*
					foreach( var Sources要素 in Root要素.Elements( nameof( XML.Sources ) ) )
					{
						foreach( var Sourcesの子要素 in Sources要素.Elements() )
						{
							switch( Sourcesの子要素.Name.LocalName )
							{
								// <Path>
								case nameof( XML.Path ):
									this.曲の検索元フォルダパスのリスト.Add( FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( Sourcesの子要素.Value ) );
									break;
							}
						}
					}
				}
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"ソースファイルの読み込みに失敗しました。{e.Message}[{this.ソースXmlファイルパス}]" );
			}
		}

		protected readonly string ソースXmlファイルパス = @"Sources.xml";
	}
}
