﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;

namespace SST
{
	class フォルダ : FDK.フォルダ
	{
		/// <summary>
		/// 静的な（アプリを通じて不変の）リソースファイルが置かれる場所のルートフォルダ。絶対パス。
		/// 具体的には、exe のあるフォルダ。
		/// </summary>
		public string StaticFolder => Path.GetDirectoryName( Assembly.GetExecutingAssembly().Location );

		/// <summary>
		/// 共通データが保存される場所のルートフォルダ。絶対パス。
		/// 具体的には、%APPDATA%\StrokeStyleT\ 。
		/// </summary>
		public string AppDataFolder => Path.Combine(
			Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData, Environment.SpecialFolderOption.Create ),
			@"StrokeStyleT\" );

		/// <summary>
		/// SSTユーザごとに用意されたデータの保存場所。絶対パス表記。
		/// 具体的には %APPDATA%\StrokeStyleT\Users\SSTユーザ名\ 。
		/// </summary>
		public string UserFolder( string SSTユーザ名 ) => Path.Combine( this.AppDataFolder, $@"Users\{SSTユーザ名}\" );
	}
}
