﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;
using FDK;	// for SystemStringExtensions

namespace SST.ステージ.演奏
{
	class 演奏ステージ : ステージ
	{
		public Dictionary<ヒット判定種別, int> ヒットした回数 { get; } = new Dictionary<ヒット判定種別, int>();
		public enum フェーズ
		{
			初期状態,
			演奏中,
			クリアor失敗,
			キャンセル,
		}
		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		public 演奏ステージ()
		{
			this.子リスト.Add( this.コンボ = new コンボ() );
			this.子リスト.Add( this.レーンフレーム = new レーンフレーム() );
			this.子リスト.Add( this.スクロール譜面 = new スクロール譜面() );
			this.子リスト.Add( this.ヒット判定文字列 = new ヒット判定文字列() );
			this.子リスト.Add( this.回転羽 = new 回転羽( 最大同時発火数: 32 ) );
			this.子リスト.Add( this.ドラムサウンド = new ドラムサウンド() );
			this.子リスト.Add( this.ドラムセット = new 汎用.ドラムセット() );
			this.子リスト.Add( this.判定バー = new 画像( @"$(Static)\images\判定バー.png" ) );
			this.子リスト.Add( this.ステージ台 = new 画像( @"$(Static)\images\ステージ台.png" ) );
			this.子リスト.Add( this.FPS画像 = new 文字列画像() );

			// 子Activity の外部依存 Action を実装する。
			this.スクロール譜面.ヒット判定文字列開始 = ( chipType, hitType ) => { this.ヒット判定文字列.表示開始( chipType, hitType ); };
			this.スクロール譜面.コンボリセット = () => { this.コンボ.COMBO値 = 0; };
			this.スクロール譜面.コンボ加算 = () => { this.コンボ.COMBO値++; };
			this.スクロール譜面.ヒット判定数加算 = ( hitType ) => { this.ヒットした回数[ hitType ]++; };
			this.スクロール譜面.背景動画再生開始 = () => { this.背景動画開始済み = true; };
			this.スクロール譜面.チップヒット = ( chip ) => {
				this.回転羽.発火する( chip.チップ種別 );
				this.ドラムサウンド.発声する( chip.チップ種別, chip.音量 * 0.25f );
			};
			this.スクロール譜面.ステージクリア = () => { this.現在のフェーズ = フェーズ.クリアor失敗; };
		}
		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "演奏ステージを開始します。" );
			Debug.Assert( null != StrokeStyleT.演奏スコア, "[バグあり] 演奏スコアが null です。" );

			#region " ヒットした回数をすべてクリア。"
			//----------------
			this.ヒットした回数.Clear();
			foreach( var 判定 in typeof( ヒット判定種別 ).GetEnumValues() )
				this.ヒットした回数[ (ヒット判定種別) 判定 ] = 0;
			//----------------
			#endregion
			#region " 選択ノードの持つ動画ファイルパスが有効なら背景動画とBGMを初期化する。"
			//----------------
			var 動画ファイルパス = ( (SST.曲.MusicNode) StrokeStyleT.曲ツリー管理.現在選択されているノード ).動画ファイルパス;
			if( 動画ファイルパス.Nullでも空でもない() )
			{
				this.子リスト.Add( this.背景動画 = new 動画( 動画ファイルパス ) );	// 子リストに追加
				this.BGM = new FDK.メディア.サウンド.WASAPI排他.Sound();
				this.BGM.ファイルから作成する( 動画ファイルパス );
				StrokeStyleT.Wasapiデバイス.サウンドをミキサーに追加する( this.BGM ); // 作成に失敗した Sound を追加しても鳴らないだけなので、ノーチェックで大丈夫。
			}
			//----------------
			#endregion

			this.演奏開始時刻sec = 0.0;
			this.現在進行描画中の譜面スクロール速度の倍率 = StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率;
			this.BGM再生開始済み = false;
			this.背景動画開始済み = false;
			this.レーンフレーム.左端位置dpx = 400f;
			this.レーンフレーム.高さdpx = dr.設計画面サイズdpx.Height;
			this.現在のフェーズ = フェーズ.演奏中;
			this.活性化した直後である = true;
		}
		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "演奏ステージを終了します。" );

			//this.BGMを解放する(); → ここではまだ解放しない。結果ステージが終わったときに解放する。

			if( null != this.背景動画 )
				this.子リスト.Remove( this.背景動画 );	// 子リストから削除
		}
		public override void 進行描画する( デバイスリソース dr )
		{
			// 進行描画。

			#region " 初めての進行描画。"
			//----------------
			if( this.活性化した直後である )
			{
				this.演奏開始時刻sec = this.サウンドタイマ.現在のデバイス位置secを取得する( StrokeStyleT.Wasapiデバイス.AudioClock );
				this.FPS = new FDK.カウンタ.FPS();
				this.活性化した直後である = false;
			}
			//----------------
			#endregion

			double 演奏時刻sec = this.サウンドタイマ.現在のデバイス位置secを取得する( StrokeStyleT.Wasapiデバイス.AudioClock ) - this.演奏開始時刻sec;

			this.FPS.FPSをカウントする();
			this.FPS.VPSをカウントする();
			this.FPS画像.表示文字列 = $"VPS: {this.FPS.現在のVPS.ToString()}";

			#region " 譜面スクロール速度の追い付き進行。"
			//----------------
			if( this.現在進行描画中の譜面スクロール速度の倍率 < StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 )
			{
				// 時間間隔に関係なく進行描画ごとに倍率を変えてしまっているが、まあVPSなど60～120くらいやろうからよし。
				this.現在進行描画中の譜面スクロール速度の倍率 =
					Math.Min( this.現在進行描画中の譜面スクロール速度の倍率 + 0.05, StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 );
			}
			else if( this.現在進行描画中の譜面スクロール速度の倍率 > StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 )
			{
				// 同上。
				this.現在進行描画中の譜面スクロール速度の倍率 =
					Math.Max( this.現在進行描画中の譜面スクロール速度の倍率 - 0.05, StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 );
			}
			//----------------
			#endregion

			if( this.背景動画開始済み )
			{
				// 背景動画チップがヒット済みなら、背景動画の進行描画を行う。
				this.背景動画?.進行描画する( dr, new SharpDX.RectangleF( 0f, 0f, dr.設計画面サイズdpx.Width, dr.設計画面サイズdpx.Height ) );

				// 動画が重たいかもしれないので、時刻をここで再取得する。
				演奏時刻sec = this.サウンドタイマ.現在のデバイス位置secを取得する( StrokeStyleT.Wasapiデバイス.AudioClock ) - this.演奏開始時刻sec;

				// 背景動画が再生されているのにBGMがまだ再生されていないなら、再生を開始する。
				if( false == this.BGM再生開始済み )
				{
					this.BGM?.再生を開始する();
					this.BGM再生開始済み = true;
				}
			}

			this.ステージ台.進行描画する( dr, 0.0f, 0.0f );
			this.レーンフレーム.進行描画する( dr );
			this.コンボ.進行描画する( dr );
			this.ヒット判定文字列.進行描画する( dr );
			this.スクロール譜面.小節線拍線を進行描画する( dr, 演奏時刻sec, this.現在進行描画中の譜面スクロール速度の倍率 );
			this.判定バー.進行描画する( dr, 597f, 座標.判定バーの中央Y座標dpx - 43f );
			this.ドラムセット.進行描画する( dr );
			this.スクロール譜面.チップを進行描画する( dr, 演奏時刻sec, this.現在進行描画中の譜面スクロール速度の倍率 );
			this.回転羽.進行描画する( dr );
			this.FPS画像.進行描画する( dr, 0f, 0f );

			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// ESC 押下 → キャンセル
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Escape ) )
			{
				this.BGMを解放する();
				this.現在のフェーズ = フェーズ.キャンセル;
			}
			// 上矢印押下 → 譜面スクロール速度の倍率を +0.5
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Up ) )
			{
				StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 =
					Math.Min( StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 + 0.5, 8.0 );    // 最大 8.0
			}
			// 下矢印押下 → 譜面スクロール速度の倍率を -0.5
			else if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Down ) )
			{
				StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 =
					Math.Max( StrokeStyleT.ユーザ管理.現在選択されているユーザ.譜面スクロール速度の倍率 - 0.5, 0.5 );    // 最小 0.5
			}
		}
		public void BGMを解放する()
		{
			if( null != this.BGM )  // 背景動画がなければ null である
			{
				StrokeStyleT.Wasapiデバイス.サウンドをミキサーから削除する( this.BGM );
				FDK.Utilities.解放する( ref this.BGM );
			}
		}

		protected bool 活性化した直後である = false;
		protected bool 背景動画開始済み = false;
		protected bool BGM再生開始済み = false;
		protected double 現在進行描画中の譜面スクロール速度の倍率 = 0.0;
		protected double 演奏開始時刻sec = 0.0;
		protected readonly FDK.メディア.サウンド.WASAPI排他.SoundTimer サウンドタイマ = new FDK.メディア.サウンド.WASAPI排他.SoundTimer();
		protected readonly SST.ステージ.演奏.コンボ コンボ;
		protected readonly SST.ステージ.演奏.レーンフレーム レーンフレーム;
		protected readonly SST.ステージ.演奏.スクロール譜面 スクロール譜面;
		protected readonly SST.ステージ.演奏.ヒット判定文字列 ヒット判定文字列;
		protected readonly SST.ステージ.演奏.回転羽 回転羽 = new 回転羽( 32 );
		protected readonly SST.ステージ.演奏.ドラムサウンド ドラムサウンド;
		protected readonly SST.ステージ.汎用.ドラムセット ドラムセット;
		protected readonly FDK.メディア.画像 判定バー;
		protected readonly FDK.メディア.画像 ステージ台;
		protected readonly FDK.メディア.文字列画像 FPS画像;
		/// <remarks>
		/// 解放は、このクラスの非活性化後に、外から行われる。
		/// <see cref="SST.ステージ.演奏.演奏ステージ.BGMを解放する"/>
		/// </remarks>
		protected FDK.メディア.サウンド.WASAPI排他.Sound BGM = null;
		protected FDK.カウンタ.FPS FPS = null;
		/// <summary>
		/// 動的子Activity。背景動画を再生しない場合は null のまま。
		/// </summary>
		protected FDK.メディア.動画 背景動画 = null;
	}
}
