﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.汎用
{
	/// <summary>
	/// ドラム一式を表す Activity。表示と操作が可能。
	/// </summary>
	class ドラムセット : FDK.Activity
	{
		/// <summary>
		/// 0.0:閉じる ～ 1.0:開く
		/// </summary>
		public float ハイハットの開度
		{
			get
			{
				return this.bs_ハイハットの開度;
			}
			set
			{
				if( 1.0f < value )
					throw new OutOfMemoryException( "1.0 を超える値は設定できません。" );
				else if( 0.0f > value )
					throw new OutOfMemoryException( "負数は設定できません。" );
				else
					this.bs_ハイハットの開度 = value;
			}
		}

		public ドラムセット()
		{
			this.子リスト.Add( this.HiHatTop = new 画像( @"$(Static)\images\DrumKit HiHat Top.png" ) );
			this.子リスト.Add( this.HiHatBottom = new 画像( @"$(Static)\images\DrumKit HiHat Bottom.png" ) );
			this.子リスト.Add( this.Snare = new 画像( @"$(Static)\images\DrumKit Snare.png" ) );
			this.子リスト.Add( this.Bass = new 画像( @"$(Static)\images\DrumKit Bass.png" ) );
			this.子リスト.Add( this.HiTom = new 画像( @"$(Static)\images\DrumKit HiTom.png" ) );
			this.子リスト.Add( this.LowTom = new 画像( @"$(Static)\images\DrumKit LowTom.png" ) );
			this.子リスト.Add( this.FloorTom = new 画像( @"$(Static)\images\DrumKit FloorTom.png" ) );
			this.子リスト.Add( this.LCymbal = new 画像( @"$(Static)\images\DrumKit LCymbal.png" ) );
			this.子リスト.Add( this.LCymbalStand = new 画像( @"$(Static)\images\DrumKit LCymbal Stand.png" ) );
			this.子リスト.Add( this.LCymbalTop = new 画像( @"$(Static)\images\DrumKit LCymbal Top.png" ) );
			this.子リスト.Add( this.RCymbal = new 画像( @"$(Static)\images\DrumKit RCymbal.png" ) );
			this.子リスト.Add( this.RCymbalStand = new 画像( @"$(Static)\images\DrumKit RCymbal Stand.png" ) );
			this.子リスト.Add( this.RCymbalTop = new 画像( @"$(Static)\images\DrumKit RCymbal Top.png" ) );
		}
		public void 進行描画する( デバイスリソース dr )
		{
			this.Bass.進行描画する( dr, 881f, 891f );
			this.LowTom.進行描画する( dr, 999f, 901f );
			this.HiTom.進行描画する( dr, 850f, 901f );
			this.FloorTom.進行描画する( dr, 1050f, 981f );
			this.Snare.進行描画する( dr, 741f, 988f );
			this.HiHatBottom.進行描画する( dr, 657f, 935f );
			this.HiHatTop.進行描画する( dr, 657f, ( 935f - 20f * this.ハイハットの開度 ) );
			this.RCymbalStand.進行描画する( dr, 1229f, 920f );
			this.RCymbal.進行描画する( dr, 1257f - this.RCymbal.サイズdpx.Width / 2f, 923f - this.RCymbal.サイズdpx.Height / 2f );
			this.RCymbalTop.進行描画する( dr, 1229f, 880f );
			this.LCymbalStand.進行描画する( dr, 472f, 916f );
			this.LCymbal.進行描画する( dr, 649f - this.LCymbal.サイズdpx.Width / 2f, 918f - this.LCymbal.サイズdpx.Height / 2f );
			this.LCymbalTop.進行描画する( dr, 633f, 891f );
		}

		protected readonly FDK.メディア.画像 HiHatTop;
		protected readonly FDK.メディア.画像 HiHatBottom;
		protected readonly FDK.メディア.画像 Snare;
		protected readonly FDK.メディア.画像 Bass;
		protected readonly FDK.メディア.画像 HiTom;
		protected readonly FDK.メディア.画像 LowTom;
		protected readonly FDK.メディア.画像 FloorTom;
		protected readonly FDK.メディア.画像 LCymbal;
		protected readonly FDK.メディア.画像 LCymbalStand;
		protected readonly FDK.メディア.画像 LCymbalTop;
		protected readonly FDK.メディア.画像 RCymbal;
		protected readonly FDK.メディア.画像 RCymbalStand;
		protected readonly FDK.メディア.画像 RCymbalTop;

		#region " バックストア。"
		//-----------------
		private float bs_ハイハットの開度 = 1.0f;
		//-----------------
		#endregion
	}
}
