﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Windows.Forms;

namespace SSTFEditor
{
	// ※デザイナでは開けないので注意すること。

	partial class メインフォーム : Form
	{
		public readonly int バージョン番号 = FileVersionInfo.GetVersionInfo( Assembly.GetExecutingAssembly().Location ).FileMajorPart;
		public readonly int マイナーバージョン番号 = FileVersionInfo.GetVersionInfo( Assembly.GetExecutingAssembly().Location ).FileMinorPart;
		public readonly int リビジョン番号 = FileVersionInfo.GetVersionInfo( Assembly.GetExecutingAssembly().Location ).FilePrivatePart;
		public readonly int ビルド番号 = FileVersionInfo.GetVersionInfo( Assembly.GetExecutingAssembly().Location ).FileBuildPart;

		public const int 最大音量 = 4;
		public const int 最小音量 = 1;

		public bool 未保存である
		{
			get
			{
				return this.bs_未保存である;
			}
			set
			{
				// まず値を保存。
				this.bs_未保存である = value;

				// ウィンドウのタイトルバーの文字列を修正。
				string 表示するファイルの名前 = ( string.IsNullOrEmpty( this.編集中のファイル名 ) ) ? Properties.Resources.NEW_FILENAME : this.編集中のファイル名;
				if( this.bs_未保存である )
				{
					// 変更ありかつ未保存なら「*」を付ける
					this.Text = $"SSTFEditor {this.バージョン番号}.{this.マイナーバージョン番号}.{this.リビジョン番号}.{this.ビルド番号} *[{表示するファイルの名前}]";
					this.toolStripMenuItem上書き保存.Enabled = true;
					this.toolStripButton上書き保存.Enabled = true;
				}
				else
				{
					// 保存後変更がないなら「*」なない
					this.Text = $"SSTFEditor {this.バージョン番号}.{this.マイナーバージョン番号}.{this.リビジョン番号}.{this.ビルド番号} [{表示するファイルの名前}]";
					this.toolStripMenuItem上書き保存.Enabled = false;
					this.toolStripButton上書き保存.Enabled = false;
				}
			}
		}
		public bool 選択モードである
		{
			get
			{
				return ( CheckState.Checked == this.toolStripButton選択モード.CheckState ) ? true : false;
			}
		}
		public bool 編集モードである
		{
			get
			{
				return ( CheckState.Checked == this.toolStripButton編集モード.CheckState ) ? true : false;
			}
		}

		public int GRID_PER_PART
		{
			get;
			protected set;
		}
		public int GRID_PER_PIXEL
		{
			get
			{
				return this.bs_GRID_PER_PIXEL / ( this.toolStripComboBox譜面拡大率.SelectedIndex + 1 );
			}
		}

		public bool 初期化完了 = false;
		public Config Config;
		public 選択モード 選択モード;
		public 編集モード 編集モード;
		public C譜面 譜面;
		public UndoRedo.管理 UndoRedo管理;
		public クリップボード クリップボード;
		public Size 譜面パネルサイズ
		{
			get { return this.pictureBox譜面パネル.ClientSize; }
		}
		public SSTFormat.チップ種別 現在のチップ種別
		{
			get
			{
				return this.bs_e現在のチップ種別; 
			}
			set
			{
				this.bs_e現在のチップ種別 = value;
				this.label現在のチップ種別.Text = this.チップ種別toチップ名対応表[ value ];
			}
		}
		public int 現在のチップ音量 = メインフォーム.最大音量;

		public メインフォーム()
		{
			InitializeComponent();

			this.Actアプリを起動する();
		}

		public void 選択モードに切替えて関連GUIを設定する()
		{
			this.toolStripButton選択モード.CheckState = CheckState.Checked;
			this.toolStripButton編集モード.CheckState = CheckState.Unchecked;

			this.toolStripMenuItem選択モード.CheckState = CheckState.Checked;
			this.toolStripMenuItem編集モード.CheckState = CheckState.Unchecked;

			this.label現在のチップ種別.Text = "----";

			this.譜面をリフレッシュする();
		}
		public void 編集モードに切替えて関連GUIを設定する()
		{
			this.選択モード.全チップの選択を解除する();
			this.譜面をリフレッシュする();

			this.toolStripButton選択モード.CheckState = CheckState.Unchecked;
			this.toolStripButton編集モード.CheckState = CheckState.Checked;

			this.toolStripMenuItem選択モード.CheckState = CheckState.Unchecked;
			this.toolStripMenuItem編集モード.CheckState = CheckState.Checked;
		}
		public void 選択チップの有無に応じて編集用GUIのEnabledを設定する()
		{
			bool 譜面上に選択チップがある = this.選択チップが１個以上ある;
			bool クリップボードに選択チップがある = ( null != this.クリップボード ) && ( 0 < this.クリップボード.セル数 );

			// 編集メニューの Enabled 設定
			this.toolStripMenuItemコピー.Enabled = 譜面上に選択チップがある;
			this.toolStripMenuItem切り取り.Enabled = 譜面上に選択チップがある;
			this.toolStripMenuItem貼り付け.Enabled = クリップボードに選択チップがある;
			this.toolStripMenuItem削除.Enabled = 譜面上に選択チップがある;

			// ツールバーの Enabled 設定
			this.toolStripButtonコピー.Enabled = 譜面上に選択チップがある;
			this.toolStripButton切り取り.Enabled = 譜面上に選択チップがある;
			this.toolStripButton貼り付け.Enabled = クリップボードに選択チップがある;
			this.toolStripButton削除.Enabled = 譜面上に選択チップがある;

			// 右メニューの Enabled 設定
			this.toolStripMenuItem選択チップのコピー.Enabled = 譜面上に選択チップがある;
			this.toolStripMenuItem選択チップの切り取り.Enabled = 譜面上に選択チップがある;
			this.toolStripMenuItem選択チップの貼り付け.Enabled = クリップボードに選択チップがある;
			this.toolStripMenuItem選択チップの削除.Enabled = 譜面上に選択チップがある;
		}
		public void 譜面をリフレッシュする()
		{
			this.pictureBox譜面パネル.Refresh();
		}
		public void UndoRedo用GUIのEnabledを設定する()
		{
			bool Undo可 = ( 0 < this.UndoRedo管理.Undo可能な回数 ) ? true : false;
			bool Redo可 = ( 0 < this.UndoRedo管理.Redo可能な回数 ) ? true : false;

			this.toolStripMenuItem元に戻す.Enabled = Undo可;
			this.toolStripMenuItemやり直す.Enabled = Redo可;
			this.toolStripButton元に戻す.Enabled = Undo可;
			this.toolStripButtonやり直す.Enabled = Redo可;
		}
		public void 選択モードのコンテクストメニューを表示する( int x, int y )
		{
			this.contextMenuStrip譜面右メニュー.Show( this.pictureBox譜面パネル, x, y );
	
			// メニューを表示した時のマウス座標を控えておく。
			this.選択モードのコンテクストメニューを開いたときのマウスの位置 = new Point( x, y );
		}
		public void 譜面を縦スクロールする( int nスクロール量grid )
		{
			int 現在の位置grid = this.vScrollBar譜面用垂直スクロールバー.Value;
			int スクロール後の位置grid = this.vScrollBar譜面用垂直スクロールバー.Value + nスクロール量grid;
			int 最小値grid = this.vScrollBar譜面用垂直スクロールバー.Minimum;
			int 最大値grid = ( this.vScrollBar譜面用垂直スクロールバー.Maximum + 1 ) - this.vScrollBar譜面用垂直スクロールバー.LargeChange;
			
			if( スクロール後の位置grid < 最小値grid )
			{
				スクロール後の位置grid = 最小値grid;
			}
			else if( スクロール後の位置grid > 最大値grid )
			{
				スクロール後の位置grid = 最大値grid;
			}

			this.vScrollBar譜面用垂直スクロールバー.Value = スクロール後の位置grid;
		}

		protected readonly Dictionary<SSTFormat.チップ種別, string> チップ種別toチップ名対応表 = new Dictionary<SSTFormat.チップ種別, string>() {
			#region [ **** ]
			//-----------------
			{ SSTFormat.チップ種別.Bass, "BassDrum" },
			{ SSTFormat.チップ種別.BPM, "BPM" },
			{ SSTFormat.チップ種別.China, "China" },
			{ SSTFormat.チップ種別.HiHat_Close, "HiHat(Close)" },
			{ SSTFormat.チップ種別.HiHat_Foot, "FootPedal" },
			{ SSTFormat.チップ種別.HiHat_HalfOpen, "HiHat(HarfOpen)" },
			{ SSTFormat.チップ種別.HiHat_Open, "HiHat(Open)" },
			{ SSTFormat.チップ種別.LeftCrash, "Crash" },
			{ SSTFormat.チップ種別.Ride, "Ride" },
			{ SSTFormat.チップ種別.Ride_Cup, "Ride(Cup)" },
			{ SSTFormat.チップ種別.RightCrash, "Crash" },
			{ SSTFormat.チップ種別.Snare, "Snare" },
			{ SSTFormat.チップ種別.Snare_ClosedRim, "Snare(CloseRimShot)" },
			{ SSTFormat.チップ種別.Snare_Ghost, "Snare(Ghost)" },
			{ SSTFormat.チップ種別.Snare_OpenRim, "Snare(OpenRimShot)" },
			{ SSTFormat.チップ種別.Splash, "Splash" },
			{ SSTFormat.チップ種別.Tom1, "HighTom" },
			{ SSTFormat.チップ種別.Tom1_Rim, "HighTom(RimShot)" },
			{ SSTFormat.チップ種別.Tom2, "LowTom" },
			{ SSTFormat.チップ種別.Tom2_Rim, "LowTom(RimShot)" },
			{ SSTFormat.チップ種別.Tom3, "FloorTom" },
			{ SSTFormat.チップ種別.Tom3_Rim, "FloorTom(RimShot)" },
			{ SSTFormat.チップ種別.Unknown, "" },
			{ SSTFormat.チップ種別.小節線, "" },
			{ SSTFormat.チップ種別.背景動画, "" },
			{ SSTFormat.チップ種別.拍線, "" },
			{ SSTFormat.チップ種別.小節メモ, "" },
			//-----------------
			#endregion
		};
		protected bool bs_未保存である = false;
		protected SSTFormat.チップ種別 bs_e現在のチップ種別;
		protected int bs_GRID_PER_PIXEL = 1;
		protected bool 選択チップが１個以上ある
		{
			get
			{
				if( ( null != this.譜面.SSTFormatScore ) && 
					( null != this.譜面.SSTFormatScore.listチップ ) &&
					( 0 < this.譜面.SSTFormatScore.listチップ.Count ) )
				{
					foreach( var chip in this.譜面.SSTFormatScore.listチップ )
					{
						if( chip.選択が確定している )
							return true;
					}
				}
				return false;
			}
		}
		protected int 現在のガイド間隔 = 0;
		protected Point 選択モードのコンテクストメニューを開いたときのマウスの位置;

		/// <summary>
		/// システムフォルダ。
		/// SSTFEditor.exe と StrokeStyleT.exe が格納されているフォルダへのパス。
		/// 末尾は '\'。
		/// </summary>
		/// <remarks>
		/// 例："c:\Program Files\StrokeStyleT\" 
		/// </remarks>
		protected string システムフォルダパス = @"\";
		/// <summary>
		/// Windowsログインユーザのアプリデータフォルダ。
		/// 末尾は '\'。
		/// </summary>
		/// <remarks>
		/// 例: "C:\Users\ログインユーザ名\ApplicationData\SSTFEditor\"
		/// </remarks>
		protected string ユーザフォルダパス = @"\";
		/// <summary>
		/// 作業フォルダ。
		/// 末尾は '\'。
		/// </summary>
		/// <remarks>
		/// ダイアログでカレントフォルダを移動したりすると、作業フォルダも移動する。
		/// </remarks>
		protected string 作業フォルダパス = @"\";
		/// <summary>
		/// ファイル名。
		/// </summary>
		/// <remarks>
		/// 例: "test.sstf"
		/// </remarks>
		protected string 編集中のファイル名 = "";
		/// <summary>
		/// システムフォルダ＋プレイヤー名。
		/// </summary>
		/// <remarks>
		/// 例："C:\Program Files\StrokeStyleT\StrokeStyleT.exe"
		/// </remarks>
		protected string プレイヤーの絶対パスファイル名 = "";
		protected string 最後にプレイヤーに渡した一時ファイル名 = "";

		// アクションメソッド（最上位の機能。メニューやコマンドバーなどから呼び出される。）

		protected void Actアプリを起動する()
		{
			this.GRID_PER_PART = int.Parse( Properties.Resources.GRID_PER_PART );
			this.bs_GRID_PER_PIXEL = int.Parse( Properties.Resources.GRID_PER_PIXEL );

			#region " システムフォルダ、ユーザフォルダ、作業フォルダ、プレイヤーの絶対パスファイル名 を取得する。"
			//-----------------
#if DEBUG
			this.システムフォルダパス = Environment.CurrentDirectory;		// DEBUG 時に限り、システムフォルダはカレントフォルダ（VC# で設定した作業フォルダ）になる。
#else
			this.システムフォルダパス = Path.GetDirectoryName( Application.ExecutablePath );	// DEBUG 以外は、exe の存在するフォルダ。
#endif
			this.ユーザフォルダパス = Path.Combine( Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData ), @"SSTFEditor" );
			if( false == Directory.Exists( this.ユーザフォルダパス ) )		// なければ作成する。
				Directory.CreateDirectory( this.ユーザフォルダパス );

			this.作業フォルダパス = Environment.GetFolderPath( Environment.SpecialFolder.MyDocuments ); // 作業フォルダの初期値としてユーザのマイドキュメントフォルダを設定する。
			this.プレイヤーの絶対パスファイル名 = Path.Combine( this.システムフォルダパス, Properties.Resources.PLAYER_NAME );
			//-----------------
			#endregion

			// Config.xml を読み込む。
			this.Config = Config.読み込む( Path.Combine( this.ユーザフォルダパス, Properties.Resources.CONFIG_FILE_NAME ) );

			// デザイナでは追加できないイベントを手動で追加する。
			this.splitContainer分割パネルコンテナ.MouseWheel += new MouseEventHandler( splitContainer分割パネルコンテナ_MouseWheel );
			
			// 最近使ったファイル一覧を更新する。
			this.ConfigのRecentUsedFilesをファイルメニューへ追加する();
			
			// その他の初期化。
			this.Act新規作成する();
			this.Actガイド間隔を変更する( 16 );	// 初期は 1/16 間隔。
			this.Act譜面拡大率を変更する( 1 );		// 初期は 標準。

			// 完了。
			this.初期化完了 = true;
		}
		protected void Actアプリを終了する()
		{
			// 一時ファイルを削除する。
			if( File.Exists( this.最後にプレイヤーに渡した一時ファイル名 ) )
				File.Delete( this.最後にプレイヤーに渡した一時ファイル名 );

			// Config.xml を保存する。
			this.Config.保存する( Path.Combine( this.ユーザフォルダパス, Properties.Resources.CONFIG_FILE_NAME ) );
			
			FDK.Utilities.解放する( ref this.譜面 );
			FDK.Utilities.解放する( ref this.選択モード );
		}
		protected void Act新規作成する()
		{
			if( DialogResult.Cancel == this.未保存なら保存する() )
				return; // 保存がキャンセルされた場合はここで中断。

			this.エディタを初期化する();
		}
		protected void Act開く()
		{
			if( DialogResult.Cancel == this.未保存なら保存する() )
				return; // 保存がキャンセルされた場合はここで中断。

			#region " 「ファイルを開く」ダイアログでファイルを選択する。 "
			//-----------------
			var dialog = new OpenFileDialog() {
				Title = Properties.Resources.MSG_ファイル選択ダイアログのタイトル,
				Filter = Properties.Resources.MSG_ファイル選択ダイアログのフィルタ,
				FilterIndex = 1,
				InitialDirectory = this.作業フォルダパス,
			};
			var result = dialog.ShowDialog( this );

			// メインフォームを再描画してダイアログを完全に消す。
			this.Refresh();

			// OKじゃないならここで中断。
			if( DialogResult.OK != result )
				return;
			//-----------------
			#endregion

			this.ファイルを読み込む( dialog.FileName );
		}
		protected void Act指定されたファイルを開く( string strFileNames )
		{
			if( DialogResult.Cancel == this.未保存なら保存する() )
				return; // 保存がキャンセルされた場合はここで中断。

			this.ファイルを読み込む( strFileNames );
		}
		protected void Act上書き保存する()
		{
			if( string.IsNullOrEmpty( this.編集中のファイル名 ) )
			{
				#region " ファイル名が未設定なら、初めての保存と見なし、ファイル保存ダイアログで保存ファイル名を指定させる。"
				//-----------------
				string 絶対パスファイル名 = this.ファイル保存ダイアログを開いてファイル名を取得する();

				if( string.IsNullOrEmpty( 絶対パスファイル名 ) )
					return; // ファイル保存ダイアログがキャンセルされたのならここで打ち切り。

				this.作業フォルダパス = Path.GetDirectoryName( 絶対パスファイル名 );	// ダイアログでディレクトリを変更した場合、カレントディレクトリも変更されている。
				this.編集中のファイル名 = Path.GetFileName( 絶対パスファイル名 );
				//-----------------
				#endregion
			}

			this.Act上書き保存する(
				Path.Combine( this.作業フォルダパス, this.編集中のファイル名 ),
				プレイヤー用一時ファイルである: false );
		}
		protected void Act上書き保存する( string ファイルの絶対パス, bool プレイヤー用一時ファイルである )
		{
			#region "「保存中です」ポップアップを表示する。"
			//-----------------
			var msg = new Popupメッセージ( 
				Properties.Resources.MSG_保存中です + Environment.NewLine + 
				Properties.Resources.MSG_しばらくお待ち下さい );
			msg.Owner = this;
			msg.Show();
			msg.Refresh();
			//-----------------
			#endregion
			#region " 選択モードだったら、選択を解除する。"
			//-----------------
			if( this.選択モードである )
				this.選択モード.全チップの選択を解除する();
			//-----------------
			#endregion
			#region " 出力するパス内の背景動画を検索する。"
			//-----------------
			this.textBox背景動画.Text =
				( from ファイル名 in Directory.GetFiles( Path.GetDirectoryName( ファイルの絶対パス ) )
				  where SSTFormat.スコア.listデフォルト拡張子.Any( 拡張子名 => ( Path.GetExtension( ファイル名 ).ToLower() == 拡張子名 ) )
				  select ファイル名 ).FirstOrDefault();  // 複数あったら、最初に見つけたほうを採用。1つも見つからなければ null。
			//-----------------
			#endregion
			#region " SSTFファイルを出力する。"
			//-----------------
			this.譜面.SSTFファイルを書き出す(
				ファイルの絶対パス,
				$"# Created by SSTFEditor {this.バージョン番号}.{this.マイナーバージョン番号}.{this.リビジョン番号}.{this.ビルド番号}" );
			//-----------------
			#endregion
			#region " 出力したファイルのパスを、[ファイル]メニューの最近使ったファイル一覧に追加する。"
			//-----------------
			if( false == プレイヤー用一時ファイルである )
			{
				this.Config.ファイルを最近使ったファイルの一覧に追加する( ファイルの絶対パス );
				this.ConfigのRecentUsedFilesをファイルメニューへ追加する();
			}
			//-----------------
			#endregion
			#region "「保存中です」ポップアップを閉じる。"
			//-----------------
			msg.Close();
			//-----------------
			#endregion

			// 最後に、ダイアログのゴミなどを消すために再描画。
			this.Refresh();

			if( false == プレイヤー用一時ファイルである )
				this.未保存である = false;
		}
		protected void Act名前を付けて保存する()
		{
			#region " ユーザに保存ファイル名を入力させる。"
			//-----------------
			string 絶対パスファイル名 = this.ファイル保存ダイアログを開いてファイル名を取得する();
			if( string.IsNullOrEmpty( 絶対パスファイル名 ) )
				return;	// キャンセルされたらここで中断。

			this.作業フォルダパス = Path.GetDirectoryName( 絶対パスファイル名 );
			this.編集中のファイル名 = Path.GetFileName( 絶対パスファイル名 );
			//-----------------
			#endregion

			this.Act上書き保存する();

			this.未保存である = true;	// ウィンドウタイトルに表示されているファイル名を変更するため、一度わざと true にする。
			this.未保存である = false;
		}
		protected void Act終了する()
		{
			this.Close();
		}
		protected void Act元に戻す()
		{
			// Undo する対象を UndoRedoリストから取得する。
			var cell = this.UndoRedo管理.Undoするセルを取得して返す();
			if( null == cell )
				return;		// なければ中断

			// Undo を実行する。
			cell.Undoを実行する();

			// GUIを再描画する。
			this.UndoRedo用GUIのEnabledを設定する();
			this.選択チップの有無に応じて編集用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
		}
		protected void Actやり直す()
		{
			// Redo する対象を UndoRedoリストから取得する。
			var cell = this.UndoRedo管理.Redoするセルを取得して返す();
			if( null == cell )
				return;	// なければ中断

			// Redo を実行する。
			cell.Redoを実行する();

			// GUI を再描画する。
			this.UndoRedo用GUIのEnabledを設定する();
			this.選択チップの有無に応じて編集用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
		}
		protected void Act切り取る()
		{
			// 譜面にフォーカスがないなら、何もしない。
			if( false == this.pictureBox譜面パネル.Focused )
				return;

			// 切り取り ＝ コピー ＋ 削除
			this.Actコピーする();
			this.Act削除する();
		}
		protected void Actコピーする()
		{
			// 譜面にフォーカスがないなら何もしない。
			if( false == this.pictureBox譜面パネル.Focused )
				return;

			// コピーする。
			this.クリップボード.現在選択されているチップをボードにコピーする();

			// 画面を再描画する。
			this.選択チップの有無に応じて編集用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
		}
		protected void Act貼り付ける( int 貼り付けを開始する譜面内絶対位置grid )
		{
			// 譜面にフォーカスがないなら何もしない。
			if( false == this.pictureBox譜面パネル.Focused )
				return;

			this.クリップボード.tチップを指定位置から貼り付ける( 貼り付けを開始する譜面内絶対位置grid );
		}
		protected void Act削除する()
		{
			// 譜面にフォーカスがないなら何もしない。
			if( false == this.pictureBox譜面パネル.Focused )
				return;

			this.UndoRedo管理.トランザクション記録を開始する();

			// 譜面が持つすべてのチップについて、選択されているチップがあれば削除する。
			for( int i = this.譜面.SSTFormatScore.listチップ.Count - 1; 0 <= i; i-- )
			{
				var chip = this.譜面.SSTFormatScore.listチップ[ i ];

				if( chip.選択が確定している )
				{
					var chip変更前 = new SSTFormat.チップ( chip );

					var cell = new UndoRedo.セル<SSTFormat.チップ>(
						所有者ID: null, 
						undoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							変更対象.CopyFrom( 変更前 );
							this.譜面.SSTFormatScore.listチップ.Add( 変更対象 );
							this.譜面.SSTFormatScore.listチップ.Sort();
						}, 
						redoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							this.譜面.SSTFormatScore.listチップ.Remove( 変更対象 );
							this.未保存である = true;
						},
						変更対象: chip,
						変更前の値: chip変更前,
						変更後の値: null,
						任意1: null,
						任意2: null );

					this.UndoRedo管理.セルを追加する( cell );
					cell.Redoを実行する();
				}
			}

			this.UndoRedo管理.トランザクション記録を終了する();

			// GUI を再描画する。
			this.UndoRedo用GUIのEnabledを設定する();
			this.選択チップの有無に応じて編集用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
		}
		protected void Actすべて選択する()
		{
			// 編集モードなら強制的に選択モードにする。
			if( this.編集モードである )
				this.選択モードに切替えて関連GUIを設定する();

			this.選択モード.全チップを選択する();
		}
		protected void Act選択モードにする()
		{
			this.選択モードに切替えて関連GUIを設定する();
		}
		protected void Act編集モードにする()
		{
			this.編集モードに切替えて関連GUIを設定する();
		}
		protected void Actモードを切替える()
		{
			if( this.選択モードである )
			{
				this.編集モードに切替えて関連GUIを設定する();
			}
			else
			{
				this.選択モードに切替えて関連GUIを設定する();
			}
		}
		protected void Act検索する()
		{
			this.選択モード.検索する();			// モードによらず、検索はすべて選択モードオブジェクトが行う。	
		}
		protected void Actガイド間隔を変更する( int n分 )
		{
			#region " 引数チェック。"
			//-----------------
			if( !new List<int>() { 4, 6, 8, 12, 16, 24, 32, 48, 64, 128, 0 }.Contains( n分 ) )
				throw new ArgumentException( $"不正なガイド間隔({n分})が指定されました。" );
			//-----------------
			#endregion
			#region " 新しいガイド間隔を設定する。"
			//-----------------
			this.現在のガイド間隔 = n分;
			this.譜面.現在のガイド間隔を変更する( n分 );	// 譜面オブジェクトにも伝達。
			//-----------------
			#endregion
			#region " ガイド間隔関連GUI（メニュー、コンボボックス）を更新する。"
			//-----------------
			// 一度すべてのガイド間隔メニューのチェックをはずし、制定された分数のメニューのみチェックする。 
			this.toolStripMenuItemガイド間隔4分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔6分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔8分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔12分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔16分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔24分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔32分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔48分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔64分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔128分.CheckState = CheckState.Unchecked;
			this.toolStripMenuItemガイド間隔フリー.CheckState = CheckState.Unchecked;

			switch( n分 )
			{
				// Menu と ComboBox の２つを変更することでイベントが２つ発生し、最終的に
				// Actガイド間隔を変更する() を立て続けに２回呼び出してしまうことになるが……、まぁよしとする。（汗

				case 4:
					this.toolStripMenuItemガイド間隔4分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 0;
					break;

				case 6:
					this.toolStripMenuItemガイド間隔6分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 1;
					break;

				case 8:
					this.toolStripMenuItemガイド間隔8分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 2;
					break;

				case 12:
					this.toolStripMenuItemガイド間隔12分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 3;
					break;

				case 16:
					this.toolStripMenuItemガイド間隔16分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 4;
					break;

				case 24:
					this.toolStripMenuItemガイド間隔24分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 5;
					break;

				case 32:
					this.toolStripMenuItemガイド間隔32分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 6;
					break;

				case 48:
					this.toolStripMenuItemガイド間隔48分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 7;
					break;

				case 64:
					this.toolStripMenuItemガイド間隔64分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 8;
					break;

				case 128:
					this.toolStripMenuItemガイド間隔128分.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 9;
					break;

				case 0:
					this.toolStripMenuItemガイド間隔フリー.CheckState = CheckState.Checked;
					this.toolStripComboBoxガイド間隔.SelectedIndex = 10;
					break;
			}
			//-----------------
			#endregion
			#region " 画面を再描画する。"
			//-----------------
			this.pictureBox譜面パネル.Invalidate();
			//-----------------
			#endregion
		}
		protected void Actガイド間隔を拡大する()
		{
			switch( this.現在のガイド間隔 )
			{
				case 4: break;
				case 6: this.Actガイド間隔を変更する( 4 ); break;
				case 8: this.Actガイド間隔を変更する( 6 ); break;
				case 12: this.Actガイド間隔を変更する( 8 ); break;
				case 16: this.Actガイド間隔を変更する( 12 ); break;
				case 24: this.Actガイド間隔を変更する( 16 ); break;
				case 32: this.Actガイド間隔を変更する( 24 ); break;
				case 48: this.Actガイド間隔を変更する( 32 ); break;
				case 64: this.Actガイド間隔を変更する( 48 ); break;
				case 128: this.Actガイド間隔を変更する( 64 ); break;
				case 0: this.Actガイド間隔を変更する( 128 ); break;
			}
		}
		protected void Actガイド間隔を縮小する()
		{
			switch( this.現在のガイド間隔 )
			{
				case 4: this.Actガイド間隔を変更する( 6 ); break;
				case 6: this.Actガイド間隔を変更する( 8 ); break;
				case 8: this.Actガイド間隔を変更する( 12 ); break;
				case 12: this.Actガイド間隔を変更する( 16 ); break;
				case 16: this.Actガイド間隔を変更する( 24 ); break;
				case 24: this.Actガイド間隔を変更する( 32 ); break;
				case 32: this.Actガイド間隔を変更する( 48 ); break;
				case 48: this.Actガイド間隔を変更する( 64 ); break;
				case 64: this.Actガイド間隔を変更する( 128 ); break;
				case 128: this.Actガイド間隔を変更する( 0 ); break;
				case 0: break;
			}
		}
		protected void Act譜面拡大率を変更する( int n倍 )
		{
			if( ( 1 > n倍 ) || ( 10 < n倍 ) )
				throw new ArgumentException( $"不正な譜面拡大率({n倍})が指定されました。" );

			this.toolStripComboBox譜面拡大率.SelectedIndex = ( n倍 - 1 );
			this.譜面をリフレッシュする();
		}
		protected void Act最初から再生する()
		{
			this.Act指定された小節の先頭から再生する( 小節番号: 0 );
		}
		protected void Act現在位置から再生する()
		{
			int 位置grid;
			int 小節番号 = this.譜面.譜面内絶対位置gridにおける小節の番号と小節先頭の位置gridを返す( this.譜面.現在のカレントラインの譜面内絶対位置grid, out 位置grid );
			this.Act指定された小節の先頭から再生する( 小節番号 );
		}
		protected void Act現在位置からBGMのみ再生する()
		{
			int 位置grid;
			int 小節番号 = this.譜面.譜面内絶対位置gridにおける小節の番号と小節先頭の位置gridを返す( this.譜面.現在のカレントラインの譜面内絶対位置grid, out 位置grid );
			this.Act指定された小節の先頭から再生する( 小節番号, 仮想ドラムを使う: false );
		}
		protected void Act指定された小節の先頭から再生する( int 小節番号 )
		{
			this.Act指定された小節の先頭から再生する( 小節番号, 仮想ドラムを使う: true );
		}
		protected void Act指定された小節の先頭から再生する( int 小節番号, bool 仮想ドラムを使う )
		{
			if( string.IsNullOrEmpty( this.プレイヤーの絶対パスファイル名 ) ||
				( false == File.Exists( this.プレイヤーの絶対パスファイル名 ) ) )
				return;

			// 前回のテンポラリファイルが存在していれば削除する。
			if( File.Exists( this.最後にプレイヤーに渡した一時ファイル名 ) )
				File.Delete( this.最後にプレイヤーに渡した一時ファイル名 );

			// 譜面を新しくテンポラリファイルとして出力する。
			do
			{
				this.最後にプレイヤーに渡した一時ファイル名 = Path.Combine( this.作業フォルダパス, Path.GetRandomFileName() );
			} while( File.Exists( this.最後にプレイヤーに渡した一時ファイル名 ) );	// 同一名のファイルが存在してたらもう一度。（まずないだろうが）

			this.Act上書き保存する( 
				this.最後にプレイヤーに渡した一時ファイル名, 
				プレイヤー用一時ファイルである: true );	// 一時ファイルなので、「最近使ったファイル一覧」には残さない。

			// プレイヤーを起動する。
			Process.Start( this.プレイヤーの絶対パスファイル名, "\"" + this.最後にプレイヤーに渡した一時ファイル名 + "\" -p " + 小節番号.ToString() + (( 仮想ドラムを使う ) ? @" -h" : @"") );
		}
		protected void Act再生を停止する()
		{
			if( string.IsNullOrEmpty( this.プレイヤーの絶対パスファイル名 ) ||
				( false == File.Exists( this.プレイヤーの絶対パスファイル名 ) ) )
				return;

			Process.Start( this.プレイヤーの絶対パスファイル名, @"-s" );
		}
		protected void Actオプションを設定する()
		{
			var dialog = new オプションダイアログ();

			// Config の現在の値をダイアログへ反映する。
			dialog.checkBoxオートフォーカス.CheckState = ( this.Config.AutoFocus ) ? CheckState.Checked : CheckState.Unchecked;
			dialog.checkBox最近使用したファイル.CheckState = ( this.Config.ShowRecentUsedFiles ) ? CheckState.Checked : CheckState.Unchecked;
			dialog.numericUpDown最近使用したファイルの最大表示個数.Value = this.Config.MaxOfUsedRecentFiles;

			if( DialogResult.OK == dialog.ShowDialog( this ) )
			{
				// 決定された値をダイアログから Config に反映する。
				this.Config.AutoFocus = dialog.checkBoxオートフォーカス.Checked;
				this.Config.ShowRecentUsedFiles = dialog.checkBox最近使用したファイル.Checked;
				this.Config.MaxOfUsedRecentFiles = (int) dialog.numericUpDown最近使用したファイルの最大表示個数.Value;

				// [ファイル] メニューを修正。
				this.ConfigのRecentUsedFilesをファイルメニューへ追加する();
			}

			// 画面を再描画してダイアログのゴミを消す。
			this.Refresh();
		}
		protected void Actバージョンを表示する()
		{
			using( var dialog = new バージョン表示ダイアログ() )
				dialog.ShowDialog( this );
		}
		protected void Act小節長倍率を変更する( int 小節番号 )
		{
			double 変更後倍率 = 1.0;

			#region " 変更後の小節長倍率をユーザに入力させる。"
			//-----------------
			var db現在の小節長倍率 = this.譜面.SSTFormatScore.小節長倍率を取得する( 小節番号 );
			var dialog = new 小節長倍率入力ダイアログ( 小節番号 ) {
				f倍率 = (float) db現在の小節長倍率,
				後続も全部変更する = false,
			};
			if( DialogResult.OK != dialog.ShowDialog( this ) )  // キャンセルされたらここで中断。
				return;
			変更後倍率 = (double) dialog.f倍率;
			//-----------------
			#endregion

			int 変更開始小節番号 = 小節番号;
			int 変更終了小節番号 = ( dialog.後続も全部変更する ) ? this.譜面.SSTFormatScore.最大小節番号 : 小節番号;

			// 変更する。
			this.UndoRedo管理.トランザクション記録を開始する();

			for( int i = 変更開始小節番号; i <= 変更終了小節番号; i++ )
			{
				var 変更前倍率 = this.譜面.SSTFormatScore.小節長倍率を取得する( i );

				#region " 新しい小節長倍率を設定する。"
				//-----------------
				var cell = new UndoRedo.セル<double>(
					所有者ID: null,
					undoアクション: ( 変更対象, 変更前, 変更後, 対象小節番号, 任意2 ) => {
						this.譜面.SSTFormatScore.小節長倍率を設定する( (int) 対象小節番号, 変更前 );
						this.未保存である = true;
					},
					redoアクション: 	( 変更対象, 変更前, 変更後, 対象小節番号, 任意2 ) => {
						this.譜面.SSTFormatScore.小節長倍率を設定する( (int) 対象小節番号, 変更後 );
						this.未保存である = true;
					},
					変更対象: 0.0,
					変更前の値: 変更前倍率,
					変更後の値: 変更後倍率,
					任意1: i,
					任意2: null );

				this.UndoRedo管理.セルを追加する( cell );
				cell.Redoを実行する();
				//-----------------
				#endregion
				#region " チップを移動または削除する。"
				//-----------------
				int 変化量grid = (int) ( ( 変更後倍率 - 変更前倍率 ) * this.GRID_PER_PART );

				for( int j = this.譜面.SSTFormatScore.listチップ.Count - 1; j >= 0; j-- )	// 削除する場合があるので後ろからカウントする。
				{
					var chip = this.譜面.SSTFormatScore.listチップ[ j ];

					// (A) 変更対象の小節内のチップ　→　移動なし。カウント変更あり。小節はみ出しチェックあり。
					if( chip.小節番号 == i )
					{
						#region " 小節からはみ出したチップは、削除する。"
						//-----------------
						int 次小節の先頭位置grid = this.譜面.小節先頭の譜面内絶対位置gridを返す( i ) + (int) ( 変更後倍率 * this.GRID_PER_PART );
						if( 次小節の先頭位置grid <= chip.譜面内絶対位置grid )
						{
							var chip変更前 = new SSTFormat.チップ( chip );

							var cc = new UndoRedo.セル<SSTFormat.チップ>(
								所有者ID: null,
								undoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
									変更対象.CopyFrom( 変更前 );
									this.譜面.SSTFormatScore.listチップ.Add( 変更対象 );
									this.譜面.SSTFormatScore.listチップ.Sort();
									this.未保存である = true;
								},
								redoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
									this.譜面.SSTFormatScore.listチップ.Remove( 変更対象 );
									this.未保存である = true;
								},
								変更対象: chip,
								変更前の値: chip変更前,
								変更後の値: null,
								任意1: null,
								任意2: null );

							this.UndoRedo管理.セルを追加する( cc );
							cc.Redoを実行する();
						}
						//-----------------
						#endregion
						#region " 小節からはみ出さなかったチップは、カウント（小節解像度と小節内位置）を変更する。"
						//-----------------
						else
						{
							// 解像度が小さいと計算結果がおかしくなるので、無条件に解像度を上げる。

							int 十分に大きな値 = this.GRID_PER_PART;	// 充分に大きい数なら何でもいい。
							if( 十分に大きな値 > chip.小節解像度 )	// 何度も乗算されたら値が肥大化しまくるので、制限をかける。
							{
								chip.小節解像度 *= 十分に大きな値;
								chip.小節内位置 *= 十分に大きな値;
							}

							// 小節解像度を変更する。（小節内位置は変更しない。）
							chip.小節解像度 = (int) ( 変更後倍率 * chip.小節解像度 );
						}
						//-----------------
						#endregion
					}

					// (B) 変更対象より先の小節内のチップ　→　移動あり。カウントなし。小節はみ出しチェックなし。
					else if( i < chip.小節番号 )
					{
						#region " チップを n変化量grid 移動する。"
						//-----------------
						var cc = new UndoRedo.セル<SSTFormat.チップ>(
							所有者ID: null,
							undoアクション: ( 変更対象, 変更前, 変更後, _変化量grid, 任意2 ) => {	
								 変更対象.譜面内絶対位置grid -= (int) _変化量grid;
								 this.未保存である = true;
							 },
							redoアクション: ( 変更対象, 変更前, 変更後, _変化量grid, 任意2 ) => {
								 変更対象.譜面内絶対位置grid += (int) _変化量grid;
								 this.未保存である = true;
							 },
							変更対象: chip,
							変更前の値: null,
							変更後の値: null,
							任意1: 変化量grid,
							任意2: null );

						this.UndoRedo管理.セルを追加する( cc );
						cc.Redoを実行する();
						//-----------------
						#endregion
					}
				}
				//-----------------
				#endregion
			}

			this.UndoRedo管理.トランザクション記録を終了する();
			
			// 画面を再描画する。
			this.UndoRedo用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
		}
		protected void Act小節を挿入する( int 挿入前小節番号 )
		{
			// 挿入する新しい小節の小節長は、直前の（挿入前小節番号-1 の小節）と同じサイズとする。
			double 小節長倍率 = ( 0 < 挿入前小節番号 ) ? this.譜面.SSTFormatScore.小節長倍率を取得する( 挿入前小節番号 - 1 ) : 1.0;

			// 移動する。
			this.UndoRedo管理.トランザクション記録を開始する();

			#region " 後方のチップを移動する。"
			//-----------------
			int 挿入に伴う増加量grid = (int) ( this.GRID_PER_PART * 小節長倍率 );

			foreach( var chip in this.譜面.SSTFormatScore.listチップ )
			{
				if( 挿入前小節番号 <= chip.小節番号 )
				{
					var cell = new UndoRedo.セル<SSTFormat.チップ>(
						所有者ID: null,
						undoアクション:( 変更対象, 変更前, 変更後, _挿入に伴う増加量grid, 任意2 ) => {
							変更対象.小節番号--;
							変更対象.譜面内絶対位置grid -= (int) _挿入に伴う増加量grid;
						},
						redoアクション: ( 変更対象, 変更前, 変更後, _挿入に伴う増加量grid, 任意2 ) => {
							変更対象.小節番号++;
							変更対象.譜面内絶対位置grid += (int) _挿入に伴う増加量grid;
						},
						変更対象: chip,
						変更前の値: null,
						変更後の値: null,
						任意1: 挿入に伴う増加量grid,
						任意2: null );

					this.UndoRedo管理.セルを追加する( cell );
					cell.Redoを実行する();
				}
			}
			//-----------------
			#endregion
			#region " 後方の小節長倍率を移動する。"
			//-----------------
			var cc = new UndoRedo.セル<double>(
				所有者ID: null,
				undoアクション: ( 変更対象, 変更前, 変更後, _挿入前小節番号, 任意2 ) => {
					this.譜面.SSTFormatScore.list小節長倍率.RemoveAt( (int) _挿入前小節番号 );
					this.未保存である = true;
				},
				redoアクション: ( 変更対象, 変更前, 変更後, _挿入前小節番号, 任意2 ) => {
					this.譜面.SSTFormatScore.list小節長倍率.Insert( (int) _挿入前小節番号, 小節長倍率 );
					this.未保存である = true;
				},
				変更対象: 0.0,
				変更前の値: 0.0,
				変更後の値: 小節長倍率,
				任意1: 挿入前小節番号,
				任意2: null );
			
			this.UndoRedo管理.セルを追加する( cc );
			cc.Redoを実行する();
			//-----------------
			#endregion

			this.UndoRedo管理.トランザクション記録を終了する();

			// 画面を再描画する。
			this.UndoRedo用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
			this.未保存である = true;
		}
		protected void Act小節を削除する( int 削除する小節番号 )
		{
			double 削除する小節の小節長倍率 = this.譜面.SSTFormatScore.小節長倍率を取得する( 削除する小節番号 );

			// 削除する。
			this.UndoRedo管理.トランザクション記録を開始する();

			#region " 削除される小節内のチップをすべて削除する。"
			//-----------------
			for( int i = this.譜面.SSTFormatScore.listチップ.Count - 1; i >= 0; i-- )
			{
				var chip = this.譜面.SSTFormatScore.listチップ[ i ];

				if( 削除する小節番号 == chip.小節番号 )
				{
					var chip変更前 = new SSTFormat.チップ( chip );

					var cell = new UndoRedo.セル<SSTFormat.チップ>(
						所有者ID: null,
						undoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							変更対象.CopyFrom( 変更前 );
							this.譜面.SSTFormatScore.listチップ.Add( 変更対象 );
							this.譜面.SSTFormatScore.listチップ.Sort();
						},
						redoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							this.譜面.SSTFormatScore.listチップ.Remove( 変更対象 );
							this.未保存である = true;
						},
						変更対象: chip,
						変更前の値: chip変更前, 
						変更後の値: null,
						任意1: null,
						任意2: null );

					this.UndoRedo管理.セルを追加する( cell );
					cell.Redoを実行する();
				}
			}
			//-----------------
			#endregion
			#region " 後方のチップを移動する。"
			//-----------------
			int 削除に伴う減少量grid = (int) ( this.GRID_PER_PART * 削除する小節の小節長倍率 );

			foreach( var chip in this.譜面.SSTFormatScore.listチップ )
			{
				if( 削除する小節番号 < chip.小節番号 )
				{
					var cell = new UndoRedo.セル<SSTFormat.チップ>(
						所有者ID: null,
						undoアクション: ( 変更対象, 変更前, 変更後, _削除に伴う減少量grid, 任意2 ) => {
							変更対象.小節番号++;
							変更対象.譜面内絶対位置grid += (int) _削除に伴う減少量grid;
						},
						redoアクション: ( 変更対象, 変更前, 変更後, _削除に伴う減少量grid, 任意2 ) => {	
							変更対象.小節番号--;
							変更対象.譜面内絶対位置grid -= (int) _削除に伴う減少量grid;
						},
						変更対象: chip,
						変更前の値: null,
						変更後の値: null,
						任意1: 削除に伴う減少量grid,
						任意2: null );

					this.UndoRedo管理.セルを追加する( cell );
					cell.Redoを実行する();
				}
			}
			//-----------------
			#endregion
			#region " 後方の小節長倍率を移動する。"
			//-----------------
			var cc = new UndoRedo.セル<double>(
				所有者ID: null,
				undoアクション: ( 変更対象, 変更前, 変更後, _削除する小節番号, 任意2 ) => {
					this.譜面.SSTFormatScore.list小節長倍率.Insert( (int) _削除する小節番号, 変更前 );
					this.未保存である = true;
				},
				redoアクション: ( 変更対象, 変更前, 変更後, _削除する小節番号, 任意2 ) => {
					this.譜面.SSTFormatScore.list小節長倍率.RemoveAt( (int) _削除する小節番号 );
					this.未保存である = true;
				},
				変更対象: 0.0,
				変更前の値: 削除する小節の小節長倍率,
				変更後の値: 0.0, 
				任意1: 削除する小節番号,
				任意2: null );

			this.UndoRedo管理.セルを追加する( cc );
			cc.Redoを実行する();
			//-----------------
			#endregion

			this.UndoRedo管理.トランザクション記録を終了する();

			// 画面を再描画する。
			this.UndoRedo用GUIのEnabledを設定する();
			this.譜面をリフレッシュする();
		}
		protected void Act小節の先頭へ移動する( int 小節番号 )
		{
			// 小節番号をクリッピングする。
			if( 0 > 小節番号 )
				小節番号 = 0;
			else if( 小節番号 > this.譜面.SSTFormatScore.最大小節番号 )
				小節番号 = this.譜面.SSTFormatScore.最大小節番号;

			// 垂直スクロールバーを移動させると、画面も自動的に移動する。
			var bar = this.vScrollBar譜面用垂直スクロールバー;
			bar.Value = ( ( bar.Maximum + 1 ) - bar.LargeChange ) - this.譜面.小節先頭の譜面内絶対位置gridを返す( 小節番号 );
		}

		// アクション補佐メソッド

		protected void エディタを初期化する()
		{
			this.編集中のファイル名 = "";

			#region " 各種オブジェクトを生成する。"
			//-----------------
			this.譜面?.Dispose();
			this.譜面 = new C譜面( this );  // 譜面は、選択・編集モードよりも先に生成すること。

			this.UndoRedo管理 = new UndoRedo.管理();
			this.選択モード = new 選択モード( this );
			this.編集モード = new 編集モード( this );
			this.クリップボード = new クリップボード( this );
			//-----------------
			#endregion

			// GUI の初期値を設定する。

			#region " 基本情報タブ "
			//-----------------
			this.次のプロパティ変更がUndoRedoリストに載らないようにする();
			this.textBox曲名.Clear();

			this.次のプロパティ変更がUndoRedoリストに載らないようにする();
			this.textBox説明.Clear();
			//-----------------
			#endregion
			#region " Viewer 再生 "
			//-----------------
			this.Viewer再生関連GUIのEnabledを設定する();
			//-----------------
			#endregion
			#region " ガイド間隔 "
			//-----------------
			this.Actガイド間隔を変更する( 16 );	// 初期値は 1/16。
			//-----------------
			#endregion
			#region " 譜面拡大率 "
			//-----------------
			this.Act譜面拡大率を変更する( 1 );		// 初期値は x1.0。
			//-----------------
			#endregion
			#region " Undo/Redo "
			//-----------------
			this.次のプロパティ変更がUndoRedoリストに載るようにする();
			this.UndoRedo用GUIのEnabledを設定する();
			//-----------------
			#endregion
			#region " 垂直スクロールバー "
			//-----------------
			this.vScrollBar譜面用垂直スクロールバー.Minimum = 0;
			this.vScrollBar譜面用垂直スクロールバー.Maximum = ( this.譜面.全小節の高さgrid - 1 );
			this.vScrollBar譜面用垂直スクロールバー.SmallChange = ( this.GRID_PER_PART / 16 );
			this.vScrollBar譜面用垂直スクロールバー.LargeChange = this.GRID_PER_PART;
			this.vScrollBar譜面用垂直スクロールバー.Value = this.vScrollBar譜面用垂直スクロールバー.Maximum - this.vScrollBar譜面用垂直スクロールバー.LargeChange;
			//-----------------
			#endregion

			// 最初は編集モードで始める。

			this.編集モードに切替えて関連GUIを設定する();
			this.未保存である = false;
		}
		protected DialogResult 未保存なら保存する()
		{
			#region " 既に保存済みなら何もしない。"
			//-----------------
			if( false == this.未保存である )
				return DialogResult.OK;
			//-----------------
			#endregion
			#region "「編集中のデータを保存しますか？」ダイアログを表示し、回答を待つ。"
			//-----------------
			var result = MessageBox.Show(
				Properties.Resources.MSG_編集中のデータを保存しますか,
				Properties.Resources.MSG_確認ダイアログのタイトル,
				MessageBoxButtons.YesNoCancel,
				MessageBoxIcon.Question,
				MessageBoxDefaultButton.Button1 );
			//-----------------
			#endregion
			#region " YES なら上書き保存する。"
			//-----------------
			if( DialogResult.Yes == result )
				this.Act上書き保存する();
			//-----------------
			#endregion
			#region " 画面を再描画してダイアログを消去する。"
			//-----------------
			this.Refresh();
			//-----------------
			#endregion

			return result;	// ダイアログの結果を返す。
		}
		protected string ファイル保存ダイアログを開いてファイル名を取得する()
		{
			// ダイアログでファイル名を取得する。
			var dialog = new SaveFileDialog() {
				Title = "名前をつけて保存",
				Filter = "SSTFファイル(*.sstf)|*.sstf",
				FilterIndex = 1,
				InitialDirectory = this.作業フォルダパス,
			};
			var result = dialog.ShowDialog( this );

			// 画面を再描画してダイアログのゴミを消去する。
			this.Refresh();

			// キャンセルされたら ""（空文字列）を返す。
			if( DialogResult.OK != result )
				return "";

			// ファイルの拡張子を .sstf に変更。
			string fileName = dialog.FileName;
			if( 0 == Path.GetExtension( fileName ).Length )
				fileName = Path.ChangeExtension( fileName, ".sstf" );

			return fileName;
		}
		protected void ファイルを読み込む( string ファイル名 )
		{
			this.エディタを初期化する();

			#region "「読み込み中です」ポップアップを表示する。"
			//-----------------
			var msg	= new Popupメッセージ( 
				Properties.Resources.MSG_読み込み中です + Environment.NewLine + 
				Properties.Resources.MSG_しばらくお待ち下さい );
			msg.Owner = this;
			msg.Show();
			msg.Refresh();
			//-----------------
			#endregion

			try
			{
				this.譜面.曲データファイルを読み込む( ファイル名 );

				// 最低でも 10 小節は存在させる。
				for( int n = this.譜面.SSTFormatScore.最大小節番号 + 1; n < 9; n++ )
				{
				}

				string 読み込み時の拡張子 = Path.GetExtension( ファイル名 ).ToLower();
				this.編集中のファイル名 = Path.ChangeExtension( Path.GetFileName( ファイル名 ), ".sstf" );		// 読み込んだファイルの拡張子を .sstf に変換。
				this.作業フォルダパス = Path.GetDirectoryName( ファイル名 );

				// 読み込んだファイルを [ファイル]メニューの最近使ったファイル一覧に追加する。
				this.Config.ファイルを最近使ったファイルの一覧に追加する( Path.Combine( this.作業フォルダパス, this.編集中のファイル名 ) );
				this.ConfigのRecentUsedFilesをファイルメニューへ追加する();

				// 基本情報タブを設定する。
				譜面.SSTFormatScore.背景動画ファイル名 =
					( from file in Directory.GetFiles( Path.GetDirectoryName( this.作業フォルダパス ) )
					  where SSTFormat.スコア.listデフォルト拡張子.Any( 拡張子名 => ( Path.GetExtension( file ).ToLower() == 拡張子名 ) )
					  select file ).FirstOrDefault();  // 複数あったら、最初に見つけたほうを採用。1つも見つからなければ null。
				this.次のプロパティ変更がUndoRedoリストに載らないようにする();
				this.textBox曲名.Text = 譜面.SSTFormatScore.Header.str曲名;
				this.次のプロパティ変更がUndoRedoリストに載らないようにする();
				this.textBox説明.Text = 譜面.SSTFormatScore.Header.str説明文;
				this.次のプロパティ変更がUndoRedoリストに載らないようにする();
				this.textBox背景動画.Text = Path.GetFileName( 譜面.SSTFormatScore.背景動画ファイル名 );
				this.次のプロパティ変更がUndoRedoリストに載らないようにする();
				this.textBoxメモ.Text = ( this.譜面.SSTFormatScore.dicメモ.ContainsKey( 0 ) ) ? this.譜面.SSTFormatScore.dicメモ[ 0 ] : "";

				// ウィンドウのタイトルバーの表示変更（str編集中のファイル名 が確定した後に）
				this.未保存である = true;     // 以前の状態によらず、確実に更新するようにする。

				// sstf 以外を読み込んだ場合は、未保存状態のままとする。
				if( 読み込み時の拡張子.ToLower() == ".sstf" )
					this.未保存である = false;
			}
			catch( InvalidDataException )
			{
				MessageBox.Show(
					Properties.Resources.MSG_対応していないファイルです,
					Properties.Resources.MSG_確認ダイアログのタイトル,
					MessageBoxButtons.OK );
			}

			#region "「読み込み中です」ポップアップを閉じる。 "
			//-----------------
			msg.Close();
			//-----------------
			#endregion

			// 最後に、ダイアログのゴミなどを消すために画面を再描画する。
			this.Refresh();
		}
		protected enum タブ種別 : int { 基本情報 = 0 }
		protected void タブを選択する( タブ種別 eタブ種別 )
		{
			this.tabControl情報タブコンテナ.SelectedIndex = (int) eタブ種別;
		}
		protected void 次のプロパティ変更がUndoRedoリストに載らないようにする()
		{
			UndoRedo.管理.UndoRedoした直後である = true;
		}
		protected void 次のプロパティ変更がUndoRedoリストに載るようにする()
		{
			UndoRedo.管理.UndoRedoした直後である = false;
		}
		protected void 垂直スクロールバーと譜面の上下位置を調整する()
		{
			var bar = this.vScrollBar譜面用垂直スクロールバー;
			var box = this.pictureBox譜面パネル;
			var panel2 = this.splitContainer分割パネルコンテナ.Panel2;
		
			// 譜面パネルの長さをパネルに合わせて調整する。
			box.ClientSize = new Size(
				box.ClientSize.Width, 
				panel2.ClientSize.Height - box.Location.Y );

			// 現在のバーの位置を割合で記憶する。
			var bar率 = (double) bar.Value / (double) ( bar.Maximum - bar.Minimum );

			// 新しい値域を設定した後、バーの位置を記憶しておいた割合で設定。
			bar.Minimum = 0;
			bar.Maximum = this.譜面.全小節の高さgrid - 1;
			bar.Value = (int) ( ( bar.Maximum - bar.Minimum ) * bar率 );

			// 譜面長さが画面長さより短いなら、スクロールバーを表示しない。
			bar.Enabled = ( bar.Maximum > bar.LargeChange ) ? true : false;
		}
		protected void Viewer再生関連GUIのEnabledを設定する()
		{
			if( File.Exists( this.プレイヤーの絶対パスファイル名 ) )
			{
				// (A) StrokeStyleT.exe (Viewer) が存在するなら、各GUIは有効。

				this.toolStripButton先頭から再生.Enabled = true;
				this.toolStripButton現在位置から再生.Enabled = true;
				this.toolStripButton現在位置からBGMのみ再生.Enabled = true;
				this.toolStripButton再生停止.Enabled = true;

				this.toolStripMenuItem先頭から再生.Enabled = true;
				this.toolStripMenuItem現在位置から再生.Enabled = true;
				this.toolStripMenuItem現在位置からBGMのみ再生.Enabled = true;
				this.toolStripMenuItem再生停止.Enabled = true;
			}
			else
			{
				// (B) StrokeStyleT.exe (Viewer) が存在しないなら、各GUIは無効。

				this.toolStripButton先頭から再生.Enabled = false;
				this.toolStripButton現在位置から再生.Enabled = false;
				this.toolStripButton現在位置からBGMのみ再生.Enabled = false;
				this.toolStripButton再生停止.Enabled = false;

				this.toolStripMenuItem先頭から再生.Enabled = false;
				this.toolStripMenuItem現在位置から再生.Enabled = false;
				this.toolStripMenuItem現在位置からBGMのみ再生.Enabled = false;
				this.toolStripMenuItem再生停止.Enabled = false;
			}
		}
		protected void ConfigのRecentUsedFilesをファイルメニューへ追加する()
		{
			#region " [ファイル] メニューから、「最近使ったファイルの一覧」をクリアする。"
			//-----------------
			for( int i = 0; i < this.toolStripMenuItemファイル.DropDownItems.Count; i++ )
			{
				var item = this.toolStripMenuItemファイル.DropDownItems[ i ];

				// ↓削除したくないサブメニューの一覧。これ以外のサブメニュー項目はすべて削除する。
				if( item != this.toolStripMenuItem新規作成 &&
					item != this.toolStripMenuItem開く &&
					item != this.toolStripMenuItem上書き保存 &&
					item != this.toolStripMenuItem名前を付けて保存 &&
					item != this.toolStripSeparator1 &&
					item != this.toolStripMenuItem終了 )
				{
					this.toolStripMenuItemファイル.DropDownItems.Remove( item );
					i = -1;	// 要素数が変わったので列挙しなおし。RemoveAll() があればなあ...
				}
			}
			//-----------------
			#endregion
			#region " 表示しないオプション設定であるか、履歴が０件ならここで終了する。"
			//-----------------
			if( ( false == this.Config.ShowRecentUsedFiles ) ||
				( 0 == this.Config.RecentUsedFiles.Count ) )
				return;
			//-----------------
			#endregion
			#region " Config が持つ履歴にそって、[ファイル] メニューにサブメニュー項目リストを追加する（ただし最大表示数まで）。"
			//-----------------
			// [File] のサブメニューリストに項目が１つでもある場合は、履歴サブメニュー項目の追加の前に「終了」の下にセパレータを入れる。手動で。
			bool セパレータの追加がまだ = true;

			// すべての「最近使ったファイル」について...
			for( int i = 0; i < this.Config.RecentUsedFiles.Count; i++ )
			{
				// 最大表示数を越えたら中断。
				if( this.Config.MaxOfUsedRecentFiles <= i )
					return;

				#region " ファイルパスを、サブメニュー項目として [ファイル] メニューに追加する。 "
				//-----------------
				string ファイルパス = this.Config.RecentUsedFiles[ i ];
				if( string.IsNullOrEmpty( ファイルパス ) )
					continue;

				if( セパレータの追加がまだ )
				{
					// セパレータの追加がまだなら追加する。
					this.toolStripMenuItemファイル.DropDownItems.Add( new ToolStripSeparator() { Size = this.toolStripSeparator1.Size } );
					セパレータの追加がまだ = false;
				}

				#region " ToolStripMenuItem を手動で作って [ファイル] のサブメニューリストに追加する。"
				//-----------------
				var item = new ToolStripMenuItem() {
					Name = "最近使ったファイル" + i,
					Size = this.toolStripMenuItem終了.Size,
					Text = "&" + i + " " + ファイルパス,
				};
				item.Click += new EventHandler( this.toolStripMenuItem最近使ったファイル_Click );
				this.toolStripMenuItemファイル.DropDownItems.Add( item );
				//-----------------
				#endregion
				#region " 追加したファイルが既に存在していないなら項目を無効化（グレー表示）する。"
				//-----------------
				if( false == File.Exists( ファイルパス ) )
					item.Enabled = false;
				//-----------------
				#endregion

				//-----------------
				#endregion
			}
			//-----------------
			#endregion
		}
		protected Point 現在のマウス位置を譜面パネル内座標pxに変換して返す()
		{
			Point p = new Point( Cursor.Position.X, Cursor.Position.Y );
			return this.pictureBox譜面パネル.PointToClient( p );
		}
		protected void 現在のチップ音量をツールバーに表示する()
		{
			this.toolStripLabel音量.Text = ( this.dic音量ラベル.ContainsKey( this.現在のチップ音量 ) ) ? this.dic音量ラベル[ this.現在のチップ音量 ] : @"???";
		}

		// GUIイベントメソッド

		#region " メインフォーム "
		//-----------------
		protected void メインフォーム_DragDrop( object sender, DragEventArgs e )
		{
			string[] data = (string[]) e.Data.GetData( DataFormats.FileDrop );

			if( 1 <= data.Length )
				this.Act指定されたファイルを開く( data[ 0 ] );			// Dropされたファイルが複数個あっても、先頭のファイルだけを有効とする。
		}
		protected void メインフォーム_DragEnter( object sender, DragEventArgs e )
		{
			if( e.Data.GetDataPresent( DataFormats.FileDrop ) )
			{
				e.Effect = DragDropEffects.Copy;	// ファイルならコピーと見なす（カーソルがコピー型になる）
			}
			else
			{
				e.Effect = DragDropEffects.None;	// ファイルじゃないなら無視（カーソル変化なし）
			}
		}
		protected void メインフォーム_FormClosing( object sender, FormClosingEventArgs e )
		{
			if( DialogResult.Cancel == this.未保存なら保存する() )
			{
				e.Cancel = true;
			}
			else
			{
				this.Actアプリを終了する();
			}
		}
		//-----------------
		#endregion
		#region " メニューバー "
		//-----------------
		// File
		protected void toolStripMenuItem新規作成_Click( object sender, EventArgs e )
		{
			this.Act新規作成する();
		}
		protected void toolStripMenuItem開く_Click( object sender, EventArgs e )
		{
			this.Act開く();
		}
		protected void toolStripMenuItem上書き保存_Click( object sender, EventArgs e )
		{
			this.Act上書き保存する();
		}
		protected void toolStripMenuItem名前を付けて保存_Click( object sender, EventArgs e )
		{
			this.Act名前を付けて保存する();
		}
		protected void toolStripMenuItem終了_Click( object sender, EventArgs e )
		{
			this.Act終了する();
		}
		protected void toolStripMenuItem最近使ったファイル_Click( object sender, EventArgs e )
		{
			// ※このイベントハンドラに対応する「toolStripMenuItem最近使ったファイル」というアイテムはデザイナにはないので注意。
			//   「this.t最近使ったファイルをFileメニューへ追加する()」の中で、手動で作って追加したアイテムに対するハンドラである。
			
			this.Act指定されたファイルを開く( ( (ToolStripMenuItem) sender ).Text.Substring( 3 ) );
		}

		// Edit
		protected void toolStripMenuItem元に戻す_Click( object sender, EventArgs e )
		{
			this.Act元に戻す();
		}
		protected void toolStripMenuItemやり直す_Click( object sender, EventArgs e )
		{
			this.Actやり直す();
		}
		protected void toolStripMenuItem切り取り_Click( object sender, EventArgs e )
		{
			this.Act切り取る();
		}
		protected void toolStripMenuItemコピー_Click( object sender, EventArgs e )
		{
			this.Actコピーする();
		}
		protected void toolStripMenuItem貼り付け_Click( object sender, EventArgs e )
		{
			// マウスの位置を譜面パネル内座標で取得する。
			var マウスの位置 = this.現在のマウス位置を譜面パネル内座標pxに変換して返す();

			// (A) マウスが譜面上になかった → 表示領域下辺から貼り付ける。
			if( ( ( マウスの位置.X < 0 ) || ( マウスの位置.Y < 0 ) ) ||
				( ( マウスの位置.X > this.譜面パネルサイズ.Width ) || ( マウスの位置.Y > this.譜面パネルサイズ.Height ) ) )
			{
				this.Act貼り付ける( this.譜面.現在の譜面表示下辺の譜面内絶対位置grid );
			}
			// (B) マウスが譜面上にある → そこから貼り付ける。
			else
			{
				this.Act貼り付ける( this.譜面.譜面パネル内Y座標pxにおける譜面内絶対位置gridをガイド幅単位で返す( マウスの位置.Y ) );
			}
		}
		protected void toolStripMenuItem削除_Click( object sender, EventArgs e )
		{
			this.Act削除する();
		}
		protected void toolStripMenuItemすべて選択_Click( object sender, EventArgs e )
		{
			this.Actすべて選択する();
		}
		protected void toolStripMenuItem選択モード_Click( object sender, EventArgs e )
		{
			this.選択モードに切替えて関連GUIを設定する();
		}
		protected void toolStripMenuItem編集モード_Click( object sender, EventArgs e )
		{
			this.編集モードに切替えて関連GUIを設定する();
		}
		protected void toolStripMenuItemモード切替え_Click( object sender, EventArgs e )
		{
			if( this.選択モードである )
			{
				this.編集モードに切替えて関連GUIを設定する();
			}
			else
			{
				this.選択モードに切替えて関連GUIを設定する();
			}
		}
		protected void toolStripMenuItem検索_Click( object sender, EventArgs e )
		{
			this.Act検索する();
		}

		// View
		protected void toolStripMenuItemガイド間隔4分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 4 );
		}
		protected void toolStripMenuItemガイド間隔6分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 6 );
		}
		protected void toolStripMenuItemガイド間隔8分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 8 );
		}
		protected void toolStripMenuItemガイド間隔12分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 12 );
		}
		protected void toolStripMenuItemガイド間隔16分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 16 );
		}
		protected void toolStripMenuItemガイド間隔24分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 24 );
		}
		protected void toolStripMenuItemガイド間隔32分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 32 );
		}
		protected void toolStripMenuItemガイド間隔48分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 48 );
		}
		protected void toolStripMenuItemガイド間隔64分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 64 );
		}
		protected void toolStripMenuItemガイド間隔128分_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 128 );
		}
		protected void toolStripMenuItemガイド間隔フリー_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を変更する( 0 );
		}
		protected void toolStripMenuItemガイド間隔拡大_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を拡大する();
		}
		protected void toolStripMenuItemガイド間隔縮小_Click( object sender, EventArgs e )
		{
			this.Actガイド間隔を縮小する();
		}

		// Play
		protected void toolStripMenuItem先頭から再生_Click( object sender, EventArgs e )
		{
			this.Act最初から再生する();
		}
		protected void toolStripMenuItem現在位置から再生_Click( object sender, EventArgs e )
		{
			this.Act現在位置から再生する();
		}
		protected void toolStripMenuItem現在位置からBGMのみ再生_Click( object sender, EventArgs e )
		{
			this.Act現在位置からBGMのみ再生する();
		}
		protected void toolStripMenuItem再生停止_Click( object sender, EventArgs e )
		{
			this.Act再生を停止する();
		}

		// Tool
		protected void toolStripMenuItemオプション_Click( object sender, EventArgs e )
		{
			this.Actオプションを設定する();
		}

		// Help
		protected void toolStripMenuItemバージョン_Click( object sender, EventArgs e )
		{
			this.Actバージョンを表示する();
		}
		//-----------------
		#endregion
		#region " ツールバー "
		//-----------------
		protected void toolStripButton新規作成_Click( object sender, EventArgs e )
		{
			this.Act新規作成する();
		}
		protected void toolStripButton開く_Click( object sender, EventArgs e )
		{
			this.Act開く();
		}
		protected void toolStripButton上書き保存_Click( object sender, EventArgs e )
		{
			this.Act上書き保存する();
		}
		protected void toolStripButton切り取り_Click( object sender, EventArgs e )
		{
			this.Act切り取る();
		}
		protected void toolStripButtonコピー_Click( object sender, EventArgs e )
		{
			this.Actコピーする();
		}
		protected void toolStripButton貼り付け_Click( object sender, EventArgs e )
		{
			// マウスの位置を譜面パネル内座標で取得する。
			var マウスの位置 = this.現在のマウス位置を譜面パネル内座標pxに変換して返す();

			// (A) マウスが譜面上になかった → 表示領域下辺から貼り付ける。
			if( ( ( マウスの位置.X < 0 ) || ( マウスの位置.Y < 0 ) ) ||
				( ( マウスの位置.X > this.譜面パネルサイズ.Width ) || ( マウスの位置.Y > this.譜面パネルサイズ.Height ) ) )
			{
				this.Act貼り付ける( this.譜面.現在の譜面表示下辺の譜面内絶対位置grid );
			}
			// (B) マウスが譜面上にある → そこから貼り付ける。
			else
			{
				this.Act貼り付ける( this.譜面.譜面パネル内Y座標pxにおける譜面内絶対位置gridをガイド幅単位で返す( マウスの位置.Y ) );
			}
		}
		protected void toolStripButton削除_Click( object sender, EventArgs e )
		{
			this.Act削除する();
		}
		
		protected void toolStripButton元に戻す_Click( object sender, EventArgs e )
		{
			this.Act元に戻す();
		}
		protected void toolStripButtonやり直す_Click( object sender, EventArgs e )
		{
			this.Actやり直す();
		}

		protected void toolStripComboBox譜面拡大率_SelectedIndexChanged( object sender, EventArgs e )
		{
			this.Act譜面拡大率を変更する( this.toolStripComboBox譜面拡大率.SelectedIndex + 1 );
		}
		protected void toolStripComboBoxガイド間隔_SelectedIndexChanged( object sender, EventArgs e )
		{
			switch( this.toolStripComboBoxガイド間隔.SelectedIndex )
			{
				case 0:
					this.Actガイド間隔を変更する( 4 );
					return;

				case 1:
					this.Actガイド間隔を変更する( 6 );
					return;

				case 2:
					this.Actガイド間隔を変更する( 8 );
					return;

				case 3:
					this.Actガイド間隔を変更する( 12 );
					return;

				case 4:
					this.Actガイド間隔を変更する( 16 );
					return;

				case 5:
					this.Actガイド間隔を変更する( 24 );
					return;

				case 6:
					this.Actガイド間隔を変更する( 32 );
					return;

				case 7:
					this.Actガイド間隔を変更する( 48 );
					return;

				case 8:
					this.Actガイド間隔を変更する( 64 );
					return;

				case 9:
					this.Actガイド間隔を変更する( 128 );
					return;

				case 10:
					this.Actガイド間隔を変更する( 0 );
					return;
			}

		}
		protected void toolStripButton選択モード_Click( object sender, EventArgs e )
		{
			this.Act選択モードにする();
		}
		protected void toolStripButton編集モード_Click( object sender, EventArgs e )
		{
			this.Act編集モードにする();
		}

		protected void toolStripButton先頭から再生_Click( object sender, EventArgs e )
		{
			this.Act最初から再生する();
		}
		protected void toolStripButton現在位置から再生_Click( object sender, EventArgs e )
		{
			this.Act現在位置から再生する();
		}
		protected void toolStripButton現在位置からBGMのみ再生_Click( object sender, EventArgs e )
		{
			this.Act現在位置からBGMのみ再生する();
		}
		protected void toolStripButton再生停止_Click( object sender, EventArgs e )
		{
			this.Act再生を停止する();
		}

		protected void toolStripButton音量Down_Click( object sender, EventArgs e )
		{
			int 新音量 = this.現在のチップ音量 - 1;
			this.現在のチップ音量 = ( 新音量 < メインフォーム.最小音量 ) ? メインフォーム.最小音量 : 新音量;

			this.現在のチップ音量をツールバーに表示する();
		}
		protected void toolStripButton音量UP_Click( object sender, EventArgs e )
		{
			int 新音量 = this.現在のチップ音量 + 1;
			this.現在のチップ音量 = ( 新音量 > メインフォーム.最大音量 ) ? メインフォーム.最大音量 : 新音量;

			this.現在のチップ音量をツールバーに表示する();
		}
		//-----------------
		#endregion
		#region " 分割パネルコンテナ、譜面パネル、スクロールバー "
		//-----------------
		protected void pictureBox譜面パネル_MouseClick( object sender, MouseEventArgs e )
		{
			// フォーカスを得る。
			this.pictureBox譜面パネル.Focus();

			// 選択・編集モードオブジェクトのいずれかへ処理を引き継ぐ。
			if( this.選択モードである )
			{
				this.選択モード.MouseClick( e );
			}
			else
			{
				this.編集モード.MouseClick( e );
			}
		}
		protected void pictureBox譜面パネル_MouseDown( object sender, MouseEventArgs e )
		{
			// 選択モードオブジェクトへ処理を引き継ぐ。
			if( this.選択モードである )
				this.選択モード.MouseDown( e );
		}
		protected void pictureBox譜面パネル_MouseEnter( object sender, EventArgs e )
		{
			// オートフォーカスが有効の場合、譜面にマウスが入ったら譜面がフォーカスを得る。"
			if( this.Config.AutoFocus )
				this.pictureBox譜面パネル.Focus();
		}
		protected void pictureBox譜面パネル_MouseLeave( object sender, EventArgs e )
		{
			// 編集モードオブジェクトへ処理を引き継ぐ。
			if( this.編集モードである )
				this.編集モード.MouseLeave( e );
		}
		protected void pictureBox譜面パネル_MouseMove( object sender, MouseEventArgs e )
		{
			// 選択・編集モードオブジェクトのいずれかへ処理を引き継ぐ。
			if( this.選択モードである )
			{
				this.選択モード.MouseMove( e );
			}
			else
			{
				this.編集モード.MouseMove( e );
			}
		}
		protected void pictureBox譜面パネル_Paint( object sender, PaintEventArgs e )
		{
			if( false == this.初期化完了 )
				return;		// 初期化が終わってないのに呼び出されることがあるので、その場合は無視。

			#region " 小節数が変わってたら、スクロールバーの値域を調整する。"
			//-----------------
			int 全譜面の高さgrid = this.譜面.全小節の高さgrid;

			if( this.vScrollBar譜面用垂直スクロールバー.Maximum != 全譜面の高さgrid - 1 )	// 小節数が変わっている
			{
				// 譜面の高さ(grid)がどれだけ変わったか？
				int 増加分grid = ( 全譜面の高さgrid - 1 ) - this.vScrollBar譜面用垂直スクロールバー.Maximum;

				#region " スクロールバーの状態を新しい譜面の高さに合わせる。"
				//-----------------
				{
					int value = this.vScrollBar譜面用垂直スクロールバー.Value;		// 次の式で Maximum が Value より小さくなると例外が発生するので、
					this.vScrollBar譜面用垂直スクロールバー.Value = 0;				// Value のバックアップを取っておいて、ひとまず 0 にする。
					this.vScrollBar譜面用垂直スクロールバー.Maximum = 全譜面の高さgrid - 1;

					int newValue = value + 増加分grid;

					// オーバーフローしないようクリッピングする。
					if( 0 > newValue )
					{
						this.vScrollBar譜面用垂直スクロールバー.Value = 0;
					}
					else if( ( this.vScrollBar譜面用垂直スクロールバー.Maximum - this.vScrollBar譜面用垂直スクロールバー.LargeChange ) <= newValue )
					{
						this.vScrollBar譜面用垂直スクロールバー.Value = this.vScrollBar譜面用垂直スクロールバー.Maximum - this.vScrollBar譜面用垂直スクロールバー.LargeChange;
					}
					else
					{
						this.vScrollBar譜面用垂直スクロールバー.Value = newValue;
					}
				}
				//-----------------
				#endregion
				#region " 譜面表示下辺の位置を更新する。"
				//-----------------
				this.譜面.現在の譜面表示下辺の譜面内絶対位置grid =
					( ( this.vScrollBar譜面用垂直スクロールバー.Maximum - this.vScrollBar譜面用垂直スクロールバー.LargeChange ) + 1 ) - this.vScrollBar譜面用垂直スクロールバー.Value;
				//-----------------
				#endregion
			}
			//-----------------
			#endregion
			#region " 譜面を描画する。"
			//-----------------
			this.譜面.描画する( e.Graphics, this.pictureBox譜面パネル );
			//-----------------
			#endregion
			
			// 選択・編集モードオブジェクトのいずれかへ処理を引き継ぐ。
			if( this.選択モードである )
			{
				this.選択モード.Paint( e );
			}
			else
			{
				this.編集モード.Paint( e );
			}
		}
		protected void pictureBox譜面パネル_PreviewKeyDown( object sender, PreviewKeyDownEventArgs e )
		{
			if( Keys.Prior == e.KeyCode )
			{
				#region " PageUp → 移動量に対応する grid だけ垂直つまみを移動させる。あとはこの移動で生じる ChangedValue イベントで処理。"
				//-----------------
				int 移動すべき数grid = -this.GRID_PER_PART;
				int 新しい位置 = this.vScrollBar譜面用垂直スクロールバー.Value + 移動すべき数grid;
				int 最小値 = this.vScrollBar譜面用垂直スクロールバー.Minimum;
				int 最大値 = ( this.vScrollBar譜面用垂直スクロールバー.Maximum + 1 ) - this.vScrollBar譜面用垂直スクロールバー.LargeChange;

				if( 新しい位置 < 最小値 )
				{
					新しい位置 = 最小値;
				}
				else if( 新しい位置 > 最大値 )
				{
					新しい位置 = 最大値;
				}
				this.vScrollBar譜面用垂直スクロールバー.Value = 新しい位置;
				//-----------------
				#endregion
			}
			else if( Keys.Next == e.KeyCode )
			{
				#region " PageDown → 移動量に対応する grid だけ垂直つまみを移動させる。あとはこの移動で生じる ChangedValue イベントで処理。"
				//-----------------
				int 移動すべき数grid = this.GRID_PER_PART;
				int 新しい位置 = this.vScrollBar譜面用垂直スクロールバー.Value + 移動すべき数grid;
				int 最小値 = this.vScrollBar譜面用垂直スクロールバー.Minimum;
				int 最大値 = ( this.vScrollBar譜面用垂直スクロールバー.Maximum + 1 ) - this.vScrollBar譜面用垂直スクロールバー.LargeChange;

				if( 新しい位置 < 最小値 )
				{
					新しい位置 = 最小値;
				}
				else if( 新しい位置 > 最大値 )
				{
					新しい位置 = 最大値;
				}
				this.vScrollBar譜面用垂直スクロールバー.Value = 新しい位置;
				//-----------------
				#endregion
			}
			else
			{
				// 編集モードオブジェクトへ処理を引き継ぐ。
				if( this.編集モードである )
					this.編集モード.PreviewKeyDown( e );
			}
		}
		
		protected void splitContainer分割パネルコンテナ_MouseWheel( object sender, MouseEventArgs e )
		{
			if( false == this.初期化完了 )
				return;     // 初期化が終わってないのに呼び出されることがあるので、その場合は無視。

			#region " 移動量に対応する grid だけ垂直つまみを移動させる。あとはこの移動で生じる ChangedValue イベントで処理する。"
			//-----------------
			if( 0 == e.Delta )
				return;     // 移動量なし

			// e.Delta は、スクロールバーを下へ動かしたいときに負、上へ動かしたいときに正となる。
			int 移動すべき行数 = ( -e.Delta * SystemInformation.MouseWheelScrollLines ) / 120;

			// １行＝１拍とする。
			int 移動すべき数grid = 移動すべき行数 * ( this.GRID_PER_PART / 4 );

			// スクロールバーのつまみを移動する。
			int 新しい位置 = this.vScrollBar譜面用垂直スクロールバー.Value + 移動すべき数grid;
			int 最小値 = this.vScrollBar譜面用垂直スクロールバー.Minimum;
			int 最大値 = ( this.vScrollBar譜面用垂直スクロールバー.Maximum + 1 ) - this.vScrollBar譜面用垂直スクロールバー.LargeChange;

			if( 新しい位置 < 最小値 )
			{
				新しい位置 = 最小値;
			}
			else if( 新しい位置 > 最大値 )
			{
				新しい位置 = 最大値;
			}
			this.vScrollBar譜面用垂直スクロールバー.Value = 新しい位置;
			//-----------------
			#endregion
		}
		protected void splitContainer分割パネルコンテナ_Panel2_SizeChanged( object sender, EventArgs e )
		{
			if( false == this.初期化完了 )
				return;		// 初期化が終わってないのに呼び出されることがあるので、その場合は無視。

			this.垂直スクロールバーと譜面の上下位置を調整する();
		}
		protected void splitContainer分割パネルコンテナ_Panel2_Paint( object sender, PaintEventArgs e )
		{
			if( false == this.初期化完了 )
				return;		// 初期化が終わってないのに呼び出されることがあるので、その場合は無視。

			var g = e.Graphics;
			var メモ領域左上隅の位置 = new PointF() {
				X = this.譜面.レーンの合計幅px,
				Y = this.pictureBox譜面パネル.Location.Y,
			};

			#region " 見出し＜小節メモ＞を描画する。"
			//-----------------
			g.DrawString( Properties.Resources.MSG_小節メモ, this.メモ用フォント, Brushes.White, PointF.Add( メモ領域左上隅の位置, new Size( 24, -24 )/*マージン*/ ) );
			//-----------------
			#endregion
			#region " 小節メモを描画する。"
			//-----------------

			// グリッド値は 上辺＞下辺 なので注意。
			int パネル下辺grid = this.譜面.現在の譜面表示下辺の譜面内絶対位置grid;
			int パネル上辺grid = パネル下辺grid + ( this.pictureBox譜面パネル.ClientSize.Height * this.GRID_PER_PIXEL );
			int 開始小節番号 = this.譜面.現在譜面表示下辺に存在している小節番号;

			for( int 小節番号 = 開始小節番号; 小節番号 <= this.譜面.SSTFormatScore.最大小節番号; 小節番号++ )
			{
				int 小節の下辺grid = this.譜面.小節先頭の譜面内絶対位置gridを返す( 小節番号 );
				int 小節の上辺grid = 小節の下辺grid + this.譜面.t小節長をグリッドで返す( 小節番号 );

				if( 小節の下辺grid > パネル上辺grid )
					break;	// 小節が画面上方にはみ出し切ってしまったらそこで終了。

				if( this.譜面.SSTFormatScore.dicメモ.ContainsKey( 小節番号 ) )
				{
					string メモ = this.譜面.SSTFormatScore.dicメモ[ 小節番号 ];

					string[] lines = メモ.Split( new string[] { Environment.NewLine }, StringSplitOptions.None );
					int 行数 = lines.Length;

					var メモの位置 = new PointF() {
						X = メモ領域左上隅の位置.X + 4,	// + 4 はマージン
						Y = メモ領域左上隅の位置.Y + ( パネル上辺grid - 小節の下辺grid ) / this.GRID_PER_PIXEL - ( 行数 * 16 ),		// 9pt = だいたい16px 
					};
					g.DrawString( メモ, this.メモ用フォント, Brushes.White, メモの位置 );
				}
			}
			//-----------------
			#endregion
		}

		protected void vScrollBar譜面用垂直スクロールバー_ValueChanged( object sender, EventArgs e )
		{
			if( false == this.初期化完了 )
				return;		// 初期化が終わってないのに呼び出されることがあるので、その場合は無視。

			var bar = vScrollBar譜面用垂直スクロールバー;

			if( bar.Enabled )
			{
				// 下辺の位置を再計算。
				this.譜面.現在の譜面表示下辺の譜面内絶対位置grid = ( ( bar.Maximum + 1 ) - bar.LargeChange ) - bar.Value;

				// 編集モードの場合、カーソルのgrid位置を再計算。
				if( this.編集モードである )
				{
					this.編集モード.MouseMove(
						new MouseEventArgs( MouseButtons.None, 0, this.編集モード.rc現在のチップカーソル領域.X, this.編集モード.rc現在のチップカーソル領域.Y, 0 ) );
				}

				// メモ用小節番号を再計算。
				this.次のプロパティ変更がUndoRedoリストに載らないようにする();
				this.numericUpDownメモ用小節番号.Value = this.譜面.n現在カレントラインに存在している小節番号;
				this.次のプロパティ変更がUndoRedoリストに載るようにする();

				// 小節メモを再描画する。
				this.splitContainer分割パネルコンテナ.Panel2.Refresh();
			}
		}
		//-----------------
		#endregion
		#region " 譜面右メニュー "
		//-----------------
		protected void toolStripMenuItem選択チップの切り取り_Click( object sender, EventArgs e )
		{
			this.Act切り取る();
		}
		protected void toolStripMenuItem選択チップのコピー_Click( object sender, EventArgs e )
		{
			this.Actコピーする();
		}
		protected void toolStripMenuItem選択チップの貼り付け_Click( object sender, EventArgs e )
		{
			// メニューが開かれたときのマウスの座標を取得。
			// ※メニューは必ずマウス位置を左上にして表示されるとは限らないため、メニューの表示位置からは取得しないこと。
			var マウスの位置 = this.選択モードのコンテクストメニューを開いたときのマウスの位置;

			if( this.譜面.譜面パネル内X座標pxにある編集レーンを返す( マウスの位置.X ) == 編集レーン種別.Unknown )
				return;		// クリックされた場所にレーンがないなら無視。

			// アクションを実行。
			this.Act貼り付ける( this.譜面.譜面パネル内Y座標pxにおける譜面内絶対位置gridをガイド幅単位で返す( マウスの位置.Y ) );
		}
		protected void toolStripMenuItem選択チップの削除_Click( object sender, EventArgs e )
		{
			this.Act削除する();
		}
		protected void toolStripMenuItemすべてのチップの選択_Click( object sender, EventArgs e )
		{
			// 編集モードなら強制的に選択モードにする。
			if( this.編集モードである )
				this.選択モードに切替えて関連GUIを設定する();

			// 全チップを選択。
			this.選択モード.全チップを選択する();
		}
		protected void toolStripMenuItem小節長変更_Click( object sender, EventArgs e )
		{
			// メニューが開かれたときのマウスの座標を取得。
			// ※メニューは必ずマウス位置を左上にして表示されるとは限らないため、メニューの表示位置からは取得しないこと。
			var マウスの位置 = this.選択モードのコンテクストメニューを開いたときのマウスの位置;

			if( this.譜面.譜面パネル内X座標pxにある編集レーンを返す( マウスの位置.X ) == 編集レーン種別.Unknown )
				return;		// クリックされた場所にレーンがないなら無視。

			// アクションを実行。
			this.Act小節長倍率を変更する( this.譜面.譜面パネル内Y座標pxにおける小節番号を返す( マウスの位置.Y ) );
		}
		protected void toolStripMenuItem小節の挿入_Click( object sender, EventArgs e )
		{
			// メニューが開かれたときのマウスの座標を取得。
			// ※メニューは必ずマウス位置を左上にして表示されるとは限らないため、メニューの表示位置からは取得しないこと。
			var マウスの位置 = this.選択モードのコンテクストメニューを開いたときのマウスの位置;

			if( this.譜面.譜面パネル内X座標pxにある編集レーンを返す( マウスの位置.X ) == 編集レーン種別.Unknown )
				return;		// クリックされた場所にレーンがないなら無視。

			// アクションを実行。
			this.Act小節を挿入する( this.譜面.譜面パネル内Y座標pxにおける小節番号を返す( マウスの位置.Y ) );
		}
		protected void toolStripMenuItem小節の削除_Click( object sender, EventArgs e )
		{
			// メニューが開かれたときのマウスの座標を取得。
			// ※メニューは必ずマウス位置を左上にして表示されるとは限らないため、メニューの表示位置からは取得しないこと。
			var マウスの位置 = this.選択モードのコンテクストメニューを開いたときのマウスの位置;

			if( this.譜面.譜面パネル内X座標pxにある編集レーンを返す( マウスの位置.X ) == 編集レーン種別.Unknown )
				return;		// クリックされた場所にレーンがないなら無視。

			// アクションを実行。
			this.Act小節を削除する( this.譜面.譜面パネル内Y座標pxにおける小節番号を返す( マウスの位置.Y ) );
		}
		//-----------------
		#endregion
		#region " 基本情報タブ "
		//-----------------
		protected void textBox曲名_TextChanged( object sender, EventArgs e )
		{
			#region " この変更が Undo/Redo したことによるものではない場合、UndoRedoセルを追加 or 修正する。"
			//-----------------
			if( false == UndoRedo.管理.UndoRedoした直後である )
			{
				// 最新のセルの所有者が自分？
				var cell = this.UndoRedo管理.Undoするセルを取得して返す_見るだけ();

				if( ( null != cell ) && cell.所有権がある( this.textBox曲名 ) )
				{
					// (A) 所有者である → 最新のセルの "変更後の値" を現在のコントロールの値に更新する。
					( (UndoRedo.セル<string>) cell ).変更後の値 = this.textBox曲名.Text;
				}
				else
				{
					// (B) 所有者ではない → 以下のようにセルを新規追加する。
					//    "変更前の値" ← 以前の値
					//    "変更後の値" ← 現在の値
					//    "所有者ID" ← 対象となるコンポーネントオブジェクト
					var cc = new UndoRedo.セル<string>(
						所有者ID: this.textBox曲名,
						undoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	
							this.タブを選択する( タブ種別.基本情報 );
							this.次のプロパティ変更がUndoRedoリストに載らないようにする();
							this.textBox曲名.Text = 変更前;
							this.textBox曲名.Focus();
						},
						redoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							this.タブを選択する( タブ種別.基本情報 );
							this.次のプロパティ変更がUndoRedoリストに載らないようにする();
							this.textBox曲名.Text = 変更後;
							this.textBox曲名.Focus();
						},
						変更対象: null,
						変更前の値: this.textBox曲名_以前の値,
						変更後の値: this.textBox曲名.Text,
						任意1: null, 
						任意2: null );
					
					this.UndoRedo管理.セルを追加する( cc );

					// Undo ボタンを有効にする。
					this.UndoRedo用GUIのEnabledを設定する();
				}
			}
			//-----------------
			#endregion

			this.textBox曲名_以前の値 = this.textBox曲名.Text;		// 以前の値 ← 現在の値
			UndoRedo.管理.UndoRedoした直後である = false;
			this.未保存である = true;

			// スコアには随時保存する。
			譜面.SSTFormatScore.Header.str曲名 = this.textBox曲名.Text;
		}
		protected void textBox曲名_Leave( object sender, EventArgs e )
		{
			// 最新の UndoRedoセル の所有権を放棄する。
			var cell = this.UndoRedo管理.Undoするセルを取得して返す_見るだけ();
			cell?.所有権を放棄する( this.textBox曲名 );
		}
		protected string textBox曲名_以前の値 = "";

		protected void textBox説明_TextChanged( object sender, EventArgs e )
		{
			#region " この変更が Undo/Redo したことによるものではない場合、UndoRedoセルを追加 or 修正する。"
			//-----------------
			if( false == UndoRedo.管理.UndoRedoした直後である )
			{
				// 最新のセルの所有者が自分？
				var cell = this.UndoRedo管理.Undoするセルを取得して返す_見るだけ();
				if( ( null != cell ) && cell.所有権がある( this.textBox説明 ) )
				{
					// (A) 所有者である → 最新のセルの "変更後の値" を現在のコントロールの値に更新。

					( (UndoRedo.セル<string>) cell ).変更後の値 = this.textBox説明.Text;
				}
				else
				{
					// (B) 所有者ではない → 以下のようにセルを新規追加する。
					//    "変更前の値" ← 以前の値
					//    "変更後の値" ← 現在の値
					//    "所有者ID" ← 対象となるコンポーネントオブジェクト
					var cc = new UndoRedo.セル<string>(
						所有者ID: this.textBox説明,
						undoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							this.タブを選択する( タブ種別.基本情報 );
							this.次のプロパティ変更がUndoRedoリストに載らないようにする();
							this.textBox説明.Text = 変更前;
							this.textBox説明.Focus();
						},
						redoアクション: ( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {
							this.タブを選択する( タブ種別.基本情報 );
							this.次のプロパティ変更がUndoRedoリストに載らないようにする();
							this.textBox説明.Text = 変更後;
							this.textBox説明.Focus();
						},
						変更対象: null,
						変更前の値: this.textBox説明_以前の値, 
						変更後の値: this.textBox説明.Text,
						任意1: null,
						任意2: null );

					this.UndoRedo管理.セルを追加する( cc );

					// Undo ボタンを有効にする。
					this.UndoRedo用GUIのEnabledを設定する();
				}
			}
			//-----------------
			#endregion

			this.textBox説明_以前の値 = this.textBox説明.Text;	// 以前の値 ← 現在の値
			UndoRedo.管理.UndoRedoした直後である = false;
			this.未保存である = true;

			// スコアには随時保存する。
			譜面.SSTFormatScore.Header.str説明文 = this.textBox説明.Text;
		}
		protected void textBox説明_Leave( object sender, EventArgs e )
		{
			// 最新 UndoRedoセル の所有権を放棄する。
			this.UndoRedo管理.Undoするセルを取得して返す_見るだけ()?.所有権を放棄する( this.textBox説明 );
		}
		protected string textBox説明_以前の値 = "";

		protected void textBoxメモ_TextChanged( object sender, EventArgs e )
		{
			#region [ この変更が Undo/Redo したことによるものではない場合、UndoRedoセルを追加or修正する。]
			//-----------------
			if( !UndoRedo.管理.UndoRedoした直後である )
			{
				// 最新のセルの所有者が自分？

				UndoRedo.セルBase cell = this.UndoRedo管理.Undoするセルを取得して返す_見るだけ();


				if( ( cell != null ) && cell.所有権がある( this.textBoxメモ ) )
				{
					// (Yes) 最新のセルの "変更後の値" を <現在の値> に更新。

					( (UndoRedo.セル<string>) cell ).変更後の値 = this.textBoxメモ.Text;
				}
				else
				{
					// (No) セルを新規追加：
					//      "変更前の値" = <以前の値>
					//      "変更後の値" = <現在の値>
					//      "所有者ID" = 対象となるコンポーネントオブジェクト

					var cc = new UndoRedo.セル<string>(
						this.textBoxメモ,
						( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	// Undo
							this.タブを選択する( タブ種別.基本情報 );
							this.numericUpDownメモ用小節番号.Value = (decimal) 任意1;
							this.次のプロパティ変更がUndoRedoリストに載らないようにする();
							this.textBoxメモ.Text = 変更前;
							this.textBoxメモ.Focus();

							int n小節番号 = (int) ( (decimal) 任意1 );

							#region [ dicメモ の更新 ]
							//-----------------
							if( this.譜面.SSTFormatScore.dicメモ.ContainsKey( n小節番号 ) )
							{
								if( string.IsNullOrEmpty( 変更前 ) )
									this.譜面.SSTFormatScore.dicメモ.Remove( n小節番号 );
								else
									this.譜面.SSTFormatScore.dicメモ[ n小節番号 ] = 変更前;
							}
							else
							{
								if( !string.IsNullOrEmpty( 変更前 ) )
									this.譜面.SSTFormatScore.dicメモ.Add( n小節番号, 変更前 );
							}
							//-----------------
							#endregion

							this.Act小節の先頭へ移動する( n小節番号 );
							this.splitContainer分割パネルコンテナ.Panel2.Refresh();	// 小節メモをリフレッシュ。

						},
						( 変更対象, 変更前, 変更後, 任意1, 任意2 ) => {	// Redo
							this.タブを選択する( タブ種別.基本情報 );
							this.numericUpDownメモ用小節番号.Value = (decimal) 任意1;
							this.次のプロパティ変更がUndoRedoリストに載らないようにする();
							this.textBoxメモ.Text = 変更後;
							this.textBoxメモ.Focus();

							int n小節番号 = (int) ( (decimal) 任意1 );

							#region [ dicメモの更新 ]
							//-----------------
							if( this.譜面.SSTFormatScore.dicメモ.ContainsKey( n小節番号 ) )
							{
								if( string.IsNullOrEmpty( 変更後 ) )
									this.譜面.SSTFormatScore.dicメモ.Remove( n小節番号 );
								else
									this.譜面.SSTFormatScore.dicメモ[ n小節番号 ] = 変更後;
							}
							else
							{
								if( !string.IsNullOrEmpty( 変更後 ) )
									this.譜面.SSTFormatScore.dicメモ.Add( n小節番号, 変更後 );
							}
							//-----------------
							#endregion

							this.Act小節の先頭へ移動する( n小節番号 );
							this.splitContainer分割パネルコンテナ.Panel2.Refresh();	// 小節メモをリフレッシュ。
						},
						null, this.textBoxメモ_以前の値, this.textBoxメモ.Text, (object) this.numericUpDownメモ用小節番号.Value, null );

					this.UndoRedo管理.セルを追加する( cc );


					// Undo ボタンを有効にする。

					this.UndoRedo用GUIのEnabledを設定する();
				}
			}
			//-----------------
			#endregion

			this.textBoxメモ_以前の値 = this.textBoxメモ.Text;	// <以前の値> = <現在の値>

			if( !UndoRedo.管理.UndoRedoした直後である )
				this.未保存である = true;

			UndoRedo.管理.UndoRedoした直後である = false;

			#region [ 小節番号に対応するメモを dicメモ に登録する。]
			//-----------------
			{
				int n小節番号 = (int) this.numericUpDownメモ用小節番号.Value;

				if( string.IsNullOrEmpty( this.textBoxメモ.Text ) )
				{
					// (A) 空文字列の場合

					if( this.譜面.SSTFormatScore.dicメモ.ContainsKey( n小節番号 ) )
						this.譜面.SSTFormatScore.dicメモ.Remove( n小節番号 );		// 存在してたら削除。
					// 存在してなかったら何もしない。
				}
				else
				{
					// (B) その他の場合

					if( this.譜面.SSTFormatScore.dicメモ.ContainsKey( n小節番号 ) )
						this.譜面.SSTFormatScore.dicメモ[ n小節番号 ] = this.textBoxメモ.Text;		// 存在してたら更新。
					else
						this.譜面.SSTFormatScore.dicメモ.Add( n小節番号, this.textBoxメモ.Text );	// 存在してなかったら追加。
				}
			}
			//-----------------
			#endregion
			#region [ もし最終小節だったなら、後ろに４つ小節を加える。]
			//-----------------
			{
				int n小節番号 = (int) this.numericUpDownメモ用小節番号.Value;

				if( n小節番号 == this.譜面.SSTFormatScore.最大小節番号 )
				{
					this.譜面.t最後の小節の後ろに小節を４つ追加する();
				}
			}
			//-----------------
			#endregion

		}
		protected void textBoxメモ_Leave( object sender, EventArgs e )
		{
			// 最新 UndoRedoセル の所有権を放棄する。
			this.UndoRedo管理.Undoするセルを取得して返す_見るだけ()?.所有権を放棄する( this.textBoxメモ );

			// 小節メモをリフレッシュ。
			this.splitContainer分割パネルコンテナ.Panel2.Refresh();
		}
		protected string textBoxメモ_以前の値 = "";
	
		protected void numericUpDownメモ用小節番号_ValueChanged( object sender, EventArgs e )
		{
			// 小節番号にあわせて、textBoxメモにメモを表示する。

			int n小節番号 = (int) this.numericUpDownメモ用小節番号.Value;

			this.次のプロパティ変更がUndoRedoリストに載らないようにする();
			{
				if( this.譜面.SSTFormatScore.dicメモ.ContainsKey( n小節番号 ) )
					this.textBoxメモ.Text = this.譜面.SSTFormatScore.dicメモ[ n小節番号 ];
				else
					this.textBoxメモ.Text = "";
			}
			this.次のプロパティ変更がUndoRedoリストに載るようにする();
		}
		//-----------------
		#endregion

		private Font メモ用フォント = new Font( FontFamily.GenericSansSerif, 9.0f );
		private readonly Dictionary<int, string> dic音量ラベル = new Dictionary<int, string>() {
			{ 1, "1 (Smallest)" },
			{ 2, "2 (Smaller)" },
			{ 3, "3 (Middle)" },
			{ 4, "4 (Normal)" },
		};
	}
}
