﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SSTFEditor
{
	public partial class Popupメッセージ : Form
	{
		public Popupメッセージ( string strメッセージ )
		{
			InitializeComponent();

			this.strメッセージ = strメッセージ;
			this.ftフォント = new Font( "MS PGothic", 10f );
		}

		#region [ protected ]
		//-----------------
		protected string strメッセージ;
		protected Font ftフォント;

		protected void Cポップアップメッセージ_FormClosing( object sender, FormClosingEventArgs e )
		{
			FDK.Utilities.解放する( ref this.ftフォント );
		}
		protected void Cポップアップメッセージ_Load( object sender, EventArgs e )
		{
			base.Location = new Point(
				base.Owner.Location.X + ( ( base.Owner.Width - base.Width ) / 2 ),
				base.Owner.Location.Y + ( ( base.Owner.Height - base.Height ) / 2 ) );
		}

		protected void panelメッセージ本文_Paint( object sender, PaintEventArgs e )
		{
			using( var brush = new SolidBrush( Color.Black ) )
			{
				e.Graphics.DrawString(
					this.strメッセージ,
					this.ftフォント,
					brush,
					new RectangleF( 0f, 0f, (float) this.panelメッセージ本文.ClientSize.Width, (float) this.panelメッセージ本文.ClientSize.Height ),
					new StringFormat() {
						LineAlignment = StringAlignment.Center,
						Alignment = StringAlignment.Near,
					} );
			}
		}
		//-----------------
		#endregion
	}
}
