﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;

namespace FDK.同期
{
	/// <summary>
	/// ReadWriterLock アクセスを提供する。
	/// </summary>
	/// <typeparam name="T">排他アクセスを行いたい型。</typeparam>
	public class RWLock<T>
	{
		public T Value
		{
			get
			{
				this.排他利用.EnterReadLock();
				try
				{
					return this._target;
				}
				finally
				{
					this.排他利用.ExitReadLock();
				}
			}
			set
			{
				this.排他利用.EnterWriteLock();
				try
				{
					this._target = value;
				}
				finally
				{
					this.排他利用.ExitWriteLock();
				}
			}
		}

		public RWLock() : this( default( T ) )
		{
		}
		public RWLock( T 初期値 )
		{
			this.排他利用 = new ReaderWriterLockSlim( LockRecursionPolicy.SupportsRecursion );  // 再入可能（実は推奨されない）
			this._target = 初期値;
		}
		public RWLock( ReaderWriterLockSlim rwLocker, T 初期値 )
		{
			Debug.Assert( null != rwLocker );

			this.排他利用 = rwLocker;
			this._target = 初期値;
		}
		public RWLock( ReaderWriterLockSlim rwLocker ) : this( rwLocker, default( T ) )
		{
		}

		protected T _target = default( T );
		protected readonly ReaderWriterLockSlim 排他利用;
	}
}
