﻿using System;
using System.Collections.Generic;

namespace FDK.同期
{
	/// <summary>
	/// DXGIデバイスマネージャからD3Dデバイスを取得するためのロック機構。
	/// </summary>
	/// <remarks>
	/// MediaFoundation と Direct3D は、DXGI のロックを介して Direct3Dデバイス を共有する。
	/// </remarks>
	public class AutoD3DDeviceLock : IDisposable
	{
		public AutoD3DDeviceLock( SharpDX.MediaFoundation.DXGIDeviceManager deviceManager, out SharpDX.Direct3D11.Device d3dDevice )
		{
			this.deviceManager = deviceManager;
			this.deviceHandle = this.deviceManager.OpenDeviceHandle();
			this.デバイスをロックし取得する( out d3dDevice );
		}
		public void Dispose()
		{
			this.デバイスを解放しロックを解除する();
			//Utility.Disposeする( ref this.deviceManager ); → ここで Dispose してはならない。Dispose する責任は呼び出しもとにある。
			this.deviceManager = null; // 自分の参照だけを外す。
		}

		/// <param name="d3dDevice">利用が終わったら Dispose すること。</param>
		private void デバイスをロックし取得する( out SharpDX.Direct3D11.Device d3dDevice )
		{
			var dev = this.deviceManager.LockDevice(
				this.deviceHandle,
				typeof( SharpDX.Direct3D11.Device ).GUID,
				true );   // Lockできるまでブロックする

			d3dDevice = SharpDX.Direct3D11.Device.FromPointer<SharpDX.Direct3D11.Device>( dev );
		}
		private void デバイスを解放しロックを解除する()
		{
			if( IntPtr.Zero == this.deviceHandle )
				return;

			this.deviceManager.UnlockDevice( this.deviceHandle );
			this.deviceManager.CloseDeviceHandle( this.deviceHandle );
			this.deviceHandle = IntPtr.Zero;
		}

		private SharpDX.MediaFoundation.DXGIDeviceManager deviceManager = null;
		private IntPtr deviceHandle = IntPtr.Zero;
	}
}
