﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

namespace FDK.メディア
{
	public class テクスチャ : FDK.Activity
	{
		// (1) 個別項目

		/// <summary>
		/// 0:透明～1:不透明
		/// </summary>
		public float 不透明度 { get; set; } = 1f;
		public bool 加算合成する { get; set; } = false;
		public SharpDX.Size2F サイズdpx => this.ShaderResourceViewSize;
		public SharpDX.Matrix 等倍スケーリング行列 => SharpDX.Matrix.Scaling( this.サイズdpx.Width, this.サイズdpx.Height, 1f );

		public テクスチャ( string 画像ファイルパス )
		{
			this.画像ファイルパス = 画像ファイルパス;
			this.ユーザ指定サイズdpx = SharpDX.Size2.Empty;
		}
		public テクスチャ( SharpDX.Size2 サイズdpx )
		{
			this.画像ファイルパス = null;
			this.ユーザ指定サイズdpx = サイズdpx;
		}
		protected override void Onデバイス依存リソースの作成( デバイスリソース dr )
		{
			var d3dDevice = (SharpDX.Direct3D11.Device) null;

			using( var d3dLock = new FDK.同期.AutoD3DDeviceLock( dr.DXGIDeviceManager, out d3dDevice ) )
			using( d3dDevice )
			{
				#region " 定数バッファ "
				//----------------
				var cBufferDesc = new SharpDX.Direct3D11.BufferDescription() {
					Usage = SharpDX.Direct3D11.ResourceUsage.Dynamic,   // 動的使用法
					BindFlags = SharpDX.Direct3D11.BindFlags.ConstantBuffer,    // 定数バッファ
					CpuAccessFlags = SharpDX.Direct3D11.CpuAccessFlags.Write,   // CPUから書き込む
					OptionFlags = SharpDX.Direct3D11.ResourceOptionFlags.None,
					SizeInBytes = SharpDX.Utilities.SizeOf<ST定数バッファの転送元データ>(),   // バッファサイズ
					StructureByteStride = 0,
				};
				this.ConstantBuffer = new SharpDX.Direct3D11.Buffer( d3dDevice, cBufferDesc );
				//----------------
				#endregion
				#region " テクスチャとシェーダーリソースビュー "
				//----------------
				if( this.画像ファイルパス.Nullでも空でもない() )
				{
					this.ShaderResourceView = FDK.Utilities.CreateShaderResourceViewFromFile(
						d3dDevice, FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this.画像ファイルパス ), out this.ShaderResourceViewSize, out this.Texture );
				}
				else if( this.ユーザ指定サイズdpx != SharpDX.Size2.Empty )
				{
					this.ShaderResourceView = FDK.Utilities.CreateShaderResourceView(
						d3dDevice, this.ユーザ指定サイズdpx, out this.Texture );

					this.ShaderResourceViewSize = new SharpDX.Size2F( this.ユーザ指定サイズdpx.Width, this.ユーザ指定サイズdpx.Height );
				}
				else
				{
					throw new InvalidOperationException();
				}
				//----------------
				#endregion
			}
		}
		protected override void Onデバイス依存リソースの解放( デバイスリソース dr )
		{
			FDK.Utilities.解放する( ref this.ShaderResourceView );
			FDK.Utilities.解放する( ref this.Texture );
			FDK.Utilities.解放する( ref this.ConstantBuffer );
		}

		/// <summary>テクスチャを描画する。</summary>
		/// <param name="ワールド行列変換">テクスチャは1×1のモデルサイズで表現されており、それにこのワールド行列を適用する。</param>
		/// <param name="転送元矩形">テクスチャ座標(値域0～1)で指定する。</param>
		public void 進行描画する( デバイスリソース dr, SharpDX.Matrix ワールド行列変換, SharpDX.RectangleF? 転送元矩形 = null )
		{
			var d3dDevice = (SharpDX.Direct3D11.Device) null;
			using( var d3dLock = new FDK.同期.AutoD3DDeviceLock( dr.DXGIDeviceManager, out d3dDevice ) )
			using( d3dDevice )
			using( var d3dContext = d3dDevice.ImmediateContext )
			{
				#region " 定数バッファを更新する。"
				//----------------
				{
					// ワールド変換行列
					ワールド行列変換.Transpose();    // 転置
					this.定数バッファの転送元データ.World = ワールド行列変換;

					// ビュー変換行列
					this.定数バッファの転送元データ.View = dr.ビュー変換行列;

					// 射影変換行列
					this.定数バッファの転送元データ.Projection = dr.射影変換行列;

					// 描画元矩形
					if( null == 転送元矩形 )
						転送元矩形 = new SharpDX.RectangleF( 0f, 0f, 1f, 1f );
					this.定数バッファの転送元データ.TexLeft = 転送元矩形.Value.Left;
					this.定数バッファの転送元データ.TexTop = 転送元矩形.Value.Top;
					this.定数バッファの転送元データ.TexRight = 転送元矩形.Value.Right;
					this.定数バッファの転送元データ.TexBottom = 転送元矩形.Value.Bottom;

					// アルファ
					this.定数バッファの転送元データ.TexAlpha = this.不透明度;
					this.定数バッファの転送元データ.dummy1 = 0f;
					this.定数バッファの転送元データ.dummy2 = 0f;
					this.定数バッファの転送元データ.dummy3 = 0f;

					// 定数バッファへ書き込む。
					var dataBox = d3dContext.MapSubresource(
						resourceRef: this.ConstantBuffer,
						subresource: 0,
						mapType: SharpDX.Direct3D11.MapMode.WriteDiscard,
						mapFlags: SharpDX.Direct3D11.MapFlags.None );
					SharpDX.Utilities.Write( dataBox.DataPointer, ref this.定数バッファの転送元データ );
					d3dContext.UnmapSubresource( this.ConstantBuffer, 0 );
				}
				//----------------
				#endregion
				#region " 3Dパイプラインを設定する。"
				//----------------
				// 入力アセンブラ
				d3dContext.InputAssembler.InputLayout = null;
				d3dContext.InputAssembler.PrimitiveTopology = SharpDX.Direct3D.PrimitiveTopology.TriangleStrip;

				// 頂点シェーダ
				d3dContext.VertexShader.Set( テクスチャ.VertexShader );
				d3dContext.VertexShader.SetConstantBuffers( 0, this.ConstantBuffer );

				// ジオメトリシェーダ
				d3dContext.GeometryShader.Set( null );

				// ラスタライザ
				d3dContext.Rasterizer.SetViewports( dr.D3DViewPort );
				d3dContext.Rasterizer.State = テクスチャ.RasterizerState;

				// ピクセルシェーダ
				d3dContext.PixelShader.Set( テクスチャ.PixelShader );
				d3dContext.PixelShader.SetConstantBuffers( 0, this.ConstantBuffer );
				d3dContext.PixelShader.SetShaderResources( 0, 1, this.ShaderResourceView );
				d3dContext.PixelShader.SetSamplers( 0, 1, テクスチャ.SamplerState );

				// 出力マージャ
				d3dContext.OutputMerger.SetTargets( dr.D3DDepthStencilView, dr.D3DRenderTargetView );
				d3dContext.OutputMerger.SetBlendState(
					( this.加算合成する ) ? テクスチャ.BlendStateAdd : テクスチャ.BlendStateNormal,
					new SharpDX.Mathematics.Interop.RawColor4( 0f, 0f, 0f, 0f ),
					-1 );
				d3dContext.OutputMerger.SetDepthStencilState( dr.D3DDepthStencilState, 0 );
				//----------------
				#endregion

				// 頂点バッファとインデックスバッファを使わずに 4 つの頂点を描画する。
				d3dContext.Draw( vertexCount: 4, startVertexLocation: 0 );
			}
		}

		protected string 画像ファイルパス = null;
		protected SharpDX.Size2 ユーザ指定サイズdpx;
		protected struct ST定数バッファの転送元データ
		{
			public SharpDX.Matrix World;      // ワールド変換行列
			public SharpDX.Matrix View;       // ビュー変換行列
			public SharpDX.Matrix Projection; // 透視変換行列

			public float TexLeft;   // 描画元矩形の左u座標(0～1)
			public float TexTop;    // 描画元矩形の上v座標(0～1)
			public float TexRight;  // 描画元矩形の右u座標(0～1)
			public float TexBottom; // 描画元矩形の下v座標(0～1)

			public float TexAlpha;  // テクスチャに乗じるアルファ値(0～1)
			public float dummy1;    // float4境界に合わせるためのダミー
			public float dummy2;    // float4境界に合わせるためのダミー
			public float dummy3;    // float4境界に合わせるためのダミー
		};
		protected ST定数バッファの転送元データ 定数バッファの転送元データ;
		protected SharpDX.Direct3D11.Buffer ConstantBuffer = null;
		protected SharpDX.Direct3D11.Texture2D Texture = null;
		protected SharpDX.Direct3D11.ShaderResourceView ShaderResourceView = null;
		protected SharpDX.Size2F ShaderResourceViewSize;

		// (2) 全インスタンス共通項目(static)

		public static void 共有リソースを作成する( FDK.メディア.デバイスリソース dr )
		{
			var d3dDevice = (SharpDX.Direct3D11.Device) null;
			using( var d3dLock = new FDK.同期.AutoD3DDeviceLock( dr.DXGIDeviceManager, out d3dDevice ) )
			using( d3dDevice )
			{
				#region " 頂点シェーダ "
				//----------------
				var シェーダコンパイルのオプション =
					SharpDX.D3DCompiler.ShaderFlags.Debug |
					SharpDX.D3DCompiler.ShaderFlags.SkipOptimization |
					SharpDX.D3DCompiler.ShaderFlags.EnableStrictness |
					SharpDX.D3DCompiler.ShaderFlags.PackMatrixColumnMajor;

				// シェーダコードをコンパイルする。
				using( var code = SharpDX.D3DCompiler.ShaderBytecode.Compile(
					FDK.Properties.Resources.テクスチャ用シェーダコード,
					"VS", "vs_4_0", シェーダコンパイルのオプション ) )
				{
					// 頂点シェーダを生成する。
					テクスチャ.VertexShader = new SharpDX.Direct3D11.VertexShader( d3dDevice, code );
				}
				//----------------
				#endregion
				#region " ピクセルシェーダ "
				//----------------
				// シェーダコードをコンパイルする。
				using( var code = SharpDX.D3DCompiler.ShaderBytecode.Compile(
					FDK.Properties.Resources.テクスチャ用シェーダコード,
					"PS", "ps_4_0", シェーダコンパイルのオプション ) )
				{
					// ピクセルシェーダを作成する。
					テクスチャ.PixelShader = new SharpDX.Direct3D11.PixelShader( d3dDevice, code );
				}
				//----------------
				#endregion
				#region " ブレンドステート（通常）"
				//----------------
				var BlendStateNorm = new SharpDX.Direct3D11.BlendStateDescription() {
					AlphaToCoverageEnable = false,  // アルファマスクで透過する（するならZバッファ必須）
					IndependentBlendEnable = false, // 個別設定。false なら BendStateDescription.RenderTarget[0] だけが有効で、[1～7] は無視される。
				};
				BlendStateNorm.RenderTarget[ 0 ].IsBlendEnabled = true; // true ならブレンディングが有効。
				BlendStateNorm.RenderTarget[ 0 ].RenderTargetWriteMask = SharpDX.Direct3D11.ColorWriteMaskFlags.All;        // RGBA の書き込みマスク。

				// アルファ値のブレンディング設定 ... 特になし
				BlendStateNorm.RenderTarget[ 0 ].SourceAlphaBlend = SharpDX.Direct3D11.BlendOption.One;
				BlendStateNorm.RenderTarget[ 0 ].DestinationAlphaBlend = SharpDX.Direct3D11.BlendOption.Zero;
				BlendStateNorm.RenderTarget[ 0 ].AlphaBlendOperation = SharpDX.Direct3D11.BlendOperation.Add;

				// 色値のブレンディング設定 ... アルファ強度に応じた透明合成（テクスチャのアルファ値は、テクスチャのアルファ×ピクセルシェーダでの全体アルファとする（HLSL参照））
				BlendStateNorm.RenderTarget[ 0 ].SourceBlend = SharpDX.Direct3D11.BlendOption.SourceAlpha;
				BlendStateNorm.RenderTarget[ 0 ].DestinationBlend = SharpDX.Direct3D11.BlendOption.InverseSourceAlpha;
				BlendStateNorm.RenderTarget[ 0 ].BlendOperation = SharpDX.Direct3D11.BlendOperation.Add;

				// ブレンドステートを作成する。
				テクスチャ.BlendStateNormal = new SharpDX.Direct3D11.BlendState( d3dDevice, BlendStateNorm );
				//----------------
				#endregion
				#region " ブレンドステート（加算合成）"
				//----------------
				var BlendStateAdd = new SharpDX.Direct3D11.BlendStateDescription() {
					AlphaToCoverageEnable = false,  // アルファマスクで透過する（するならZバッファ必須）
					IndependentBlendEnable = false, // 個別設定。false なら BendStateDescription.RenderTarget[0] だけが有効で、[1～7] は無視される。
				};
				BlendStateAdd.RenderTarget[ 0 ].IsBlendEnabled = true; // true ならブレンディングが有効。
				BlendStateAdd.RenderTarget[ 0 ].RenderTargetWriteMask = SharpDX.Direct3D11.ColorWriteMaskFlags.All;        // RGBA の書き込みマスク。

				// アルファ値のブレンディング設定 ... 特になし
				BlendStateAdd.RenderTarget[ 0 ].SourceAlphaBlend = SharpDX.Direct3D11.BlendOption.One;
				BlendStateAdd.RenderTarget[ 0 ].DestinationAlphaBlend = SharpDX.Direct3D11.BlendOption.Zero;
				BlendStateAdd.RenderTarget[ 0 ].AlphaBlendOperation = SharpDX.Direct3D11.BlendOperation.Add;

				// 色値のブレンディング設定 ... 加算合成
				BlendStateAdd.RenderTarget[ 0 ].SourceBlend = SharpDX.Direct3D11.BlendOption.SourceAlpha;
				BlendStateAdd.RenderTarget[ 0 ].DestinationBlend = SharpDX.Direct3D11.BlendOption.One;
				BlendStateAdd.RenderTarget[ 0 ].BlendOperation = SharpDX.Direct3D11.BlendOperation.Add;

				// ブレンドステートを作成する。
				テクスチャ.BlendStateAdd = new SharpDX.Direct3D11.BlendState( d3dDevice, BlendStateNorm );
				//----------------
				#endregion
				#region " ラスタライザステート "
				//----------------
				var RSDesc = new SharpDX.Direct3D11.RasterizerStateDescription() {
					FillMode = SharpDX.Direct3D11.FillMode.Solid,   // 普通に描画する
					CullMode = SharpDX.Direct3D11.CullMode.None,    // 両面を描画する
					IsFrontCounterClockwise = false,    // 時計回りが表面
					DepthBias = 0,
					DepthBiasClamp = 0,
					SlopeScaledDepthBias = 0,
					IsDepthClipEnabled = true,
					IsScissorEnabled = false,
					IsMultisampleEnabled = false,
					IsAntialiasedLineEnabled = false,
				};
				テクスチャ.RasterizerState = new SharpDX.Direct3D11.RasterizerState( d3dDevice, RSDesc );
				//----------------
				#endregion
				#region " サンプラーステート "
				//----------------
				var descSampler = new SharpDX.Direct3D11.SamplerStateDescription() {
					Filter = SharpDX.Direct3D11.Filter.Anisotropic,
					AddressU = SharpDX.Direct3D11.TextureAddressMode.Wrap,
					AddressV = SharpDX.Direct3D11.TextureAddressMode.Wrap,
					AddressW = SharpDX.Direct3D11.TextureAddressMode.Wrap,
					MipLodBias = 0.0f,
					MaximumAnisotropy = 2,
					ComparisonFunction = SharpDX.Direct3D11.Comparison.Never,
					BorderColor = new SharpDX.Mathematics.Interop.RawColor4( 0f, 0f, 0f, 0f ),
					MinimumLod = float.MinValue,
					MaximumLod = float.MaxValue,
				};
				テクスチャ.SamplerState = new SharpDX.Direct3D11.SamplerState( d3dDevice, descSampler );
				//----------------
				#endregion
			}
		}
		public static void 共有リソースを解放する()
		{
			FDK.Utilities.解放する( ref テクスチャ.SamplerState );
			FDK.Utilities.解放する( ref テクスチャ.RasterizerState );
			FDK.Utilities.解放する( ref テクスチャ.BlendStateAdd );
			FDK.Utilities.解放する( ref テクスチャ.BlendStateNormal );
			FDK.Utilities.解放する( ref テクスチャ.PixelShader );
			FDK.Utilities.解放する( ref テクスチャ.VertexShader );
		}

		protected static SharpDX.Direct3D11.VertexShader VertexShader = null;
		protected static SharpDX.Direct3D11.PixelShader PixelShader = null;
		protected static SharpDX.Direct3D11.BlendState BlendStateNormal = null;
		protected static SharpDX.Direct3D11.BlendState BlendStateAdd = null;
		protected static SharpDX.Direct3D11.RasterizerState RasterizerState = null;
		protected static SharpDX.Direct3D11.SamplerState SamplerState = null;
	}
}
