// Copyright (c) Athena Dev Teams - Licensed under GNU GPL
// For more information, see LICENCE in the main folder

#ifndef _SCRIPT_CONSTANTS_H_
	#define _SCRIPT_CONSTANTS_H_

	#define export_constant(a) script_set_constant(#a,a,false,false)
	#define export_constant2(a,b) script_set_constant(a,b,false,false)
	#define export_parameter(a,b) script_set_constant(a,b,true,false)

	/* min and maximum variable value */
	export_constant(INT_MIN);
	export_constant(INT_MAX);

	/* server defines */
	export_constant(PACKETVER);
	export_constant(MAX_LEVEL);
	export_constant(MAX_STORAGE);
	export_constant(MAX_INVENTORY);
	export_constant(MAX_CART);
	export_constant(MAX_ZENY);
	export_constant(MAX_PARTY);
	export_constant(MAX_GUILD);
	export_constant(MAX_GUILDLEVEL);
	export_constant(MAX_GUARDIANS);
	export_constant(MAX_GUILD_STORAGE);
	export_constant(MAX_BG_MEMBERS);
	export_constant(MAX_CHAT_USERS);
	export_constant(VIP_SCRIPT);
	export_constant(MIN_STORAGE);
	export_constant(MAX_SLOTS);
	export_constant(MAX_ITEM_RDM_OPT);
	export_constant(NAME_LENGTH);
	export_constant(PASSWD_LENGTH);

	/* boolean values */
	export_constant(true);
	export_constant(false);

	/* jobs */
	export_constant(JOB_NOVICE);
	export_constant(JOB_SWORDMAN);
	export_constant(JOB_MAGE);
	export_constant(JOB_ARCHER);
	export_constant(JOB_ACOLYTE);
	export_constant(JOB_MERCHANT);
	export_constant(JOB_THIEF);
	export_constant(JOB_KNIGHT);
	export_constant(JOB_PRIEST);
	export_constant(JOB_WIZARD);
	export_constant(JOB_BLACKSMITH);
	export_constant(JOB_HUNTER);
	export_constant(JOB_ASSASSIN);
	export_constant(JOB_KNIGHT2);
	export_constant(JOB_CRUSADER);
	export_constant(JOB_MONK);
	export_constant(JOB_SAGE);
	export_constant(JOB_ROGUE);
	export_constant(JOB_ALCHEMIST);
	export_constant(JOB_BARD);
	export_constant(JOB_DANCER);
	export_constant(JOB_CRUSADER2);
	export_constant(JOB_WEDDING);
	export_constant(JOB_SUPER_NOVICE);
	// For backwards compatability
	export_constant2("Job_SuperNovice",JOB_SUPER_NOVICE); // TODO: Refactor NPCs to use the new constant
	export_constant(JOB_GUNSLINGER);
	export_constant(JOB_NINJA);
	export_constant(JOB_XMAS);
	export_constant(JOB_SUMMER);
	export_constant(JOB_HANBOK);
	export_constant(JOB_OKTOBERFEST);

	export_constant(JOB_NOVICE_HIGH);
	export_constant(JOB_SWORDMAN_HIGH);
	export_constant(JOB_MAGE_HIGH);
	export_constant(JOB_ARCHER_HIGH);
	export_constant(JOB_ACOLYTE_HIGH);
	export_constant(JOB_MERCHANT_HIGH);
	export_constant(JOB_THIEF_HIGH);
	export_constant(JOB_LORD_KNIGHT);
	export_constant(JOB_HIGH_PRIEST);
	export_constant(JOB_HIGH_WIZARD);
	export_constant(JOB_WHITESMITH);
	export_constant(JOB_SNIPER);
	export_constant(JOB_ASSASSIN_CROSS);
	export_constant(JOB_LORD_KNIGHT2);
	export_constant(JOB_PALADIN);
	export_constant(JOB_CHAMPION);
	export_constant(JOB_PROFESSOR);
	export_constant(JOB_STALKER);
	export_constant(JOB_CREATOR);
	export_constant(JOB_CLOWN);
	export_constant(JOB_GYPSY);
	export_constant(JOB_PALADIN2);

	export_constant(JOB_BABY);
	export_constant(JOB_BABY_SWORDMAN);
	export_constant(JOB_BABY_MAGE);
	export_constant(JOB_BABY_ARCHER);
	export_constant(JOB_BABY_ACOLYTE);
	export_constant(JOB_BABY_MERCHANT);
	export_constant(JOB_BABY_THIEF);
	export_constant(JOB_BABY_KNIGHT);
	export_constant(JOB_BABY_PRIEST);
	export_constant(JOB_BABY_WIZARD);
	export_constant(JOB_BABY_BLACKSMITH);
	export_constant(JOB_BABY_HUNTER);
	export_constant(JOB_BABY_ASSASSIN);
	export_constant(JOB_BABY_KNIGHT2);
	export_constant(JOB_BABY_CRUSADER);
	export_constant(JOB_BABY_MONK);
	export_constant(JOB_BABY_SAGE);
	export_constant(JOB_BABY_ROGUE);
	export_constant(JOB_BABY_ALCHEMIST);
	export_constant(JOB_BABY_BARD);
	export_constant(JOB_BABY_DANCER);
	export_constant(JOB_BABY_CRUSADER2);
	export_constant(JOB_SUPER_BABY);

	export_constant(JOB_TAEKWON);
	export_constant(JOB_STAR_GLADIATOR);
	export_constant(JOB_STAR_GLADIATOR2);
	export_constant(JOB_SOUL_LINKER);

	export_constant(JOB_GANGSI);
	export_constant(JOB_DEATH_KNIGHT);
	export_constant(JOB_DARK_COLLECTOR);

	export_constant(JOB_RUNE_KNIGHT);
	export_constant(JOB_WARLOCK);
	export_constant(JOB_RANGER);
	export_constant(JOB_ARCH_BISHOP);
	export_constant(JOB_MECHANIC);
	export_constant(JOB_GUILLOTINE_CROSS);

	export_constant(JOB_RUNE_KNIGHT_T);
	export_constant(JOB_WARLOCK_T);
	export_constant(JOB_RANGER_T);
	export_constant(JOB_ARCH_BISHOP_T);
	export_constant(JOB_MECHANIC_T);
	export_constant(JOB_GUILLOTINE_CROSS_T);

	export_constant(JOB_ROYAL_GUARD);
	export_constant(JOB_SORCERER);
	export_constant(JOB_MINSTREL);
	export_constant(JOB_WANDERER);
	export_constant(JOB_SURA);
	export_constant(JOB_GENETIC);
	export_constant(JOB_SHADOW_CHASER);

	export_constant(JOB_ROYAL_GUARD_T);
	export_constant(JOB_SORCERER_T);
	export_constant(JOB_MINSTREL_T);
	export_constant(JOB_WANDERER_T);
	export_constant(JOB_SURA_T);
	export_constant(JOB_GENETIC_T);
	export_constant(JOB_SHADOW_CHASER_T);

	export_constant(JOB_RUNE_KNIGHT2);
	export_constant(JOB_RUNE_KNIGHT_T2);
	export_constant(JOB_ROYAL_GUARD2);
	export_constant(JOB_ROYAL_GUARD_T2);
	export_constant(JOB_RANGER2);
	export_constant(JOB_RANGER_T2);
	export_constant(JOB_MECHANIC2);
	export_constant(JOB_MECHANIC_T2);

	export_constant(JOB_BABY_RUNE);
	export_constant(JOB_BABY_WARLOCK);
	export_constant(JOB_BABY_RANGER);
	export_constant(JOB_BABY_BISHOP);
	export_constant(JOB_BABY_MECHANIC);
	export_constant(JOB_BABY_CROSS);
	export_constant(JOB_BABY_GUARD);
	export_constant(JOB_BABY_SORCERER);
	export_constant(JOB_BABY_MINSTREL);
	export_constant(JOB_BABY_WANDERER);
	export_constant(JOB_BABY_SURA);
	export_constant(JOB_BABY_GENETIC);
	export_constant(JOB_BABY_CHASER);

	export_constant(JOB_BABY_RUNE2);
	export_constant(JOB_BABY_GUARD2);
	export_constant(JOB_BABY_RANGER2);
	export_constant(JOB_BABY_MECHANIC2);

	export_constant(JOB_SUPER_NOVICE_E);
	export_constant(JOB_SUPER_BABY_E);

	export_constant(JOB_KAGEROU);
	export_constant(JOB_OBORO);

	export_constant(JOB_REBELLION);

	export_constant(JOB_SUMMONER);

	export_constant(JOB_BABY_SUMMONER);

	export_constant(JOB_BABY_NINJA);
	export_constant(JOB_BABY_KAGEROU);
	export_constant(JOB_BABY_OBORO);
	export_constant(JOB_BABY_TAEKWON);
	export_constant(JOB_BABY_STAR_GLADIATOR);
	export_constant(JOB_BABY_SOUL_LINKER);
	export_constant(JOB_BABY_GUNSLINGER);
	export_constant(JOB_BABY_REBELLION);

	export_constant(JOB_BABY_STAR_GLADIATOR2);

	/* EA jobs */
	export_constant2("EAJL_2_1",JOBL_2_1);
	export_constant2("EAJL_2_2",JOBL_2_2);
	export_constant2("EAJL_2",JOBL_2);
	export_constant2("EAJL_UPPER",JOBL_UPPER);
	export_constant2("EAJL_BABY",JOBL_BABY);
	export_constant2("EAJL_THIRD",JOBL_THIRD);

	export_constant2("EAJ_BASEMASK",MAPID_BASEMASK);
	export_constant2("EAJ_UPPERMASK",MAPID_UPPERMASK);
	export_constant2("EAJ_THIRDMASK",MAPID_THIRDMASK);

	export_constant2("EAJ_NOVICE",MAPID_NOVICE);
	export_constant2("EAJ_SWORDMAN",MAPID_SWORDMAN);
	export_constant2("EAJ_MAGE",MAPID_MAGE);
	export_constant2("EAJ_ARCHER",MAPID_ARCHER);
	export_constant2("EAJ_ACOLYTE",MAPID_ACOLYTE);
	export_constant2("EAJ_MERCHANT",MAPID_MERCHANT);
	export_constant2("EAJ_THIEF",MAPID_THIEF);
	export_constant2("EAJ_TAEKWON",MAPID_TAEKWON);
	export_constant2("EAJ_GUNSLINGER",MAPID_GUNSLINGER);
	export_constant2("EAJ_NINJA",MAPID_NINJA);
	export_constant2("EAJ_GANGSI",MAPID_GANGSI);

	export_constant2("EAJ_KNIGHT",MAPID_KNIGHT);
	export_constant2("EAJ_WIZARD",MAPID_WIZARD);
	export_constant2("EAJ_HUNTER",MAPID_HUNTER);
	export_constant2("EAJ_PRIEST",MAPID_PRIEST);
	export_constant2("EAJ_BLACKSMITH",MAPID_BLACKSMITH);
	export_constant2("EAJ_ASSASSIN",MAPID_ASSASSIN);
	export_constant2("EAJ_STAR_GLADIATOR",MAPID_STAR_GLADIATOR);
	export_constant2("EAJ_REBELLION",MAPID_REBELLION);
	export_constant2("EAJ_KAGEROUOBORO",MAPID_KAGEROUOBORO);
	export_constant2("EAJ_DEATH_KNIGHT",MAPID_DEATH_KNIGHT);

	export_constant2("EAJ_CRUSADER",MAPID_CRUSADER);
	export_constant2("EAJ_SAGE",MAPID_SAGE);
	export_constant2("EAJ_BARDDANCER",MAPID_BARDDANCER);
	export_constant2("EAJ_MONK",MAPID_MONK);
	export_constant2("EAJ_ALCHEMIST",MAPID_ALCHEMIST);
	export_constant2("EAJ_ROGUE",MAPID_ROGUE);
	export_constant2("EAJ_SOUL_LINKER",MAPID_SOUL_LINKER);
	export_constant2("EAJ_DARK_COLLECTOR",MAPID_DARK_COLLECTOR);

	export_constant2("EAJ_NOVICE_HIGH",MAPID_NOVICE_HIGH);
	export_constant2("EAJ_SWORDMAN_HIGH",MAPID_SWORDMAN_HIGH);
	export_constant2("EAJ_MAGE_HIGH",MAPID_MAGE_HIGH);
	export_constant2("EAJ_ARCHER_HIGH",MAPID_ARCHER_HIGH);
	export_constant2("EAJ_ACOLYTE_HIGH",MAPID_ACOLYTE_HIGH);
	export_constant2("EAJ_MERCHANT_HIGH",MAPID_MERCHANT_HIGH);
	export_constant2("EAJ_THIEF_HIGH",MAPID_THIEF_HIGH);

	export_constant2("EAJ_LORD_KNIGHT",MAPID_LORD_KNIGHT);
	export_constant2("EAJ_HIGH_WIZARD",MAPID_HIGH_WIZARD);
	export_constant2("EAJ_SNIPER",MAPID_SNIPER);
	export_constant2("EAJ_HIGH_PRIEST",MAPID_HIGH_PRIEST);
	export_constant2("EAJ_WHITESMITH",MAPID_WHITESMITH);
	export_constant2("EAJ_ASSASSIN_CROSS",MAPID_ASSASSIN_CROSS);

	export_constant2("EAJ_PALADIN",MAPID_PALADIN);
	export_constant2("EAJ_PROFESSOR",MAPID_PROFESSOR);
	export_constant2("EAJ_CLOWNGYPSY",MAPID_CLOWNGYPSY);
	export_constant2("EAJ_CHAMPION",MAPID_CHAMPION);
	export_constant2("EAJ_CREATOR",MAPID_CREATOR);
	export_constant2("EAJ_STALKER",MAPID_STALKER);

	export_constant2("EAJ_BABY",MAPID_BABY);
	export_constant2("EAJ_BABY_SWORDMAN",MAPID_BABY_SWORDMAN);
	export_constant2("EAJ_BABY_MAGE",MAPID_BABY_MAGE);
	export_constant2("EAJ_BABY_ARCHER",MAPID_BABY_ARCHER);
	export_constant2("EAJ_BABY_ACOLYTE",MAPID_BABY_ACOLYTE);
	export_constant2("EAJ_BABY_MERCHANT",MAPID_BABY_MERCHANT);
	export_constant2("EAJ_BABY_THIEF",MAPID_BABY_THIEF);
	export_constant2("EAJ_BABY_TAEKWON",MAPID_BABY_TAEKWON);
	export_constant2("EAJ_BABY_GUNSLINGER",MAPID_BABY_GUNSLINGER);
	export_constant2("EAJ_BABY_NINJA",MAPID_BABY_NINJA);
	export_constant2("EAJ_BABY_SUMMONER",MAPID_BABY_SUMMONER);

	export_constant2("EAJ_BABY_KNIGHT",MAPID_BABY_KNIGHT);
	export_constant2("EAJ_BABY_WIZARD",MAPID_BABY_WIZARD);
	export_constant2("EAJ_BABY_HUNTER",MAPID_BABY_HUNTER);
	export_constant2("EAJ_BABY_PRIEST",MAPID_BABY_PRIEST);
	export_constant2("EAJ_BABY_BLACKSMITH",MAPID_BABY_BLACKSMITH);
	export_constant2("EAJ_BABY_ASSASSIN",MAPID_BABY_ASSASSIN);
	export_constant2("EAJ_BABY_STAR_GLADIATOR",MAPID_BABY_STAR_GLADIATOR);
	export_constant2("EAJ_BABY_REBELLION",MAPID_BABY_REBELLION);
	export_constant2("EAJ_BABY_KAGEROUOBORO",MAPID_BABY_KAGEROUOBORO);

	export_constant2("EAJ_BABY_CRUSADER",MAPID_BABY_CRUSADER);
	export_constant2("EAJ_BABY_SAGE",MAPID_BABY_SAGE);
	export_constant2("EAJ_BABY_BARDDANCER",MAPID_BABY_BARDDANCER);
	export_constant2("EAJ_BABY_MONK",MAPID_BABY_MONK);
	export_constant2("EAJ_BABY_ALCHEMIST",MAPID_BABY_ALCHEMIST);
	export_constant2("EAJ_BABY_ROGUE",MAPID_BABY_ROGUE);
	export_constant2("EAJ_BABY_SOUL_LINKER",MAPID_BABY_SOUL_LINKER);

	export_constant2("EAJ_RUNE_KNIGHT",MAPID_RUNE_KNIGHT);
	export_constant2("EAJ_WARLOCK",MAPID_WARLOCK);
	export_constant2("EAJ_RANGER",MAPID_RANGER);
	export_constant2("EAJ_ARCH_BISHOP",MAPID_ARCH_BISHOP);
	export_constant2("EAJ_MECHANIC",MAPID_MECHANIC);
	export_constant2("EAJ_GUILLOTINE_CROSS",MAPID_GUILLOTINE_CROSS);

	export_constant2("EAJ_ROYAL_GUARD",MAPID_ROYAL_GUARD);
	export_constant2("EAJ_SORCERER",MAPID_SORCERER);
	export_constant2("EAJ_MINSTRELWANDERER",MAPID_MINSTRELWANDERER);
	export_constant2("EAJ_SURA",MAPID_SURA);
	export_constant2("EAJ_GENETIC",MAPID_GENETIC);
	export_constant2("EAJ_SHADOW_CHASER",MAPID_SHADOW_CHASER);

	export_constant2("EAJ_RUNE_KNIGHT_T",MAPID_RUNE_KNIGHT_T);
	export_constant2("EAJ_WARLOCK_T",MAPID_WARLOCK_T);
	export_constant2("EAJ_RANGER_T",MAPID_RANGER_T);
	export_constant2("EAJ_ARCH_BISHOP_T",MAPID_ARCH_BISHOP_T);
	export_constant2("EAJ_MECHANIC_T",MAPID_MECHANIC_T);
	export_constant2("EAJ_GUILLOTINE_CROSS_T",MAPID_GUILLOTINE_CROSS_T);

	export_constant2("EAJ_ROYAL_GUARD_T",MAPID_ROYAL_GUARD_T);
	export_constant2("EAJ_SORCERER_T",MAPID_SORCERER_T);
	export_constant2("EAJ_MINSTRELWANDERER_T",MAPID_MINSTRELWANDERER_T);
	export_constant2("EAJ_SURA_T",MAPID_SURA_T);
	export_constant2("EAJ_GENETIC_T",MAPID_GENETIC_T);
	export_constant2("EAJ_SHADOW_CHASER_T",MAPID_SHADOW_CHASER_T);

	export_constant2("EAJ_BABY_RUNE",MAPID_BABY_RUNE);
	export_constant2("EAJ_BABY_WARLOCK",MAPID_BABY_WARLOCK);
	export_constant2("EAJ_BABY_RANGER",MAPID_BABY_RANGER);
	export_constant2("EAJ_BABY_BISHOP",MAPID_BABY_BISHOP);
	export_constant2("EAJ_BABY_MECHANIC",MAPID_BABY_MECHANIC);
	export_constant2("EAJ_BABY_CROSS",MAPID_BABY_CROSS);

	export_constant2("EAJ_BABY_GUARD",MAPID_BABY_GUARD);
	export_constant2("EAJ_BABY_SORCERER",MAPID_BABY_SORCERER);
	export_constant2("EAJ_BABY_MINSTRELWANDERER",MAPID_BABY_MINSTRELWANDERER);
	export_constant2("EAJ_BABY_SURA",MAPID_BABY_SURA);
	export_constant2("EAJ_BABY_GENETIC",MAPID_BABY_GENETIC);
	export_constant2("EAJ_BABY_CHASER",MAPID_BABY_CHASER);

	export_constant2("EAJ_SUPER_NOVICE",MAPID_SUPER_NOVICE);
	export_constant2("EAJ_SUPER_BABY",MAPID_SUPER_BABY);
	export_constant2("EAJ_SUPER_NOVICE_E",MAPID_SUPER_NOVICE_E);
	export_constant2("EAJ_SUPER_BABY_E",MAPID_SUPER_BABY_E);

	export_constant2("EAJ_SUMMONER",MAPID_SUMMONER);

	/* sex */
	export_constant(SEX_FEMALE);
	export_constant(SEX_MALE);

	/* broadcasts */
	export_constant(BC_ALL);
	export_constant(BC_MAP);
	export_constant(BC_AREA);
	export_constant(BC_SELF);
	export_constant(BC_PC);
	export_constant(BC_NPC);
	export_constant(BC_YELLOW);
	export_constant(BC_BLUE);
	export_constant(BC_WOE);

	/* mapflags */
	export_constant(MF_NOMEMO);
	export_constant(MF_NOTELEPORT);
	export_constant(MF_NOSAVE);
	export_constant(MF_NOBRANCH);
	export_constant(MF_NOPENALTY);
	export_constant(MF_NOZENYPENALTY);
	export_constant(MF_PVP);
	export_constant(MF_PVP_NOPARTY);
	export_constant(MF_PVP_NOGUILD);
	export_constant(MF_GVG);
	export_constant(MF_GVG_NOPARTY);
	export_constant(MF_NOTRADE);
	export_constant(MF_NOSKILL);
	export_constant(MF_NOWARP);
	export_constant(MF_PARTYLOCK);
	export_constant(MF_NOICEWALL);
	export_constant(MF_SNOW);
	export_constant(MF_FOG);
	export_constant(MF_SAKURA);
	export_constant(MF_LEAVES);
	// Intentionally disabled mf_rain because Ind removed it source side
	//export_constant(MF_RAIN);
	export_constant(MF_NOGO);
	export_constant(MF_CLOUDS);
	export_constant(MF_CLOUDS2);
	export_constant(MF_FIREWORKS);
	export_constant(MF_GVG_CASTLE);
	export_constant(MF_GVG_DUNGEON);
	export_constant(MF_NIGHTENABLED);
	export_constant(MF_NOBASEEXP);
	export_constant(MF_NOJOBEXP);
	export_constant(MF_NOMOBLOOT);
	export_constant(MF_NOMVPLOOT);
	export_constant(MF_NORETURN);
	export_constant(MF_NOWARPTO);
	export_constant(MF_NIGHTMAREDROP);
	export_constant(MF_RESTRICTED);
	export_constant(MF_NOCOMMAND);
	export_constant(MF_NODROP);
	export_constant(MF_JEXP);
	export_constant(MF_BEXP);
	export_constant(MF_NOVENDING);
	export_constant(MF_LOADEVENT);
	export_constant(MF_NOCHAT);
	export_constant(MF_NOEXPPENALTY);
	export_constant(MF_GUILDLOCK);
	export_constant(MF_TOWN);
	export_constant(MF_AUTOTRADE);
	export_constant(MF_ALLOWKS);
	export_constant(MF_MONSTER_NOTELEPORT);
	export_constant(MF_PVP_NOCALCRANK);
	export_constant(MF_BATTLEGROUND);
	export_constant(MF_RESET);
	// TODO: Check why it is called differently on source and const
	//export_constant(MF_CHANNELAUTOJOIN);
	export_constant2("mf_nomapchannelautojoin",MF_CHANNELAUTOJOIN);
	export_constant(MF_NOUSECART);
	export_constant(MF_NOITEMCONSUMPTION);
	export_constant(MF_SUMSTARTMIRACLE);
	export_constant(MF_NOMINEEFFECT);
	export_constant(MF_NOLOCKON);
	export_constant(MF_NOTOMB);
	export_constant(MF_SKILL_DAMAGE);
	export_constant(MF_NOCOSTUME);
	export_constant(MF_GVG_TE_CASTLE);
	export_constant(MF_GVG_TE);
	export_constant(MF_HIDEMOBHPBAR);

	/* setcell types */
	export_constant(CELL_WALKABLE);
	export_constant(CELL_SHOOTABLE);
	export_constant(CELL_WATER);
	export_constant(CELL_NPC);
	export_constant(CELL_BASILICA);
	export_constant(CELL_LANDPROTECTOR);
	export_constant(CELL_NOVENDING);
	export_constant(CELL_NOCHAT);
	export_constant(CELL_MAELSTROM);
	export_constant(CELL_ICEWALL);

	/* getcell types */
	export_constant(CELL_CHKWALL);
	export_constant(CELL_CHKWATER);
	export_constant(CELL_CHKCLIFF);
	export_constant(CELL_CHKPASS);
	export_constant(CELL_CHKREACH);
	export_constant(CELL_CHKNOPASS);
	export_constant(CELL_CHKNOREACH);
	// TODO: Check why this was commented until now
	//export_constant(CELL_CHKSTACK);
	export_constant(CELL_CHKNPC);
	export_constant(CELL_CHKBASILICA);
	export_constant(CELL_CHKLANDPROTECTOR);
	export_constant(CELL_CHKNOVENDING);
	export_constant(CELL_CHKNOCHAT);
	export_constant(CELL_CHKMAELSTROM);
	export_constant(CELL_CHKICEWALL);

	/* parameters */
	export_parameter("StatusPoint",SP_STATUSPOINT);
	export_parameter("BaseLevel",SP_BASELEVEL);
	export_parameter("SkillPoint",SP_SKILLPOINT);
	export_parameter("Class",SP_CLASS);
	export_parameter("Upper",SP_UPPER);
	export_parameter("Zeny",SP_ZENY);
	export_parameter("Sex",SP_SEX);
	export_parameter("Weight",SP_WEIGHT);
	export_parameter("MaxWeight",SP_MAXWEIGHT);
	export_parameter("JobLevel",SP_JOBLEVEL);
	export_parameter("BaseExp",SP_BASEEXP);
	export_parameter("JobExp",SP_JOBEXP);
	export_parameter("Karma",SP_KARMA);
	export_parameter("Manner",SP_MANNER);
	export_parameter("NextBaseExp",SP_NEXTBASEEXP);
	export_parameter("NextJobExp",SP_NEXTJOBEXP);
	export_parameter("Hp",SP_HP);
	export_parameter("MaxHp",SP_MAXHP);
	export_parameter("Sp",SP_SP);
	export_parameter("MaxSp",SP_MAXSP);
	export_parameter("BaseJob",SP_BASEJOB);
	export_parameter("BaseClass",SP_BASECLASS);
	export_parameter("killerrid",SP_KILLERRID);
	export_parameter("killedrid",SP_KILLEDRID);
	export_parameter("Sitting",SP_SITTING);
	export_parameter("CharMoves",SP_CHARMOVE);
	export_parameter("CharRename",SP_CHARRENAME);
	export_parameter("Font",SP_CHARFONT);
	export_parameter("BankVault",SP_BANK_VAULT);
	export_parameter(ROULETTE_BRONZE_VAR,SP_ROULETTE_BRONZE);
	export_parameter(ROULETTE_SILVER_VAR,SP_ROULETTE_SILVER);
	export_parameter(ROULETTE_GOLD_VAR,SP_ROULETTE_GOLD);

	export_constant2("bMaxHP",SP_MAXHP);
	export_constant2("bMaxSP",SP_MAXSP);
	export_constant2("bStr",SP_STR);
	export_constant2("bAgi",SP_AGI);
	export_constant2("bVit",SP_VIT);
	export_constant2("bInt",SP_INT);
	export_constant2("bDex",SP_DEX);
	export_constant2("bLuk",SP_LUK);
	export_constant2("bAtk",SP_ATK1);
	export_constant2("bAtk2",SP_ATK2);
	export_constant2("bDef",SP_DEF1);
	export_constant2("bDef2",SP_DEF2);
	export_constant2("bMdef",SP_MDEF1);
	export_constant2("bMdef2",SP_MDEF2);
	export_constant2("bHit",SP_HIT);
	export_constant2("bFlee",SP_FLEE1);
	export_constant2("bFlee2",SP_FLEE2);
	export_constant2("bCritical",SP_CRITICAL);
	export_constant2("bAspd",SP_ASPD);
	export_constant2("bFame",SP_FAME);
	export_constant2("bUnbreakable",SP_UNBREAKABLE);

	export_constant2("bAtkRange",SP_ATTACKRANGE);
	export_constant2("bAtkEle",SP_ATKELE);
	export_constant2("bDefEle",SP_DEFELE);
	export_constant2("bCastrate",SP_CASTRATE);
	export_constant2("bMaxHPrate",SP_MAXHPRATE);
	export_constant2("bMaxSPrate",SP_MAXSPRATE);
	export_constant2("bUseSPrate",SP_SPRATE);
	export_constant2("bAddEle",SP_ADDELE);
	export_constant2("bAddRace",SP_ADDRACE);
	export_constant2("bAddSize",SP_ADDSIZE);
	export_constant2("bSubEle",SP_SUBELE);
	export_constant2("bSubRace",SP_SUBRACE);
	export_constant2("bAddEff",SP_ADDEFF);
	export_constant2("bResEff",SP_RESEFF);
	export_constant2("bBaseAtk",SP_BASE_ATK);
	export_constant2("bAspdRate",SP_ASPD_RATE);
	export_constant2("bHPrecovRate",SP_HP_RECOV_RATE);
	export_constant2("bSPrecovRate",SP_SP_RECOV_RATE);
	export_constant2("bSpeedRate",SP_SPEED_RATE);
	export_constant2("bCriticalDef",SP_CRITICAL_DEF);
	export_constant2("bNearAtkDef",SP_NEAR_ATK_DEF);
	export_constant2("bLongAtkDef",SP_LONG_ATK_DEF);
	export_constant2("bDoubleRate",SP_DOUBLE_RATE);
	export_constant2("bDoubleAddRate",SP_DOUBLE_ADD_RATE);
	export_constant2("bSkillHeal",SP_SKILL_HEAL);
	export_constant2("bMatkRate",SP_MATK_RATE);
	export_constant2("bWeaponMatkRate",SP_WEAPON_MATK_RATE);
	export_constant2("bIgnoreDefEle",SP_IGNORE_DEF_ELE);
	export_constant2("bIgnoreDefRace",SP_IGNORE_DEF_RACE);
	export_constant2("bAtkRate",SP_ATK_RATE);
	export_constant2("bWeaponAtkRate",SP_WEAPON_ATK_RATE);
	export_constant2("bSpeedAddRate",SP_SPEED_ADDRATE);
	export_constant2("bSPRegenRate",SP_SP_REGEN_RATE);
	export_constant2("bMagicAtkDef",SP_MAGIC_ATK_DEF);
	export_constant2("bMiscAtkDef",SP_MISC_ATK_DEF);
	export_constant2("bIgnoreMdefEle",SP_IGNORE_MDEF_ELE);
	export_constant2("bIgnoreMdefRace",SP_IGNORE_MDEF_RACE);
	export_constant2("bMagicAddEle",SP_MAGIC_ADDELE);
	export_constant2("bMagicAddRace",SP_MAGIC_ADDRACE);
	export_constant2("bMagicAddSize",SP_MAGIC_ADDSIZE);
	export_constant2("bPerfectHitRate",SP_PERFECT_HIT_RATE);
	export_constant2("bPerfectHitAddRate",SP_PERFECT_HIT_ADD_RATE);
	export_constant2("bCriticalRate",SP_CRITICAL_RATE);
	export_constant2("bGetZenyNum",SP_GET_ZENY_NUM);
	export_constant2("bAddGetZenyNum",SP_ADD_GET_ZENY_NUM);
	export_constant2("bAddDamageClass",SP_ADD_DAMAGE_CLASS);
	export_constant2("bAddMagicDamageClass",SP_ADD_MAGIC_DAMAGE_CLASS);
	export_constant2("bAddDefMonster",SP_ADD_DEF_MONSTER);
	export_constant2("bAddMdefMonster",SP_ADD_MDEF_MONSTER);
	export_constant2("bAddMonsterDropItem",SP_ADD_MONSTER_DROP_ITEM);
	export_constant2("bDefRatioAtkEle",SP_DEF_RATIO_ATK_ELE);
	export_constant2("bDefRatioAtkRace",SP_DEF_RATIO_ATK_RACE);
	export_constant2("bUnbreakableGarment",SP_UNBREAKABLE_GARMENT);
	export_constant2("bHitRate",SP_HIT_RATE);
	export_constant2("bFleeRate",SP_FLEE_RATE);
	export_constant2("bFlee2Rate",SP_FLEE2_RATE);
	export_constant2("bDefRate",SP_DEF_RATE);
	export_constant2("bDef2Rate",SP_DEF2_RATE);
	export_constant2("bMdefRate",SP_MDEF_RATE);
	export_constant2("bMdef2Rate",SP_MDEF2_RATE);
	export_constant2("bSplashRange",SP_SPLASH_RANGE);
	export_constant2("bSplashAddRange",SP_SPLASH_ADD_RANGE);
	export_constant2("bAutoSpell",SP_AUTOSPELL);
	export_constant2("bHPDrainRate",SP_HP_DRAIN_RATE);
	export_constant2("bSPDrainRate",SP_SP_DRAIN_RATE);
	export_constant2("bShortWeaponDamageReturn",SP_SHORT_WEAPON_DAMAGE_RETURN);
	export_constant2("bLongWeaponDamageReturn",SP_LONG_WEAPON_DAMAGE_RETURN);
	export_constant2("bWeaponComaEle",SP_WEAPON_COMA_ELE);
	export_constant2("bWeaponComaRace",SP_WEAPON_COMA_RACE);
	export_constant2("bAddEff2",SP_ADDEFF2);
	export_constant2("bBreakWeaponRate",SP_BREAK_WEAPON_RATE);
	export_constant2("bBreakArmorRate",SP_BREAK_ARMOR_RATE);
	export_constant2("bAddStealRate",SP_ADD_STEAL_RATE);
	export_constant2("bMagicDamageReturn",SP_MAGIC_DAMAGE_RETURN);
	export_constant2("bAllStats",SP_ALL_STATS);
	export_constant2("bAgiVit",SP_AGI_VIT);
	export_constant2("bAgiDexStr",SP_AGI_DEX_STR);
	export_constant2("bPerfectHide",SP_PERFECT_HIDE);
	export_constant2("bNoKnockback",SP_NO_KNOCKBACK);
	export_constant2("bClassChange",SP_CLASSCHANGE);
	export_constant2("bHPDrainValue",SP_HP_DRAIN_VALUE);
	export_constant2("bSPDrainValue",SP_SP_DRAIN_VALUE);
	export_constant2("bWeaponAtk",SP_WEAPON_ATK);
	export_constant2("bWeaponDamageRate",SP_WEAPON_DAMAGE_RATE);
	export_constant2("bDelayrate",SP_DELAYRATE);
	export_constant2("bHPDrainValueRace",SP_HP_DRAIN_VALUE_RACE);
	export_constant2("bSPDrainValueRace",SP_SP_DRAIN_VALUE_RACE);
	export_constant2("bIgnoreMdefRaceRate",SP_IGNORE_MDEF_RACE_RATE);
	export_constant2("bIgnoreDefRaceRate",SP_IGNORE_DEF_RACE_RATE);
	export_constant2("bSkillHeal2",SP_SKILL_HEAL2);
	export_constant2("bAddEffOnSkill",SP_ADDEFF_ONSKILL);
	export_constant2("bHealPower",SP_ADD_HEAL_RATE);
	export_constant2("bHealPower2",SP_ADD_HEAL2_RATE);

	export_constant2("bRestartFullRecover",SP_RESTART_FULL_RECOVER);
	export_constant2("bNoCastCancel",SP_NO_CASTCANCEL);
	export_constant2("bNoSizeFix",SP_NO_SIZEFIX);
	export_constant2("bNoMagicDamage",SP_NO_MAGIC_DAMAGE);
	export_constant2("bNoWeaponDamage",SP_NO_WEAPON_DAMAGE);
	export_constant2("bNoGemStone",SP_NO_GEMSTONE);
	export_constant2("bNoCastCancel2",SP_NO_CASTCANCEL2);
	export_constant2("bNoMiscDamage",SP_NO_MISC_DAMAGE);
	export_constant2("bUnbreakableWeapon",SP_UNBREAKABLE_WEAPON);
	export_constant2("bUnbreakableArmor",SP_UNBREAKABLE_ARMOR);
	export_constant2("bUnbreakableHelm",SP_UNBREAKABLE_HELM);
	export_constant2("bUnbreakableShield",SP_UNBREAKABLE_SHIELD);
	export_constant2("bLongAtkRate",SP_LONG_ATK_RATE);
	export_constant2("bCritAtkRate",SP_CRIT_ATK_RATE);
	export_constant2("bCriticalAddRace",SP_CRITICAL_ADDRACE);
	export_constant2("bNoRegen",SP_NO_REGEN);
	export_constant2("bAddEffWhenHit",SP_ADDEFF_WHENHIT);
	export_constant2("bAutoSpellWhenHit",SP_AUTOSPELL_WHENHIT);
	export_constant2("bSkillAtk",SP_SKILL_ATK);
	export_constant2("bUnstripable",SP_UNSTRIPABLE);
	export_constant2("bAutoSpellOnSkill",SP_AUTOSPELL_ONSKILL);
	export_constant2("bSPGainValue",SP_SP_GAIN_VALUE);
	export_constant2("bHPRegenRate",SP_HP_REGEN_RATE);
	export_constant2("bHPLossRate",SP_HP_LOSS_RATE);
	export_constant2("bAddRace2",SP_ADDRACE2);
	export_constant2("bHPGainValue",SP_HP_GAIN_VALUE);
	export_constant2("bSubSize",SP_SUBSIZE);
	export_constant2("bHPDrainValueClass",SP_HP_DRAIN_VALUE_CLASS);
	export_constant2("bAddItemHealRate",SP_ADD_ITEM_HEAL_RATE);
	export_constant2("bSPDrainValueClass",SP_SP_DRAIN_VALUE_CLASS);
	export_constant2("bExpAddRace",SP_EXP_ADDRACE);
	export_constant2("bSPGainRace",SP_SP_GAIN_RACE);
	export_constant2("bSubRace2",SP_SUBRACE2);
	export_constant2("bUnbreakableShoes",SP_UNBREAKABLE_SHOES);
	export_constant2("bUnstripableWeapon",SP_UNSTRIPABLE_WEAPON);
	export_constant2("bUnstripableArmor",SP_UNSTRIPABLE_ARMOR);
	export_constant2("bUnstripableHelm",SP_UNSTRIPABLE_HELM);
	export_constant2("bUnstripableShield",SP_UNSTRIPABLE_SHIELD);
	export_constant2("bIntravision",SP_INTRAVISION);
	export_constant2("bAddMonsterDropItemGroup",SP_ADD_MONSTER_DROP_ITEMGROUP);
	export_constant2("bSPLossRate",SP_SP_LOSS_RATE);
	export_constant2("bAddSkillBlow",SP_ADD_SKILL_BLOW);
	export_constant2("bSPVanishRate",SP_SP_VANISH_RATE);
	export_constant2("bMagicSPGainValue",SP_MAGIC_SP_GAIN_VALUE);
	export_constant2("bMagicHPGainValue",SP_MAGIC_HP_GAIN_VALUE);
	export_constant2("bAddMonsterIdDropItem",SP_ADD_MONSTER_ID_DROP_ITEM);
	export_constant2("bMatk",SP_EMATK);
	export_constant2("bComaClass",SP_COMA_CLASS);
	export_constant2("bComaRace",SP_COMA_RACE);
	export_constant2("bSkillUseSPrate",SP_SKILL_USE_SP_RATE);
	export_constant2("bSkillCooldown",SP_SKILL_COOLDOWN);
	export_constant2("bSkillFixedCast",SP_SKILL_FIXEDCAST);
	export_constant2("bSkillVariableCast",SP_SKILL_VARIABLECAST);
	export_constant2("bFixedCastrate",SP_FIXCASTRATE);
	export_constant2("bVariableCastrate",SP_VARCASTRATE);
	export_constant2("bSkillUseSP",SP_SKILL_USE_SP);
	export_constant2("bMagicAtkEle",SP_MAGIC_ATK_ELE);
	export_constant2("bFixedCast",SP_ADD_FIXEDCAST);
	export_constant2("bVariableCast",SP_ADD_VARIABLECAST);
	export_constant2("bSetDefRace",SP_SET_DEF_RACE);
	export_constant2("bSetMDefRace",SP_SET_MDEF_RACE);
	export_constant2("bHPVanishRate",SP_HP_VANISH_RATE);
	export_constant2("bIgnoreDefClass",SP_IGNORE_DEF_CLASS);
	export_constant2("bDefRatioAtkClass",SP_DEF_RATIO_ATK_CLASS);
	export_constant2("bAddClass",SP_ADDCLASS);
	export_constant2("bSubClass",SP_SUBCLASS);
	export_constant2("bMagicAddClass",SP_MAGIC_ADDCLASS);
	export_constant2("bWeaponComaClass",SP_WEAPON_COMA_CLASS);
	export_constant2("bIgnoreMdefClassRate",SP_IGNORE_MDEF_CLASS_RATE);
	export_constant2("bExpAddClass",SP_EXP_ADDCLASS);
	export_constant2("bAddClassDropItem",SP_ADD_CLASS_DROP_ITEM);
	export_constant2("bAddClassDropItemGroup",SP_ADD_CLASS_DROP_ITEMGROUP);
	export_constant2("bAddMaxWeight",SP_ADDMAXWEIGHT);
	export_constant2("bAddItemGroupHealRate",SP_ADD_ITEMGROUP_HEAL_RATE);
	export_constant2("bHPVanishRaceRate",SP_HP_VANISH_RACE_RATE);
	export_constant2("bSPVanishRaceRate",SP_SP_VANISH_RACE_RATE);
	export_constant2("bAbsorbDmgMaxHP",SP_ABSORB_DMG_MAXHP);
	export_constant2("bSubSkill",SP_SUB_SKILL);
	export_constant2("bSubDefEle",SP_SUBDEF_ELE);
	export_constant2("bStateNoRecoverRace",SP_STATE_NORECOVER_RACE);
	export_constant2("bCriticalLong",SP_CRITICAL_RANGEATK);
	export_constant2("bMagicAddRace2", SP_MAGIC_ADDRACE2);
	export_constant2("bIgnoreMdefRace2Rate", SP_IGNORE_MDEF_RACE2_RATE);
	export_constant2("bDropAddRace", SP_DROP_ADDRACE);
	export_constant2("bDropAddClass", SP_DROP_ADDCLASS);
	export_constant2("bNoMadoFuel", SP_NO_MADO_FUEL);
	export_constant2("bIgnoreDefClassRate", SP_IGNORE_DEF_CLASS_RATE);
	export_constant2("bRegenPercentHP", SP_REGEN_PERCENT_HP);
	export_constant2("bRegenPercentSP", SP_REGEN_PERCENT_SP);

	/* equip indices */
	export_constant(EQI_COMPOUND_ON);
	export_constant(EQI_HEAD_TOP);
	export_constant(EQI_ARMOR);
	export_constant(EQI_HAND_L);
	export_constant(EQI_HAND_R);
	export_constant(EQI_GARMENT);
	export_constant(EQI_SHOES);
	export_constant(EQI_ACC_L);
	export_constant(EQI_ACC_R);
	export_constant(EQI_HEAD_MID);
	export_constant(EQI_HEAD_LOW);
	export_constant(EQI_COSTUME_HEAD_LOW);
	export_constant(EQI_COSTUME_HEAD_MID);
	export_constant(EQI_COSTUME_HEAD_TOP);
	export_constant(EQI_COSTUME_GARMENT);
	export_constant(EQI_AMMO);
	export_constant(EQI_SHADOW_ARMOR );
	export_constant(EQI_SHADOW_WEAPON);
	export_constant(EQI_SHADOW_SHIELD);
	export_constant(EQI_SHADOW_SHOES);
	export_constant(EQI_SHADOW_ACC_R);
	export_constant(EQI_SHADOW_ACC_L);

	/* equip positions */
	export_constant(EQP_ACC_L);
	export_constant(EQP_ACC_R);
	export_constant(EQP_SHOES);
	export_constant(EQP_GARMENT);
	export_constant(EQP_HEAD_LOW);
	export_constant(EQP_HEAD_MID);
	export_constant(EQP_HEAD_TOP);
	export_constant(EQP_ARMOR);
	export_constant(EQP_HAND_L);
	export_constant(EQP_HAND_R);
	export_constant(EQP_COSTUME_HEAD_TOP);
	export_constant(EQP_COSTUME_HEAD_MID);
	export_constant(EQP_COSTUME_HEAD_LOW);
	export_constant(EQP_COSTUME_GARMENT);
	export_constant(EQP_AMMO);
	export_constant(EQP_SHADOW_ARMOR);
	export_constant(EQP_SHADOW_WEAPON);
	export_constant(EQP_SHADOW_SHIELD);
	export_constant(EQP_SHADOW_SHOES);
	export_constant(EQP_SHADOW_ACC_R);
	export_constant(EQP_SHADOW_ACC_L);
	export_constant(EQP_ACC_RL);
	export_constant(EQP_SHADOW_ACC_RL);

	/* looks */
	export_constant(LOOK_BASE);
	export_constant(LOOK_HAIR);
	export_constant(LOOK_WEAPON);
	export_constant(LOOK_HEAD_BOTTOM);
	export_constant(LOOK_HEAD_TOP);
	export_constant(LOOK_HEAD_MID);
	export_constant(LOOK_HAIR_COLOR);
	export_constant(LOOK_CLOTHES_COLOR);
	export_constant(LOOK_SHIELD);
	export_constant(LOOK_SHOES);
	export_constant(LOOK_BODY);
	export_constant(LOOK_RESET_COSTUMES);
	export_constant(LOOK_ROBE);
	export_constant(LOOK_BODY2);
	// TODO: check why we didnt have floor and enable it
	//export_constant(LOOK_FLOOR);

	// For backwards compatability - might be removed in the near future
	export_constant2("VAR_HEAD",LOOK_HAIR);
	export_constant2("VAR_WEAPON",LOOK_WEAPON);
	export_constant2("VAR_HEAD_TOP",LOOK_HEAD_TOP); // This one was actually pointing to LOOK_HEAD_BOTTOM until now, so we might be safe to remove them anyway(since we got no bug report until today)
	export_constant2("VAR_HEAD_MID",LOOK_HEAD_MID); // This one was actually pointing to LOOK_HEAD_TOP until now, so we might be safe to remove them anyway(since we got no bug report until today)
	export_constant2("VAR_HEAD_BOTTOM",LOOK_HEAD_BOTTOM);  // This one was actually pointing to LOOK_HEAD_MID until now, so we might be safe to remove them anyway(since we got no bug report until today)
	export_constant2("VAR_HEADPALETTE",LOOK_HAIR_COLOR);
	export_constant2("VAR_BODYPALETTE",LOOK_CLOTHES_COLOR);
	export_constant2("VAR_SHIELD",LOOK_SHIELD);
	export_constant2("VAR_SHOES",LOOK_SHOES);

	/* status changes */
	export_constant2("Eff_Stone",SC_STONE);
	export_constant2("Eff_Freeze",SC_FREEZE);
	export_constant2("Eff_Stun",SC_STUN);
	export_constant2("Eff_Sleep",SC_SLEEP);
	export_constant2("Eff_Poison",SC_POISON);
	export_constant2("Eff_Curse",SC_CURSE);
	export_constant2("Eff_Silence",SC_SILENCE);
	export_constant2("Eff_Confusion",SC_CONFUSION);
	export_constant2("Eff_Blind",SC_BLIND);
	export_constant2("Eff_Bleeding",SC_BLEEDING);
	export_constant2("Eff_DPoison",SC_DPOISON);
	export_constant2("Eff_Fear",SC_FEAR);
	export_constant2("Eff_Burning",SC_BURNING);
	export_constant2("Eff_Crystalize",SC_CRYSTALIZE);

	export_constant2("SC_ALL",SC_NONE);

	export_constant(SC_NONE);
	export_constant(SC_STONE);
	export_constant(SC_FREEZE);
	export_constant(SC_STUN);
	export_constant(SC_SLEEP);
	export_constant(SC_POISON);
	export_constant(SC_CURSE);
	export_constant(SC_SILENCE);
	export_constant(SC_CONFUSION);
	export_constant(SC_BLIND);
	export_constant(SC_BLEEDING);
	export_constant(SC_DPOISON);
	export_constant(SC_PROVOKE);
	export_constant(SC_ENDURE);
	export_constant(SC_TWOHANDQUICKEN);
	export_constant(SC_CONCENTRATE);
	export_constant(SC_HIDING);
	export_constant(SC_CLOAKING);
	export_constant(SC_ENCPOISON);
	export_constant(SC_POISONREACT);
	export_constant(SC_QUAGMIRE);
	export_constant(SC_ANGELUS);
	export_constant(SC_BLESSING);
	export_constant(SC_SIGNUMCRUCIS);
	export_constant(SC_INCREASEAGI);
	export_constant(SC_DECREASEAGI);
	export_constant(SC_SLOWPOISON);
	export_constant(SC_IMPOSITIO);
	export_constant(SC_SUFFRAGIUM);
	export_constant(SC_ASPERSIO);
	export_constant(SC_BENEDICTIO);
	export_constant(SC_KYRIE);
	export_constant(SC_MAGNIFICAT);
	export_constant(SC_GLORIA);
	export_constant(SC_AETERNA);
	export_constant(SC_ADRENALINE);
	export_constant(SC_WEAPONPERFECTION);
	export_constant(SC_OVERTHRUST);
	export_constant(SC_MAXIMIZEPOWER);
	export_constant(SC_TRICKDEAD);
	export_constant(SC_LOUD);
	export_constant(SC_ENERGYCOAT);
	export_constant(SC_BROKENARMOR);
	export_constant(SC_BROKENWEAPON);
	export_constant(SC_HALLUCINATION);
	export_constant(SC_WEIGHT50);
	export_constant(SC_WEIGHT90);
	export_constant(SC_ASPDPOTION0);
	export_constant(SC_ASPDPOTION1);
	export_constant(SC_ASPDPOTION2);
	export_constant(SC_ASPDPOTION3);
	export_constant(SC_SPEEDUP0);
	export_constant(SC_SPEEDUP1);
	export_constant(SC_ATKPOTION);
	export_constant(SC_MATKPOTION);
	export_constant(SC_WEDDING);
	export_constant(SC_SLOWDOWN);
	export_constant(SC_ANKLE);
	export_constant(SC_KEEPING);
	export_constant(SC_BARRIER);
	export_constant(SC_STRIPWEAPON);
	export_constant(SC_STRIPSHIELD);
	export_constant(SC_STRIPARMOR);
	export_constant(SC_STRIPHELM);
	export_constant(SC_CP_WEAPON);
	export_constant(SC_CP_SHIELD);
	export_constant(SC_CP_ARMOR);
	export_constant(SC_CP_HELM);
	export_constant(SC_AUTOGUARD);
	export_constant(SC_REFLECTSHIELD);
	export_constant(SC_SPLASHER);
	export_constant(SC_PROVIDENCE);
	export_constant(SC_DEFENDER);
	export_constant(SC_MAGICROD);
	export_constant(SC_SPELLBREAKER);
	export_constant(SC_AUTOSPELL);
	export_constant(SC_SIGHTTRASHER);
	export_constant(SC_AUTOBERSERK);
	export_constant(SC_SPEARQUICKEN);
	export_constant(SC_AUTOCOUNTER);
	export_constant(SC_SIGHT);
	export_constant(SC_SAFETYWALL);
	export_constant(SC_RUWACH);
	export_constant(SC_EXTREMITYFIST);
	export_constant(SC_EXPLOSIONSPIRITS);
	export_constant(SC_COMBO);
	export_constant(SC_BLADESTOP_WAIT);
	export_constant(SC_BLADESTOP);
	export_constant(SC_FIREWEAPON);
	export_constant(SC_WATERWEAPON);
	export_constant(SC_WINDWEAPON);
	export_constant(SC_EARTHWEAPON);
	export_constant(SC_VOLCANO);
	export_constant(SC_DELUGE);
	export_constant(SC_VIOLENTGALE);
	export_constant(SC_WATK_ELEMENT);
	export_constant(SC_ARMOR);
	export_constant(SC_ARMOR_ELEMENT_WATER);
	export_constant(SC_NOCHAT);
	export_constant(SC_BABY);
	export_constant(SC_AURABLADE);
	export_constant(SC_PARRYING);
	export_constant(SC_CONCENTRATION);
	export_constant(SC_TENSIONRELAX);
	export_constant(SC_BERSERK);
	export_constant(SC_FURY);
	export_constant(SC_GOSPEL);
	export_constant(SC_ASSUMPTIO);
	export_constant(SC_BASILICA);
	export_constant(SC_GUILDAURA);
	export_constant(SC_MAGICPOWER);
	export_constant(SC_EDP);
	export_constant(SC_TRUESIGHT);
	export_constant(SC_WINDWALK);
	export_constant(SC_MELTDOWN);
	export_constant(SC_CARTBOOST);
	export_constant(SC_CHASEWALK);
	export_constant(SC_REJECTSWORD);
	export_constant(SC_MARIONETTE);
	export_constant(SC_MARIONETTE2);
	export_constant(SC_CHANGEUNDEAD);
	export_constant(SC_JOINTBEAT);
	export_constant(SC_MINDBREAKER);
	export_constant(SC_MEMORIZE);
	export_constant(SC_FOGWALL);
	export_constant(SC_SPIDERWEB);
	export_constant(SC_DEVOTION);
	export_constant(SC_SACRIFICE);
	export_constant(SC_STEELBODY);
	export_constant(SC_ORCISH);
	export_constant(SC_READYSTORM);
	export_constant(SC_READYDOWN);
	export_constant(SC_READYTURN);
	export_constant(SC_READYCOUNTER);
	export_constant(SC_DODGE);
	export_constant(SC_RUN);
	export_constant(SC_SHADOWWEAPON);
	export_constant(SC_ADRENALINE2);
	export_constant(SC_GHOSTWEAPON);
	export_constant(SC_KAIZEL);
	export_constant(SC_KAAHI);
	export_constant(SC_KAUPE);
	export_constant(SC_ONEHAND);
	export_constant(SC_PRESERVE);
	export_constant(SC_BATTLEORDERS);
	export_constant(SC_REGENERATION);
	export_constant(SC_DOUBLECAST);
	export_constant(SC_GRAVITATION);
	export_constant(SC_MAXOVERTHRUST);
	export_constant(SC_LONGING);
	export_constant(SC_HERMODE);
	export_constant(SC_SHRINK);
	export_constant(SC_SIGHTBLASTER);
	export_constant(SC_WINKCHARM);
	export_constant(SC_CLOSECONFINE);
	export_constant(SC_CLOSECONFINE2);
	export_constant(SC_DANCING);
	export_constant(SC_ELEMENTALCHANGE);
	export_constant(SC_RICHMANKIM);
	export_constant(SC_ETERNALCHAOS);
	export_constant(SC_DRUMBATTLE);
	export_constant(SC_NIBELUNGEN);
	export_constant(SC_ROKISWEIL);
	export_constant(SC_INTOABYSS);
	export_constant(SC_SIEGFRIED);
	export_constant(SC_WHISTLE);
	export_constant(SC_ASSNCROS);
	export_constant(SC_POEMBRAGI);
	export_constant(SC_APPLEIDUN);
	export_constant(SC_MODECHANGE);
	export_constant(SC_HUMMING);
	export_constant(SC_DONTFORGETME);
	export_constant(SC_FORTUNE);
	export_constant(SC_SERVICE4U);
	export_constant(SC_STOP);
	export_constant(SC_SPURT);
	export_constant(SC_SPIRIT);
	export_constant(SC_COMA);
	export_constant(SC_INTRAVISION);
	export_constant(SC_INCALLSTATUS);
	export_constant(SC_INCSTR);
	export_constant(SC_INCAGI);
	export_constant(SC_INCVIT);
	export_constant(SC_INCINT);
	export_constant(SC_INCDEX);
	export_constant(SC_INCLUK);
	export_constant(SC_INCHIT);
	export_constant(SC_INCHITRATE);
	export_constant(SC_INCFLEE);
	export_constant(SC_INCFLEERATE);
	export_constant(SC_INCMHPRATE);
	export_constant(SC_INCMSPRATE);
	export_constant(SC_INCATKRATE);
	export_constant(SC_INCMATKRATE);
	export_constant(SC_INCDEFRATE);
	export_constant(SC_STRFOOD);
	export_constant(SC_AGIFOOD);
	export_constant(SC_VITFOOD);
	export_constant(SC_INTFOOD);
	export_constant(SC_DEXFOOD);
	export_constant(SC_LUKFOOD);
	export_constant(SC_HITFOOD);
	export_constant(SC_FLEEFOOD);
	export_constant(SC_BATKFOOD);
	export_constant(SC_WATKFOOD);
	export_constant(SC_MATKFOOD);
	export_constant(SC_SCRESIST);
	export_constant(SC_XMAS);
	export_constant(SC_WARM);
	export_constant(SC_SUN_COMFORT);
	export_constant(SC_MOON_COMFORT);
	export_constant(SC_STAR_COMFORT);
	export_constant(SC_FUSION);
	export_constant(SC_SKILLRATE_UP);
	export_constant(SC_SKE);
	export_constant(SC_KAITE);
	export_constant(SC_SWOO);
	export_constant(SC_SKA);
	export_constant(SC_EARTHSCROLL);
	export_constant(SC_MIRACLE);
	export_constant(SC_MADNESSCANCEL);
	export_constant(SC_ADJUSTMENT);
	export_constant(SC_INCREASING);
	export_constant(SC_GATLINGFEVER);
	export_constant(SC_TATAMIGAESHI);
	export_constant(SC_UTSUSEMI);
	export_constant(SC_BUNSINJYUTSU);
	export_constant(SC_KAENSIN);
	export_constant(SC_SUITON);
	export_constant(SC_NEN);
	export_constant(SC_KNOWLEDGE);
	export_constant(SC_SMA);
	export_constant(SC_FLING);
	export_constant(SC_AVOID);
	export_constant(SC_CHANGE);
	export_constant(SC_BLOODLUST);
	export_constant(SC_FLEET);
	export_constant(SC_SPEED);
	export_constant(SC_DEFENCE);
	export_constant(SC_INCASPDRATE);
	export_constant(SC_INCFLEE2);
	export_constant(SC_JAILED);
	export_constant(SC_ENCHANTARMS);
	export_constant(SC_MAGICALATTACK);
	export_constant(SC_ARMORCHANGE);
	export_constant(SC_CRITICALWOUND);
	export_constant(SC_MAGICMIRROR);
	export_constant(SC_SLOWCAST);
	export_constant(SC_SUMMER);
	export_constant(SC_EXPBOOST);
	export_constant(SC_ITEMBOOST);
	export_constant(SC_BOSSMAPINFO);
	export_constant(SC_LIFEINSURANCE);
	export_constant(SC_INCCRI);
	//export_constant(SC_INCDEF);
	//export_constant(SC_INCBASEATK);
	//export_constant(SC_FASTCAST);
	export_constant(SC_MDEF_RATE);
	//export_constant(SC_HPREGEN);
	export_constant(SC_INCHEALRATE);
	export_constant(SC_PNEUMA);
	export_constant(SC_AUTOTRADE);
	export_constant(SC_KSPROTECTED);
	export_constant(SC_ARMOR_RESIST);
	export_constant(SC_SPCOST_RATE);
	export_constant(SC_COMMONSC_RESIST);
	export_constant(SC_SEVENWIND);
	export_constant(SC_DEF_RATE);
	//export_constant(SC_SPREGEN);
	export_constant(SC_WALKSPEED);
	export_constant(SC_MERC_FLEEUP);
	export_constant(SC_MERC_ATKUP);
	export_constant(SC_MERC_HPUP);
	export_constant(SC_MERC_SPUP);
	export_constant(SC_MERC_HITUP);
	export_constant(SC_MERC_QUICKEN);
	export_constant(SC_REBIRTH);
	//export_constant(SC_SKILLCASTRATE);
	//export_constant(SC_DEFRATIOATK);
	//export_constant(SC_HPDRAIN);
	//export_constant(SC_SKILLATKBONUS);
	export_constant(SC_ITEMSCRIPT);
	export_constant(SC_S_LIFEPOTION);
	export_constant(SC_L_LIFEPOTION);
	export_constant(SC_JEXPBOOST);
	//export_constant(SC_IGNOREDEF);
	export_constant(SC_HELLPOWER);
	export_constant(SC_INVINCIBLE);
	export_constant(SC_INVINCIBLEOFF);
	export_constant(SC_MANU_ATK);
	export_constant(SC_MANU_DEF);
	export_constant(SC_SPL_ATK);
	export_constant(SC_SPL_DEF);
	export_constant(SC_MANU_MATK);
	export_constant(SC_SPL_MATK);
	export_constant(SC_FOOD_STR_CASH);
	export_constant(SC_FOOD_AGI_CASH);
	export_constant(SC_FOOD_VIT_CASH);
	export_constant(SC_FOOD_DEX_CASH);
	export_constant(SC_FOOD_INT_CASH);
	export_constant(SC_FOOD_LUK_CASH);
	export_constant(SC_FEAR);
	export_constant(SC_BURNING);
	export_constant(SC_FREEZING);
	export_constant(SC_ENCHANTBLADE);
	export_constant(SC_DEATHBOUND);
	export_constant(SC_MILLENNIUMSHIELD);
	export_constant(SC_CRUSHSTRIKE);
	export_constant(SC_REFRESH);
	export_constant(SC_REUSE_REFRESH);
	export_constant(SC_GIANTGROWTH);
	export_constant(SC_STONEHARDSKIN);
	export_constant(SC_VITALITYACTIVATION);
	export_constant(SC_STORMBLAST);
	export_constant(SC_FIGHTINGSPIRIT);
	export_constant(SC_ABUNDANCE);
	export_constant(SC_ADORAMUS);
	export_constant(SC_EPICLESIS);
	export_constant(SC_ORATIO);
	export_constant(SC_LAUDAAGNUS);
	export_constant(SC_LAUDARAMUS);
	export_constant(SC_RENOVATIO);
	export_constant(SC_EXPIATIO);
	export_constant(SC_DUPLELIGHT);
	export_constant(SC_SECRAMENT);
	export_constant(SC_WHITEIMPRISON);
	export_constant(SC_MARSHOFABYSS);
	export_constant(SC_RECOGNIZEDSPELL);
	export_constant(SC_STASIS);
	export_constant(SC_SPHERE_1);
	export_constant(SC_SPHERE_2);
	export_constant(SC_SPHERE_3);
	export_constant(SC_SPHERE_4);
	export_constant(SC_SPHERE_5);
	export_constant(SC_READING_SB);
	export_constant(SC_FREEZE_SP);
	export_constant(SC_FEARBREEZE);
	export_constant(SC_ELECTRICSHOCKER);
	export_constant(SC_WUGDASH);
	export_constant(SC_BITE);
	export_constant(SC_CAMOUFLAGE);
	export_constant(SC_ACCELERATION);
	export_constant(SC_HOVERING);
	export_constant(SC_SHAPESHIFT);
	export_constant(SC_INFRAREDSCAN);
	export_constant(SC_ANALYZE);
	export_constant(SC_MAGNETICFIELD);
	export_constant(SC_NEUTRALBARRIER);
	export_constant(SC_NEUTRALBARRIER_MASTER);
	export_constant(SC_STEALTHFIELD);
	export_constant(SC_STEALTHFIELD_MASTER);
	export_constant(SC_OVERHEAT);
	export_constant(SC_OVERHEAT_LIMITPOINT);
	export_constant(SC_VENOMIMPRESS);
	export_constant(SC_POISONINGWEAPON);
	export_constant(SC_WEAPONBLOCKING);
	export_constant(SC_CLOAKINGEXCEED);
	export_constant(SC_HALLUCINATIONWALK);
	export_constant(SC_HALLUCINATIONWALK_POSTDELAY);
	export_constant(SC_ROLLINGCUTTER);
	export_constant(SC_TOXIN);
	export_constant(SC_PARALYSE);
	export_constant(SC_VENOMBLEED);
	export_constant(SC_MAGICMUSHROOM);
	export_constant(SC_DEATHHURT);
	export_constant(SC_PYREXIA);
	export_constant(SC_OBLIVIONCURSE);
	export_constant(SC_LEECHESEND);
	export_constant(SC_REFLECTDAMAGE);
	export_constant(SC_FORCEOFVANGUARD);
	export_constant(SC_SHIELDSPELL_DEF);
	export_constant(SC_SHIELDSPELL_MDEF);
	export_constant(SC_SHIELDSPELL_REF);
	export_constant(SC_EXEEDBREAK);
	export_constant(SC_PRESTIGE);
	export_constant(SC_BANDING);
	export_constant(SC_BANDING_DEFENCE);
	export_constant(SC_EARTHDRIVE);
	export_constant(SC_INSPIRATION);
	export_constant(SC_SPELLFIST);
	export_constant(SC_CRYSTALIZE);
	export_constant(SC_STRIKING);
	export_constant(SC_WARMER);
	export_constant(SC_VACUUM_EXTREME);
	export_constant(SC_PROPERTYWALK);
	export_constant(SC_SWINGDANCE);
	export_constant(SC_SYMPHONYOFLOVER);
	export_constant(SC_MOONLITSERENADE);
	export_constant(SC_RUSHWINDMILL);
	export_constant(SC_ECHOSONG);
	export_constant(SC_HARMONIZE);
	export_constant(SC_VOICEOFSIREN);
	export_constant(SC_DEEPSLEEP);
	export_constant(SC_SIRCLEOFNATURE);
	export_constant(SC_GLOOMYDAY);
	export_constant(SC_GLOOMYDAY_SK);
	export_constant(SC_SONGOFMANA);
	export_constant(SC_DANCEWITHWUG);
	export_constant(SC_SATURDAYNIGHTFEVER);
	export_constant(SC_LERADSDEW);
	export_constant(SC_MELODYOFSINK);
	export_constant(SC_BEYONDOFWARCRY);
	export_constant(SC_UNLIMITEDHUMMINGVOICE);
	export_constant(SC_SITDOWN_FORCE);
	export_constant(SC_NETHERWORLD);
	export_constant(SC_CRESCENTELBOW);
	export_constant(SC_CURSEDCIRCLE_ATKER);
	export_constant(SC_CURSEDCIRCLE_TARGET);
	export_constant(SC_LIGHTNINGWALK);
	export_constant(SC_RAISINGDRAGON);
	export_constant(SC_GT_ENERGYGAIN);
	export_constant(SC_GT_CHANGE);
	export_constant(SC_GT_REVITALIZE);
	export_constant(SC_GN_CARTBOOST);
	export_constant(SC_THORNSTRAP);
	export_constant(SC_BLOODSUCKER);
	export_constant(SC_SMOKEPOWDER);
	export_constant(SC_TEARGAS);
	export_constant(SC_MANDRAGORA);
	export_constant(SC_STOMACHACHE);
	export_constant(SC_MYSTERIOUS_POWDER);
	export_constant(SC_MELON_BOMB);
	export_constant(SC_BANANA_BOMB);
	export_constant(SC_BANANA_BOMB_SITDOWN);
	export_constant(SC_SAVAGE_STEAK);
	export_constant(SC_COCKTAIL_WARG_BLOOD);
	export_constant(SC_MINOR_BBQ);
	export_constant(SC_SIROMA_ICE_TEA);
	export_constant(SC_DROCERA_HERB_STEAMED);
	export_constant(SC_PUTTI_TAILS_NOODLES);
	export_constant(SC_BOOST500);
	export_constant(SC_FULL_SWING_K);
	export_constant(SC_MANA_PLUS);
	export_constant(SC_MUSTLE_M);
	export_constant(SC_LIFE_FORCE_F);
	export_constant(SC_EXTRACT_WHITE_POTION_Z);
	export_constant(SC_VITATA_500);
	export_constant(SC_EXTRACT_SALAMINE_JUICE);
	export_constant(SC__REPRODUCE);
	export_constant(SC__AUTOSHADOWSPELL);
	export_constant(SC__SHADOWFORM);
	export_constant(SC__BODYPAINT);
	export_constant(SC__INVISIBILITY);
	export_constant(SC__DEADLYINFECT);
	export_constant(SC__ENERVATION);
	export_constant(SC__GROOMY);
	export_constant(SC__IGNORANCE);
	export_constant(SC__LAZINESS);
	export_constant(SC__UNLUCKY);
	export_constant(SC__WEAKNESS);
	export_constant(SC__STRIPACCESSORY);
	export_constant(SC__MANHOLE);
	export_constant(SC__BLOODYLUST);
	export_constant(SC_CIRCLE_OF_FIRE);
	export_constant(SC_CIRCLE_OF_FIRE_OPTION);
	export_constant(SC_FIRE_CLOAK);
	export_constant(SC_FIRE_CLOAK_OPTION);
	export_constant(SC_WATER_SCREEN);
	export_constant(SC_WATER_SCREEN_OPTION);
	export_constant(SC_WATER_DROP);
	export_constant(SC_WATER_DROP_OPTION);
	export_constant(SC_WATER_BARRIER);
	export_constant(SC_WIND_STEP);
	export_constant(SC_WIND_STEP_OPTION);
	export_constant(SC_WIND_CURTAIN);
	export_constant(SC_WIND_CURTAIN_OPTION);
	export_constant(SC_ZEPHYR);
	export_constant(SC_SOLID_SKIN);
	export_constant(SC_SOLID_SKIN_OPTION);
	export_constant(SC_STONE_SHIELD);
	export_constant(SC_STONE_SHIELD_OPTION);
	export_constant(SC_POWER_OF_GAIA);
	export_constant(SC_PYROTECHNIC);
	export_constant(SC_PYROTECHNIC_OPTION);
	export_constant(SC_HEATER);
	export_constant(SC_HEATER_OPTION);
	export_constant(SC_TROPIC);
	export_constant(SC_TROPIC_OPTION);
	export_constant(SC_AQUAPLAY);
	export_constant(SC_AQUAPLAY_OPTION);
	export_constant(SC_COOLER);
	export_constant(SC_COOLER_OPTION);
	export_constant(SC_CHILLY_AIR);
	export_constant(SC_CHILLY_AIR_OPTION);
	export_constant(SC_GUST);
	export_constant(SC_GUST_OPTION);
	export_constant(SC_BLAST);
	export_constant(SC_BLAST_OPTION);
	export_constant(SC_WILD_STORM);
	export_constant(SC_WILD_STORM_OPTION);
	export_constant(SC_PETROLOGY);
	export_constant(SC_PETROLOGY_OPTION);
	export_constant(SC_CURSED_SOIL);
	export_constant(SC_CURSED_SOIL_OPTION);
	export_constant(SC_UPHEAVAL);
	export_constant(SC_UPHEAVAL_OPTION);
	export_constant(SC_TIDAL_WEAPON);
	export_constant(SC_TIDAL_WEAPON_OPTION);
	export_constant(SC_ROCK_CRUSHER);
	export_constant(SC_ROCK_CRUSHER_ATK);
	export_constant(SC_LEADERSHIP);
	export_constant(SC_GLORYWOUNDS);
	export_constant(SC_SOULCOLD);
	export_constant(SC_HAWKEYES);
	export_constant(SC_ODINS_POWER);
	export_constant(SC_RAID);
	export_constant(SC_FIRE_INSIGNIA);
	export_constant(SC_WATER_INSIGNIA);
	export_constant(SC_WIND_INSIGNIA);
	export_constant(SC_EARTH_INSIGNIA);
	export_constant(SC_PUSH_CART);
	export_constant(SC_SPELLBOOK1);
	export_constant(SC_SPELLBOOK2);
	export_constant(SC_SPELLBOOK3);
	export_constant(SC_SPELLBOOK4);
	export_constant(SC_SPELLBOOK5);
	export_constant(SC_SPELLBOOK6);
	export_constant(SC_MAXSPELLBOOK);
	export_constant(SC_INCMHP);
	export_constant(SC_INCMSP);
	export_constant(SC_PARTYFLEE);
	export_constant(SC_MEIKYOUSISUI);
	export_constant(SC_JYUMONJIKIRI);
	export_constant(SC_KYOUGAKU);
	export_constant(SC_IZAYOI);
	export_constant(SC_ZENKAI);
	export_constant(SC_KAGEHUMI);
	export_constant(SC_KYOMU);
	export_constant(SC_KAGEMUSYA);
	export_constant(SC_ZANGETSU);
	export_constant(SC_GENSOU);
	export_constant(SC_AKAITSUKI);
	export_constant(SC_STYLE_CHANGE);
	export_constant(SC_TINDER_BREAKER);
	export_constant(SC_TINDER_BREAKER2);
	export_constant(SC_CBC);
	export_constant(SC_EQC);
	export_constant(SC_GOLDENE_FERSE);
	export_constant(SC_ANGRIFFS_MODUS);
	export_constant(SC_OVERED_BOOST);
	export_constant(SC_LIGHT_OF_REGENE);
	export_constant(SC_ASH);
	export_constant(SC_GRANITIC_ARMOR);
	export_constant(SC_MAGMA_FLOW);
	export_constant(SC_PYROCLASTIC);
	export_constant(SC_PARALYSIS);
	export_constant(SC_PAIN_KILLER);
	export_constant(SC_HANBOK);
	export_constant(SC_DEFSET);
	export_constant(SC_MDEFSET);
	export_constant(SC_DARKCROW);
	export_constant(SC_FULL_THROTTLE);
	export_constant(SC_REBOUND);
	export_constant(SC_UNLIMIT);
	export_constant(SC_KINGS_GRACE);
	export_constant(SC_TELEKINESIS_INTENSE);
	export_constant(SC_OFFERTORIUM);
	export_constant(SC_FRIGG_SONG);
	export_constant(SC_MONSTER_TRANSFORM);
	export_constant(SC_ANGEL_PROTECT);
	export_constant(SC_ILLUSIONDOPING);
	export_constant(SC_FLASHCOMBO);
	export_constant(SC_MOONSTAR);
	export_constant(SC_SUPER_STAR);
	export_constant(SC_HEAT_BARREL);
	export_constant(SC_HEAT_BARREL_AFTER);
	export_constant(SC_P_ALTER);
	export_constant(SC_E_CHAIN);
	export_constant(SC_C_MARKER);
	export_constant(SC_ANTI_M_BLAST);
	export_constant(SC_B_TRAP);
	export_constant(SC_H_MINE);
	export_constant(SC_QD_SHOT_READY);
	export_constant(SC_MTF_ASPD);
	export_constant(SC_MTF_RANGEATK);
	export_constant(SC_MTF_MATK);
	export_constant(SC_MTF_MLEATKED);
	export_constant(SC_MTF_CRIDAMAGE);
	export_constant(SC_OKTOBERFEST);
	export_constant(SC_STRANGELIGHTS);
	export_constant(SC_DECORATION_OF_MUSIC);
	export_constant(SC_QUEST_BUFF1);
	export_constant(SC_QUEST_BUFF2);
	export_constant(SC_QUEST_BUFF3);
	export_constant(SC_ALL_RIDING);
	export_constant(SC_TEARGAS_SOB);
	export_constant(SC__FEINTBOMB);
	export_constant(SC__CHAOS);
	export_constant(SC_CHASEWALK2);
	export_constant(SC_VACUUM_EXTREME_POSTDELAY);
	export_constant(SC_MTF_ASPD2);
	export_constant(SC_MTF_RANGEATK2);
	export_constant(SC_MTF_MATK2);
	export_constant(SC_2011RWC_SCROLL);
	export_constant(SC_JP_EVENT04);
	export_constant(SC_MTF_MHP);
	export_constant(SC_MTF_MSP);
	export_constant(SC_MTF_PUMPKIN);
	export_constant(SC_MTF_HITFLEE);
	export_constant(SC_CRIFOOD);
	export_constant(SC_ATTHASTE_CASH);
	export_constant(SC_REUSE_LIMIT_A);
	export_constant(SC_REUSE_LIMIT_B);
	export_constant(SC_REUSE_LIMIT_C);
	export_constant(SC_REUSE_LIMIT_D);
	export_constant(SC_REUSE_LIMIT_E);
	export_constant(SC_REUSE_LIMIT_F);
	export_constant(SC_REUSE_LIMIT_G);
	export_constant(SC_REUSE_LIMIT_H);
	export_constant(SC_REUSE_LIMIT_MTF);
	export_constant(SC_REUSE_LIMIT_ASPD_POTION);
	export_constant(SC_REUSE_MILLENNIUMSHIELD);
	export_constant(SC_REUSE_CRUSHSTRIKE);
	export_constant(SC_REUSE_STORMBLAST);
	export_constant(SC_ALL_RIDING_REUSE_LIMIT);
	export_constant(SC_REUSE_LIMIT_ECL);
	export_constant(SC_REUSE_LIMIT_RECALL);
	export_constant(SC_PROMOTE_HEALTH_RESERCH);
	export_constant(SC_ENERGY_DRINK_RESERCH);
	export_constant(SC_NORECOVER_STATE);
	export_constant(SC_SUHIDE);
	export_constant(SC_SU_STOOP);
	export_constant(SC_SPRITEMABLE);
	export_constant(SC_CATNIPPOWDER);
	export_constant(SC_SV_ROOTTWIST);
	export_constant(SC_BITESCAR);
	export_constant(SC_ARCLOUSEDASH);
	export_constant(SC_TUNAPARTY);
	export_constant(SC_SHRIMP);
	export_constant(SC_FRESHSHRIMP);
	export_constant(SC_ACTIVE_MONSTER_TRANSFORM);
	export_constant(SC_CLOUD_KILL);
	export_constant(SC_LJOSALFAR);
	export_constant(SC_MERMAID_LONGING);
	export_constant(SC_HAT_EFFECT);
	export_constant(SC_FLOWERSMOKE);
	export_constant(SC_FSTONE);
	export_constant(SC_HAPPINESS_STAR);
	export_constant(SC_MAPLE_FALLS);
	export_constant(SC_TIME_ACCESSORY);
	export_constant(SC_MAGICAL_FEATHER);
	export_constant(SC_GVG_GIANT);
	export_constant(SC_GVG_GOLEM);
	export_constant(SC_GVG_STUN);
	export_constant(SC_GVG_STONE);
	export_constant(SC_GVG_FREEZ);
	export_constant(SC_GVG_SLEEP);
	export_constant(SC_GVG_CURSE);
	export_constant(SC_GVG_SILENCE);
	export_constant(SC_GVG_BLIND);
	export_constant(SC_CLAN_INFO);
	export_constant(SC_SWORDCLAN);
	export_constant(SC_ARCWANDCLAN);
	export_constant(SC_GOLDENMACECLAN);
	export_constant(SC_CROSSBOWCLAN);
	export_constant(SC_JUMPINGCLAN);
	export_constant(SC_GEFFEN_MAGIC1);
	export_constant(SC_GEFFEN_MAGIC2);
	export_constant(SC_GEFFEN_MAGIC3);
	export_constant(SC_MAXPAIN);
	export_constant(SC_ARMOR_ELEMENT_EARTH);
	export_constant(SC_ARMOR_ELEMENT_FIRE);
	export_constant(SC_ARMOR_ELEMENT_WIND);
	export_constant(SC_DAILYSENDMAILCNT);
	export_constant(SC_DORAM_BUF_01);
	export_constant(SC_DORAM_BUF_02);
	export_constant(SC_HISS);
	export_constant(SC_NYANGGRASS);
	export_constant(SC_GROOMING);
	export_constant(SC_SHRIMPBLESSING);
	export_constant(SC_CHATTERING);
	export_constant(SC_DORAM_WALKSPEED);
	export_constant(SC_DORAM_MATK);
	export_constant(SC_DORAM_FLEE2);
	export_constant(SC_DORAM_SVSP);
#ifdef RENEWAL
	export_constant(SC_EXTREMITYFIST2);
#endif

	/* status icons */
	export_constant(SI_BLANK);
	export_constant(SI_PROVOKE);
	export_constant(SI_ENDURE);
	export_constant(SI_TWOHANDQUICKEN);
	export_constant(SI_CONCENTRATE);
	export_constant(SI_HIDING);
	export_constant(SI_CLOAKING);
	export_constant(SI_ENCPOISON);
	export_constant(SI_POISONREACT);
	export_constant(SI_QUAGMIRE);
	export_constant(SI_ANGELUS);
	export_constant(SI_BLESSING);
	export_constant(SI_SIGNUMCRUCIS);
	export_constant(SI_INCREASEAGI);
	export_constant(SI_DECREASEAGI);
	export_constant(SI_SLOWPOISON);
	export_constant(SI_IMPOSITIO);
	export_constant(SI_SUFFRAGIUM);
	export_constant(SI_ASPERSIO);
	export_constant(SI_BENEDICTIO);
	export_constant(SI_KYRIE);
	export_constant(SI_MAGNIFICAT);
	export_constant(SI_GLORIA);
	export_constant(SI_AETERNA);
	export_constant(SI_ADRENALINE);
	export_constant(SI_WEAPONPERFECTION);
	export_constant(SI_OVERTHRUST);
	export_constant(SI_MAXIMIZEPOWER);
	export_constant(SI_RIDING);
	export_constant(SI_FALCON);
	export_constant(SI_TRICKDEAD);
	export_constant(SI_LOUD);
	export_constant(SI_ENERGYCOAT);
	export_constant(SI_BROKENARMOR);
	export_constant(SI_BROKENWEAPON);
	export_constant(SI_HALLUCINATION);
	export_constant(SI_WEIGHT50);
	export_constant(SI_WEIGHT90);
	export_constant(SI_ASPDPOTION0);
	export_constant(SI_ASPDPOTION1);
	export_constant(SI_ASPDPOTION2);
	export_constant(SI_ASPDPOTIONINFINITY);
	export_constant(SI_SPEEDPOTION1);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MOVHASTE_INFINITY);
	export_constant(SI_AUTOCOUNTER);
	export_constant(SI_SPLASHER);
	export_constant(SI_ANKLESNARE);
	export_constant(SI_ACTIONDELAY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_NOACTION);
	// disabled source side, does not make sense to export it
	//export_constant(SI_IMPOSSIBLEPICKUP);
	export_constant(SI_BARRIER);
	export_constant(SI_STRIPWEAPON);
	export_constant(SI_STRIPSHIELD);
	export_constant(SI_STRIPARMOR);
	export_constant(SI_STRIPHELM);
	export_constant(SI_CP_WEAPON);
	export_constant(SI_CP_SHIELD);
	export_constant(SI_CP_ARMOR);
	export_constant(SI_CP_HELM);
	export_constant(SI_AUTOGUARD);
	export_constant(SI_REFLECTSHIELD);
	export_constant(SI_DEVOTION);
	export_constant(SI_PROVIDENCE);
	export_constant(SI_DEFENDER);
	export_constant(SI_MAGICROD);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WEAPONPROPERTY);
	export_constant(SI_AUTOSPELL);
	// disabled source side, does not make sense to export it
	//export_constant(SI_SPECIALZONE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MASK);
	export_constant(SI_SPEARQUICKEN);
	export_constant(SI_BDPLAYING);
	export_constant(SI_WHISTLE);
	export_constant(SI_ASSASSINCROSS);
	export_constant(SI_POEMBRAGI);
	export_constant(SI_APPLEIDUN);
	export_constant(SI_HUMMING);
	export_constant(SI_DONTFORGETME);
	export_constant(SI_FORTUNEKISS);
	export_constant(SI_SERVICEFORYOU);
	export_constant(SI_RICHMANKIM);
	export_constant(SI_ETERNALCHAOS);
	export_constant(SI_DRUMBATTLEFIELD);
	export_constant(SI_RINGNIBELUNGEN);
	export_constant(SI_ROKISWEIL);
	export_constant(SI_INTOABYSS);
	export_constant(SI_SIEGFRIED);
	export_constant(SI_BLADESTOP);
	export_constant(SI_EXPLOSIONSPIRITS);
	export_constant(SI_STEELBODY);
	export_constant(SI_EXTREMITYFIST);
	// disabled source side, does not make sense to export it
	//export_constant(SI_COMBOATTACK);
	export_constant(SI_FIREWEAPON);
	export_constant(SI_WATERWEAPON);
	export_constant(SI_WINDWEAPON);
	export_constant(SI_EARTHWEAPON);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MAGICATTACK);
	export_constant(SI_STOP);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WEAPONBRAKER);
	export_constant(SI_UNDEAD);
	// disabled source side, does not make sense to export it
	//export_constant(SI_POWERUP);
	// disabled source side, does not make sense to export it
	//export_constant(SI_AGIUP);
	// disabled source side, does not make sense to export it
	//export_constant(SI_SIEGEMODE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_INVISIBLE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_STATUSONE);
	export_constant(SI_AURABLADE);
	export_constant(SI_PARRYING);
	export_constant(SI_CONCENTRATION);
	export_constant(SI_TENSIONRELAX);
	export_constant(SI_BERSERK);
	// disabled source side, does not make sense to export it
	//export_constant(SI_SACRIFICE);
	export_constant(SI_GOSPEL);
	export_constant(SI_ASSUMPTIO);
	export_constant(SI_BASILICA);
	export_constant(SI_LANDENDOW);
	export_constant(SI_MAGICPOWER);
	export_constant(SI_EDP);
	export_constant(SI_TRUESIGHT);
	export_constant(SI_WINDWALK);
	export_constant(SI_MELTDOWN);
	export_constant(SI_CARTBOOST);
	export_constant(SI_CHASEWALK);
	export_constant(SI_REJECTSWORD);
	export_constant(SI_MARIONETTE);
	export_constant(SI_MARIONETTE2);
	export_constant(SI_MOONLIT);
	export_constant(SI_BLEEDING);
	export_constant(SI_JOINTBEAT);
	export_constant(SI_MINDBREAKER);
	export_constant(SI_MEMORIZE);
	export_constant(SI_FOGWALL);
	export_constant(SI_SPIDERWEB);
	export_constant(SI_BABY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_SUB_WEAPONPROPERTY);
	export_constant(SI_AUTOBERSERK);
	export_constant(SI_RUN);
	export_constant(SI_BUMP);
	export_constant(SI_READYSTORM);
	// disabled source side, does not make sense to export it
	//export_constant(SI_STORMKICK_READY);
	export_constant(SI_READYDOWN);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DOWNKICK_READY);
	export_constant(SI_READYTURN);
	// disabled source side, does not make sense to export it
	//export_constant(SI_TURNKICK_READY);
	export_constant(SI_READYCOUNTER);
	// disabled source side, does not make sense to export it
	//export_constant(SI_COUNTER_READY);
	export_constant(SI_DODGE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DODGE_READY);
	export_constant(SI_SPURT);
	export_constant(SI_SHADOWWEAPON);
	export_constant(SI_ADRENALINE2);
	export_constant(SI_GHOSTWEAPON);
	export_constant(SI_SPIRIT);
	export_constant(SI_PLUSATTACKPOWER);
	export_constant(SI_PLUSMAGICPOWER);
	export_constant(SI_DEVIL);
	export_constant(SI_KAITE);
	export_constant(SI_SWOO);
	// disabled source side, does not make sense to export it
	//export_constant(SI_STAR2);
	export_constant(SI_KAIZEL);
	export_constant(SI_KAAHI);
	export_constant(SI_KAUPE);
	export_constant(SI_SMA);
	export_constant(SI_NIGHT);
	export_constant(SI_ONEHAND);
	// disabled source side, does not make sense to export it
	//export_constant(SI_FRIEND);
	// disabled source side, does not make sense to export it
	//export_constant(SI_FRIENDUP);
	// disabled source side, does not make sense to export it
	//export_constant(SI_SG_WARM);
	export_constant(SI_WARM);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EMOTION);
	export_constant(SI_SUN_COMFORT);
	export_constant(SI_MOON_COMFORT);
	export_constant(SI_STAR_COMFORT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EXPUP);
	export_constant(SI_GDSKILL_BATTLEORDER);
	export_constant(SI_GDSKILL_REGENERATION);
	// disabled source side, does not make sense to export it
	//export_constant(SI_GDSKILL_POSTDELAY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_RESISTHANDICAP);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MAXHPPERCENT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MAXSPPERCENT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DEFENCE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_SLOWDOWN);
	export_constant(SI_PRESERVE);
	export_constant(SI_CHASEWALK2);
	// disabled source side, does not make sense to export it
	//export_constant(SI_NOT_EXTREMITYFIST);
	export_constant(SI_INTRAVISION);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MOVESLOW_POTION);
	export_constant(SI_DOUBLECAST);
	export_constant(SI_GRAVITATION);
	export_constant(SI_MAXOVERTHRUST);
	export_constant(SI_LONGING);
	export_constant(SI_HERMODE);
	export_constant(SI_TAROT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_HLIF_AVOID);
	// disabled source side, does not make sense to export it
	//export_constant(SI_HFLI_FLEET);
	// disabled source side, does not make sense to export it
	//export_constant(SI_HFLI_SPEED);
	// disabled source side, does not make sense to export it
	//export_constant(SI_HLIF_CHANGE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_HAMI_BLOODLUST);
	export_constant(SI_SHRINK);
	export_constant(SI_SIGHTBLASTER);
	export_constant(SI_WINKCHARM);
	export_constant(SI_CLOSECONFINE);
	export_constant(SI_CLOSECONFINE2);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DISABLEMOVE);
	export_constant(SI_MADNESSCANCEL);
	export_constant(SI_GATLINGFEVER);
	export_constant(SI_EARTHSCROLL);
	export_constant(SI_UTSUSEMI);
	export_constant(SI_BUNSINJYUTSU);
	export_constant(SI_NEN);
	export_constant(SI_ADJUSTMENT);
	export_constant(SI_ACCURACY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_NJ_SUITON);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PET);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MENTAL);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EXPMEMORY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PERFORMANCE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_GAIN);
	// disabled source side, does not make sense to export it
	//export_constant(SI_GRIFFON);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DRIFT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WALLSHIFT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_REINCARNATION);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PATTACK);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PSPEED);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PDEFENSE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PCRITICAL);
	// disabled source side, does not make sense to export it
	//export_constant(SI_RANKING);
	// disabled source side, does not make sense to export it
	//export_constant(SI_PTRIPLE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DENERGY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WAVE1);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WAVE2);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WAVE3);
	// disabled source side, does not make sense to export it
	//export_constant(SI_WAVE4);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DAURA);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DFREEZER);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DPUNISH);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DBARRIER);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DWARNING);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MOUSEWHEEL);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DGAUGE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DACCEL);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DBLOCK);
	export_constant(SI_FOODSTR);
	export_constant(SI_FOODAGI);
	export_constant(SI_FOODVIT);
	export_constant(SI_FOODDEX);
	export_constant(SI_FOODINT);
	export_constant(SI_FOODLUK);
	export_constant(SI_FOODFLEE);
	export_constant(SI_FOODHIT);
	export_constant(SI_FOODCRI);
	export_constant(SI_EXPBOOST);
	export_constant(SI_LIFEINSURANCE);
	export_constant(SI_ITEMBOOST);
	export_constant(SI_BOSSMAPINFO);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_ENERGY);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_FIRSTSLOT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_HEADDEF);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_SPACE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_TRANSFORM);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_ITEMREBUILD);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_ILLUSION);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_DARKPOWER);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_EARPLUG);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_CONTRACT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_BLACK);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_MAGICCART);
	// disabled source side, does not make sense to export it
	//export_constant(SI_CRYSTAL);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_REBUILD);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_EDARKNESS);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_EGUARDIAN);
	// disabled source side, does not make sense to export it
	//export_constant(SI_DA_TIMEOUT);
	export_constant(SI_FOOD_STR_CASH);
	export_constant(SI_FOOD_AGI_CASH);
	export_constant(SI_FOOD_VIT_CASH);
	export_constant(SI_FOOD_DEX_CASH);
	export_constant(SI_FOOD_INT_CASH);
	export_constant(SI_FOOD_LUK_CASH);
	export_constant(SI_MERC_FLEEUP);
	export_constant(SI_MERC_ATKUP);
	export_constant(SI_MERC_HPUP);
	export_constant(SI_MERC_SPUP);
	export_constant(SI_MERC_HITUP);
	export_constant(SI_SLOWCAST);
	// disabled source side, does not make sense to export it
	//export_constant(SI_MAGICMIRROR);
	// disabled source side, does not make sense to export it
	//export_constant(SI_STONESKIN);
	// disabled source side, does not make sense to export it
	//export_constant(SI_ANTIMAGIC);
	export_constant(SI_CRITICALWOUND);
	// disabled source side, does not make sense to export it
	//export_constant(SI_NPC_DEFENDER);
	// disabled source side, does not make sense to export it
	//export_constant(SI_NOACTION_WAIT);
	export_constant(SI_MOVHASTE_HORSE);
	export_constant(SI_DEF_RATE);
	export_constant(SI_MDEF_RATE);
	export_constant(SI_INCHEALRATE);
	export_constant(SI_S_LIFEPOTION);
	export_constant(SI_L_LIFEPOTION);
	export_constant(SI_INCCRI);
	export_constant(SI_PLUSAVOIDVALUE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_ATKER_ASPD);
	// disabled source side, does not make sense to export it
	//export_constant(SI_TARGET_ASPD);
	// disabled source side, does not make sense to export it
	//export_constant(SI_ATKER_MOVESPEED);
	export_constant(SI_ATKER_BLOOD);
	export_constant(SI_TARGET_BLOOD);
	export_constant(SI_ARMOR_PROPERTY);
	export_constant(SI_REUSE_LIMIT_A);
	export_constant(SI_HELLPOWER);
	export_constant(SI_STEAMPACK);
	export_constant(SI_REUSE_LIMIT_B);
	export_constant(SI_REUSE_LIMIT_C);
	export_constant(SI_REUSE_LIMIT_D);
	export_constant(SI_REUSE_LIMIT_E);
	export_constant(SI_REUSE_LIMIT_F);
	export_constant(SI_INVINCIBLE);
	export_constant(SI_CASH_PLUSONLYJOBEXP);
	export_constant(SI_PARTYFLEE);
	export_constant(SI_ANGEL_PROTECT);
	export_constant(SI_ENDURE_MDEF);
	export_constant(SI_ENCHANTBLADE);
	export_constant(SI_DEATHBOUND);
	export_constant(SI_REFRESH);
	export_constant(SI_GIANTGROWTH);
	export_constant(SI_STONEHARDSKIN);
	export_constant(SI_VITALITYACTIVATION);
	export_constant(SI_FIGHTINGSPIRIT);
	export_constant(SI_ABUNDANCE);
	export_constant(SI_REUSE_MILLENNIUMSHIELD);
	export_constant(SI_REUSE_CRUSHSTRIKE);
	export_constant(SI_REUSE_REFRESH);
	export_constant(SI_REUSE_STORMBLAST);
	export_constant(SI_VENOMIMPRESS);
	export_constant(SI_EPICLESIS);
	export_constant(SI_ORATIO);
	export_constant(SI_LAUDAAGNUS);
	export_constant(SI_LAUDARAMUS);
	export_constant(SI_CLOAKINGEXCEED);
	export_constant(SI_HALLUCINATIONWALK);
	export_constant(SI_HALLUCINATIONWALK_POSTDELAY);
	export_constant(SI_RENOVATIO);
	export_constant(SI_WEAPONBLOCKING);
	export_constant(SI_WEAPONBLOCKING_POSTDELAY);
	export_constant(SI_ROLLINGCUTTER);
	export_constant(SI_EXPIATIO);
	export_constant(SI_POISONINGWEAPON);
	export_constant(SI_TOXIN);
	export_constant(SI_PARALYSE);
	export_constant(SI_VENOMBLEED);
	export_constant(SI_MAGICMUSHROOM);
	export_constant(SI_DEATHHURT);
	export_constant(SI_PYREXIA);
	export_constant(SI_OBLIVIONCURSE);
	export_constant(SI_LEECHESEND);
	export_constant(SI_DUPLELIGHT);
	export_constant(SI_FROSTMISTY);
	export_constant(SI_FEARBREEZE);
	export_constant(SI_ELECTRICSHOCKER);
	export_constant(SI_MARSHOFABYSS);
	export_constant(SI_RECOGNIZEDSPELL);
	export_constant(SI_STASIS);
	export_constant(SI_WUGRIDER);
	export_constant(SI_WUGDASH);
	export_constant(SI_WUGBITE);
	export_constant(SI_CAMOUFLAGE);
	export_constant(SI_ACCELERATION);
	export_constant(SI_HOVERING);
	export_constant(SI_SPHERE_1);
	export_constant(SI_SPHERE_2);
	export_constant(SI_SPHERE_3);
	export_constant(SI_SPHERE_4);
	export_constant(SI_SPHERE_5);
	export_constant(SI_MVPCARD_TAOGUNKA);
	export_constant(SI_MVPCARD_MISTRESS);
	export_constant(SI_MVPCARD_ORCHERO);
	export_constant(SI_MVPCARD_ORCLORD);
	export_constant(SI_OVERHEAT_LIMITPOINT);
	export_constant(SI_OVERHEAT);
	export_constant(SI_SHAPESHIFT);
	export_constant(SI_INFRAREDSCAN);
	export_constant(SI_MAGNETICFIELD);
	export_constant(SI_NEUTRALBARRIER);
	export_constant(SI_NEUTRALBARRIER_MASTER);
	export_constant(SI_STEALTHFIELD);
	export_constant(SI_STEALTHFIELD_MASTER);
	export_constant(SI_MANU_ATK);
	export_constant(SI_MANU_DEF);
	export_constant(SI_SPL_ATK);
	export_constant(SI_SPL_DEF);
	export_constant(SI_REPRODUCE);
	export_constant(SI_MANU_MATK);
	export_constant(SI_SPL_MATK);
	export_constant(SI_STR_SCROLL);
	export_constant(SI_INT_SCROLL);
	export_constant(SI_LG_REFLECTDAMAGE);
	export_constant(SI_FORCEOFVANGUARD);
	export_constant(SI_BUCHEDENOEL);
	export_constant(SI_AUTOSHADOWSPELL);
	export_constant(SI_SHADOWFORM);
	export_constant(SI_RAID);
	export_constant(SI_SHIELDSPELL_DEF);
	export_constant(SI_SHIELDSPELL_MDEF);
	export_constant(SI_SHIELDSPELL_REF);
	export_constant(SI_BODYPAINT);
	export_constant(SI_EXEEDBREAK);
	export_constant(SI_ADORAMUS);
	export_constant(SI_PRESTIGE);
	export_constant(SI_INVISIBILITY);
	export_constant(SI_DEADLYINFECT);
	export_constant(SI_BANDING);
	export_constant(SI_EARTHDRIVE);
	export_constant(SI_INSPIRATION);
	export_constant(SI_ENERVATION);
	export_constant(SI_GROOMY);
	export_constant(SI_RAISINGDRAGON);
	export_constant(SI_IGNORANCE);
	export_constant(SI_LAZINESS);
	export_constant(SI_LIGHTNINGWALK);
	export_constant(SI_ACARAJE);
	export_constant(SI_UNLUCKY);
	export_constant(SI_CURSEDCIRCLE_ATKER);
	export_constant(SI_CURSEDCIRCLE_TARGET);
	export_constant(SI_WEAKNESS);
	export_constant(SI_CRESCENTELBOW);
	export_constant(SI_NOEQUIPACCESSARY);
	export_constant(SI_STRIPACCESSARY);
	export_constant(SI_MANHOLE);
	export_constant(SI_POPECOOKIE);
	export_constant(SI_FALLENEMPIRE);
	export_constant(SI_GENTLETOUCH_ENERGYGAIN);
	export_constant(SI_GENTLETOUCH_CHANGE);
	export_constant(SI_GENTLETOUCH_REVITALIZE);
	export_constant(SI_BLOODYLUST);
	export_constant(SI_SWINGDANCE);
	export_constant(SI_SYMPHONYOFLOVERS);
	export_constant(SI_PROPERTYWALK);
	export_constant(SI_SPELLFIST);
	export_constant(SI_NETHERWORLD);
	export_constant(SI_VOICEOFSIREN);
	export_constant(SI_DEEPSLEEP);
	export_constant(SI_SIRCLEOFNATURE);
	export_constant(SI_COLD);
	export_constant(SI_GLOOMYDAY);
	export_constant(SI_SONGOFMANA);
	export_constant(SI_CLOUDKILL);
	export_constant(SI_DANCEWITHWUG);
	export_constant(SI_RUSHWINDMILL);
	export_constant(SI_ECHOSONG);
	export_constant(SI_HARMONIZE);
	export_constant(SI_STRIKING);
	export_constant(SI_WARMER);
	export_constant(SI_MOONLITSERENADE);
	export_constant(SI_SATURDAYNIGHTFEVER);
	export_constant(SI_SITDOWN_FORCE);
	export_constant(SI_ANALYZE);
	export_constant(SI_LERADSDEW);
	export_constant(SI_MELODYOFSINK);
	export_constant(SI_WARCRYOFBEYOND);
	export_constant(SI_UNLIMITEDHUMMINGVOICE);
	export_constant(SI_SPELLBOOK1);
	export_constant(SI_SPELLBOOK2);
	export_constant(SI_SPELLBOOK3);
	export_constant(SI_FREEZE_SP);
	export_constant(SI_GN_TRAINING_SWORD);
	export_constant(SI_GN_REMODELING_CART);
	export_constant(SI_GN_CARTBOOST);
	export_constant(SI_FIXEDCASTINGTM_REDUCE);
	export_constant(SI_THORNTRAP);
	export_constant(SI_BLOODSUCKER);
	export_constant(SI_SPORE_EXPLOSION);
	export_constant(SI_DEMONIC_FIRE);
	export_constant(SI_FIRE_EXPANSION_SMOKE_POWDER);
	export_constant(SI_FIRE_EXPANSION_TEAR_GAS);
	export_constant(SI_BLOCKING_PLAY);
	export_constant(SI_MANDRAGORA);
	export_constant(SI_ACTIVATE);
	export_constant(SI_SECRAMENT);
	export_constant(SI_ASSUMPTIO2);
	export_constant(SI_TK_SEVENWIND);
	export_constant(SI_LIMIT_ODINS_RECALL);
	export_constant(SI_STOMACHACHE);
	export_constant(SI_MYSTERIOUS_POWDER);
	export_constant(SI_MELON_BOMB);
	export_constant(SI_BANANA_BOMB_SITDOWN_POSTDELAY);
	export_constant(SI_PROMOTE_HEALTH_RESERCH);
	export_constant(SI_ENERGY_DRINK_RESERCH);
	export_constant(SI_EXTRACT_WHITE_POTION_Z);
	export_constant(SI_VITATA_500);
	export_constant(SI_EXTRACT_SALAMINE_JUICE);
	export_constant(SI_BOOST500);
	export_constant(SI_FULL_SWING_K);
	export_constant(SI_MANA_PLUS);
	export_constant(SI_MUSTLE_M);
	export_constant(SI_LIFE_FORCE_F);
	export_constant(SI_VACUUM_EXTREME);
	export_constant(SI_SAVAGE_STEAK);
	export_constant(SI_COCKTAIL_WARG_BLOOD);
	export_constant(SI_MINOR_BBQ);
	export_constant(SI_SIROMA_ICE_TEA);
	export_constant(SI_DROCERA_HERB_STEAMED);
	export_constant(SI_PUTTI_TAILS_NOODLES);
	export_constant(SI_BANANA_BOMB);
	export_constant(SI_SUMMON_AGNI);
	export_constant(SI_SPELLBOOK4);
	export_constant(SI_SPELLBOOK5);
	export_constant(SI_SPELLBOOK6);
	export_constant(SI_SPELLBOOK7);
	export_constant(SI_ELEMENTAL_AGGRESSIVE);
	export_constant(SI_RETURN_TO_ELDICASTES);
	export_constant(SI_BANDING_DEFENCE);
	export_constant(SI_SKELSCROLL);
	export_constant(SI_DISTRUCTIONSCROLL);
	export_constant(SI_ROYALSCROLL);
	export_constant(SI_IMMUNITYSCROLL);
	export_constant(SI_MYSTICSCROLL);
	export_constant(SI_BATTLESCROLL);
	export_constant(SI_ARMORSCROLL);
	export_constant(SI_FREYJASCROLL);
	export_constant(SI_SOULSCROLL);
	export_constant(SI_CIRCLE_OF_FIRE);
	export_constant(SI_CIRCLE_OF_FIRE_OPTION);
	export_constant(SI_FIRE_CLOAK);
	export_constant(SI_FIRE_CLOAK_OPTION);
	export_constant(SI_WATER_SCREEN);
	export_constant(SI_WATER_SCREEN_OPTION);
	export_constant(SI_WATER_DROP);
	export_constant(SI_WATER_DROP_OPTION);
	export_constant(SI_WIND_STEP);
	export_constant(SI_WIND_STEP_OPTION);
	export_constant(SI_WIND_CURTAIN);
	export_constant(SI_WIND_CURTAIN_OPTION);
	export_constant(SI_WATER_BARRIER);
	export_constant(SI_ZEPHYR);
	export_constant(SI_SOLID_SKIN);
	export_constant(SI_SOLID_SKIN_OPTION);
	export_constant(SI_STONE_SHIELD);
	export_constant(SI_STONE_SHIELD_OPTION);
	export_constant(SI_POWER_OF_GAIA);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EL_WAIT);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EL_PASSIVE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EL_DEFENSIVE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EL_OFFENSIVE);
	// disabled source side, does not make sense to export it
	//export_constant(SI_EL_COST);
	export_constant(SI_PYROTECHNIC);
	export_constant(SI_PYROTECHNIC_OPTION);
	export_constant(SI_HEATER);
	export_constant(SI_HEATER_OPTION);
	export_constant(SI_TROPIC);
	export_constant(SI_TROPIC_OPTION);
	export_constant(SI_AQUAPLAY);
	export_constant(SI_AQUAPLAY_OPTION);
	export_constant(SI_COOLER);
	export_constant(SI_COOLER_OPTION);
	export_constant(SI_CHILLY_AIR);
	export_constant(SI_CHILLY_AIR_OPTION);
	export_constant(SI_GUST);
	export_constant(SI_GUST_OPTION);
	export_constant(SI_BLAST);
	export_constant(SI_BLAST_OPTION);
	export_constant(SI_WILD_STORM);
	export_constant(SI_WILD_STORM_OPTION);
	export_constant(SI_PETROLOGY);
	export_constant(SI_PETROLOGY_OPTION);
	export_constant(SI_CURSED_SOIL);
	export_constant(SI_CURSED_SOIL_OPTION);
	export_constant(SI_UPHEAVAL);
	export_constant(SI_UPHEAVAL_OPTION);
	export_constant(SI_TIDAL_WEAPON);
	export_constant(SI_TIDAL_WEAPON_OPTION);
	export_constant(SI_ROCK_CRUSHER);
	export_constant(SI_ROCK_CRUSHER_ATK);
	export_constant(SI_FIRE_INSIGNIA);
	export_constant(SI_WATER_INSIGNIA);
	export_constant(SI_WIND_INSIGNIA);
	export_constant(SI_EARTH_INSIGNIA);
	export_constant(SI_EQUIPED_FLOOR);
	export_constant(SI_GUARDIAN_RECALL);
	export_constant(SI_MORA_BUFF);
	export_constant(SI_REUSE_LIMIT_G);
	export_constant(SI_REUSE_LIMIT_H);
	export_constant(SI_NEEDLE_OF_PARALYZE);
	export_constant(SI_PAIN_KILLER);
	export_constant(SI_G_LIFEPOTION);
	export_constant(SI_VITALIZE_POTION);
	export_constant(SI_LIGHT_OF_REGENE);
	export_constant(SI_OVERED_BOOST);
	export_constant(SI_SILENT_BREEZE);
	export_constant(SI_ODINS_POWER);
	export_constant(SI_STYLE_CHANGE);
	export_constant(SI_SONIC_CLAW_POSTDELAY);
	export_constant(SI_SILVERVEIN_RUSH_POSTDELAY);
	export_constant(SI_MIDNIGHT_FRENZY_POSTDELAY);
	export_constant(SI_GOLDENE_FERSE);
	export_constant(SI_ANGRIFFS_MODUS);
	export_constant(SI_TINDER_BREAKER);
	export_constant(SI_TINDER_BREAKER_POSTDELAY);
	export_constant(SI_CBC);
	export_constant(SI_CBC_POSTDELAY);
	export_constant(SI_EQC);
	export_constant(SI_MAGMA_FLOW);
	export_constant(SI_GRANITIC_ARMOR);
	export_constant(SI_PYROCLASTIC);
	export_constant(SI_VOLCANIC_ASH);
	export_constant(SI_SPIRITS_SAVEINFO1);
	export_constant(SI_SPIRITS_SAVEINFO2);
	export_constant(SI_MAGIC_CANDY);
	export_constant(SI_SEARCH_STORE_INFO);
	export_constant(SI_ALL_RIDING);
	export_constant(SI_ALL_RIDING_REUSE_LIMIT);
	export_constant(SI_MACRO);
	export_constant(SI_MACRO_POSTDELAY);
	export_constant(SI_BEER_BOTTLE_CAP);
	export_constant(SI_OVERLAPEXPUP);
	export_constant(SI_PC_IZ_DUN05);
	export_constant(SI_CRUSHSTRIKE);
	export_constant(SI_MONSTER_TRANSFORM);
	export_constant(SI_SIT);
	export_constant(SI_ONAIR);
	export_constant(SI_MTF_ASPD);
	export_constant(SI_MTF_RANGEATK);
	export_constant(SI_MTF_MATK);
	export_constant(SI_MTF_MLEATKED);
	export_constant(SI_MTF_CRIDAMAGE);
	export_constant(SI_REUSE_LIMIT_MTF);
	export_constant(SI_MACRO_PERMIT);
	export_constant(SI_MACRO_PLAY);
	export_constant(SI_SKF_CAST);
	export_constant(SI_SKF_ASPD);
	export_constant(SI_SKF_ATK);
	export_constant(SI_SKF_MATK);
	export_constant(SI_REWARD_PLUSONLYJOBEXP);
	export_constant(SI_HANDICAPSTATE_NORECOVER);
	export_constant(SI_SET_NUM_DEF);
	export_constant(SI_SET_NUM_MDEF);
	export_constant(SI_SET_PER_DEF);
	export_constant(SI_SET_PER_MDEF);
	export_constant(SI_PARTYBOOKING_SEARCH_DELAY);
	export_constant(SI_PARTYBOOKING_REGISTER_DELAY);
	export_constant(SI_PERIOD_TIME_CHECK_DETECT_SKILL);
	export_constant(SI_KO_JYUMONJIKIRI);
	export_constant(SI_MEIKYOUSISUI);
	export_constant(SI_ATTHASTE_CASH);
	export_constant(SI_EQUIPPED_DIVINE_ARMOR);
	export_constant(SI_EQUIPPED_HOLY_ARMOR);
	export_constant(SI_2011RWC);
	export_constant(SI_KYOUGAKU);
	export_constant(SI_IZAYOI);
	export_constant(SI_ZENKAI);
	export_constant(SI_KG_KAGEHUMI);
	export_constant(SI_KYOMU);
	export_constant(SI_KAGEMUSYA);
	export_constant(SI_ZANGETSU);
	export_constant(SI_PHI_DEMON);
	export_constant(SI_GENSOU);
	export_constant(SI_AKAITSUKI);
	export_constant(SI_TETANY);
	export_constant(SI_GM_BATTLE);
	export_constant(SI_GM_BATTLE2);
	export_constant(SI_2011RWC_SCROLL);
	export_constant(SI_ACTIVE_MONSTER_TRANSFORM);
	export_constant(SI_MYSTICPOWDER);
	export_constant(SI_ECLAGE_RECALL);
	export_constant(SI_ENTRY_QUEUE_APPLY_DELAY);
	export_constant(SI_REUSE_LIMIT_ECL);
	export_constant(SI_M_LIFEPOTION);
	export_constant(SI_ENTRY_QUEUE_NOTIFY_ADMISSION_TIME_OUT);
	export_constant(SI_UNKNOWN_NAME);
	export_constant(SI_ON_PUSH_CART);
	export_constant(SI_HAT_EFFECT);
	export_constant(SI_FLOWER_LEAF);
	export_constant(SI_RAY_OF_PROTECTION);
	export_constant(SI_GLASTHEIM_ATK);
	export_constant(SI_GLASTHEIM_DEF);
	export_constant(SI_GLASTHEIM_HEAL);
	export_constant(SI_GLASTHEIM_HIDDEN);
	export_constant(SI_GLASTHEIM_STATE);
	export_constant(SI_GLASTHEIM_ITEMDEF);
	export_constant(SI_GLASTHEIM_HPSP);
	export_constant(SI_HOMUN_SKILL_POSTDELAY);
	export_constant(SI_ALMIGHTY);
	export_constant(SI_GVG_GIANT);
	export_constant(SI_GVG_GOLEM);
	export_constant(SI_GVG_STUN);
	export_constant(SI_GVG_STONE);
	export_constant(SI_GVG_FREEZ);
	export_constant(SI_GVG_SLEEP);
	export_constant(SI_GVG_CURSE);
	export_constant(SI_GVG_SILENCE);
	export_constant(SI_GVG_BLIND);
	export_constant(SI_CLIENT_ONLY_EQUIP_ARROW);
	export_constant(SI_CLAN_INFO);
	export_constant(SI_JP_EVENT01);
	export_constant(SI_JP_EVENT02);
	export_constant(SI_JP_EVENT03);
	export_constant(SI_JP_EVENT04);
	export_constant(SI_TELEPORT_FIXEDCASTINGDELAY);
	export_constant(SI_GEFFEN_MAGIC1);
	export_constant(SI_GEFFEN_MAGIC2);
	export_constant(SI_GEFFEN_MAGIC3);
	export_constant(SI_QUEST_BUFF1);
	export_constant(SI_QUEST_BUFF2);
	export_constant(SI_QUEST_BUFF3);
	export_constant(SI_REUSE_LIMIT_RECALL);
	export_constant(SI_SAVEPOSITION);
	export_constant(SI_HANDICAPSTATE_ICEEXPLO);
	export_constant(SI_FENRIR_CARD);
	export_constant(SI_REUSE_LIMIT_ASPD_POTION);
	export_constant(SI_MAXPAIN);
	export_constant(SI_PC_STOP);
	export_constant(SI_FRIGG_SONG);
	export_constant(SI_OFFERTORIUM);
	export_constant(SI_TELEKINESIS_INTENSE);
	export_constant(SI_MOONSTAR);
	export_constant(SI_STRANGELIGHTS);
	export_constant(SI_FULL_THROTTLE);
	export_constant(SI_REBOUND);
	export_constant(SI_UNLIMIT);
	export_constant(SI_KINGS_GRACE);
	export_constant(SI_ITEM_ATKMAX);
	export_constant(SI_ITEM_ATKMIN);
	export_constant(SI_ITEM_MATKMAX);
	export_constant(SI_ITEM_MATKMIN);
	export_constant(SI_SUPER_STAR);
	export_constant(SI_HIGH_RANKER);
	export_constant(SI_DARKCROW);
	export_constant(SI_2013_VALENTINE1);
	export_constant(SI_2013_VALENTINE2);
	export_constant(SI_2013_VALENTINE3);
	export_constant(SI_ILLUSIONDOPING);
	export_constant(SI_WIDEWEB);
	export_constant(SI_CHILL);
	export_constant(SI_BURNT);
	export_constant(SI_PCCAFE_PLAY_TIME);
	export_constant(SI_TWISTED_TIME);
	export_constant(SI_FLASHCOMBO);
	export_constant(SI_JITTER_BUFF1);
	export_constant(SI_JITTER_BUFF2);
	export_constant(SI_JITTER_BUFF3);
	export_constant(SI_JITTER_BUFF4);
	export_constant(SI_JITTER_BUFF5);
	export_constant(SI_JITTER_BUFF6);
	export_constant(SI_JITTER_BUFF7);
	export_constant(SI_JITTER_BUFF8);
	export_constant(SI_JITTER_BUFF9);
	export_constant(SI_JITTER_BUFF10);
	export_constant(SI_CUP_OF_BOZA);
	export_constant(SI_B_TRAP);
	export_constant(SI_E_CHAIN);
	export_constant(SI_E_QD_SHOT_READY);
	export_constant(SI_C_MARKER);
	export_constant(SI_H_MINE);
	export_constant(SI_H_MINE_SPLASH);
	export_constant(SI_P_ALTER);
	export_constant(SI_HEAT_BARREL);
	export_constant(SI_ANTI_M_BLAST);
	export_constant(SI_SLUGSHOT);
	export_constant(SI_SWORDCLAN);
	export_constant(SI_ARCWANDCLAN);
	export_constant(SI_GOLDENMACECLAN);
	export_constant(SI_CROSSBOWCLAN);
	export_constant(SI_PACKING_ENVELOPE1);
	export_constant(SI_PACKING_ENVELOPE2);
	export_constant(SI_PACKING_ENVELOPE3);
	export_constant(SI_PACKING_ENVELOPE4);
	export_constant(SI_PACKING_ENVELOPE5);
	export_constant(SI_PACKING_ENVELOPE6);
	export_constant(SI_PACKING_ENVELOPE7);
	export_constant(SI_PACKING_ENVELOPE8);
	export_constant(SI_PACKING_ENVELOPE9);
	export_constant(SI_PACKING_ENVELOPE10);
	export_constant(SI_GLASTHEIM_TRANS);
	export_constant(SI_ZONGZI_POUCH_TRANS);
	export_constant(SI_HEAT_BARREL_AFTER);
	export_constant(SI_DECORATION_OF_MUSIC);
	export_constant(SI_OVERSEAEXPUP);
	export_constant(SI_CLOWN_N_GYPSY_CARD);
	export_constant(SI_OPEN_NPC_MARKET);
	export_constant(SI_BEEF_RIB_STEW);
	export_constant(SI_PORK_RIB_STEW);
	export_constant(SI_CHUSEOK_MONDAY);
	export_constant(SI_CHUSEOK_TUESDAY);
	export_constant(SI_CHUSEOK_WEDNESDAY);
	export_constant(SI_CHUSEOK_THURSDAY);
	export_constant(SI_CHUSEOK_FRIDAY);
	export_constant(SI_CHUSEOK_WEEKEND);
	export_constant(SI_ALL_LIGHTGUARD);
	export_constant(SI_ALL_LIGHTGUARD_COOL_TIME);
	export_constant(SI_MTF_MHP);
	export_constant(SI_MTF_MSP);
	export_constant(SI_MTF_PUMPKIN);
	export_constant(SI_MTF_HITFLEE);
	export_constant(SI_MTF_CRIDAMAGE2);
	export_constant(SI_MTF_SPDRAIN);
	export_constant(SI_ACUO_MINT_GUM);
	export_constant(SI_S_HEALPOTION);
	export_constant(SI_REUSE_LIMIT_S_HEAL_POTION);
	export_constant(SI_PLAYTIME_STATISTICS);
	export_constant(SI_GN_CHANGEMATERIAL_OPERATOR);
	export_constant(SI_GN_MIX_COOKING_OPERATOR);
	export_constant(SI_GN_MAKEBOMB_OPERATOR);
	export_constant(SI_GN_S_PHARMACY_OPERATOR);
	export_constant(SI_SO_EL_ANALYSIS_DISASSEMBLY_OPERATOR);
	export_constant(SI_SO_EL_ANALYSIS_COMBINATION_OPERATOR);
	export_constant(SI_NC_MAGICDECOY_OPERATOR);
	export_constant(SI_GUILD_STORAGE);
	export_constant(SI_GC_POISONINGWEAPON_OPERATOR);
	export_constant(SI_WS_WEAPONREFINE_OPERATOR);
	export_constant(SI_BS_REPAIRWEAPON_OPERATOR);
	export_constant(SI_GET_MAILBOX);
	export_constant(SI_JUMPINGCLAN);
	export_constant(SI_JP_OTP);
	export_constant(SI_HANDICAPTOLERANCE_LEVELGAP);
	export_constant(SI_MTF_RANGEATK2);
	export_constant(SI_MTF_ASPD2);
	export_constant(SI_MTF_MATK2);
	export_constant(SI_SHOW_NPCHPBAR);
	export_constant(SI_FLOWERSMOKE);
	export_constant(SI_FSTONE);
	export_constant(SI_DAILYSENDMAILCNT);
	export_constant(SI_QSCARABA);
	export_constant(SI_LJOSALFAR);
	export_constant(SI_PAD_READER_KNIGHT);
	export_constant(SI_PAD_READER_CRUSADER);
	export_constant(SI_PAD_READER_BLACKSMITH);
	export_constant(SI_PAD_READER_ALCHEMIST);
	export_constant(SI_PAD_READER_ASSASSIN);
	export_constant(SI_PAD_READER_ROGUE);
	export_constant(SI_PAD_READER_WIZARD);
	export_constant(SI_PAD_READER_SAGE);
	export_constant(SI_PAD_READER_PRIEST);
	export_constant(SI_PAD_READER_MONK);
	export_constant(SI_PAD_READER_HUNTER);
	export_constant(SI_PAD_READER_BARD);
	export_constant(SI_PAD_READER_DANCER);
	export_constant(SI_PAD_READER_TAEKWON);
	export_constant(SI_PAD_READER_NINJA);
	export_constant(SI_PAD_READER_GUNSLINGER);
	export_constant(SI_PAD_READER_SUPERNOVICE);
	export_constant(SI_ESSENCE_OF_TIME);
	export_constant(SI_MINIGAME_ROULETTE);
	export_constant(SI_MINIGAME_GOLD_POINT);
	export_constant(SI_MINIGAME_SILVER_POINT);
	export_constant(SI_MINIGAME_BRONZE_POINT);
	export_constant(SI_HAPPINESS_STAR);
	export_constant(SI_SUMMEREVENT01);
	export_constant(SI_SUMMEREVENT02);
	export_constant(SI_SUMMEREVENT03);
	export_constant(SI_SUMMEREVENT04);
	export_constant(SI_SUMMEREVENT05);
	export_constant(SI_MINIGAME_ROULETTE_BONUS_ITEM);
	export_constant(SI_DRESS_UP);
	export_constant(SI_MAPLE_FALLS);
	export_constant(SI_ALL_NIFLHEIM_RECALL);
	export_constant(SI_MTF_MARIONETTE);
	export_constant(SI_MTF_LUDE);
	export_constant(SI_MTF_CRUISER);
	export_constant(SI_MERMAID_LONGING);
	export_constant(SI_MAGICAL_FEATHER);
	export_constant(SI_DRACULA_CARD);
	export_constant(SI_LIMIT_POWER_BOOSTER);
	export_constant(SI_TIME_ACCESSORY);
	export_constant(SI_EP16_DEF);
	export_constant(SI_NORMAL_ATKED_SP);
	export_constant(SI_BODYSTATE_STONECURSE);
	export_constant(SI_BODYSTATE_FREEZING);
	export_constant(SI_BODYSTATE_STUN);
	export_constant(SI_BODYSTATE_SLEEP);
	export_constant(SI_BODYSTATE_UNDEAD);
	export_constant(SI_BODYSTATE_STONECURSE_ING);
	export_constant(SI_BODYSTATE_BURNNING);
	export_constant(SI_BODYSTATE_IMPRISON);
	export_constant(SI_HEALTHSTATE_POISON);
	export_constant(SI_HEALTHSTATE_CURSE);
	export_constant(SI_HEALTHSTATE_SILENCE);
	export_constant(SI_HEALTHSTATE_CONFUSION);
	export_constant(SI_HEALTHSTATE_BLIND);
	export_constant(SI_HEALTHSTATE_ANGELUS);
	export_constant(SI_HEALTHSTATE_BLOODING);
	export_constant(SI_HEALTHSTATE_HEAVYPOISON);
	export_constant(SI_HEALTHSTATE_FEAR);
	export_constant(SI_CHERRY_BLOSSOM_CAKE);
	export_constant(SI_SU_STOOP);
	export_constant(SI_CATNIPPOWDER);
	export_constant(SI_SV_ROOTTWIST);
	export_constant(SI_ATTACK_PROPERTY_NOTHING);
	export_constant(SI_ATTACK_PROPERTY_WATER);
	export_constant(SI_ATTACK_PROPERTY_GROUND);
	export_constant(SI_ATTACK_PROPERTY_FIRE);
	export_constant(SI_ATTACK_PROPERTY_WIND);
	export_constant(SI_ATTACK_PROPERTY_POISON);
	export_constant(SI_ATTACK_PROPERTY_SAINT);
	export_constant(SI_ATTACK_PROPERTY_DARKNESS);
	export_constant(SI_ATTACK_PROPERTY_TELEKINESIS);
	export_constant(SI_ATTACK_PROPERTY_UNDEAD);
	export_constant(SI_RESIST_PROPERTY_NOTHING);
	export_constant(SI_RESIST_PROPERTY_WATER);
	export_constant(SI_RESIST_PROPERTY_GROUND);
	export_constant(SI_RESIST_PROPERTY_FIRE);
	export_constant(SI_RESIST_PROPERTY_WIND);
	export_constant(SI_RESIST_PROPERTY_POISON);
	export_constant(SI_RESIST_PROPERTY_SAINT);
	export_constant(SI_RESIST_PROPERTY_DARKNESS);
	export_constant(SI_RESIST_PROPERTY_TELEKINESIS);
	export_constant(SI_RESIST_PROPERTY_UNDEAD);
	export_constant(SI_BITESCAR);
	export_constant(SI_ARCLOUSEDASH);
	export_constant(SI_TUNAPARTY);
	export_constant(SI_SHRIMP);
	export_constant(SI_FRESHSHRIMP);
	export_constant(SI_PERIOD_RECEIVEITEM);
	export_constant(SI_PERIOD_PLUSEXP);
	export_constant(SI_PERIOD_PLUSJOBEXP);
	export_constant(SI_RUNEHELM);
	export_constant(SI_HELM_VERKANA);
	export_constant(SI_HELM_RHYDO);
	export_constant(SI_HELM_TURISUS);
	export_constant(SI_HELM_HAGALAS);
	export_constant(SI_HELM_ISIA);
	export_constant(SI_HELM_ASIR);
	export_constant(SI_HELM_URJ);
	export_constant(SI_SUHIDE);
	export_constant(SI_DORAM_BUF_01);
	export_constant(SI_DORAM_BUF_02);
	export_constant(SI_SPRITEMABLE);
	export_constant(SI_AID_PERIOD_RECEIVEITEM);
	export_constant(SI_AID_PERIOD_PLUSEXP);
	export_constant(SI_AID_PERIOD_PLUSJOBEXP);
	export_constant(SI_AID_PERIOD_DEADPENALTY);
	export_constant(SI_AID_PERIOD_ADDSTOREITEMCOUNT);
	export_constant(SI_HISS);
	export_constant(SI_NYANGGRASS);
	export_constant(SI_CHATTERING);
	export_constant(SI_GROOMING);
	export_constant(SI_PROTECTIONOFSHRIMP);
	export_constant(SI_EP16_2_BUFF_SS);
	export_constant(SI_EP16_2_BUFF_SC);
	export_constant(SI_EP16_2_BUFF_AC);
	export_constant(SI_GS_MAGICAL_BULLET);
	export_constant(SI_FALLEN_ANGEL);
	export_constant(SI_BLAZE_BEAD);
	export_constant(SI_FROZEN_BEAD);
	export_constant(SI_BREEZE_BEAD);
	export_constant(SI_AID_PERIOD_RECEIVEITEM_2ND);
	export_constant(SI_AID_PERIOD_PLUSEXP_2ND);
	export_constant(SI_AID_PERIOD_PLUSJOBEXP_2ND);
	export_constant(SI_PRONTERA_JP);
	export_constant(SI_GLOOM_CARD);
	export_constant(SI_PHARAOH_CARD);
	export_constant(SI_KIEL_CARD);
	export_constant(SI_S_MANAPOTION);
	export_constant(SI_M_DEFSCROLL);

	/* elements */
	export_constant(ELE_NEUTRAL);
	export_constant(ELE_WATER);
	export_constant(ELE_EARTH);
	export_constant(ELE_FIRE);
	export_constant(ELE_WIND);
	export_constant(ELE_POISON);
	export_constant(ELE_HOLY);
	export_constant(ELE_DARK);
	export_constant(ELE_GHOST);
	export_constant(ELE_UNDEAD);
	export_constant(ELE_ALL);

	/* races */
	export_constant(RC_FORMLESS);
	export_constant(RC_UNDEAD);
	export_constant(RC_BRUTE);
	export_constant(RC_PLANT);
	export_constant(RC_INSECT);
	export_constant(RC_FISH);
	export_constant(RC_DEMON);
	export_constant(RC_DEMIHUMAN);
	export_constant(RC_ANGEL);
	export_constant(RC_DRAGON);
	export_constant(RC_PLAYER);
	export_constant(RC_ALL);

	export_constant(RC2_NONE);
	export_constant(RC2_GOBLIN);
	export_constant(RC2_KOBOLD);
	export_constant(RC2_ORC);
	export_constant(RC2_GOLEM);
	export_constant(RC2_GUARDIAN);
	export_constant(RC2_NINJA);
	export_constant(RC2_GVG);
	export_constant(RC2_BATTLEFIELD);
	export_constant(RC2_TREASURE);
	export_constant(RC2_BIOLAB);
	export_constant(RC2_MANUK);
	export_constant(RC2_SPLENDIDE);
	export_constant(RC2_SCARABA);
	export_constant(RC2_MAX);

	/* classes */
	export_constant(CLASS_NORMAL);
	export_constant(CLASS_BOSS);
	export_constant(CLASS_GUARDIAN);
	export_constant(CLASS_BATTLEFIELD);
	export_constant(CLASS_ALL);

	/* sizes */
	export_constant2("Size_Small",SZ_SMALL);
	export_constant2("Size_Medium",SZ_MEDIUM);
	export_constant2("Size_Large",SZ_BIG);
	export_constant2("Size_All",SZ_ALL);

	/* ai */
	export_constant(AI_NONE);
	export_constant(AI_ATTACK);
	export_constant(AI_SPHERE);
	export_constant(AI_FLORA);
	export_constant(AI_ZANZOU);
	export_constant(AI_LEGION);
	export_constant(AI_FAW);

	/* battle flags */
	export_constant(BF_WEAPON);
	export_constant(BF_MAGIC);
	export_constant(BF_MISC);
	export_constant(BF_SHORT);
	export_constant(BF_LONG);
	export_constant(BF_SKILL);
	export_constant(BF_NORMAL);

	/* auto trigger flags */
	export_constant(ATF_SELF);
	export_constant(ATF_TARGET);
	export_constant(ATF_SHORT);
	export_constant(ATF_LONG);
	export_constant(ATF_WEAPON);
	export_constant(ATF_MAGIC);
	export_constant(ATF_MISC);
	// TODO: Check why this was in const.txt, but not on source side
	export_constant2("ATF_SKILL",ATF_MAGIC|ATF_MISC);

	/* emoticons */
	export_constant(E_GASP);
	export_constant(E_WHAT);
	export_constant(E_HO);
	export_constant(E_LV);
	export_constant(E_SWT);
	export_constant(E_IC);
	export_constant(E_AN);
	export_constant(E_AG);
	export_constant(E_CASH);
	export_constant(E_DOTS);
	export_constant(E_SCISSORS);
	export_constant(E_ROCK);
	export_constant(E_PAPER);
	export_constant(E_KOREA);
	export_constant(E_LV2);
	export_constant(E_THX);
	export_constant(E_WAH);
	export_constant(E_SRY);
	export_constant(E_HEH);
	export_constant(E_SWT2);
	export_constant(E_HMM);
	export_constant(E_NO1);
	export_constant(E_NO);
	export_constant(E_OMG);
	export_constant(E_OH);
	export_constant(E_X);
	export_constant(E_HLP);
	export_constant(E_GO);
	export_constant(E_SOB);
	export_constant(E_GG);
	export_constant(E_KIS);
	export_constant(E_KIS2);
	export_constant(E_PIF);
	export_constant(E_OK);
	export_constant(E_MUTE);
	export_constant(E_INDONESIA);
	export_constant(E_BZZ);
	export_constant(E_RICE);
	export_constant(E_AWSM);
	export_constant(E_MEH);
	export_constant(E_SHY);
	export_constant(E_PAT);
	export_constant(E_MP);
	export_constant(E_SLUR);
	export_constant(E_COM);
	export_constant(E_YAWN);
	export_constant(E_GRAT);
	export_constant(E_HP);
	export_constant(E_PHILIPPINES);
	export_constant(E_MALAYSIA);
	export_constant(E_SINGAPORE);
	export_constant(E_BRAZIL);
	export_constant(E_FLASH);
	export_constant(E_SPIN);
	export_constant(E_SIGH);
	export_constant(E_DUM);
	export_constant(E_LOUD);
	export_constant(E_OTL);
	export_constant(E_DICE1);
	export_constant(E_DICE2);
	export_constant(E_DICE3);
	export_constant(E_DICE4);
	export_constant(E_DICE5);
	export_constant(E_DICE6);
	export_constant(E_INDIA);
	export_constant(E_LUV);
	export_constant(E_RUSSIA);
	export_constant(E_VIRGIN);
	export_constant(E_MOBILE);
	export_constant(E_MAIL);
	export_constant(E_CHINESE);
	export_constant(E_ANTENNA1);
	export_constant(E_ANTENNA2);
	export_constant(E_ANTENNA3);
	export_constant(E_HUM);
	export_constant(E_ABS);
	export_constant(E_OOPS);
	export_constant(E_SPIT);
	export_constant(E_ENE);
	export_constant(E_PANIC);
	export_constant(E_WHISP);
	export_constant(E_YUT1);
	export_constant(E_YUT2);
	export_constant(E_YUT3);
	export_constant(E_YUT4);
	export_constant(E_YUT5);
	export_constant(E_YUT6);
	export_constant(E_YUT7);

	/* send targets */
	export_constant(ALL_CLIENT);
	export_constant(ALL_SAMEMAP);
	export_constant(AREA);
	export_constant(AREA_WOS);
	export_constant(AREA_WOC);
	export_constant(AREA_WOSC);
	export_constant(AREA_CHAT_WOC);
	export_constant(CHAT);
	export_constant(CHAT_WOS);
	export_constant(PARTY);
	export_constant(PARTY_WOS);
	export_constant(PARTY_SAMEMAP);
	export_constant(PARTY_SAMEMAP_WOS);
	export_constant(PARTY_AREA);
	export_constant(PARTY_AREA_WOS);
	export_constant(GUILD);
	export_constant(GUILD_WOS);
	export_constant(GUILD_SAMEMAP);
	export_constant(GUILD_SAMEMAP_WOS);
	export_constant(GUILD_AREA);
	export_constant(GUILD_AREA_WOS);
	export_constant(GUILD_NOBG);
	export_constant(DUEL);
	export_constant(DUEL_WOS);
	export_constant(SELF);
	export_constant(BG);
	export_constant(BG_WOS);
	export_constant(BG_SAMEMAP);
	export_constant(BG_SAMEMAP_WOS);
	export_constant(BG_AREA);
	export_constant(BG_AREA_WOS);
	export_constant(CLAN);

	/* mercenary guilds */
	export_constant(ARCH_MERC_GUILD);
	export_constant(SPEAR_MERC_GUILD);
	export_constant(SWORD_MERC_GUILD);

	/* item types */
	export_constant(IT_HEALING);
	export_constant(IT_USABLE);
	export_constant(IT_ETC);
	export_constant(IT_ARMOR);
	export_constant(IT_WEAPON);
	export_constant(IT_CARD);
	export_constant(IT_PETEGG);
	export_constant(IT_PETARMOR);
	export_constant(IT_AMMO);
	export_constant(IT_DELAYCONSUME);
	export_constant(IT_SHADOWGEAR);
	export_constant(IT_CASH);

	/* weapon types */
	export_constant(W_FIST);
	export_constant(W_DAGGER);
	export_constant(W_1HSWORD);
	export_constant(W_2HSWORD);
	export_constant(W_1HSPEAR);
	export_constant(W_2HSPEAR);
	export_constant(W_1HAXE);
	export_constant(W_2HAXE);
	export_constant(W_MACE);
	export_constant(W_2HMACE);
	export_constant(W_STAFF);
	export_constant(W_BOW);
	export_constant(W_KNUCKLE);
	export_constant(W_MUSICAL);
	export_constant(W_WHIP);
	export_constant(W_BOOK);
	export_constant(W_KATAR);
	export_constant(W_REVOLVER);
	export_constant(W_RIFLE);
	export_constant(W_GATLING);
	export_constant(W_SHOTGUN);
	export_constant(W_GRENADE);
	export_constant(W_HUUMA);
	export_constant(W_2HSTAFF);
	export_constant(MAX_WEAPON_TYPE);
	export_constant(W_DOUBLE_DD);
	export_constant(W_DOUBLE_SS);
	export_constant(W_DOUBLE_AA);
	export_constant(W_DOUBLE_DS);
	export_constant(W_DOUBLE_DA);
	export_constant(W_DOUBLE_SA);

	/* ammunition types */
	export_constant(A_ARROW);
	export_constant(A_DAGGER);
	export_constant(A_BULLET);
	export_constant(A_SHELL);
	export_constant(A_GRENADE);
	export_constant(A_SHURIKEN);
	export_constant(A_KUNAI);
	export_constant(A_CANNONBALL);
	export_constant(A_THROWWEAPON);

	/* monsterinfo types */
	export_constant(MOB_NAME);
	export_constant(MOB_LV);
	export_constant(MOB_MAXHP);
	export_constant(MOB_BASEEXP);
	export_constant(MOB_JOBEXP);
	export_constant(MOB_ATK1);
	export_constant(MOB_ATK2);
	export_constant(MOB_DEF);
	export_constant(MOB_MDEF);
	export_constant(MOB_STR);
	export_constant(MOB_AGI);
	export_constant(MOB_VIT);
	export_constant(MOB_INT);
	export_constant(MOB_DEX);
	export_constant(MOB_LUK);
	export_constant(MOB_RANGE);
	export_constant(MOB_RANGE2);
	export_constant(MOB_RANGE3);
	export_constant(MOB_SIZE);
	export_constant(MOB_RACE);
	export_constant(MOB_ELEMENT);
	export_constant(MOB_MODE);
	export_constant(MOB_MVPEXP);

	/* petinfo types */
	export_constant(PETINFO_ID);
	export_constant(PETINFO_CLASS);
	export_constant(PETINFO_NAME);
	export_constant(PETINFO_INTIMATE);
	export_constant(PETINFO_HUNGRY);
	export_constant(PETINFO_RENAMED);
	export_constant(PETINFO_LEVEL);
	export_constant(PETINFO_BLOCKID);

	// For backwards compatability - might be removed in the near future
	export_constant2("PET_ID",PETINFO_ID);
	export_constant2("PET_CLASS",PETINFO_CLASS);
	export_constant2("PET_NAME",PETINFO_NAME);
	export_constant2("PET_INTIMATE",PETINFO_INTIMATE);
	export_constant2("PET_HUNGRY",PETINFO_HUNGRY);
	export_constant2("PET_RENAMED",PETINFO_RENAMED);
	export_constant2("PET_LEVEL",PETINFO_LEVEL);

	/* questinfo types */
	export_constant(QTYPE_QUEST);
	export_constant(QTYPE_QUEST2);
	export_constant(QTYPE_JOB);
	export_constant(QTYPE_JOB2);
	export_constant(QTYPE_EVENT);
	export_constant(QTYPE_EVENT2);
	export_constant(QTYPE_WARG);
	export_constant(QTYPE_WARG2);
	export_constant(QTYPE_NONE);

	/* font weight types */
	export_constant(FW_DONTCARE);
	export_constant(FW_THIN);
	export_constant(FW_EXTRALIGHT);
	export_constant(FW_LIGHT);
	export_constant(FW_NORMAL);
	export_constant(FW_MEDIUM);
	export_constant(FW_SEMIBOLD);
	export_constant(FW_BOLD);
	export_constant(FW_EXTRABOLD);
	export_constant(FW_HEAVY);

	/* add skill types */
	export_constant2("SKILL_PERM",ADDSKILL_PERMANENT);
	export_constant2("SKILL_TEMP",ADDSKILL_TEMP);
	export_constant2("SKILL_TEMPLEVEL",ADDSKILL_TEMP_ADDLEVEL);
	export_constant2("SKILL_PERM_GRANT",ADDSKILL_PERMANENT_GRANTED);

	/* bonus script flags */
	export_constant(BSF_REM_ON_DEAD);
	export_constant(BSF_REM_ON_DISPELL);
	export_constant(BSF_REM_ON_CLEARANCE);
	export_constant(BSF_REM_ON_LOGOUT);
	export_constant(BSF_REM_ON_BANISHING_BUSTER);
	export_constant(BSF_REM_ON_REFRESH);
	export_constant(BSF_REM_ON_LUXANIMA);
	export_constant(BSF_REM_ON_MADOGEAR);
	export_constant(BSF_REM_ON_DAMAGED);
	export_constant(BSF_PERMANENT);
	export_constant(BSF_FORCE_REPLACE);
	export_constant(BSF_FORCE_DUPLICATE);

	/* bindings */
	export_constant(BOUND_NONE);
	export_constant(BOUND_ACCOUNT);
	export_constant(BOUND_GUILD);
	export_constant(BOUND_PARTY);
	export_constant(BOUND_CHAR);

	/* quest check types */
	export_constant(HAVEQUEST);
	export_constant(PLAYTIME);
	export_constant(HUNTING);

	/* status options */
	export_constant(OPTION_NOTHING);
	export_constant(OPTION_SIGHT);
	export_constant(OPTION_HIDE);
	export_constant(OPTION_CLOAK);
	export_constant(OPTION_FALCON);
	export_constant(OPTION_RIDING);
	export_constant(OPTION_INVISIBLE);
	export_constant(OPTION_ORCISH);
	export_constant(OPTION_WEDDING);
	export_constant(OPTION_RUWACH);
	export_constant(OPTION_CHASEWALK);
	export_constant(OPTION_FLYING);
	export_constant(OPTION_XMAS);
	export_constant(OPTION_TRANSFORM);
	export_constant(OPTION_SUMMER);
	export_constant(OPTION_DRAGON1);
	export_constant(OPTION_WUG);
	export_constant(OPTION_WUGRIDER);
	export_constant(OPTION_MADOGEAR);
	export_constant(OPTION_DRAGON2);
	export_constant(OPTION_DRAGON3);
	export_constant(OPTION_DRAGON4);
	export_constant(OPTION_DRAGON5);
	export_constant(OPTION_HANBOK);
	export_constant(OPTION_OKTOBERFEST);

	/* status option compounds */
	export_constant(OPTION_DRAGON);
	export_constant(OPTION_COSTUME);

	/* sc_start flags */
	export_constant(SCSTART_NONE);
	export_constant(SCSTART_NOAVOID);
	export_constant(SCSTART_NOTICKDEF);
	export_constant(SCSTART_LOADED);
	export_constant(SCSTART_NORATEDEF);
	export_constant(SCSTART_NOICON);

	export_constant(UNITTYPE_PC);
	export_constant(UNITTYPE_NPC);
	export_constant(UNITTYPE_PET);
	export_constant(UNITTYPE_MOB);
	export_constant(UNITTYPE_HOM);
	export_constant(UNITTYPE_MER);
	export_constant(UNITTYPE_ELEM);

	/* unit control - mob */
	export_constant(UMOB_SIZE);
	export_constant(UMOB_LEVEL);
	export_constant(UMOB_HP);
	export_constant(UMOB_MAXHP);
	export_constant(UMOB_MASTERAID);
	export_constant(UMOB_MAPID);
	export_constant(UMOB_X);
	export_constant(UMOB_Y);
	export_constant(UMOB_SPEED);
	export_constant(UMOB_MODE);
	export_constant(UMOB_AI);
	export_constant(UMOB_SCOPTION);
	export_constant(UMOB_SEX);
	export_constant(UMOB_CLASS);
	export_constant(UMOB_HAIRSTYLE);
	export_constant(UMOB_HAIRCOLOR);
	export_constant(UMOB_HEADBOTTOM);
	export_constant(UMOB_HEADMIDDLE);
	export_constant(UMOB_HEADTOP);
	export_constant(UMOB_CLOTHCOLOR);
	export_constant(UMOB_SHIELD);
	export_constant(UMOB_WEAPON);
	export_constant(UMOB_LOOKDIR);
	export_constant(UMOB_CANMOVETICK);
	export_constant(UMOB_STR);
	export_constant(UMOB_AGI);
	export_constant(UMOB_VIT);
	export_constant(UMOB_INT);
	export_constant(UMOB_DEX);
	export_constant(UMOB_LUK);
	export_constant(UMOB_SLAVECPYMSTRMD);
	export_constant(UMOB_DMGIMMUNE);
	export_constant(UMOB_ATKRANGE);
	export_constant(UMOB_ATKMIN);
	export_constant(UMOB_ATKMAX);
	export_constant(UMOB_MATKMIN);
	export_constant(UMOB_MATKMAX);
	export_constant(UMOB_DEF);
	export_constant(UMOB_MDEF);
	export_constant(UMOB_HIT);
	export_constant(UMOB_FLEE);
	export_constant(UMOB_PDODGE);
	export_constant(UMOB_CRIT);
	export_constant(UMOB_RACE);
	export_constant(UMOB_ELETYPE);
	export_constant(UMOB_ELELEVEL);
	export_constant(UMOB_AMOTION);
	export_constant(UMOB_ADELAY);
	export_constant(UMOB_DMOTION);

	/* unit control - homunculus */
	export_constant(UHOM_SIZE);
	export_constant(UHOM_LEVEL);
	export_constant(UHOM_HP);
	export_constant(UHOM_MAXHP);
	export_constant(UHOM_SP);
	export_constant(UHOM_MAXSP);
	export_constant(UHOM_MASTERCID);
	export_constant(UHOM_MAPID);
	export_constant(UHOM_X);
	export_constant(UHOM_Y);
	export_constant(UHOM_HUNGER);
	export_constant(UHOM_INTIMACY);
	export_constant(UHOM_SPEED);
	export_constant(UHOM_LOOKDIR);
	export_constant(UHOM_CANMOVETICK);
	export_constant(UHOM_STR);
	export_constant(UHOM_AGI);
	export_constant(UHOM_VIT);
	export_constant(UHOM_INT);
	export_constant(UHOM_DEX);
	export_constant(UHOM_LUK);
	export_constant(UHOM_DMGIMMUNE);
	export_constant(UHOM_ATKRANGE);
	export_constant(UHOM_ATKMIN);
	export_constant(UHOM_ATKMAX);
	export_constant(UHOM_MATKMIN);
	export_constant(UHOM_MATKMAX);
	export_constant(UHOM_DEF);
	export_constant(UHOM_MDEF);
	export_constant(UHOM_HIT);
	export_constant(UHOM_FLEE);
	export_constant(UHOM_PDODGE);
	export_constant(UHOM_CRIT);
	export_constant(UHOM_RACE);
	export_constant(UHOM_ELETYPE);
	export_constant(UHOM_ELELEVEL);
	export_constant(UHOM_AMOTION);
	export_constant(UHOM_ADELAY);
	export_constant(UHOM_DMOTION);

	/* unit control - pet */
	export_constant(UPET_SIZE);
	export_constant(UPET_LEVEL);
	export_constant(UPET_HP);
	export_constant(UPET_MAXHP);
	export_constant(UPET_MASTERAID);
	export_constant(UPET_MAPID);
	export_constant(UPET_X);
	export_constant(UPET_Y);
	export_constant(UPET_HUNGER);
	export_constant(UPET_INTIMACY);
	export_constant(UPET_SPEED);
	export_constant(UPET_LOOKDIR);
	export_constant(UPET_CANMOVETICK);
	export_constant(UPET_STR);
	export_constant(UPET_AGI);
	export_constant(UPET_VIT);
	export_constant(UPET_INT);
	export_constant(UPET_DEX);
	export_constant(UPET_LUK);
	export_constant(UPET_DMGIMMUNE);
	export_constant(UPET_ATKRANGE);
	export_constant(UPET_ATKMIN);
	export_constant(UPET_ATKMAX);
	export_constant(UPET_MATKMIN);
	export_constant(UPET_MATKMAX);
	export_constant(UPET_DEF);
	export_constant(UPET_MDEF);
	export_constant(UPET_HIT);
	export_constant(UPET_FLEE);
	export_constant(UPET_PDODGE);
	export_constant(UPET_CRIT);
	export_constant(UPET_RACE);
	export_constant(UPET_ELETYPE);
	export_constant(UPET_ELELEVEL);
	export_constant(UPET_AMOTION);
	export_constant(UPET_ADELAY);
	export_constant(UPET_DMOTION);

	/* unit control - mercenary */
	export_constant(UMER_SIZE);
	export_constant(UMER_HP);
	export_constant(UMER_MAXHP);
	export_constant(UMER_MASTERCID);
	export_constant(UMER_MAPID);
	export_constant(UMER_X);
	export_constant(UMER_Y);
	export_constant(UMER_KILLCOUNT);
	export_constant(UMER_LIFETIME);
	export_constant(UMER_SPEED);
	export_constant(UMER_LOOKDIR);
	export_constant(UMER_CANMOVETICK);
	export_constant(UMER_STR);
	export_constant(UMER_AGI);
	export_constant(UMER_VIT);
	export_constant(UMER_INT);
	export_constant(UMER_DEX);
	export_constant(UMER_LUK);
	export_constant(UMER_DMGIMMUNE);
	export_constant(UMER_ATKRANGE);
	export_constant(UMER_ATKMIN);
	export_constant(UMER_ATKMAX);
	export_constant(UMER_MATKMIN);
	export_constant(UMER_MATKMAX);
	export_constant(UMER_DEF);
	export_constant(UMER_MDEF);
	export_constant(UMER_HIT);
	export_constant(UMER_FLEE);
	export_constant(UMER_PDODGE);
	export_constant(UMER_CRIT);
	export_constant(UMER_RACE);
	export_constant(UMER_ELETYPE);
	export_constant(UMER_ELELEVEL);
	export_constant(UMER_AMOTION);
	export_constant(UMER_ADELAY);
	export_constant(UMER_DMOTION);

	/* unit control - elemental */
	export_constant(UELE_SIZE);
	export_constant(UELE_HP);
	export_constant(UELE_MAXHP);
	export_constant(UELE_SP);
	export_constant(UELE_MAXSP);
	export_constant(UELE_MASTERCID);
	export_constant(UELE_MAPID);
	export_constant(UELE_X);
	export_constant(UELE_Y);
	export_constant(UELE_LIFETIME);
	export_constant(UELE_MODE);
	export_constant(UELE_SPEED);
	export_constant(UELE_LOOKDIR);
	export_constant(UELE_CANMOVETICK);
	export_constant(UELE_STR);
	export_constant(UELE_AGI);
	export_constant(UELE_VIT);
	export_constant(UELE_INT);
	export_constant(UELE_DEX);
	export_constant(UELE_LUK);
	export_constant(UELE_DMGIMMUNE);
	export_constant(UELE_ATKRANGE);
	export_constant(UELE_ATKMIN);
	export_constant(UELE_ATKMAX);
	export_constant(UELE_MATKMIN);
	export_constant(UELE_MATKMAX);
	export_constant(UELE_DEF);
	export_constant(UELE_MDEF);
	export_constant(UELE_HIT);
	export_constant(UELE_FLEE);
	export_constant(UELE_PDODGE);
	export_constant(UELE_CRIT);
	export_constant(UELE_RACE);
	export_constant(UELE_ELETYPE);
	export_constant(UELE_ELELEVEL);
	export_constant(UELE_AMOTION);
	export_constant(UELE_ADELAY);
	export_constant(UELE_DMOTION);

	/* unit control - NPC */
	export_constant(UNPC_DISPLAY);
	export_constant(UNPC_LEVEL);
	export_constant(UNPC_HP);
	export_constant(UNPC_MAXHP);
	export_constant(UNPC_MAPID);
	export_constant(UNPC_X);
	export_constant(UNPC_Y);
	export_constant(UNPC_LOOKDIR);
	export_constant(UNPC_STR);
	export_constant(UNPC_AGI);
	export_constant(UNPC_VIT);
	export_constant(UNPC_INT);
	export_constant(UNPC_DEX);
	export_constant(UNPC_LUK);
	export_constant(UNPC_PLUSALLSTAT);
	export_constant(UNPC_DMGIMMUNE);
	export_constant(UNPC_ATKRANGE);
	export_constant(UNPC_ATKMIN);
	export_constant(UNPC_ATKMAX);
	export_constant(UNPC_MATKMIN);
	export_constant(UNPC_MATKMAX);
	export_constant(UNPC_DEF);
	export_constant(UNPC_MDEF);
	export_constant(UNPC_HIT);
	export_constant(UNPC_FLEE);
	export_constant(UNPC_PDODGE);
	export_constant(UNPC_CRIT);
	export_constant(UNPC_RACE);
	export_constant(UNPC_ELETYPE);
	export_constant(UNPC_ELELEVEL);
	export_constant(UNPC_AMOTION);
	export_constant(UNPC_ADELAY);
	export_constant(UNPC_DMOTION);

	export_constant(NAV_NONE);
	export_constant(NAV_AIRSHIP_ONLY);
	export_constant(NAV_SCROLL_ONLY);
	export_constant(NAV_AIRSHIP_AND_SCROLL);
	export_constant(NAV_KAFRA_ONLY);
	export_constant(NAV_KAFRA_AND_AIRSHIP);
	export_constant(NAV_KAFRA_AND_SCROLL);
	export_constant(NAV_ALL);

	export_constant(ADOPT_ALLOWED);
	export_constant(ADOPT_ALREADY_ADOPTED);
	export_constant(ADOPT_MARRIED_AND_PARTY);
	export_constant(ADOPT_EQUIP_RINGS);
	export_constant(ADOPT_NOT_NOVICE);
	export_constant(ADOPT_CHARACTER_NOT_FOUND);
	export_constant(ADOPT_MORE_CHILDREN);
	export_constant(ADOPT_LEVEL_70);
	export_constant(ADOPT_MARRIED);
	
	/* directions */
	export_constant(DIR_NORTH);
	export_constant(DIR_NORTHWEST);
	export_constant(DIR_WEST);
	export_constant(DIR_SOUTHWEST);
	export_constant(DIR_SOUTH);
	export_constant(DIR_SOUTHEAST);
	export_constant(DIR_EAST);
	export_constant(DIR_NORTHEAST);

	/* instance modes */
	export_constant(IM_NONE);
	export_constant(IM_CHAR);
	export_constant(IM_PARTY);
	export_constant(IM_GUILD);
	export_constant(IM_CLAN);

	/* mob random groups */
	export_constant(MOBG_Branch_Of_Dead_Tree);
	export_constant(MOBG_Poring_Box);
	export_constant(MOBG_Bloody_Dead_Branch);
	export_constant(MOBG_Red_Pouch_Of_Surprise);
	export_constant(MOBG_ClassChange);

	/* Item Random Option Group */
	export_constant(RDMOPTG_None);
	export_constant(RDMOPTG_Crimson_Weapon);

	/* random option attributes */
	export_constant(ROA_ID);
	export_constant(ROA_VALUE);
	export_constant(ROA_PARAM);

	export_constant(CARD0_FORGE);
	export_constant(CARD0_CREATE);
	export_constant(CARD0_PET);

	/* Channel System */
	export_constant(CHAN_TYPE_PUBLIC);
	export_constant(CHAN_TYPE_PRIVATE);
	export_constant(CHAN_TYPE_MAP);
	export_constant(CHAN_TYPE_ALLY);
	export_constant(CHAN_OPT_BASE);
	export_constant(CHAN_OPT_ANNOUNCE_SELF);
	export_constant(CHAN_OPT_ANNOUNCE_JOIN);
	export_constant(CHAN_OPT_ANNOUNCE_LEAVE);
	export_constant(CHAN_OPT_MSG_DELAY);
	export_constant(CHAN_OPT_COLOR_OVERRIDE);
	export_constant(CHAN_OPT_CAN_CHAT);
	export_constant(CHAN_OPT_CAN_LEAVE);
	export_constant(CHAN_OPT_AUTOJOIN);

	export_constant(STOR_MODE_NONE);
	export_constant(STOR_MODE_GET);
	export_constant(STOR_MODE_PUT);
	
	/* instance enter */
	export_constant(IE_OK);
	export_constant(IE_NOMEMBER);
	export_constant(IE_NOINSTANCE);
	export_constant(IE_OTHER);
	
	/* months */
	export_constant(JANUARY);
	export_constant(FEBRUARY);
	export_constant(MARCH);
	export_constant(APRIL);
	export_constant(MAY);
	export_constant(JUNE);
	export_constant(JULY);
	export_constant(AUGUST);
	export_constant(SEPTEMBER);
	export_constant(OCTOBER);
	export_constant(NOVEMBER);
	export_constant(DECEMBER);
	
	/* days of the week */
	export_constant(SUNDAY);
	export_constant(MONDAY);
	export_constant(TUESDAY);
	export_constant(WEDNESDAY);
	export_constant(THURSDAY);
	export_constant(FRIDAY);
	export_constant(SATURDAY);
	
	/* date types */
	export_constant(DT_SECOND);
	export_constant(DT_MINUTE);
	export_constant(DT_HOUR);
	export_constant(DT_DAYOFWEEK);
	export_constant(DT_DAYOFMONTH);
	export_constant(DT_MONTH);
	export_constant(DT_YEAR);
	export_constant(DT_DAYOFYEAR);

	/* instance info */
	export_constant(IIT_ID);
	export_constant(IIT_TIME_LIMIT);
	export_constant(IIT_IDLE_TIMEOUT);
	export_constant(IIT_ENTER_MAP);
	export_constant(IIT_ENTER_X);
	export_constant(IIT_ENTER_Y);
	export_constant(IIT_MAPCOUNT);
	export_constant(IIT_MAP);

	/* VIP status */
	export_constant(VIP_STATUS_ACTIVE);
	export_constant(VIP_STATUS_EXPIRE);
	export_constant(VIP_STATUS_REMAINING);

	/* item groups */
	export_constant(IG_BLUEBOX);
	export_constant(IG_VIOLETBOX);
	export_constant(IG_CARDALBUM);
	export_constant(IG_GIFTBOX);
	export_constant(IG_SCROLLBOX);
	export_constant(IG_FINDINGORE);
	export_constant(IG_COOKIEBAG);
	export_constant(IG_FIRSTAID);
	export_constant(IG_HERB);
	export_constant(IG_FRUIT);
	export_constant(IG_MEAT);
	export_constant(IG_CANDY);
	export_constant(IG_JUICE);
	export_constant(IG_FISH);
	export_constant(IG_BOX);
	export_constant(IG_GEMSTONE);
	export_constant(IG_RESIST);
	export_constant(IG_ORE);
	export_constant(IG_FOOD);
	export_constant(IG_RECOVERY);
	export_constant(IG_MINERAL);
	export_constant(IG_TAMING);
	export_constant(IG_SCROLL);
	export_constant(IG_QUIVER);
	export_constant(IG_MASK);
	export_constant(IG_ACCESORY);
	export_constant(IG_JEWEL);
	export_constant(IG_GIFTBOX_1);
	export_constant(IG_GIFTBOX_2);
	export_constant(IG_GIFTBOX_3);
	export_constant(IG_GIFTBOX_4);
	export_constant(IG_EGGBOY);
	export_constant(IG_EGGGIRL);
	export_constant(IG_GIFTBOXCHINA);
	export_constant(IG_LOTTOBOX);
	export_constant(IG_FOODBAG);
	export_constant(IG_POTION);
	export_constant(IG_REDBOX_2);
	export_constant(IG_BLEUBOX);
	export_constant(IG_REDBOX);
	export_constant(IG_GREENBOX);
	export_constant(IG_YELLOWBOX);
	export_constant(IG_OLDGIFTBOX);
	export_constant(IG_MAGICCARDALBUM);
	export_constant(IG_HOMETOWNGIFT);
	export_constant(IG_MASQUERADE);
	export_constant(IG_TRESURE_BOX_WOE);
	export_constant(IG_MASQUERADE_2);
	export_constant(IG_EASTER_SCROLL);
	export_constant(IG_PIERRE_TREASUREBOX);
	export_constant(IG_CHERISH_BOX);
	export_constant(IG_CHERISH_BOX_ORI);
	export_constant(IG_LOUISE_COSTUME_BOX);
	export_constant(IG_XMAS_GIFT);
	export_constant(IG_FRUIT_BASKET);
	export_constant(IG_IMPROVED_COIN_BAG);
	export_constant(IG_INTERMEDIATE_COIN_BAG);
	export_constant(IG_MINOR_COIN_BAG);
	export_constant(IG_S_GRADE_COIN_BAG);
	export_constant(IG_A_GRADE_COIN_BAG);
	export_constant(IG_ADVANCED_WEAPONS_BOX);
	export_constant(IG_SPLENDID_BOX);
	export_constant(IG_CARDALBUM_ARMOR);
	export_constant(IG_CARDALBUM_HELM);
	export_constant(IG_CARDALBUM_ACC);
	export_constant(IG_CARDALBUM_SHOES);
	export_constant(IG_CARDALBUM_SHIELD);
	export_constant(IG_CARDALBUM_WEAPON);
	export_constant(IG_CARDALBUM_GARMENT);
	export_constant(IG_FLAMEL_CARD);
	export_constant(IG_SPECIAL_BOX);
	export_constant(IG_TRESURE_BOX_WOE_);
	export_constant(IG_RWC_PARTI_BOX);
	export_constant(IG_RWC_FINAL_COMP_BOX);
	export_constant(IG_GIFT_BUNDLE);
	export_constant(IG_CARACAS_RING_BOX);
	export_constant(IG_CRUMPLED_PAPER);
	export_constant(IG_SOLO_GIFT_BASKET);
	export_constant(IG_COUPLE_EVENT_BASKET);
	export_constant(IG_GM_WARP_BOX);
	export_constant(IG_FORTUNE_COOKIE1);
	export_constant(IG_FORTUNE_COOKIE2);
	export_constant(IG_FORTUNE_COOKIE3);
	export_constant(IG_NEW_GIFT_ENVELOPE);
	export_constant(IG_PASSION_FB_HAT_BOX);
	export_constant(IG_COOL_FB_HAT_BOX);
	export_constant(IG_VICTORY_FB_HAT_BOX);
	export_constant(IG_GLORY_FB_HAT_BOX);
	export_constant(IG_PASSION_HAT_BOX2);
	export_constant(IG_COOL_HAT_BOX2);
	export_constant(IG_VICTORY_HAT_BOX2);
	export_constant(IG_ASPERSIO_5_SCROLL_BOX);
	export_constant(IG_PET_EGG_SCROLL_BOX1);
	export_constant(IG_PET_EGG_SCROLL_BOX2);
	export_constant(IG_PET_EGG_SCROLL1);
	export_constant(IG_PET_EGG_SCROLL2);
	export_constant(IG_PET_EGG_SCROLL_BOX3);
	export_constant(IG_PET_EGG_SCROLL_BOX4);
	export_constant(IG_PET_EGG_SCROLL_BOX5);
	export_constant(IG_PET_EGG_SCROLL3);
	export_constant(IG_PET_EGG_SCROLL4);
	export_constant(IG_PET_EGG_SCROLL5);
	export_constant(IG_INFILTRATOR_BOX);
	export_constant(IG_MURAMASA_BOX);
	export_constant(IG_EXCALIBUR_BOX);
	export_constant(IG_COMBAT_KNIFE_BOX);
	export_constant(IG_COUNTER_DAGGER_BOX);
	export_constant(IG_KAISER_KNUCKLE_BOX);
	export_constant(IG_POLE_AXE_BOX);
	export_constant(IG_MIGHTY_STAFF_BOX);
	export_constant(IG_RIGHT_EPSILON_BOX);
	export_constant(IG_BALISTAR_BOX);
	export_constant(IG_DIARY_OF_GREAT_SAGE_BOX);
	export_constant(IG_ASURA_BOX);
	export_constant(IG_APPLE_OF_ARCHER_BOX);
	export_constant(IG_BUNNY_BAND_BOX);
	export_constant(IG_SAHKKAT_BOX);
	export_constant(IG_LORD_CIRCLET_BOX);
	export_constant(IG_ELVEN_EARS_BOX);
	export_constant(IG_STEEL_FLOWER_BOX);
	export_constant(IG_CRITICAL_RING_BOX);
	export_constant(IG_EARRING_BOX);
	export_constant(IG_RING_BOX);
	export_constant(IG_NECKLACE_BOX);
	export_constant(IG_GLOVE_BOX);
	export_constant(IG_BROOCH_BOX);
	export_constant(IG_ROSARY_BOX);
	export_constant(IG_SAFETY_RING_BOX);
	export_constant(IG_VESPER_CORE01_BOX);
	export_constant(IG_VESPER_CORE02_BOX);
	export_constant(IG_VESPER_CORE03_BOX);
	export_constant(IG_VESPER_CORE04_BOX);
	export_constant(IG_PET_EGG_SCROLL_BOX6);
	export_constant(IG_PET_EGG_SCROLL_BOX7);
	export_constant(IG_PET_EGG_SCROLL_BOX8);
	export_constant(IG_PET_EGG_SCROLL_BOX9);
	export_constant(IG_PET_EGG_SCROLL_BOX10);
	export_constant(IG_PET_EGG_SCROLL_BOX11);
	export_constant(IG_PET_EGG_SCROLL6);
	export_constant(IG_PET_EGG_SCROLL7);
	export_constant(IG_PET_EGG_SCROLL8);
	export_constant(IG_PET_EGG_SCROLL9);
	export_constant(IG_PET_EGG_SCROLL10);
	export_constant(IG_PET_EGG_SCROLL11);
	export_constant(IG_CP_HELM_SCROLL_BOX);
	export_constant(IG_CP_SHIELD_SCROLL_BOX);
	export_constant(IG_CP_ARMOR_SCROLL_BOX);
	export_constant(IG_CP_WEAPON_SCROLL_BOX);
	export_constant(IG_REPAIR_SCROLL_BOX);
	export_constant(IG_SUPER_PET_EGG1);
	export_constant(IG_SUPER_PET_EGG2);
	export_constant(IG_SUPER_PET_EGG3);
	export_constant(IG_SUPER_PET_EGG4);
	export_constant(IG_SUPER_CARD_PET_EGG1);
	export_constant(IG_SUPER_CARD_PET_EGG2);
	export_constant(IG_SUPER_CARD_PET_EGG3);
	export_constant(IG_SUPER_CARD_PET_EGG4);
	export_constant(IG_VIGORGRA_PACKAGE1);
	export_constant(IG_VIGORGRA_PACKAGE2);
	export_constant(IG_VIGORGRA_PACKAGE3);
	export_constant(IG_VIGORGRA_PACKAGE4);
	export_constant(IG_VIGORGRA_PACKAGE5);
	export_constant(IG_VIGORGRA_PACKAGE6);
	export_constant(IG_VIGORGRA_PACKAGE7);
	export_constant(IG_VIGORGRA_PACKAGE8);
	export_constant(IG_VIGORGRA_PACKAGE9);
	export_constant(IG_VIGORGRA_PACKAGE10);
	export_constant(IG_VIGORGRA_PACKAGE11);
	export_constant(IG_VIGORGRA_PACKAGE12);
	export_constant(IG_PET_EGG_SCROLL12);
	export_constant(IG_PET_EGG_SCROLL13);
	export_constant(IG_PET_EGG_SCROLL14);
	export_constant(IG_SUPER_PET_EGG5);
	export_constant(IG_SUPER_PET_EGG6);
	export_constant(IG_SUPER_PET_EGG7);
	export_constant(IG_SUPER_PET_EGG8);
	export_constant(IG_PET_EGG_SCROLL_E);
	export_constant(IG_RAMEN_HAT_BOX);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK1);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK2);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK3);
	export_constant(IG_MYSTERIOUS_TRAVEL_SACK4);
	export_constant(IG_MAGICIAN_CARD_BOX);
	export_constant(IG_ACOLYTE_CARD_BOX);
	export_constant(IG_ARCHER_CARD_BOX);
	export_constant(IG_SWORDMAN_CARD_BOX);
	export_constant(IG_THIEF_CARD_BOX);
	export_constant(IG_MERCHANT_CARD_BOX);
	export_constant(IG_HARD_CORE_SET_BOX);
	export_constant(IG_KITTY_SET_BOX);
	export_constant(IG_SOFT_CORE_SET_BOX);
	export_constant(IG_DEVIRUCHI_SET_BOX);
	export_constant(IG_MVP_HUNT_BOX);
	export_constant(IG_BREWING_BOX);
	export_constant(IG_XMAS_PET_SCROLL);
	export_constant(IG_LUCKY_SCROLL08);
	export_constant(IG_BR_SWORDPACKAGE);
	export_constant(IG_BR_MAGEPACKAGE);
	export_constant(IG_BR_ACOLPACKAGE);
	export_constant(IG_BR_ARCHERPACKAGE);
	export_constant(IG_BR_MERPACKAGE);
	export_constant(IG_BR_THIEFPACKAGE);
	export_constant(IG_ACIDBOMB_10_BOX);
	export_constant(IG_BASIC_SIEGE_SUPPLY_BOX);
	export_constant(IG_ADV_SIEGE_SUPPLY_BOX);
	export_constant(IG_ELITE_SIEGE_SUPPLY_BOX);
	export_constant(IG_SAKURA_SCROLL);
	export_constant(IG_BEHOLDER_RING_BOX);
	export_constant(IG_HALLOW_RING_BOX);
	export_constant(IG_CLAMOROUS_RING_BOX);
	export_constant(IG_CHEMICAL_RING_BOX);
	export_constant(IG_INSECTICIDE_RING_BOX);
	export_constant(IG_FISHER_RING_BOX);
	export_constant(IG_DECUSSATE_RING_BOX);
	export_constant(IG_BLOODY_RING_BOX);
	export_constant(IG_SATANIC_RING_BOX);
	export_constant(IG_DRAGOON_RING_BOX);
	export_constant(IG_ANGEL_SCROLL);
	export_constant(IG_DEVIL_SCROLL);
	export_constant(IG_SURPRISE_SCROLL);
	export_constant(IG_JULY7_SCROLL);
	export_constant(IG_BACSOJIN_SCROLL);
	export_constant(IG_ANIMAL_SCROLL);
	export_constant(IG_HEART_SCROLL);
	export_constant(IG_NEW_YEAR_SCROLL);
	export_constant(IG_VALENTINE_PLEDGE_BOX);
	export_constant(IG_OX_TAIL_SCROLL);
	export_constant(IG_BUDDAH_SCROLL);
	export_constant(IG_EVIL_INCARNATION);
	export_constant(IG_F_CLOVER_BOX_MOUTH);
	export_constant(IG_MOUTH_BUBBLE_GUM_BOX);
	export_constant(IG_F_CLOVER_BOX_MOUTH2);
	export_constant(IG_F_CLOVER_BOX_MOUTH4);
	export_constant(IG_BGUM_BOX_IN_MOUTH2);
	export_constant(IG_BGUM_BOX_IN_MOUTH4);
	export_constant(IG_TW_OCTOBER_SCROLL);
	export_constant(IG_MY_SCROLL1);
	export_constant(IG_TW_NOV_SCROLL);
	export_constant(IG_MY_SCROLL2);
	export_constant(IG_PR_RESET_STONE_BOX);
	export_constant(IG_FPR_RESET_STONE_BOX);
	export_constant(IG_MAJESTIC_DEVIL_SCROLL);
	export_constant(IG_LIFE_RIBBON_BOX);
	export_constant(IG_LIFE_RIBBON_BOX2);
	export_constant(IG_LIFE_RIBBON_BOX3);
	export_constant(IG_MAGIC_CANDY_BOX10);
	export_constant(IG_RWC2010_SUITCASEA);
	export_constant(IG_RWC2010_SUITCASEB);
	export_constant(IG_SAGITTARIUS_SCROLL);
	export_constant(IG_SAGITTARIUS_SCR_BOX);
	export_constant(IG_SAGITTAR_DIADEM_SCROLL);
	export_constant(IG_SAGITTAR_DI_SCROLL_BOX);
	export_constant(IG_CAPRI_CROWN_SCROLL);
	export_constant(IG_CAPRI_CROWN_SCROLL_BOX);
	export_constant(IG_CAPRICON_DI_SCROLL);
	export_constant(IG_CAPRICON_DI_SCROLL_BOX);
	export_constant(IG_AQUARIUS_DIADEM_SCROLL);
	export_constant(IG_AQUARIUS_DI_SCROLL_BOX);
	export_constant(IG_LOVELY_AQUARIUS_SCROLL);
	export_constant(IG_LOVELY_AQUARIUS_BOX);
	export_constant(IG_PISCES_DIADEM_SCROLL);
	export_constant(IG_PISCES_DIADEM_BOX);
	export_constant(IG_ENERGETIC_PISCES_SCROLL);
	export_constant(IG_ENERGETIC_PISCES_BOX);
	export_constant(IG_ARIES_SCROLL);
	export_constant(IG_ARIES_SCROLL_BOX);
	export_constant(IG_BOARDING_HALTER_BOX);
	export_constant(IG_TAURUS_DIADEM_SCROLL);
	export_constant(IG_TAURUS_DI_SCROLL_BOX);
	export_constant(IG_UMBALA_SPIRIT_BOX2);
	export_constant(IG_F_UMBALA_SPIRIT_BOX2);
	export_constant(IG_TAURUS_CROWN_SCROLL);
	export_constant(IG_TAURUS_CROWN_SCROLL_BOX);
	export_constant(IG_GEMI_DIADEM_SCROLL);
	export_constant(IG_GEMI_DIADEM_SCROLL_BOX);
	export_constant(IG_SUPER_PET_EGG1_2);
	export_constant(IG_SUPER_PET_EGG4_2);
	export_constant(IG_FIRE_BRAND_BOX);
	export_constant(IG_BR_INDEPENDENCE_SCROLL);
	export_constant(IG_ALL_IN_ONE_RING_BOX);
	export_constant(IG_GEMI_CROWN_SCROLL);
	export_constant(IG_GEMI_CROWN_SCROLL_BOX);
	export_constant(IG_RWC_SPECIAL_SCROLL);
	export_constant(IG_RWC_LIMITED_SCROLL);
	export_constant(IG_ASGARD_SCROLL);
	export_constant(IG_MS_CANCER_SCROLL);
	export_constant(IG_RWC_SUPER_SCROLL);
	export_constant(IG_LEO_SCROLL);
	export_constant(IG_MS_VIRGO_SCROLL);
	export_constant(IG_LUCKY_EGG_C6);
	export_constant(IG_LIBRA_SCROLL);
	export_constant(IG_HALLO_SCROLL);
	export_constant(IG_MS_SCORPIO_SCROLL);
	export_constant(IG_TCG_CARD_SCROLL);
	export_constant(IG_BOITATA_SCROLL);
	export_constant(IG_LUCKY_EGG_C2);
	export_constant(IG_LUCKY_EGG_C6_);
	export_constant(IG_LUCKY_EGG_C9);
	export_constant(IG_LUCKY_EGG_C7);
	export_constant(IG_LUCKY_EGG_C8);
	export_constant(IG_LUCKY_EGG_C10);
	export_constant(IG_WIND_TYPE_SCROLL);
	export_constant(IG_LUCKY_EGG_C3);
	export_constant(IG_LUCKY_EGG_C4);
	export_constant(IG_LUCKY_EGG_C5);
	export_constant(IG_WEATHER_REPORT_BOX);
	export_constant(IG_COMIN_ACTOR_BOX);
	export_constant(IG_HEN_SET_BOX);
	export_constant(IG_LUCKY_EGG_C);
	export_constant(IG_WATER_TYPE_SCROLL);
	export_constant(IG_EARTH_TYPE_SCROLL);
	export_constant(IG_EARTH_TYPE_SCROLL_);
	export_constant(IG_SPLASH_SCROLL);
	export_constant(IG_VOCATION_SCROLL);
	export_constant(IG_WISDOM_SCROLL);
	export_constant(IG_PATRON_SCROLL);
	export_constant(IG_HEAVEN_SCROLL);
	export_constant(IG_TW_AUG_SCROLL);
	export_constant(IG_TW_NOV_SCROLL2);
	export_constant(IG_ILLUSION_NOTHING);
	export_constant(IG_TW_SEP_SCROLL);
	export_constant(IG_FLAME_LIGHT);
	export_constant(IG_TW_RAINBOW_SCROLL);
	export_constant(IG_TW_RED_SCROLL);
	export_constant(IG_TW_ORANGE_SCROLL);
	export_constant(IG_TW_YELLOW_SCROLL);
	export_constant(IG_SCROLL_OF_DEATH);
	export_constant(IG_SCROLL_OF_LIFE);
	export_constant(IG_SCROLL_OF_MAGIC);
	export_constant(IG_SCROLL_OF_THEWS);
	export_constant(IG_SCROLL_OF_DARKNESS);
	export_constant(IG_SCROLL_OF_HOLINESS);
	export_constant(IG_HORNED_SCROLL);
	export_constant(IG_MERCURY_SCROLL);
	export_constant(IG_CHALLENGE_KIT);
	export_constant(IG_TW_APRIL_SCROLL);
	export_constant(IG_TW_OCTOBER_SCROLL_);
	export_constant(IG_SUMMER_SCROLL3);
	export_constant(IG_C_WING_OF_FLY_3DAY_BOX);
	export_constant(IG_RWC_2012_SET_BOX);
	export_constant(IG_EX_DEF_POTION_BOX);
	export_constant(IG_RWC_SCROLL_2012);
	export_constant(IG_OLD_COIN_POCKET);
	export_constant(IG_HIGH_COIN_POCKET);
	export_constant(IG_MID_COIN_POCKET);
	export_constant(IG_LOW_COIN_POCKET);
	export_constant(IG_SGRADE_POCKET);
	export_constant(IG_AGRADE_POCKET);
	export_constant(IG_BGRADE_POCKET);
	export_constant(IG_CGRADE_POCKET);
	export_constant(IG_DGRADE_POCKET);
	export_constant(IG_EGRADE_POCKET);
	export_constant(IG_PTOTECTION_SEAGOD_BOX);
	export_constant(IG_HAIRTAIL_BOX1);
	export_constant(IG_HAIRTAIL_BOX2);
	export_constant(IG_SPEARFISH_BOX1);
	export_constant(IG_SPEARFISH_BOX2);
	export_constant(IG_SAUREL_BOX1);
	export_constant(IG_SAUREL_BOX2);
	export_constant(IG_TUNA_BOX1);
	export_constant(IG_TUNA_BOX2);
	export_constant(IG_MALANG_CRAB_BOX1);
	export_constant(IG_MALANG_CRAB_BOX2);
	export_constant(IG_BRINDLE_EEL_BOX1);
	export_constant(IG_BRINDLE_EEL_BOX2);
	export_constant(IG_PTOTECTION_SEAGOD_BOX2);
	export_constant(IG_PTOTECTION_SEAGOD_BOX3);
	export_constant(IG_OCTO_HSTICK_BOX);
	export_constant(IG_OCTO_HSTICK_BOX2);
	export_constant(IG_OCTO_HSTICK_BOX3);
	export_constant(IG_SILVERVINE_FRUIT_BOX10);
	export_constant(IG_SILVERVINE_FRUIT_BOX40);
	export_constant(IG_SILVERVINE_FRUIT_BOX4);
	export_constant(IG_MALANG_WOE_ENCARD_BOX);
	export_constant(IG_XMAS_BLESS);
	export_constant(IG_FIRE_TYPE_SCROLL);
	export_constant(IG_BLUE_SCROLL);
	export_constant(IG_GOOD_STUDENT_GIFT_BOX);
	export_constant(IG_BAD_STUDENT_GIFT_BOX);
	export_constant(IG_INDIGO_SCROLL);
	export_constant(IG_VIOLET_SCROLL);
	export_constant(IG_BI_HWANG_SCROLL);
	export_constant(IG_JUNG_BI_SCROLL);
	export_constant(IG_JE_UN_SCROLL);
	export_constant(IG_YONG_KWANG_SCROLL);
	export_constant(IG_HALLOWEEN_G_BOX);
	export_constant(IG_SOLO_CHRISTMAS_GIFT);
	export_constant(IG_SG_WEAPON_SUPPLY_BOX);
	export_constant(IG_CANDY_HOLDER);
	export_constant(IG_LUCKY_BAG);
	export_constant(IG_HOLY_EGG_2);
	export_constant(IG_ADVENTURER_RETURNS_SUPPORT_BOX);
	export_constant(IG_SUPPORT_PACKAGE);
	export_constant(IG_SUPPORT_PACKAGE_10);
	export_constant(IG_EVENT_ALMIGHTY_BOX);
	export_constant(IG_EVENT_ALMIGHTY_BOX_100);
	export_constant(IG_LOTTOBOX1);
	export_constant(IG_LOTTOBOX2);
	export_constant(IG_LOTTOBOX3);
	export_constant(IG_LOTTOBOX4);
	export_constant(IG_LOTTOBOX5);
	export_constant(IG_SUPPORT_PACKAGE_III);
	export_constant(IG_SUPPORT_PACKAGE_III_10);
	export_constant(IG_UNLIMITED_BOX);
	export_constant(IG_UNLIMITED_BOX_10);
	export_constant(IG_UNLIMITED_BOX_II);
	export_constant(IG_UNLIMITED_BOX_II_10);
	export_constant(IG_THREE_MASTER_PACKAGE_III);
	export_constant(IG_THREE_MASTER_PACKAGE_III_10);
	export_constant(IG_2013_RWC_SCROLL);
	export_constant(IG_SUPPORT_PACKAGE_II);
	export_constant(IG_SUPPORT_PACKAGE_II_10);
	export_constant(IG_LEVEL_UP_BOX100);
	export_constant(IG_LEVEL_UP_BOX120);
	export_constant(IG_LEVEL_UP_BOX130);
	export_constant(IG_LEVEL_UP_BOX140);
	export_constant(IG_LEVEL_UP_BOX150);
	export_constant(IG_LEVEL_UP_BOX160);
	export_constant(IG_GIFT_BUFF_SET);
	export_constant(IG_LUCKY_SILVERVINE_FRUIT_BOX_III10);
	export_constant(IG_LUCKY_SILVERVINE_FRUIT_BOX_III110);
	export_constant(IG_OLD_ORE_BOX);
	export_constant(IG_BLESSING_LUCKY_SCROLL);
	export_constant(IG_SOGRAT_LUCKY_SCROLL);
	export_constant(IG_GARNET_LUCKY_SCROLL);
	export_constant(IG_AMORA_LUCKY_SCROLL);
	export_constant(IG_VENUS_LUCKY_SCROLL);
	export_constant(IG_ERZULIE_LUCKY_SCROLL);
	export_constant(IG_MAJESTIC_LUCKY_SCROLL);
	export_constant(IG_EPIC_HEROES_LUCKY_EGG);
	export_constant(IG_HERO_MIDGARD_EGG);
	export_constant(IG_IMORTAL_MIDGARD_SCROLL);
	export_constant(IG_TW_13Y_LUCKY_EGG_06);
	export_constant(IG_HAPPY_TIME_SCROLL);
	export_constant(IG_TIME_TRAVEL_SCROLL);
	export_constant(IG_SOLARIS_FESTIVAL_SCROLL);
	export_constant(IG_MIDGARD_FES_SCROLL);
	export_constant(IG_MIDGARD_SCROLL);
	export_constant(IG_SWEET_MIDGARD_SCROLL);
	export_constant(IG_WINTER_MIDGARD_SCROLL);
	export_constant(IG_SPRING_FESTIVAL_SCROLL);
	export_constant(IG_IDRO10TH_SCROLL);
	export_constant(IG_REQUIEM_SCROLL);
	export_constant(IG_HOLY_SPIRIT_SCROLL);
	export_constant(IG_GARUDA_SCROLL);
	export_constant(IG_THANKS_GIVING_SCROLL);
	export_constant(IG_IDN_LEGEND_HERO_SCROLL);
	export_constant(IG_BLESSING_MIDGARD_SCROLL);
	export_constant(IG_CHRONOSIAN_LUCKY_SCROLL);
	export_constant(IG_SANCTUARY_LUCKY_SCROLL);
	export_constant(IG_CYBORG_LUCKY_SCROLL);
	export_constant(IG_UNDINE_LUCKY_SCROLL);
	export_constant(IG_GOD_MATERIAL_BOX);
	export_constant(IG_SEALED_MIND_BOX);
	export_constant(IG_COSTAMA_EGG18);
	export_constant(IG_COSTAMA_EGG19);
	export_constant(IG_FLOWER_BLOSSOM_SCROLL);
	export_constant(IG_COSTAMA_EGG24);
	export_constant(IG_SMITHY_LUCKY_SCROLL);
	export_constant(IG_GANYMEDE_LUCKY_SCROLL);
	export_constant(IG_LASTANGEL_LUCKYSCROLL);
	export_constant(IG_VALKYRIE_LUCKY_SCROLL);
	export_constant(IG_SPLASH_RAINBOW_LUCKY_SCROLL);
	export_constant(IG_SHAPESHIFTER_COSTUME);
	export_constant(IG_JULY_LUCKY_SCROLL);
	export_constant(IG_COSTAMA_EGG23);
	export_constant(IG_COSTAMA_EGG28);
	export_constant(IG_MIDGARD_LUCKY_SCROLL);
	export_constant(IG_BLESSING_SCARLET_SCROLL);
	export_constant(IG_COSTAMA_EGG29);
	export_constant(IG_INK_BALL);
	export_constant(IG_SOMETHING_CANDY_HOLDER);
	export_constant(IG_MYSTERIOUS_EGG);
	export_constant(IG_AGUST_LUCKY_SCROLL);
	export_constant(IG_ELEMENT);
	export_constant(IG_POISON);
	export_constant(IG_CASH_FOOD);
	export_constant(IG_BOMB);
	export_constant(IG_THROWABLE);
	export_constant(IG_MERCENARY);
	export_constant(IG_NOIVE_BOX);
	export_constant(IG_VALERIAN_SCROLL);
	export_constant(IG_IMMORTAL_EGG);
	export_constant(IG_SAPPHIRE_EGG);
	export_constant(IG_IDN_HEART_SCROLL);
	export_constant(IG_IDN_WISDOM_EGG);
	export_constant(IG_CHRISTMAS_BOX);
	export_constant(IG_SPECIAL_CHRISTMAS_BOX);
	export_constant(IG_SANTA_GIFT);

	/* unit stop walking */
	export_constant(USW_NONE);
	export_constant(USW_FIXPOS);
	export_constant(USW_MOVE_ONCE);
	export_constant(USW_MOVE_FULL_CELL);
	export_constant(USW_FORCE_STOP);
	export_constant(USW_ALL);

	/* achievement groups */
	export_constant2("AG_ADD_FRIEND", AG_ADD_FRIEND);
	export_constant2("AG_ADVENTURE", AG_ADVENTURE);
	export_constant2("AG_BABY", AG_BABY);
	export_constant2("AG_BATTLE", AG_BATTLE);
	export_constant2("AG_CHATTING", AG_CHAT);
	export_constant2("AG_CHATTING_COUNT", AG_CHAT_COUNT);
	export_constant2("AG_CHATTING_CREATE", AG_CHAT_CREATE);
	export_constant2("AG_CHATTING_DYING", AG_CHAT_DYING);
	export_constant2("AG_EAT", AG_EAT);
	export_constant2("AG_GET_ITEM", AG_GET_ITEM);
	export_constant2("AG_GET_ZENY", AG_GET_ZENY);
	export_constant2("AG_GOAL_ACHIEVE", AG_GOAL_ACHIEVE);
	export_constant2("AG_GOAL_LEVEL", AG_GOAL_LEVEL);
	export_constant2("AG_GOAL_STATUS", AG_GOAL_STATUS);
	export_constant2("AG_HEAR", AG_HEAR);
	export_constant2("AG_JOB_CHANGE", AG_JOB_CHANGE);
	export_constant2("AG_MARRY", AG_MARRY);
	export_constant2("AG_PARTY", AG_PARTY);
	export_constant2("AG_ENCHANT_FAIL", AG_REFINE_FAIL);
	export_constant2("AG_ENCHANT_SUCCESS", AG_REFINE_SUCCESS);
	export_constant2("AG_SEE", AG_SEE);
	export_constant2("AG_SPEND_ZENY", AG_SPEND_ZENY);
	export_constant2("AG_TAMING", AG_TAMING);

	/* achievement info */
	export_constant(ACHIEVEINFO_COUNT1);
	export_constant(ACHIEVEINFO_COUNT2);
	export_constant(ACHIEVEINFO_COUNT3);
	export_constant(ACHIEVEINFO_COUNT4);
	export_constant(ACHIEVEINFO_COUNT5);
	export_constant(ACHIEVEINFO_COUNT6);
	export_constant(ACHIEVEINFO_COUNT7);
	export_constant(ACHIEVEINFO_COUNT8);
	export_constant(ACHIEVEINFO_COUNT9);
	export_constant(ACHIEVEINFO_COUNT10);
	export_constant(ACHIEVEINFO_COMPLETE);
	export_constant(ACHIEVEINFO_COMPLETEDATE);
	export_constant(ACHIEVEINFO_GOTREWARD);
	export_constant(ACHIEVEINFO_LEVEL);
	export_constant(ACHIEVEINFO_SCORE);
	export_constant(ACHIEVEINFO_MAX);

	/* refine cost types */
	export_constant(REFINE_COST_NORMAL);
	export_constant(REFINE_COST_OVER10);
	export_constant(REFINE_COST_HD);
	export_constant(REFINE_COST_ENRICHED);
	export_constant(REFINE_COST_OVER10_HD);
	export_constant(REFINE_COST_MAX);

	/* refine information types */
	script_set_constant("REFINE_MATERIAL_ID", 0, false, false);
	script_set_constant("REFINE_ZENY_COST", 1, false, false);

	#undef export_constant
	#undef export_constant2
	#undef export_parameter

#endif /* _SCRIPT_CONSTANTS_H_ */
