package my.codeiq.refactor.n.shape;

import my.codeiq.refactor.n.shape.animate.Animate;

import java.awt.Color;
import java.awt.Graphics;


public abstract class Shape {
    /** X座標 */
    public double x;
    /** Y座標 */
    public double y;
    /** Z座標 */
    public double z;
    /** 半径(大きさ)*/
    public double r;
    /** 図形の色 */
    public Color color;
    /** 図形の移動 */
    public Animate animate;
    
    /**
     * コンストラクタ
     */
    public Shape() {
        this(0, 0, 0, 0, null);
    }

    /**
     * コンストラクタ
     * 
     * @param x
     *            X 座標
     * @param y
     *            Y 座標
     * @param z
     *            Z 座標
     * @param radius
     *            半径 (大きさ)
     * @param color
     *            色
     */
    public Shape(double x, double y, double z, double radius, Color color) {
        this(x, y, z, radius, color, null);
    }

    /**
     * コンストラクタ
     * 
     * @param x
     *            X 座標
     * @param y
     *            Y 座標
     * @param z
     *            Z 座標
     * @param radius
     *            半径 (大きさ)
     * @param color
     *            色
     * @param animate
     *            移動
     */
    public Shape(double x, double y, double z, double radius, Color color, Animate animate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = radius;
        this.color = color;
        this.animate = animate;
    }

    /**
     * 現在位置に合わせて画面上に描画する
     * 
     * @param g
     *            グラフィック・コンテキスト
     */
    public abstract void draw(Graphics g, double x, double y, double r);
    
    /**
     * 図形の位置を動かす
     * 
     * @param id
     *            動かす図形の識別番号
     * @param x
     *            X 座標
     * @param y
     *            Y 座標
     * @param z
     *            Z 座標
     */
    public void move(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    /**
     * 図形を動かす
     */
    public void animate() {
        if (animate != null) {
            animate.move(this);
        }
    }
}
