/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class JdbcBlobTest {

    public JdbcBlobTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }


    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";
    
    private static Connection newConnection() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return DriverManager.getConnection("jdbc:sqlite:file:" + DATABASE);
    }
    
    @Test
    public void position() throws ClassNotFoundException, SQLException, UnsupportedEncodingException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL"
                        + ", VALUE BLOB"
                    + ")";
            stmt.executeUpdate(sql);

            sql = "INSERT INTO temp_tbl_1(VALUE) VALUES(?)";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            
            String value = null;
            value = "GCATCGCAGAGAGTATACAGTACG";
            pstmt.setBytes(1, value.getBytes("UTF-8"));
            assertEquals(1, pstmt.executeUpdate());
            
            value = "ABXCZCBABC";
            pstmt.setBytes(1, value.getBytes("UTF-8"));
            assertEquals(1, pstmt.executeUpdate());
            
            value = "TOKKYOKYOKAKYOKU";
            pstmt.setBytes(1, value.getBytes("UTF-8"));
            assertEquals(1, pstmt.executeUpdate());
            
            pstmt.close();
            
            sql = "SELECT VALUE FROM temp_tbl_1 ORDER BY ID";
            ResultSet rs = stmt.executeQuery(sql);
            assertTrue(rs.next());
            Blob blob = rs.getBlob(1);
            assertNotNull(blob);
            assertEquals(6L, blob.position("GCAGAGAG".getBytes("UTF-8"), 1));
            
            assertTrue(rs.next());
            blob = rs.getBlob(1);
            assertNotNull(blob);
            assertEquals(8L, blob.position("ABC".getBytes("UTF-8"), 1));

            assertTrue(rs.next());
            blob = rs.getBlob(1);
            assertNotNull(blob);
            assertEquals(12L, blob.position("KYOKU".getBytes("UTF-8"), 1));
            assertEquals(-1L, blob.position("KYOKu".getBytes("UTF-8"), 1));
            
            rs.close();
            
            rs.close();
            stmt.close();
            
        } finally {
            conn.close();
        }
    }
}