/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Context;

/**
 * User-Defined function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 */
public abstract class Function {
    protected final String name;
    protected final int argc;
    
    /** pointer of user data  */
    private volatile long pUserData;

    protected Function(String name) {
        this(name, -1);
    }
    
    protected Function(String name, int argc) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.argc = argc;
    }
    
    public String getName() {
        return name;
    }
    
    public int getArgumentCount() {
        return argc;
    }
    
    public boolean isRegistered() {
        return (pUserData != 0);
    }

    /**
     * Called from the sqlite3_step() function.
     * @param context
     * @param argc
     * @param value
     */
    private void xFunc(long context, int argc, long value) {
        Context ctx = null;
        try {
            ctx = new Context(context, argc, value);
            xFunc(ctx);
            
        } catch (Throwable th) {
            if (ctx != null) {
                final String msg = th.toString();
                ctx.resultError((msg != null ? msg : "unknown error."));
                
            } else {
                Logger.getLogger(Function.class.getName()).fine("Exception occurred: " + th.toString());
            }
        }
    }
    
    protected abstract void xFunc(Context ctx) throws SQLException;
}
