/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.text;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class CollatorTest {

    public CollatorTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }


    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";

    private static Database newDatabase() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return new Database(DATABASE, null);
    }
    
    private static Connection newConnection(Database db) throws ClassNotFoundException, SQLException {
        return new JdbcConnection(db, null);
    }

    @Test
    public void createCollation() throws SQLException, ClassNotFoundException {
        final Database db = newDatabase();
        try {
            final Collator myCol
                    = new Collator("myCol") {
                            public int compare(String arg0, String arg1) {
                                System.out.println("arg0 = [" + arg0 + "] / arg1 = [" + arg1 + "]");
                                if (arg0.length() < arg1.length()) {
                                    return -1;
                                } else if (arg0.length() > arg1.length()) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
            assertFalse(myCol.isRegistered());
            db.createCollationSequence(myCol);
            assertTrue(myCol.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT * FROM ("
                        + "SELECT '' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'One' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'Two' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'Three' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'Four' AS NUM "
                        + "UNION ALL "
                        + "SELECT NULL AS NUM "
                        + "UNION ALL "
                        + "SELECT X'5A65726F00' AS NUM "
                    + ") ORDER BY NUM COLLATE myCol ASC";
            ResultSet rs = stmt.executeQuery(sql);
            assertTrue(rs.next());
            assertNull(rs.getString(1));
            assertTrue(rs.next());
            assertEquals("", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("One", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("Two", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("Four", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("Three", rs.getString(1));
            assertTrue(rs.next());
            assertEquals("Zero", rs.getString(1));
            assertFalse(rs.next());
            rs.close();
            
            db.dropCollationSequence(myCol);
            assertFalse(myCol.isRegistered());
            
            stmt.close();
            conn.close();
            
        } finally {
            db.close();
        }        
    }

    @Test(expected = java.sql.SQLException.class)
    public void dropCollation() throws SQLException, ClassNotFoundException {
        final Database db = newDatabase();
        try {
            final Collator myCol
                    = new Collator("myCol") {
                            public int compare(String arg0, String arg1) {
                                System.out.println("arg0 = [" + arg0 + "] / arg1 = [" + arg1 + "]");
                                if (arg0.length() < arg1.length()) {
                                    return -1;
                                } else if (arg0.length() > arg1.length()) {
                                    return 1;
                                }
                                return 0;
                            }
                        };
            assertFalse(myCol.isRegistered());
            db.createCollationSequence(myCol);
            assertTrue(myCol.isRegistered());
            
            final Connection conn = newConnection(db);
            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT * FROM ("
                        + "SELECT '' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'One' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'Two' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'Three' AS NUM "
                        + "UNION ALL "
                        + "SELECT 'Four' AS NUM "
                        + "UNION ALL "
                        + "SELECT NULL AS NUM "
                    + ") ORDER BY NUM COLLATE myCol ASC";
            ResultSet rs = stmt.executeQuery(sql);
            assertTrue(rs.next());
            rs.close();
            
            db.dropCollationSequence(myCol);
            assertFalse(myCol.isRegistered());

            rs = stmt.executeQuery(sql);
            rs.close();
            
            stmt.close();
            conn.close();
            
        } finally {
            db.close();
        }        
    }
    
}