/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Context;

/**
 * User-Defined aggregate function class.
 * @author calico
 * @see <a href="http://sqlite.org/c3ref/create_function.html">Create Or Redefine SQL Functions</a>
 * @see org.sqlite.jdbc.JdbcConnection#registerFunction(Function)
 * @see org.sqlite.jdbc.JdbcConnection#unregisterFunction(Function)
 */
public abstract class AggregateFunction extends Function {
    public AggregateFunction(String name, int argc) {
        super(name, argc);
    }

    public AggregateFunction(String name) {
        super(name);
    }

    @Override
    protected final void xFunc(Context ctx) throws SQLException {
        xStep(ctx);
    }
    
    /**
     * Called from the sqlite3_step() function.
     * @param context
     */
    protected final void xFinal(long context) {
        // TODO Mysaifu JVMのBug#11980が解決したらアクセス修飾子をprivateに戻すこと！
        // @see http://sourceforge.jp/tracker/index.php?func=detail&aid=11980&group_id=1890&atid=7027
        Context ctx = null;
        try {
            ctx = new Context(context);
            xFinal(ctx);
            
        } catch (Throwable th) {
            if (ctx != null) {
                final String msg = th.toString();
                ctx.resultError((msg != null ? msg : "unknown error."));
                
            } else {
                Logger.getLogger(AggregateFunction.class.getName()).fine("Exception occurred: " + th.toString());
            }
        }
    }
    
    public abstract void xStep(Context ctx) throws SQLException;

    public abstract void xFinal(Context ctx) throws SQLException;
}
