package com.ozacc.mail.mailet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ozacc.mail.fetch.ReceivedMail;

/**
 * MailetインスタンスとMatcherインスタンスのリストを持つMailetの実行単位となるクラス。
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: MailetWrapper.java,v 1.1.2.2 2005/01/23 06:47:01 otsuka Exp $
 */
public class MailetWrapper {

	private Mailet mailet;

	private List matcherList;

	/**
	 * コンストラクタ。
	 */
	public MailetWrapper() {
		matcherList = new ArrayList();
	}

	/**
	 * コンストラクタ。
	 * 
	 * @param mailet Mailetインスタンス
	 * @param matcherList Matcherインスタンスのリスト
	 */
	public MailetWrapper(Mailet mailet, List matcherList) {
		this();
		this.mailet = mailet;
		this.matcherList = matcherList;
	}

	/**
	 * リストされているMatcherの条件をクリアしたMailetを実行します。
	 * 
	 * @param mail 受信メール
	 */
	public void execute(ReceivedMail mail) {
		for (Iterator itr = matcherList.iterator(); itr.hasNext();) {
			Matcher m = (Matcher)itr.next();
			if (!m.match(mail)) {
				return;
			}
		}
		mailet.service(mail);
	}

	/**
	 * Mailetインスタンスを返します。
	 * 
	 * @return Mailetインスタンス
	 */
	public Mailet getMailet() {
		return mailet;
	}

	/**
	 * Mailetインスタンスをセットします。
	 * 
	 * @param mailet Mailetインスタンス
	 */
	public void setMailet(Mailet mailet) {
		this.mailet = mailet;
	}

	/**
	 * Matcherインスタンスのリストを返します。
	 * 
	 * @return Matcherインスタンスのリスト
	 */
	public List getMatcherList() {
		return matcherList;
	}

	/**
	 * Matcherインスタンスのリストをセットします。
	 * 
	 * @param matcherList Matcherインスタンスのリスト
	 */
	public void setMatcherList(List matcherList) {
		this.matcherList = matcherList;
	}
}