package com.ozacc.mail;

import java.io.File;

/**
 * メールデータが記述されたファイルからMailインスタンスを生成するインスターフェース。
 * サポートするファイルの種類やメールデータ書式は実装クラスに依存します。
 * 
 * @see com.ozacc.mail.impl.XMLMailBuilderImpl
 * @see com.ozacc.mail.impl.JDomXMLMailBuilder
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: MailBuilder.java,v 1.7 2004/09/17 23:07:01 otsuka Exp $
 */
public interface MailBuilder {

	/**
	 * 指定されたクラスパス上のファイルを読み込んでMailインスタンスを生成します。
	 * 
	 * @param classPath メール内容を記述したファイルのパス
	 * @return 生成されたMailインスタンス
	 * @throws MailBuildException Mailインスタンスの生成に失敗した場合
	 */
	Mail buildMail(String classPath) throws MailBuildException;

	/**
	 * 指定されたファイルを読み込んでMailインスタンスを生成します。
	 * 
	 * @param file メール内容を記述したファイル
	 * @return 生成されたMailインスタンス
	 * @throws MailBuildException Mailインスタンスの生成に失敗した場合
	 */
	Mail buildMail(File file) throws MailBuildException;

}