package com.ozacc.mail.fetch.impl.sk_jp.io;

import junit.framework.TestCase;

public class ByteToCharUTF7Test extends TestCase {

    public void testUtf7Conversion() throws Exception {
        assertConversion(new byte[] { '+', 'A', 'K', 'M', '-' }, "\u00a3");
        // This fails. A bug?
        // assertConversion(new byte[] { '1', '+', '-', '1', '=', '2' }, "1+1=2");
    }

    private void assertConversion(byte[] bytes, String expected)
            throws Exception {
        char[] chars = new char[expected.length()];
        ByteToCharUTF7 decoder = new ByteToCharUTF7();
        int len = decoder.convert(bytes, 0, bytes.length, chars, 0,
                expected.length() + 1);
        assertEquals(expected.length(), len);
        assertEquals(expected, new String(chars));
    }

}
