package com.ozacc.mail.spring;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

import com.ozacc.mail.Mail;
import com.ozacc.mail.mock.EqualityCheck;

/**
 * XMLMailFactoryBeanのTestCase。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailFactoryBeanTest.java,v 1.5 2004/09/17 20:34:31 otsuka Exp $
 */
public class XMLMailFactoryBeanTest extends TestCase {

	Mail mail;

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	public void setUp() throws Exception {
		super.setUp();

		BasicConfigurator.configure();

		mail = new Mail();
		mail.setSubject("XMLMailBuilderのテストケース");
		mail.setText("改行します。\n改行しました。\nテストは成功。");
		mail.setFrom("from@example.com", "差出人");
		mail.setReturnPath("return@example.com");
		mail.setReplyTo("reply@example.com");
		mail.addTo("to1@example.com", "宛先1");
		mail.addTo("to2@example.com");
		mail.addCc("cc1@example.com", "CC1");
		mail.addCc("cc2@example.com");
		mail.addBcc("bcc@example.com");
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public void testMailFactoryBeanClassPathFail() throws Exception {
		mail.addBcc("ccb@example.com");

		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/java/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail");

		assertFalse(EqualityCheck.equals(mail, result));

	}

	public void testMailFactoryBeanClassPath() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/java/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail");

		assertTrue(EqualityCheck.equals(mail, result));
	}

	public void testMailFactoryBeanFilePath() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/java/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail2");

		assertTrue(EqualityCheck.equals(mail, result));
	}

	public void testMailFactoryBeanLocation() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/java/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail3");

		assertTrue(EqualityCheck.equals(mail, result));
	}

	public void testMailFactoryBeanLocationClasspath() throws Exception {
		ApplicationContext context = new FileSystemXmlApplicationContext(
				"src/test/java/com/ozacc/mail/spring/testContext.xml");
		Mail result = (Mail)context.getBean("mail4");

		assertTrue(EqualityCheck.equals(mail, result));
	}

}