package com.ozacc.mail.mock;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.mail.fetch.ReceivedMail;

/**
 * MockFetchMailのテストケース。
 * 
 * @author Tomohiro Otsuka
 * @version $Id: MockFetchMailTest.java,v 1.1.2.2 2005/02/05 09:28:58 otsuka Exp $
 */
public class MockFetchMailTest extends TestCase {

	MockFetchMail mockFetchMail;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();
		mockFetchMail = new MockFetchMail();
	}

	/*
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		BasicConfigurator.resetConfiguration();
	}

	public final void testGetMailsReturnZero() {
		ReceivedMail[] mails = mockFetchMail.getMails();
		assertEquals(0, mails.length);
	}

	public final void testGetMails() {
		ReceivedMail expectedMail = new ReceivedMail();
		expectedMail.setFrom("from@example.net", "差出人");
		expectedMail.addTo("to@example.com", "宛名");
		expectedMail.setSubject("MockFetchMailTest");
		expectedMail.setText("本文");

		mockFetchMail.setupGetMails(expectedMail);

		ReceivedMail[] mails = mockFetchMail.getMails();
		assertEquals("1通受信", 1, mails.length);

		ReceivedMail mail = mails[0];
		assertEquals("差出人", "差出人", mail.getFrom().getPersonal());
		assertEquals("差出人アドレス", "from@example.net", mail.getFrom().getAddress());
		assertEquals("宛先は1つ", 1, mail.getTo().length);
		assertEquals("宛名", "to@example.com", (mail.getTo()[0]).getAddress());
		assertEquals("件名", "MockFetchMailTest", mail.getSubject());
		assertEquals("本文", "本文", mail.getText());
	}

}