package com.ozacc.mail.xml;

import java.io.File;

import org.w3c.dom.Document;

import com.ozacc.mail.Mail;

/**
 * MailインスタンスからXMLドキュメントを生成します。
 * 
 * @see com.ozacc.mail.xml.impl.XMLBuilderImpl
 * @see com.ozacc.mail.xml.impl.JDomXMLBuilder
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: XMLBuilder.java,v 1.2 2004/09/13 07:13:31 otsuka Exp $
 */
public interface XMLBuilder {

	/**
	 * 指定されたMailインスタンスからXMLドキュメントを生成します。
	 * 
	 * @param mail
	 * @return DOM Document
	 * @throws XMLBuildException
	 */
	Document buildDocument(Mail mail) throws XMLBuildException;

	/**
	 * 指定されたMailインスタンスからXMLドキュメントを生成し、
	 * 指定されたファイルに保存します。
	 * 
	 * @param mail
	 * @param destFile MailデータXMLの保存先ファイル
	 * @throws XMLBuildException
	 */
	void saveDocument(Mail mail, File destFile) throws XMLBuildException;

}