unit SetInit;

interface

uses
  Windows, SysUtils, Forms, IniFiles, About;

var
  UserName: string;
  UserFolder: string;
  UserIniFile: TIniFile = nil;
  UserIniReadOnly: Boolean = False;

function LoadAppInit: Boolean;

const
  // AvP[V[g̐ݒ
  IS_USERS = 'Users';
  IS_APPGENERAL = 'General';

  // [U[ʂ̐ݒ
  IS_USER = 'User';
  IS_PADS = 'Pads';
  IS_SOUNDS = 'Sounds';
  IS_RESTRICTIONS = 'Restrictions';
  IS_COMMANDLINE = 'CommandLine';
  IS_ENABLEPLUGINS = 'EnablePlugins';
  IS_DISABLEPLUGINS = 'DisablePlugins';
  IS_PADSZORDER = 'PadsZOrder';
  IS_WINDOWS = 'Windows';
  IS_OPTIONS = 'Options';

  // pbh̐ݒ
  IS_GENERAL = 'General';
  IS_PADOPTIONS = 'PadOptions';

var
  FileNameIni: String;
  FileNameIco: String = 'Icons.dat';


implementation

uses
  InitFld;

function LoadAppInit: Boolean;
var
  SettingForAllUser: Boolean;
  cWork: array[0..255] of Char;
  UserSize: DWORD;
  Ini: TIniFile;
  UserInit: string;
  FindHandle: THandle;
  Win32FindData: TWin32FindData;
  UnknownFileExist: Boolean;
  NewUserFolder: string;
begin
  Result := True;

  // Init@C̖O
  FileNameIni := ExtractFileName(ChangeFileExt(ParamStr(0), '.ini'));


  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
  try
    SettingForAllUser := Ini.ReadBool(IS_APPGENERAL, 'SettingForAllUser', False);

    UserName := 'Default';
    if not SettingForAllUser then
    begin
      // ݂̃[U[擾
      UserSize := 255;
      if GetUserName(cWork, UserSize) then
        UserName := StrPas(cWork)
    end;

    // [U[tH_擾
    UserFolder := Ini.ReadString(IS_USERS, UserName, '');
  finally
    Ini.Free;
  end;

  // JgfBNgړ
  ChDir(ExtractFilePath(ParamStr(0)));

  // [U[ݒt@C
  if UserFolder = '' then
    UserInit := ''
  else
  begin
    // ΃pX擾
    UserFolder := ExpandUNCFileName(UserFolder);
    if not IsPathDelimiter(UserFolder, Length(UserFolder)) then
      UserFolder := UserFolder + '\';
    UserInit := UserFolder + FileNameIni;
  end;

  // [U[ݒt@CȂ
  if not FileExists(UserInit) then
  begin
    if not FileExists(ExtractFilePath(ParamStr(0)) + 'Setup.ini') then
      Application.MessageBox(
        PChar('Special Launch pAɂ肪Ƃ܂B' + #13#10 +
       #13#10 +
       'Special Launch ̐ݒ́ÂƎw肷f[^tH_ɂׂĕۑ܂B' +
       'Special Launch ̐ݒobNAbvꍇ́Ãf[^tH_' +
       't@CׂăobNAbvĂB'),
       'Special Launch', MB_ICONINFORMATION);


    dlgInitFolder := TdlgInitFolder.Create(nil);
    try
      if (OSVersionInfo.dwPlatformId = VER_PLATFORM_WIN32_NT) and
        (OSVersionInfo.dwMajorVersion >= 6) then
        UserFolder := GetEnvironmentVariable('appdata') + '\Special Launch\'
      else
        UserFolder := ExtractFilePath(ParamStr(0)) + UserName + '\';

      dlgInitFolder.edtInitFolder.Text := UserFolder;
      while True do
      begin
        // _CAO̕\
        if dlgInitFolder.ShowModal = idOk then
        begin
          UserFolder := dlgInitFolder.edtInitFolder.Text;

          // JgfBNgړ
          ChDir(ExtractFilePath(ParamStr(0)));

          if not IsPathDelimiter(UserFolder, Length(UserFolder)) then
            UserFolder := UserFolder + '\';
          UserInit := UserFolder + FileNameIni;

          // w̃tH_Ƀ[U[ݒt@C
          if FileExists(UserInit) then
          begin
            if Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                            '" ɂ͂łɐݒ肪܂B̐ݒ𗘗p܂H'),
                                      'mF', MB_ICONQUESTION or MB_YESNO) = idYes then
              Break;
          end
          else if DirectoryExists(UserFolder) then
          begin
            UnknownFileExist := False;
            FindHandle := FindFirstFile(PChar(UserFolder + '*.*'), Win32FindData);
            if FindHandle <> INVALID_HANDLE_VALUE then
            begin
              while True do
              begin
                if (Win32FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
                begin
                  UnknownFileExist := True;
                  Break;
                end;

                if not FindNextFile(FindHandle, Win32FindData) then
                  Break;
              end;
              Windows.FindClose(FindHandle)
            end;

            if UnknownFileExist then
            begin
              if Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                            '" ɂ͂łɐݒȊÕt@C݂Ă܂B' +
                                            '̂܂ܑsĂ낵ł?'),
                                        'mF', MB_ICONQUESTION or MB_YESNO) = idYes then
                Break;
            end
            else
            begin
              if Application.MessageBox(PChar('w̃tH_ "' + UserFolder + '" ɐݒۑ܂B'),
                                        'mF', MB_ICONINFORMATION or MB_OKCANCEL) = idOK then
                Break;
            end;
          end
          else
          begin
            try
              ForceDirectories(UserFolder);
              if DirectoryExists(UserFolder) then
                Break
              else
                Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                             '" ͍쐬ł܂łBtH_w肵ĂB'),
                                    'G[', MB_ICONSTOP);
            except
              Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                           '" ͍쐬ł܂łBtH_w肵ĂB'),
                                    'G[', MB_ICONSTOP);
            end;
          end;

        end
        else
        begin
          Result := False;
          Break;
        end;

      end;

    finally
      dlgInitFolder.Release;
    end;

    if Result then
    begin
      // JgfBNgɂꍇ͑΃pXɒu
      NewUserFolder := UserFolder;
      if Pos(ExtractFilePath(ParamStr(0)), UserFolder) = 1 then
        NewUserFolder := ExtractRelativePath(ExtractFilePath(ParamStr(0)), UserFolder);

      // [U[tH_ۑ
      Ini := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
      try
        try
          Ini.WriteString(IS_USERS, UserName, NewUserFolder);
        except
          Result := False;
          Application.MessageBox(PChar('ݒt@C "' + Ini.FileName + '" ɏ߂܂B'),
                                 'G[', MB_ICONSTOP);
        end;
      finally
        Ini.Free;
      end;
    end;

  end;

  if not Result then
    Exit;




  // [U[ݒt@C쐬
  UserIniFile := TIniFile.Create(UserInit);
  if UserIniFile.ReadString(IS_USER, 'Name', '') = '' then
  begin
    UserIniReadOnly := False;
    try
      UserIniFile.WriteString(IS_USER, 'Name', UserName);
      UserIniFile.UpdateFile;
    except
      Result := False;
      UserIniFile.Free;
      UserIniFile := nil;
      Application.MessageBox(PChar('ݒt@C "' + UserInit +
                                   '" ɏ߂܂B'),
                             'G[', MB_ICONSTOP);
    end;
  end
  else
  begin
    UserIniReadOnly := False;
    FindHandle := FindFirstFile(PChar(UserInit), Win32FindData);
    if FindHandle <> INVALID_HANDLE_VALUE then
    begin
      // ǂݎpiCD-Rj
      if (Win32FindData.dwFileAttributes and FILE_ATTRIBUTE_READONLY) <> 0 then
      begin
        UserIniReadOnly := True;
      end;
      Windows.FindClose(FindHandle)
    end;
    if not UserIniReadOnly then
    begin
      try
        UserIniFile.WriteString(IS_USER, 'Name', UserName);
        UserIniFile.UpdateFile;
      except
        // ݎG[
        UserIniReadOnly := True;
      end;
    end;
  end;


end;

end.
