{-----------------------------------------------------------------------------}
{                                                                             }
{  uDelphi ɂVFvO~OvTvvO                }
{                                                                             }
{  uڎʎqɑ΂鏈v̎                                         }
{                                                                             }
{   Copyright 1998 Masahiro Arai                                              }
{                                                                             }
{-----------------------------------------------------------------------------}
unit pidl;

interface

uses
  Windows, SysUtils, ShellAPI, ShlObj, ActiveX, Classes;

// ڎʎqiXgji[邽߂̃mۂ
function AllocItemID  (Size: integer): PItemIDList;

// ڎʎqiXgj̃TCY߂
function GetItemIDSize(ItemIDList: PItemIDList): integer;

// ڎʎqiXgj̃Rs[쐬
function CopyItemID   (ItemIDList: PItemIDList): PItemIDList;

// ڎʎqiXgjAĐVڎʎq쐬
function ConcatItemID (ItemIDList1, ItemIDList2: PItemIDList):
  PItemIDList;

// ڎʎqXǵu̍ڎʎqv
function GetNextItemID(ItemIDList: PItemIDList): PItemIDList;

// ڎʎqiXgj\擾
function GetItemIDName(Folder: IShellFolder; ItemID: PItemIDList;
  Flags: integer): string;

// t@CVXepXڎʎqiXgjɕϊ
function GetIDListFromPath(Path: string): PItemIDList;

// ڎʎqiXgj\ACR̃CfbNX擾
function GetItemIDIcon(ItemIDList: PItemIDList; Flags: integer):
  integer;

// Q̍ڎʎqr
function CompareItemID(ShellFolder: IShellFolder;
  ItemID1, ItemID2: PItemIDList): Integer;

// ڎʎqXgɊ܂܂鍀ڎʎqXgAbv
// Xg̊evf́AVF[AP[^[ɂĉ邱
function DivItemIDList(ItemIDList: PItemIDList): TList;

var
  Malloc: IMalloc;

implementation

// ڎʎqiXgji[邽߂̃mۂ
function AllocItemID(Size: integer): PItemIDList;
var
  ItemIDList: PItemIDList;
begin
  // ڎʎqiXgji[邽߂̃m
  ItemIDList := Malloc.Alloc(Size);
  // 擾̓e
  if Assigned(ItemIDList) then
    FillChar(ItemIDList^, Size, 0);
  Result := ItemIDList;
end;

// ڎʎqiXgj̃TCY߂
function GetItemIDSize(ItemIDList: PItemIDList): integer;
var
  Total: integer;
begin
  Total := 0;
  if Assigned(ItemIDList) then
  begin
    // ڎʎqԂɌ
    while (ItemIDList^.mkid.cb > 0) do
    begin
      inc(Total, ItemIDList^.mkid.cb);
      ItemIDList := GetNextItemID(ItemIDList);
    end;
    // ڎʎqXg̍Ōɉ^[~l[^[̑傫Z
    Total := Total + SizeOf(ItemIDList^.mkid.cb);
  end;
  Result := Total;
end;

// ڎʎqiXgj̃Rs[쐬
// 󂯎ڎʎqiXgj Malloc.Free(ItemID) p
//   jȂ΂ȂȂ
function CopyItemID(ItemIDList: PItemIDList): PItemIDList;
var
  NewItemID: PItemIDList;
  CopySize: integer;
begin
  // u̍ڎʎqv̓Rs[Ȃ
  Result := nil;
  if not Assigned(ItemIDList) then
    Exit;

  // ڎʎqXg̑傫擾
  CopySize := GetItemIDSize(ItemIDList);
  // m
  NewItemID := AllocItemID(CopySize);
  // ڎʎqXg̃Rs[
  Move(ItemIDList^, NewItemID^, CopySize);
  Result := NewItemID;
end;

// ڎʎqiXgjAĐVڎʎq쐬
// 󂯎ڎʎqiXgj Malloc.Free(ItemID) p
//   jȂ΂ȂȂ
function ConcatItemID(ItemIDList1, ItemIDList2: PItemIDList):
  PItemIDList;
var
  NewItemIDlist: PChar;
  ItemSize1, ItemSize2: integer;
begin
  // Rs[sTCY擾
  if Assigned(ItemIDList1) then
    // ^[~l[^[̓Rs[Ȃ
    ItemSize1 := GetItemIDSize(ItemIDList1)
      - SizeOf(ItemIDList1^.mkid.cb)
  else
    Itemsize1 := 0;
  ItemSize2 := GetItemIDSize(ItemIDList2);

  // VڎʎqXgi[郁̎擾
  NewItemIDList := PChar(AllocItemID(ItemSize1 + ItemSize2));

  // NewItemIDList ͈ȉ̏ŉĤŁA߂l\ߐݒ肷B
  Result := PItemIDList(NewItemIDList);

  // ڎʎqiXgj̃Rs[
  if Assigned(NewItemIDList) then
  begin
    if Assigned(ItemIDList1) then
      Move(ItemIDList1^, NewItemIDList^, ItemSize1);
    // |C^̃ItZbgs
    inc(NewItemIDList, ItemSize1);

    Move(ItemIDList2^, NewItemIDList^, ItemSize2);
  end;
end;

// ڎʎqiXgj\擾
function GetItemIDName(Folder: IShellFolder; ItemID: PItemIDList;
  Flags: integer): string;
var
  StrRet:  TStrRet;
  Chars:   PChar;
begin
  Result := '';
  if (NOERROR = Folder.GetDisplayNameOf(ItemID, Flags, StrRet)) then
  begin
    case StrRet.uType of
      STRRET_WSTR:
      begin
        //PWideChar  string ւ̃Rs[
        Result := StrRet.pOleStr;
      end;

      STRRET_OFFSET:
      begin
        //|C^̃ItZbg
        Chars := PChar(ItemID);
        inc(Chars, StrRet.uOffset);
        //PChar  string ւ̃Rs[
        Result := Chars;
      end;

      STRRET_CSTR:
        //PChar  string ւ̃Rs[
        Result := StrRet.cStr;
    end;
  end;
end;

// ڎʎqXǵu̍ڎʎqv
function GetNextItemID(ItemIDList: PItemIDList): PItemIDList;
var
  NextItemID: PChar;
begin
  // inc păItZbgs߂ PChar ^ɃLXg
  NextItemID := PChar(ItemIDList);

  // |C^̃ItZbgsA̗vfw
  inc(NextItemID, ItemIDList^.mkid.cb);

  if ItemIDList^.mkid.cb = 0 then
    Result := nil
  else
    Result := PItemIDList(NextItemID);
end;

// t@CVXepXڎʎqXgɕϊ
function GetIDListFromPath(Path: string): PItemIDList;
var
  DesktopFolder: IShellFolder;
  WidePath: WideString;
  Eaten, Attributes: Cardinal;
begin
  // fXNgbṽC^tF[X擾
  SHGetDesktopFolder(DesktopFolder);
  // UNICODE ւ̕ϊ
  WidePath := Path;
  // ڎʎqXg擾
  DesktopFolder.ParseDisplayName(0, nil, PWideChar(WidePath), Eaten, Result, Attributes);
end;

// ڎʎqiXgj\ACR̃CfbNX擾
function GetItemIDIcon(ItemIDList: PItemIDList; Flags: integer):
  integer;
var
  SHFileInfo: TSHFileInfo;
begin
  SHGetFileInfo(pchar(ItemIDList), 0, SHFileInfo, Sizeof(TSHFileInfo),
    SHGFI_PIDL or Flags);
  Result := SHFileInfo.iIcon;
end;

// ڎʎqr
function CompareItemID(ShellFolder: IShellFolder;
  ItemID1, ItemID2: PItemIDList): Integer;
begin
  Result := SHORT($FFFF and ShellFolder.CompareIDs(0, ItemID1, ItemID2));
end;

// ڎʎqXgɊ܂܂鍀ڎʎqXgAbv
// Xg̊evf́AVF[AP[^[ɂĉ邱
function DivItemIDList(ItemIDList: PItemIDList): TList;
var
  ItemSize: Integer;
  NewItemID: PItemIDList;
begin
  Result := TList.Create;
  while Assigned(ItemIDList) do
  begin
    // Xg̊evf̃TCY擾
    ItemSize := ItemIDList^.mkid.cb;
    // vfk^[~l[^[łΏI
    if ItemSize = 0 then
      Exit;
    // Kw̍ڂ𒊏o
    NewItemID := AllocItemID(ItemSize+SizeOf(ItemIDList^.mkid.cb));
    Move(ItemIDList^, NewItemID^, ItemSize);
    Result.Add(NewItemID);
    // ̍ڂw
    ItemIDList := GetNextItemID(ItemIDList)
  end;
end;

initialization
  //VFEEAP[^[mۂ
  SHGetMalloc(Malloc);
finalization
  Malloc := nil;
end.

