unit Option;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, SetInit, ImgList, SetPlug, About, SetIcons,
  SetPads, MMSystem, IniFiles, SetBtn;


type
  TdlgOption = class(TForm)
    btnOk: TButton;
    btnCancel: TButton;
    btnApply: TButton;
    PageControl: TPageControl;
    tabGeneral: TTabSheet;
    tabPlugins: TTabSheet;
    lblPlugins: TLabel;
    btnPluginOption: TButton;
    imlPlugins: TImageList;
    btnPluginInfo: TButton;
    lvPlugins: TListView;
    grpIconCache: TGroupBox;
    lblIconCache: TLabel;
    lblNowIconCache: TLabel;
    edtIconCache: TEdit;
    udIconCache: TUpDown;
    btnCacheClear: TButton;
    chkTaskTray: TCheckBox;
    dlgOpen: TOpenDialog;
    btnPluginEnable: TButton;
    btnPluginDisable: TButton;
    gbSound: TGroupBox;
    lblSounds: TLabel;
    cmbSounds: TComboBox;
    edtSoundName: TEdit;
    lblSoundName: TLabel;
    btnSoundTest: TButton;
    btnSoundClear: TButton;
    btnSoundBrowse: TButton;
    tabRestrictions: TTabSheet;
    Label1: TLabel;
    grpRestrictions: TGroupBox;
    chkLockBtnEdit: TCheckBox;
    chkLockPadProperty: TCheckBox;
    chkLockOption: TCheckBox;
    btnLockRestrictions: TButton;
    btnUnlockRestrictions: TButton;
    chkLockBtnDrag: TCheckBox;
    tabUserFolder: TTabSheet;
    Label2: TLabel;
    edtUserFolder: TEdit;
    btnUserFolderReset: TButton;
    btnUserFolderOpen: TButton;
    btnHelp: TButton;
    chkLockPlugin: TCheckBox;
    chkLockBtnFolder: TCheckBox;
    chkVerCheck: TCheckBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCancelClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnPluginOptionClick(Sender: TObject);
    procedure btnPluginInfoClick(Sender: TObject);
    procedure lvPluginsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnCacheClearClick(Sender: TObject);
    procedure cmbSoundsChange(Sender: TObject);
    procedure edtSoundNameChange(Sender: TObject);
    procedure btnSoundClearClick(Sender: TObject);
    procedure btnSoundBrowseClick(Sender: TObject);
    procedure btnSoundTestClick(Sender: TObject);
    procedure btnPluginEnableClick(Sender: TObject);
    procedure btnPluginDisableClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnLockRestrictionsClick(Sender: TObject);
    procedure btnUnlockRestrictionsClick(Sender: TObject);
    procedure chkTaskTrayClick(Sender: TObject);
    procedure chkLockBtnEditClick(Sender: TObject);
    procedure chkLockBtnFolderClick(Sender: TObject);
    procedure chkLockBtnDragClick(Sender: TObject);
    procedure chkLockPadPropertyClick(Sender: TObject);
    procedure chkLockOptionClick(Sender: TObject);
    procedure chkLockPluginClick(Sender: TObject);
    procedure edtIconCacheChange(Sender: TObject);
    procedure PageControlChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure PageControlChange(Sender: TObject);
    procedure btnUserFolderResetClick(Sender: TObject);
    procedure btnUserFolderOpenClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure chkVerCheckClick(Sender: TObject);
  private
    FRestrictionsPassword: String;
    FEnabledApplyBk: Boolean;
    function SaveIni: Boolean;
    procedure EnabledCheck;
  public
    procedure CreateParams(var Params: TCreateParams); override;
  end;

  TSoundFile = class(TObject)
    FileName: String;
  end;

var
  dlgOption: TdlgOption;

implementation

uses Main, Password;

{$R *.DFM}

// CreateParams
procedure TdlgOption.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.WndParent := GetDesktopWindow;
end;


// tH[͂
procedure TdlgOption.FormCreate(Sender: TObject);
var
  Work: String;
  SoundAction: String;
  SoundFile: TSoundFile;
  i: Integer;
  Plugin: TPlugin;
  ListItem: TListItem;
  Icon:TIcon;
  Ini: TIniFile;
begin
  SetClassLong(Handle, GCL_HICON, Application.Icon.Handle);

  with UserIniFile do
  begin
    PageControl.ActivePage := PageControl.Pages[0];

    for i := 0 to lvPlugins.Columns.Count - 1 do
      lvPlugins.Columns[i].Width := ReadInteger('Windows',
        Format('OptionPluginColumns%d', [i]), lvPlugins.Columns[i].Width);

    // XV`FbN
    chkVerCheck.Checked := ReadBool(IS_OPTIONS, 'VerCheck', True);

    // ^XNgC
    chkTaskTray.Checked := ReadBool(IS_OPTIONS, 'TaskTray', True);

    // ACRLbV
    udIconCache.Position := ReadInteger(IS_OPTIONS, 'IconCache', 1000);
    lblNowIconCache.Caption := Format('݂̎gp : %d', [IconCache.CacheCount]);

    // TEh
    for i := 0 to cmbSounds.Items.Count - 1 do
    begin
      SoundFile := TSoundFile.Create;
      cmbSounds.Items.Objects[i] := SoundFile;
      case i of
        0: SoundAction := 'ButtonClick';
        1: SoundAction := 'GroupChange';
        2: SoundAction := 'MoveHide';
        3: SoundAction := 'MoveShow';
      else
        SoundAction := '';
      end;
      if SoundAction <> '' then
      begin
        Work := ReadString('Sounds', SoundAction, '');
        if Work <> '' then
        begin
          SoundFile.FileName := Work;
        end;
      end;
    end;
    cmbSounds.ItemIndex := 0;
    cmbSoundsChange(cmbSounds);

    // 
    chkLockBtnDrag.Checked := ReadBool('Restrictions', 'LockBtnDrag', False);
    chkLockBtnEdit.Checked := ReadBool('Restrictions', 'LockBtnEdit', False);
    chkLockBtnFolder.Checked := ReadBool('Restrictions', 'LockBtnFolder', False);
    chkLockPadProperty.Checked := ReadBool('Restrictions', 'LockPadProperty', False);
    chkLockOption.Checked := ReadBool('Restrictions', 'LockOption', False);
    chkLockPlugin.Checked := ReadBool('Restrictions', 'LockPlugin', False);
    FRestrictionsPassword :=  ReadString('Restrictions', 'Password', '');

    // f[^tH_
    Ini := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
    try
      edtUserFolder.Text := Ini.ReadString('Users', UserName, '');
      if edtUserFolder.Text = '' then
        btnUserFolderReset.Click;
    finally
      Ini.Free;
    end;


    EnabledCheck;
  end;

  // vOC
  lvPlugins.Items.BeginUpdate;
  try
    for i := 0 to Plugins.Count - 1 do
    begin
      Plugin := TPlugin(Plugins.Objects[i]);
      ListItem := lvPlugins.Items.Add;
      ListItem.Caption := Plugin.Name;
      if Plugin.Enabled then
        ListItem.SubItems.Add('N')
      else
        ListItem.SubItems.Add('~');

      ListItem.SubItems.Add(ExtractFileName(Plugin.FileName));
      ListItem.SubItems.Add(GetFileVersionString(Plugin.FileName, True));
      ListItem.Data := Plugin;
      Icon := TIcon.Create;
      try
        Icon.Handle := IconCache.GetIcon(PChar(Plugin.FileName), ftIconPath, 0, False, False);
        ListItem.ImageIndex := imlPlugins.AddIcon(Icon);
      finally
        Icon.Free;
      end;

      if i = 0 then
        ListItem.Focused := True;
    end;
  finally
    lvPlugins.Items.EndUpdate;
  end;
end;

// ۑ
function TdlgOption.SaveIni: Boolean;
var
  i: Integer;
  SoundAction: String;
  Ini: TIniFile;
begin
  Result := True;

  try
    with UserIniFile do
    begin
      // XV`FbN
      WriteBool(IS_OPTIONS, 'VerCheck', chkVerCheck.Checked);

      // ^XNgC
      WriteBool(IS_OPTIONS, 'TaskTray', chkTaskTray.Checked);

      // ACRLbV
      WriteInteger(IS_OPTIONS, 'IconCache', udIconCache.Position);

      // TEh
      for i := 0 to cmbSounds.Items.Count - 1 do
      begin
        case i of
          0: SoundAction := 'ButtonClick';
          1: SoundAction := 'GroupChange';
          2: SoundAction := 'MoveHide';
          3: SoundAction := 'MoveShow';
        else
          SoundAction := '';
        end;

        if SoundAction <> '' then
        begin
          WriteString('Sounds', SoundAction, TSoundFile(cmbSounds.Items.Objects[i]).FileName);
        end;
      end;

      // 
      WriteBool('Restrictions', 'LockBtnDrag', chkLockBtnDrag.Checked);
      WriteBool('Restrictions', 'LockBtnEdit', chkLockBtnEdit.Checked);
      WriteBool('Restrictions', 'LockBtnFolder', chkLockBtnFolder.Checked);
      WriteBool('Restrictions', 'LockPadProperty', chkLockPadProperty.Checked);
      WriteBool('Restrictions', 'LockOption', chkLockOption.Checked);
      WriteBool('Restrictions', 'LockPlugin', chkLockPlugin.Checked);
      WriteString('Restrictions', 'Password', FRestrictionsPassword);

      UpdateFile;
    end;

  except
    Result := False;
    MessageBox(Handle, PChar('ݒt@C "' + UserIniFile.FileName +
                                 '" ɏ߂܂B'),
                           'G[', MB_ICONSTOP);
  end;


  // [U[tH_폜
  if not btnUserFolderReset.Enabled then
  begin
    Ini := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
    try
      try
        Ini.WriteString('Users', UserName, '');
      except
        Result := False;
        Application.MessageBox(PChar('ݒt@C "' + Ini.FileName + '" ɏ߂܂B'),
                               'G[', MB_ICONSTOP);
      end;
    finally
      Ini.Free;
    end;
  end;


  EnabledCheck;
  frmMain.ChangeOptions;

  btnApply.Enabled := False;
end;

// tH[I
procedure TdlgOption.FormDestroy(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to cmbSounds.Items.Count - 1 do
    TSoundFile(cmbSounds.Items.Objects[i]).Free;

  imlPlugins.Clear;
//  UserIniFile.WriteInteger('Windows', 'LastOptionPage', PageControl.ActivePage.PageIndex);
  for i := 0 to lvPlugins.Columns.Count - 1 do
    UserIniFile.WriteInteger('Windows', Format('OptionPluginColumns%d', [i]), lvPlugins.Columns[i].Width);
  UserIniFile.UpdateFile;

  dlgOption := nil;
end;

// 
procedure TdlgOption.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

// O
procedure TdlgOption.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := Enabled;
end;

// tH[
procedure TdlgOption.FormShow(Sender: TObject);
begin
  PageControl.ActivePage.SetFocus;

  btnHelp.Enabled := FileExists(Application.HelpFile);
  btnApply.Enabled := False;
end;

// nj{^
procedure TdlgOption.btnOkClick(Sender: TObject);
begin
  if SaveIni then
    Close;
end;

// LZ{^
procedure TdlgOption.btnCancelClick(Sender: TObject);
begin
  Close;
end;

// Kp{^
procedure TdlgOption.btnApplyClick(Sender: TObject);
begin
  SaveIni;
end;

// ^u؂ւ
procedure TdlgOption.PageControlChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  FEnabledApplyBk := btnApply.Enabled;
end;

// ^u؂ւ
procedure TdlgOption.PageControlChange(Sender: TObject);
begin
  btnApply.Enabled := FEnabledApplyBk;
end;

// I Special Launch ̍XVmF
procedure TdlgOption.chkVerCheckClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;

// ^XNgCɃACR\
procedure TdlgOption.chkTaskTrayClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;

// 炷ʂ̕ύX
procedure TdlgOption.cmbSoundsChange(Sender: TObject);
begin
  FEnabledApplyBk := btnApply.Enabled;
  if cmbSounds.ItemIndex >= 0 then
    edtSoundName.Text := TSoundFile(cmbSounds.Items.Objects[cmbSounds.ItemIndex]).FileName;
  btnApply.Enabled := FEnabledApplyBk;
end;

// TEh̕ύX
procedure TdlgOption.edtSoundNameChange(Sender: TObject);
begin
  if cmbSounds.ItemIndex >= 0 then
  begin
    TSoundFile(cmbSounds.Items.Objects[cmbSounds.ItemIndex]).FileName := edtSoundName.Text;
    btnApply.Enabled := True;
  end;
end;

// TEh̃eXg
procedure TdlgOption.btnSoundTestClick(Sender: TObject);
begin
  if edtSoundName.Text <> '' then
    PlaySound(PChar(edtSoundName.Text), 0, SND_ASYNC);
end;

// TEh̃NA
procedure TdlgOption.btnSoundClearClick(Sender: TObject);
begin
  edtSoundName.Text := '';
end;

// TEh̎Q
procedure TdlgOption.btnSoundBrowseClick(Sender: TObject);
begin
  if FileExists(edtSoundName.Text) then
    dlgOpen.FileName := edtSoundName.Text
  else
    dlgOpen.FileName := '';

  dlgOpen.Filter := 'TEh(*.wav)|*.wav|ׂẴt@C(*.*)|*.*';
  dlgOpen.FilterIndex := 1;

  if dlgOpen.Execute then
    edtSoundName.Text := dlgOpen.FileName;
end;

// ACRLbV
procedure TdlgOption.edtIconCacheChange(Sender: TObject);
begin
  btnApply.Enabled := True;
end;


// ACRLbṼNA
procedure TdlgOption.btnCacheClearClick(Sender: TObject);
begin
  IconCache.Clear;
  Pads.AllArrange;
  lblNowIconCache.Caption := Format('݂̎gp : %d', [IconCache.CacheCount]);
  EnabledCheck
end;



// vOCꗗ̕ύX
procedure TdlgOption.lvPluginsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if Change = ctState then
  begin
    EnabledCheck;
  end;
end;

// vOC̋N
procedure TdlgOption.btnPluginEnableClick(Sender: TObject);
var
  i: Integer;
  Item: TListItem;
begin
  for i := 0 to Pads.Count - 1 do
    Pads[i].ButtonArrangement.Clear;

  Item := lvPlugins.Selected;
  while Item <> nil do
  begin
    TPlugin(Item.Data).Enabled := True;
    if TPlugin(Item.Data).Enabled then
    begin
      Item.SubItems[0] := 'N'
    end
    else
    begin
      MessageBox(Handle, 'vOCNł܂łB', 'mF', MB_ICONWARNING);
      Item.SubItems[0] := '~';
    end;
    Item := lvPlugins.GetNextItem(Item, sdAll, [isSelected]);
  end;
  Plugins.SaveEnabled;
  Pads.AllArrange;
  EnabledCheck;
end;

// vOC̒~
procedure TdlgOption.btnPluginDisableClick(Sender: TObject);
var
  i: Integer;
  Item: TListItem;
begin
  for i := 0 to Pads.Count - 1 do
    Pads[i].ButtonArrangement.Clear;

  Item := lvPlugins.Selected;
  while Item <> nil do
  begin
    TPlugin(Item.Data).Enabled := False;
    if TPlugin(Item.Data).Enabled then
    begin
      MessageBox(Handle, 'vOC~ł܂łB', 'mF', MB_ICONWARNING);
      Item.SubItems[0] := 'N'
    end
    else
      Item.SubItems[0] := '~';
    Item := lvPlugins.GetNextItem(Item, sdAll, [isSelected]);
  end;
  Plugins.SaveEnabled;
  Pads.AllArrange;
  EnabledCheck;
end;

// vOC̐ݒ
procedure TdlgOption.btnPluginOptionClick(Sender: TObject);
var
  i: Integer;
  Plugin: TPlugin;
begin
  if lvPlugins.Selected <> nil then
  begin
    Plugin := lvPlugins.Selected.Data;

    if @Plugin.SLXChangeOptions <> nil then
    begin
      Enabled := False;
      try
        if Plugin.SLXChangeOptions(Handle) then
          for i := 0 to Plugin.Buttons.Count - 1 do
            Plugin.UpdateButton(TButtonInfo(Plugin.Buttons[i]));
      finally
        Enabled := True;
        Show;
      end;
    end;

  end;
end;

// vOC̏
procedure TdlgOption.btnPluginInfoClick(Sender: TObject);
var
  Plugin: TPlugin;
  cWork: array[0..2047] of Char;
  Explanation: String;
begin
  if lvPlugins.Selected <> nil then
  begin

    Plugin := lvPlugins.Selected.Data;
    if Plugin.Enabled then
    begin
      cWork := '';
      if @Plugin.SLXGetExplanation <> nil then
      begin
        Plugin.SLXGetExplanation(cWork, 2048);
        Explanation := cWork;
      end
      else
      begin
        Explanation := '̃vOCɂ͐܂B';
      end;
    end
    else
    begin
      Explanation := '̃vOC͋NĂȂ߁A擾ł܂B';
    end;

    ShowAbout(Plugin.Name, Plugin.FileName, Explanation);
  end;
end;

// {^̃hbO֎~
procedure TdlgOption.chkLockBtnDragClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;

// {^̕ҏW֎~
procedure TdlgOption.chkLockBtnEditClick(Sender: TObject);
begin
  if chkLockBtnEdit.Checked then
  begin
    chkLockBtnDrag.Checked := True;
  end;

  EnabledCheck;
  btnApply.Enabled := True;
end;

// pbh̐ݒ֎~
procedure TdlgOption.chkLockPadPropertyClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;

// Ŝ̐ݒ֎~
procedure TdlgOption.chkLockOptionClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;

// vOC̐ݒ֎~
procedure TdlgOption.chkLockPluginClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;

// 1 ̃tH_J֎~
procedure TdlgOption.chkLockBtnFolderClick(Sender: TObject);
begin
  btnApply.Enabled := True;
end;



// pX[hbN
procedure TdlgOption.btnLockRestrictionsClick(Sender: TObject);
var
  sWork: String;
begin
  if FRestrictionsPassword <> '' then
    Exit;

  dlgPassword := TdlgPassword.Create(Self);
  try
    while True do
    begin
      dlgPassword.edtPassword.Text := '';
      dlgPassword.lblMessage.Caption := 'bNpX[h͂ĂB';
      if dlgPassword.ShowModal = idOk then
      begin
        sWork := dlgPassword.edtPassword.Text;
        dlgPassword.edtPassword.Text := '';
        dlgPassword.lblMessage.Caption := 'mF̂ߍēx͂ĂB';
        if dlgPassword.ShowModal = idOk then
        begin
          if sWork = dlgPassword.edtPassword.Text then
          begin
            FRestrictionsPassword := dlgPassword.edtPassword.Text;
            btnApply.Enabled := True;
            Break;
          end
          else
            MessageBox(Handle, 'pX[hv܂B', 'mF', MB_ICONWARNING);
        end
        else
          Break;
      end
      else
        Break;
    end;

  finally
    dlgPassword.Release;
  end;

  EnabledCheck;

end;

// pX[h
procedure TdlgOption.btnUnlockRestrictionsClick(Sender: TObject);
begin
  dlgPassword := TdlgPassword.Create(Self);
  try
    while True do
    begin
      dlgPassword.edtPassword.Text := '';
      dlgPassword.lblMessage.Caption := '̃bNpX[h͂ĂB';
      if dlgPassword.ShowModal = idOk then
      begin
        if FRestrictionsPassword = dlgPassword.edtPassword.Text then
        begin
          FRestrictionsPassword := '';
          btnApply.Enabled := True;
          Break;
        end
        else
          MessageBox(Handle, 'pX[hႢ܂B', 'mF', MB_ICONWARNING);
      end
      else
        Break;
    end;

  finally
    dlgPassword.Release;
  end;

  EnabledCheck;
end;

procedure TdlgOption.EnabledCheck;
var
  bLockOption: Boolean;
  bLockPlugin: Boolean;
  OneEnabled, OneDisabled: Boolean;
  Item: TListItem;
begin
  bLockOption := UserIniFile.ReadBool('Restrictions', 'LockOption', False);
  bLockPlugin := UserIniFile.ReadBool('Restrictions', 'LockPlugin', False);

  tabGeneral.TabVisible := not bLockOption;
  tabUserFolder.TabVisible := not bLockOption;



  btnCacheClear.Enabled := IconCache.CacheCount > 0;

  grpRestrictions.Enabled := FRestrictionsPassword = '';
  chkLockBtnDrag.Enabled := (FRestrictionsPassword = '') and (not chkLockBtnEdit.Checked);
  chkLockBtnEdit.Enabled := FRestrictionsPassword = '';
  chkLockPadProperty.Enabled := FRestrictionsPassword = '';
  chkLockOption.Enabled := FRestrictionsPassword = '';
  chkLockPlugin.Enabled := FRestrictionsPassword = '';
  chkLockBtnFolder.Enabled := FRestrictionsPassword = '';
  btnLockRestrictions.Enabled := FRestrictionsPassword = '';
  btnUnlockRestrictions.Enabled := FRestrictionsPassword <> '';

  OneEnabled := False;
  OneDisabled := False;
  Item := lvPlugins.Selected;
  while Item <> nil do
  begin
    OneEnabled := OneEnabled or TPlugin(Item.Data).Enabled;
    OneDisabled := OneDisabled or (not TPlugin(Item.Data).Enabled);
    Item := lvPlugins.GetNextItem(Item, sdAll, [isSelected]);
    if OneEnabled and OneDisabled then
      Break;
  end;
  btnPluginEnable.Enabled := OneDisabled and not bLockPlugin;
  btnPluginDisable.Enabled := OneEnabled and not bLockPlugin;

  btnPluginOption.Enabled := (lvPlugins.SelCount = 1) and not OneDisabled;
  btnPluginInfo.Enabled := (lvPlugins.SelCount = 1) and not OneDisabled;

end;

// f[^tH_ύX
procedure TdlgOption.btnUserFolderResetClick(Sender: TObject);
begin
  btnUserFolderReset.Enabled := False;
  btnUserFolderOpen.Enabled := False;

  edtUserFolder.Enabled := False;
  edtUserFolder.Text := 'f[^tH_͎NɎw肵܂B';
  btnApply.Enabled := True;
end;

// f[^tH_J
procedure TdlgOption.btnUserFolderOpenClick(Sender: TObject);
var
  NormalButton: TNormalButton;
begin
  if not btnUserFolderOpen.Enabled then
    Exit;

  NormalButton := TNormalButton.Create;
  try
    NormalButton.FileName := edtUserFolder.Text;
    OpenNormalButton(Handle, NormalButton);
  finally
    NormalButton.Free;
  end;

end;

// wv
procedure TdlgOption.btnHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTEXT, 4);
end;

end.
