unit OleData;

interface

uses
  Windows, ActiveX, Classes, ShellAPI, ShlObj, SysUtils;

type
  PFormatList = ^TFormatList;
  TFormatList = array[0..0] of TFormatEtc;

  TEnumFormatEtc = class(TInterfacedObject, IEnumFormatEtc)
  private
    FFormatList: PFormatList;
    FFormatCount: Integer;
    FIndex: Integer;
  public
    constructor Create(FormatList: PFormatList;
      FormatCount, Index: Integer);
    { IEnumFormatEtc Œ`Ă郁\bh                        }
    function Next(celt: Longint; out elt; pceltFetched: PLongint):
      HResult; stdcall;
    function Skip(celt: Longint): HResult; stdcall;
    function Reset: HResult; stdcall;
    function Clone(out enum: IEnumFormatEtc): HResult; stdcall;
  end;

  TDataObject = class(TInterfacedObject, IDataObject)
  private
    FFormatList: PFormatList;
    FFormatCount: Integer;

    { IDataObject Œ`Ă郁\bh                           }
    function GetData(const formatetcIn: TFormatEtc;
      out medium: TStgMedium): HResult; virtual; stdcall;
    function GetDataHere(const formatetc: TFormatEtc;
      out medium: TStgMedium): HResult; virtual; stdcall;
    function QueryGetData(const formatetc: TFormatEtc): HResult;
      virtual; stdcall;
    function GetCanonicalFormatEtc(const formatetc: TFormatEtc;
      out formatetcOut: TFormatEtc): HResult; virtual; stdcall;
    function SetData(const formatetc: TFormatEtc;
      var medium: TStgMedium; fRelease: BOOL): HResult; virtual;
      stdcall;
    function EnumFormatEtc(dwDirection: Longint; out enumFormatEtc:
      IEnumFormatEtc): HResult; virtual; stdcall;
    function DAdvise(const formatetc: TFormatEtc; advf: Longint;
      const advSink: IAdviseSink; out dwConnection: Longint): HResult;
      virtual; stdcall;
    function DUnadvise(dwConnection: Longint): HResult; virtual;
      stdcall;
    function EnumDAdvise(out enumAdvise: IEnumStatData): HResult;
      virtual; stdcall;
  protected
    function GetMedium(const FormatEtc: TFormatEtc; var Medium: TStgMedium;
      CreateMedium: Boolean): HResult; virtual; abstract;
  public
    constructor Create(AFormatList: PFormatList;
      AFormatCount: Integer);
    destructor Destroy; override;
  end;

implementation

// IEnumFormatEtc
constructor TEnumFormatEtc.Create(FormatList: PFormatList;
  FormatCount, Index: Integer);
begin
  inherited Create;
  FFormatList := FormatList;
  FFormatCount := FormatCount;
  FIndex := Index;
end;

// ݂̃CfbNXX^[gĎw肳ꂽ FORMATETC \̂Ԃ܂
function TEnumFormatEtc.Next(celt: Longint; out elt;
  pceltFetched: PLongint): HResult;
var
  I: Integer;
begin
  I := 0;
  // FORMATETC \̂ celt 񋓂
  while (I < celt) and (FIndex < FFormatCount) do
  begin
    TFormatList(elt)[I] := FFormatList[FIndex];
    Inc(FIndex);
    Inc(I);
  end;
  // 񋓂Ԃ
  if pceltFetched <> nil then
    pceltFetched^ := I;
  // vꂽ FORMATETC \̂̐ƁA񋓂Ȃ S_OK
  if I = celt then
    Result := S_OK
  else
    Result := S_FALSE;
end;

// ̃\bh́Aw肳ꂽFORMATETC \̂̃XgXLbv܂B
function TEnumFormatEtc.Skip(celt: Longint): HResult;
begin
  if celt <= FFormatCount - FIndex then
  begin
    FIndex := FIndex + celt;
    Result := S_OK;
  end else
  begin
    FIndex := FFormatCount;
    Result := S_FALSE;
  end;
end;

function TEnumFormatEtc.Reset: HResult;
begin
  FIndex := 0;
  Result := S_OK;
end;

function TEnumFormatEtc.Clone(out enum: IEnumFormatEtc): HResult;
begin
  enum := TEnumFormatEtc.Create(FFormatList, FFormatCount, FIndex);
  Result := S_OK;
end;

// IDataObject ̎                                               }
constructor TDataObject.Create(AFormatList: PFormatList;
  AFormatCount: Integer);
var
  CopySize: Integer;
begin
  inherited Create;
  { IuWFNg TFormatEtc \̂̃Xg̃Rs[mۂB }
  FFormatCount := AFormatCount;
  CopySize := SizeOf(TFormatList) * FFormatCount;
  GetMem(FFormatList, CopySize);
  CopyMemory(FFormatList, AFormatList, CopySize);
end;

destructor TDataObject.Destroy;
begin
  { IuWFNgɊmۂ TFormatEtc \̂̃XgB }
  FreeMem(FFormatList);
  inherited Destroy;
end;

{ wLfBAgĎw`̃f[^WJB               }
function TDataObject.GetData(
  const formatetcIn: TFormatEtc;    { f[^߂߂Ɏg`     }
  out medium: TStgMedium            { LfBAւ̃|C^       }
  ): HResult; stdcall;
begin
  { lFw肳ꂽfBA̓T|[gł܂                   }
  Result := DV_E_FORMATETC;

  { \̂̏                                                   }
  medium.tymed := 0;
  medium.hGlobal := 0;
  medium.UnkForRelease := nil;

  try
    { T|[g\Ȍ`ł邩mF                           }
    if (S_OK = QueryGetData(formatetcIn)) then
      { ]fBA TDataObject hNX쐬B    }
      Result := GetMedium(formatetcIn, medium, TRUE);
  except
    { G[ꍇB                                         }
    Result := E_UNEXPECTED;
  end;
end;

{ w肳ꂽmۍς݋L}̂Ƀf[^WJ                       }
function TDataObject.GetDataHere(const formatetc: TFormatEtc;
  out medium: TStgMedium): HResult; stdcall;
begin
  { lFw肳ꂽfBA̓T|[gł܂                   }
  Result := DV_E_FORMATETC;         { = DATA_E_FORMATETC (Win16)     }
  try
    { T|[g\Ȍ`ł邩mF                           }
    if (S_OK = QueryGetData(formatetc)) then
      { ]fBA TDataObject hNX쐬B    }
      Result := GetMedium(formatetc, medium, FALSE);
  except
    { G[ꍇB                                         }
    Result := E_UNEXPECTED;
  end;
end;

{ formatetc  GetData ɓnꍇA邩𔻒fB@@}
function TDataObject.QueryGetData(
  const formatetc: TFormatEtc         { f[^󂯎邽߂̌`   }
  ): HResult; stdcall;
var
  i: integer;
begin
  { lFw肳ꂽfBA̓T|[głȂ }
  Result := DV_E_FORMATETC;

  { IuWFNgɊmۂ TFormatEtc \̂̃XgƔrB }
  for i := 0 to FFormatCount - 1 do
    if (formatetc.cfFormat = FFormatList^[i].cfFormat) and
       (formatetc.dwAspect = FFormatList^[i].dwAspect) and
       Bool(formatetc.tymed and FFormatList^[i].tymed) then
      begin
        Result := NOERROR;
        Break;
      end;
end;

{ \foCXɌŗLȓWJsȂȂꍇ̎               }
function TDataObject.GetCanonicalFormatEtc(
  const formatetc: TFormatEtc; out formatetcOut: TFormatEtc): HResult;
  stdcall;
begin
  formatetcOut := formatetc;
  formatetcOut.ptd := nil;
  Result := DATA_S_SAMEFORMATETC;
end;

{ ̎ɂẮÅ֐̓T|[gȂ                     }
function TDataObject.SetData(
  const formatetc: TFormatEtc;
  var medium: TStgMedium;
  fRelease: BOOL): HResult; stdcall;
begin
  Result := E_NOTIMPL;
end;

{ GetData \bhŃf[^擾邽߂ɗp\Ȍ`񋓂B }
function TDataObject.EnumFormatEtc(
  dwDirection: Longint;               { f[^肷     }
  out enumFormatEtc: IEnumFormatEtc   { 񋓃IuWFNg̲̪    }
  ): HResult; stdcall;
begin
  Result := E_NOTIMPL;
  enumFormatEtc := nil;

  if dwDirection = DATADIR_GET then
  begin
    { TFormatEtc \̂ IEnumFormatEtc C^tF[X      }
    { IuWFNg쐬                                         }
    enumFormatEtc :=
      TEnumFormatEtc.Create(FFormatList, FFormatCount, 0);
    if Assigned(enumFormatEtc) then
      Result := S_OK;
  end
end;

{ ̊֐̓T|[gȂ                                           }
function TDataObject.DAdvise(const formatetc: TFormatEtc;
  advf: Longint; const advSink: IAdviseSink;
  out dwConnection: Longint): HResult; stdcall;
begin
  Result := OLE_E_ADVISENOTSUPPORTED;
end;

{ ̊֐̓T|[gȂ                                           }
function TDataObject.DUnadvise(dwConnection: Longint): HResult;
  stdcall;
begin
  Result := OLE_E_ADVISENOTSUPPORTED;
end;

{ ̊֐̓T|[gȂ                                           }
function TDataObject.EnumDAdvise(out enumAdvise: IEnumStatData):
  HResult; stdcall;
begin
  Result := OLE_E_ADVISENOTSUPPORTED;
end;

initialization
  OleInitialize(nil);               { OLE Cȕs   }
finalization
  OleFlushClipboard;
  OleUninitialize;                  { OLE Cȕ   }
end.
