unit SetInit;

interface

uses
  Windows, SysUtils, Forms, IniFiles;

var
  UserName: string;
  UserFolder: string;
  UserIniFile: TIniFile = nil;

function LoadAppInit: Boolean;

const
  IS_GENERAL = 'General';
  IS_OPTIONS = 'Options';
  IS_PADOPTIONS = 'PadOptions';


var
  FileNameIni: String;
  FileNameIco: String = 'Icons.dat';


implementation

uses
  InitFld;

function LoadAppInit: Boolean;
var
  cWork: array[0..255] of Char;
  UserSize: DWORD;
  Ini: TIniFile;
  UserInit: string;
  FindHandle: THandle;
  Win32FindData: TWin32FindData;
  UnknownFileExist: Boolean;
begin
  Result := True;

  // Init@C̖O
  FileNameIni := ExtractFileName(ChangeFileExt(ParamStr(0), '.ini'));


  // ݂̃[U[擾
  UserSize := 255;
  if not GetUserName(cWork, UserSize) then
    cWork := '';
  if cWork = '' then
    cWork := 'Default';
  UserName := StrPas(cWork);

  // [U[tH_擾
  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
  try
    UserFolder := Ini.ReadString('Users', UserName, '');
  finally
    Ini.Free;
  end;

  // [U[ݒt@C
  if UserFolder = '' then
    UserInit := ''
  else
  begin
    if not IsPathDelimiter(UserFolder, Length(UserFolder)) then
      UserFolder := UserFolder + '\';
    UserInit := UserFolder + FileNameIni;
  end;

  // [U[ݒt@CȂ
  if not FileExists(UserInit) then
  begin
    if not FileExists(ExtractFilePath(ParamStr(0)) + 'Setup.ini') then
      Application.MessageBox(
        PChar('Special Launch pAɂ肪Ƃ܂B' + #13#10 +
       #13#10 +
       'Special Launch ̐ݒ́ÂƎw肷f[^tH_ɂׂĕۑ܂B' +
       'Special Launch ̐ݒobNAbvꍇ́Ãf[^tH_' +
       't@CׂăobNAbvĂB'),
       'Special Launch', MB_ICONINFORMATION);


    dlgInitFolder := TdlgInitFolder.Create(nil);
    try
      UserFolder := ExtractFilePath(ParamStr(0)) + UserName;
      if not IsPathDelimiter(UserFolder, Length(UserFolder)) then
        UserFolder := UserFolder + '\';

      while True do
      begin

        // _CAO̕\
        dlgInitFolder.edtInitFolder.Text := UserFolder;
        if dlgInitFolder.ShowModal = idOk then
        begin
          UserFolder := dlgInitFolder.edtInitFolder.Text;

          if not IsPathDelimiter(UserFolder, Length(UserFolder)) then
            UserFolder := UserFolder + '\';
          UserInit := UserFolder + FileNameIni;

          // w̃tH_Ƀ[U[ݒt@C
          if FileExists(UserInit) then
          begin
            if Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                            '" ɂ͂łɐݒ肪܂B̐ݒ𗘗p܂H'),
                                      'mF', MB_ICONQUESTION or MB_YESNO) = idYes then
              Break;
          end
          else if DirectoryExists(UserFolder) then
          begin
            UnknownFileExist := False;
            FindHandle := FindFirstFile(PChar(UserFolder + '*.*'), Win32FindData);
            if FindHandle <> INVALID_HANDLE_VALUE then
            begin
              while True do
              begin
                if (Win32FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
                begin
                  UnknownFileExist := True;
                  Break;
                end;

                if not FindNextFile(FindHandle, Win32FindData) then
                  Break;
              end;
              Windows.FindClose(FindHandle)
            end;

            if UnknownFileExist then
            begin
              if Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                            '" ɂ͂łɐݒȊÕt@C݂Ă܂B' +
                                            '̂܂ܑsĂ낵ł?'),
                                        'mF', MB_ICONQUESTION or MB_YESNO) = idYes then
                Break;
            end
            else
            begin
              if Application.MessageBox(PChar('w̃tH_ "' + UserFolder + '" ɐݒۑ܂B'),
                                        'mF', MB_ICONINFORMATION or MB_OKCANCEL) = idOK then
                Break;
            end;
          end
          else
          begin
            try
              ForceDirectories(UserFolder);
              if DirectoryExists(UserFolder) then
                Break
              else
                Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                             '" ͍쐬ł܂łBtH_w肵ĂB'),
                                    'G[', MB_ICONSTOP);
            except
              Application.MessageBox(PChar('w̃tH_ "' + UserFolder +
                                           '" ͍쐬ł܂łBtH_w肵ĂB'),
                                    'G[', MB_ICONSTOP);
            end;
          end;

        end
        else
        begin
          Result := False;
          Break;
        end;

      end;

    finally
      dlgInitFolder.Release;
    end;

    // [U[tH_ۑ
    Ini := TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
    try
      try
        Ini.WriteString('Users', UserName, UserFolder);
      except
        Result := False;
        Application.MessageBox(PChar('ݒt@C "' + Ini.FileName + '" ɏ߂܂B'),
                               'G[', MB_ICONSTOP);
      end;
    finally
      Ini.Free;
    end;
    
  end;

  if not Result then
    Exit;




  // [U[ݒt@C쐬
  UserIniFile := TIniFile.Create(UserInit);
  try
    UserIniFile.WriteString('User', 'Name', UserName);
    UserIniFile.UpdateFile;
  except
    Result := False;
    UserIniFile.Free;
    UserIniFile := nil;
    Application.MessageBox(PChar('ݒt@C "' + UserInit +
                                 '" ɏ߂܂B'),
                           'G[', MB_ICONSTOP);
  end;

end;

end.
