unit PlugFunc;

interface

uses
  Windows, SysUtils, Graphics, IniFiles, Option, PlugBtns, Cal, Memo, Forms;

// \ ----------------------------------------------------------------------
type

  // {^̏
  PSLXButtonInfo = ^TSLXButtonInfo;
  TSLXButtonInfo = packed record
    Name: array[0..63] of Char; // {^
    IconIndex: Integer;         // `@\Ȃꍇ̃ACRCfbNX
    OwnerDraw: BOOL;            // `@\=True
    UpdateInterval: Integer;    // f[^̍XV܂ł̊Ԋu(~0.1b)
    OwnerChip: BOOL;            // Ǝ`bv@\=True
  end;

  // j[̏
  PSLXMenuInfo = ^TSLXMenuInfo;
  TSLXMenuInfo = packed record
    Name: array[0..63] of Char; // j[
    SCut: array[0..63] of Char; // V[gJbgL[
  end;


// Sʂ̊֐ ------------------------------------------------------------------

// vOC̖OԂ
function SLXGetName(Name: PChar; Size: Word): BOOL; stdcall;
// vOC̐Ԃ
function SLXGetExplanation(Explanation: PChar; Size: Word): BOOL; stdcall;
// vOCgpłݒt@C炤
function SLXSetInitFile(InitFile: PChar): BOOL; stdcall;
// vOCJn
function SLXBeginPlugin: BOOL; stdcall;
// vOCI
function SLXEndPlugin: BOOL; stdcall;
// ݒ_CAOĂяo
function SLXChangeOptions(hWnd: HWND): BOOL; stdcall;


// {^p֐ ----------------------------------------------------------------

// {^̏(PSLXButtonInfo)XɕԂ
function SLXGetButton(No: Integer; ButtonInfo: PSLXButtonInfo): BOOL; stdcall;
// {^ꂽƂ̏
function SLXButtonClick(No: Integer; hWnd: HWND): BOOL; stdcall;
// {^`
function SLXButtonDraw(No: Integer; DC: HDC; ARect: PRect): BOOL; stdcall;
// {^XV
function SLXButtonUpdate(No: Integer): BOOL; stdcall;
// {^̓Ǝ`bv擾
function SLXButtonChip(No: Integer; Value: PChar; Size: Word): BOOL; stdcall;

// j[p֐ --------------------------------------------------------------

// j[̏(PSLXMenuInfo)XɕԂ
function SLXGetMenu(No: Integer; MenuInfo: PSLXMenuInfo): BOOL; stdcall;
// j[IꂽƂ̏
function SLXMenuClick(No: Integer; hWnd: HWND): BOOL; stdcall;
// j[Ƀ`FbNtĂ邩Ԃ
function SLXMenuCheck(No: Integer): BOOL; stdcall;


const
  // vOC̖O
  PLUGIN_NAME = 'J_[Ǝv';
  // vOC̐
  PLUGIN_EXPRANATION =
      #13#10
    + 'J_[ƎvvOC' + #13#10
    + '________________________________________________' + #13#10
    + '                           Copyright(C)1996-2002' + #13#10
    + '              SAWADA Shigeru All rights reserved.' + #13#10
    + '                             E : c';

  // {^
  BUTTON_COUNT = 2;

  // {^`
  BUTTON_INFO: array[0..BUTTON_COUNT-1] of TSLXButtonInfo =
  (
    (
      Name:           'J_[';       // {^
      IconIndex:      0;                  // `@\Ȃꍇ̃ACRCfbNX
      OwnerDraw:      True;               // `@\=True
      UpdateInterval: 50;                 // f[^̍XV܂ł̊Ԋu(~0.1b)
      OwnerChip:      True;               // Ǝ`bv@\=True
    ),
    (
      Name:           'v';             // {^
      IconIndex:      0;                  // `@\Ȃꍇ̃ACRCfbNX
      OwnerDraw:      True;               // `@\=True
      UpdateInterval: 10;                 // f[^̍XV܂ł̊Ԋu(~0.1b)
      OwnerChip:      True;               // Ǝ`bv@\=True
    )
  );


  // j[
  MENU_COUNT = 1;

  // j[`
  MENU_INFO: array[0..MENU_COUNT-1] of TSLXMenuInfo =
  (
    (
      Name: 'J_[(&L)';     // {^
      SCut: 'Ctrl+L';                   // V[gJbgL[
    )
  );


implementation

// vOC̖OԂ
function SLXGetName(Name: PChar; Size: Word): BOOL;
begin
  Result := True;
  StrPCopy(Name, Copy(PLUGIN_NAME, 1, Size - 1));
end;

// vOC̐Ԃ
function SLXGetExplanation(Explanation: PChar; Size: Word): BOOL;
begin
  Result := True;
  StrPCopy(Explanation, Copy(PLUGIN_EXPRANATION, 1, Size - 1));
end;

// vOCgpłݒt@C炤
function SLXSetInitFile(InitFile: PChar): BOOL;
begin
  Result := True;
  InitFileName := StrPas(InitFile);
  DataFileName := ChangeFileExt(InitFileName, '.dat');
end;

// vOCJn
function SLXBeginPlugin: BOOL;
var
  Ini: TMemIniFile;
begin
  Ini := TMemIniFile.Create(InitFileName);
  try
    if Ini.ReadBool('Calendar', 'Visible', False) then
    begin
      if frmCal = nil then
        frmCal := TfrmCal.Create(nil);
      frmCal.Show;
    end;

    ADigital := Ini.ReadBool('Watch', 'Digital', False);

  finally
    Ini.Free;
  end;

  UpdateDayInfo(True);
  UpdateTimeInfo;
  Result := True;
end;

// vOCI
function SLXEndPlugin: BOOL;
var
  Ini: TMemIniFile;
begin
  Ini := TMemIniFile.Create(InitFileName);
  try
    Ini.WriteBool('Calendar', 'Visible', frmCal <> nil);
    Ini.WriteBool('Watch', 'Digital', ADigital);
    Ini.UpdateFile;
  finally
    Ini.Free;
  end;

  if frmCal <> nil then
    frmCal.Close;

  Result := frmCal = nil;
end;

// ݒ_CAOĂяo
function SLXChangeOptions(hWnd: HWND): BOOL;
begin
  dlgOption := TdlgOption.CreateOwnedForm(nil, hWnd);
  try
    Result := dlgOption.ShowModal = idOk;
  finally
    dlgOption.Release;
  end;
end;

// {^̏(PSLXButtonInfo)XɕԂ
function SLXGetButton(No: Integer; ButtonInfo: PSLXButtonInfo): BOOL;
begin
  case No of
    0..BUTTON_COUNT-1:
    begin
      Result := True;
      ButtonInfo^ := BUTTON_INFO[NO];
    end;
  else
    Result := False;
  end;
end;

// {^ꂽƂ̏
function SLXButtonClick(No: Integer; hWnd: HWND): BOOL;
begin
  case No of
    0:
    begin
      if frmCal = nil then
      begin
        frmCal := TfrmCal.Create(nil);
        frmCal.Show;
      end
      else
        frmCal.Close;
      Result := True;
    end;
    1:
    begin
      ADigital := not ADigital;
      Result := True;
    end;
  else
    Result := False;
  end;
end;



// {^`
function SLXButtonDraw(No: Integer; DC: HDC; ARect: PRect): BOOL;
var
  Canvas: TCanvas;
begin
  case No of
    0:
    begin
      Canvas := TCanvas.Create;
      Canvas.Handle := DC;
      DrawDate(Canvas, ARect^);
      Canvas.Free;
      Result := True;
    end;
    1:
    begin
      Canvas := TCanvas.Create;
      Canvas.Handle := DC;
      DrawWatch(Canvas, ARect^);
      Canvas.Free;
      Result := True;
    end;
  else
    Result := False;
  end;
end;

// {^XV
function SLXButtonUpdate(No: Integer): BOOL;
begin
  Result := False;
  case No of
    0:
    begin
      Result := UpdateDayInfo(False);
    end;
    1:
    begin
      Result := UpdateTimeInfo;
    end;
  end;
end;

// {^̓Ǝ`bv擾
function SLXButtonChip(No: Integer; Value: PChar; Size: Word): BOOL;
var
  S: String;
begin
  case No of
    0:
    begin
      S := ChipStr;
      StrPCopy(Value, Copy(S, 1, Size - 1));
      Result := True;
    end;
    1:
    begin
      S := FormatDateTime('tt', Now);
      StrPCopy(Value, Copy(S, 1, Size - 1));
      Result := True;
    end;

  else
    Result := False;
  end;
end;


// j[̏(PSLXMenuInfo)XɕԂ
function SLXGetMenu(No: Integer; MenuInfo: PSLXMenuInfo): BOOL;
begin
  case No of
    0..MENU_COUNT-1:
    begin
      Result := True;
      MenuInfo^ := MENU_INFO[No];
    end;
  else
    Result := False;
  end;
end;

// j[IꂽƂ̏
function SLXMenuClick(No: Integer; hWnd: HWND): BOOL;
begin
  case No of
    0:
    begin
      if frmCal = nil then
      begin
        frmCal := TfrmCal.Create(nil);
        frmCal.Show;
      end
      else
        frmCal.Close;
      Result := True;
    end;
  else
    Result := False;
  end;
end;

// j[Ƀ`FbNtĂ邩Ԃ
function SLXMenuCheck(No: Integer): BOOL;
begin
  case No of
    0:
      Result := frmCal <> nil;
  else
    Result := False;
  end;
end;



end.
