﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SpeechCast
{
    public partial class FormCaption : Form
    {
        public FormCaption()
        {
            InitializeComponent();
        }

        public static FormCaption Instance;

        private bool borderVisible = false;
        public bool BorderVisible
        {
            set
            {
                borderVisible = value;
                this.Refresh();
            }
            get
            {
                return this.borderVisible;
            }
        }

        private void FormCaption_Paint(object sender, PaintEventArgs e)
        {
            if (borderVisible)            
            {
                //枠描画
                Rectangle rect = this.ClientRectangle;

                rect.Inflate(new Size(-2, -2));
                e.Graphics.DrawRectangle(new Pen(Brushes.YellowGreen, 4), rect);
            }

            {
                //タイトル描画
                e.Graphics.FillRectangle(Brushes.LightPink, drawRect);
                e.Graphics.DrawRectangle(new Pen(Color.Black), drawRect);
                Rectangle stringRect = drawRect;
                stringRect.Inflate(-1, -1);

                e.Graphics.DrawString("SpeechCast", this.Font, Brushes.Black, stringRect);
            }


            if (CaptionText != "")
            {
                //字幕描画   

                Rectangle captionRect = this.ClientRectangle;

                const int offsetY = 7;
                captionRect.Y = offsetY;
                captionRect.Height -= offsetY;

                captionRect.Inflate(-10, -10);
                DrawCaption(e.Graphics, captionRect, CaptionText, FormMain.UserConfig.CaptionFont);


            }
        }

        public static void DrawCaption(Graphics g, Rectangle captionRect, string captionText, CaptionFont captionFont)
        {
            System.Drawing.Font font = captionFont.CreateFont();

            List<Point> offsets = new List<Point>();

            for (int i = 0; i < captionFont.BorderSize; i++)
            {
                offsets.Add(new Point(i, -captionFont.BorderSize + i));
                offsets.Add(new Point(captionFont.BorderSize - i, i));
                offsets.Add(new Point(-i, captionFont.BorderSize - i));
                offsets.Add(new Point(-captionFont.BorderSize + i, -i));
            }
            foreach (Point ofs in offsets)
            {
                Rectangle borderRect = captionRect;

                borderRect.X += ofs.X;
                borderRect.Y += ofs.Y;

                g.DrawString(captionText, font, Brushes.Navy, borderRect);
            }

            g.DrawString(captionText, font, Brushes.White, captionRect); 

        }


        private Rectangle drawRect = new Rectangle(0, 0, 60, 14);


        //public CaptionFont CaptionFont
        //{
        //    get
        //    {
        //        return this.captionFont;
        //    }
        //}

        private string captionText = "";
        public string CaptionText
        {
            get
            {
                return this.captionText;
            }
            set
            {
                if (captionText != value)
                {
                    captionText = value;
                    this.Refresh();
                }
            }

        }

        //protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        //{
        //    if (base.ProcessCmdKey(ref msg, keyData) == false)
        //    {
        //        FormMain.Instance.SendMessage(ref msg);
        //    }
        //    return true;
        //}

        #region WindowProc

        const int WM_NCHITTEST = 0x84;
        const int HTCAPTION = 2;
        const int HTTOP = 12;
        const int HTTOPLEFT = 13;
        const int HTTOPRIGHT = 14;
        const int HTLEFT = 10;
        const int HTRIGHT = 11;
        const int HTBOTTOM = 15;
        const int HTBOTTOMLEFT = 16;
        const int HTBOTTOMRIGHT = 17;
        const int HTCLIENT = 1;
        //HTBORDER          18        可変枠を持たない境界線上にある
        //HTBOTTOM          15        可変枠の下辺境界線上にある
        //HTBOTTOMLEFT      16        同、左下隅にある
        //HTBOTTOMRIGHT     17        同、右下隅にある
        //HTCAPTION          2        キャプションバー上にある
        //HTCLIENT           1        クライアント領域内にある
        //HTERROR          (-2)       デスクトップ上にあり、警告音を鳴らす
        //HTGROWBOX          4        = HTSIZE
        //HTHSCROOL          6        水平スクロールバーないある
        //HTLEFT            10        可変枠の左辺境界線上にある
        //HTMENU             5        メニューバー内にある
        //HTMINBUTTON        8        アイコン化ボタン上にある
        //HTMAXBUTTON        9        最大化ボタン上にある
        //HTNOWHERE          0        デスクトップ上にある
        //HTREDUCE                    = HTMINBUTTON
        //HTRIGHT           11        可変枠の右辺境界線上にある
        //HTSIZE             4        サイズボックス内にある
        //HTSYSMENU          3        システムメニュー内にある
        //HTTOP             12        可変枠の上辺境界線上にある
        //HTTOPLEFT         13        可変枠の左上隅にある
        //HTTOPRIGHT        14        可変枠の右上隅にある
        //HTTRANSPARENT    (-1)       同じスレッドの別のウィンドウの下にある
        //HTVSCROLL          7        垂直スクロールバー内にある
        //HTZOOM                      = HTMAXBUTTON
        const int HitBorderSize = 8; //実際の表示より大きめに

        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case WM_NCHITTEST:
                    {
                        short x = (short)(((uint)m.LParam) & 0xffff);
                        short y = (short)(((uint)m.LParam) >> 16);
                        Point pt = new Point(x, y);
                        pt = this.PointToClient(pt);

                        if (pt.X <= drawRect.Width && pt.Y <= drawRect.Height)
                        {
                            m.Result = (IntPtr)HTCAPTION;
                            break;;
                        }

                        int hit = HTCLIENT;
                        int hitY = HTCLIENT;

                        if (pt.Y <= HitBorderSize)
                        {
                            hitY = HTTOP;
                        }
                        else if (pt.Y >= Height - HitBorderSize)
                        {
                            hitY= HTBOTTOM;
                        }

                        if (pt.X <= HitBorderSize)
                        {
                            if (hitY == HTBOTTOM)
                            {
                                hit = HTBOTTOMLEFT;
                            }
                            else if (hitY == HTTOP)
                            {
                                hit = HTTOPLEFT;
                            }
                            else
                            {
                                hit = HTLEFT;
                            }
                        }
                        else if (pt.X >= Width - HitBorderSize)
                        {
                            if (hitY == HTBOTTOM)
                            {
                                hit = HTBOTTOMRIGHT;
                            }
                            else if (hitY == HTTOP)
                            {
                                hit = HTTOPRIGHT;
                            }
                            else
                            {
                                hit = HTRIGHT;
                            }
                        }
                        else
                        {
                            hit = hitY;
                        }
                        m.Result = (IntPtr)hit;
                    }
                    break;
                default:
                    base.WndProc(ref m);
                    break;
            }
        }
        #endregion

    }
}
