﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace SpeechCast
{
    class Response
    {
        public string Text = null;
        public string RawText = null;
        public string Html = null;

        public int Number = -1;
        public string Name = null;
        public string MailAddress = null;
        public string DateTime = null;
        public string ThreadTitle = null;
        public string ID = null;
        public int ScrollY = 0;
        public static BBSStyle Style;

        static Regex jbbsRegex = new Regex(@"^(\d+)<>(.*)<>(.*)<>(.+)<>(.*)<>(.*)<>(.*)");
        //static Regex yyRegex = new Regex(@"^(.+)<>(.*)<>(\d\d/\d\d/\d\d \d\d:\d\d:\d\d)\s*(.*)<>(.*)<>(.*)");
        static Regex yyRegex = new Regex(@"^(.+)<>(.*)<>(.*)\s*(.*)<>(.*)<>(.*)");

        public enum BBSStyle
        {
            /// <summary>
            /// jbbs(したらば)形式
            /// </summary>
            jbbs,
            /// <summary>
            /// yyかきこ形式
            /// </summary>
            yykakiko,
            /// <summary>
            /// 2ch形式
            /// </summary>
            nichan,
        }

        public Response()
        {
        }

        public bool SetRawText(string rawText)
        {
            this.RawText = rawText;
            Match m;

            switch (Style)
            {
                case BBSStyle.jbbs:
                    m = jbbsRegex.Match(rawText);

                    if (m.Success)
                    {
                        //this.Number = System.Convert.ToInt32(m.Groups[1].Value);
                        this.Name = ConvertToText(m.Groups[2].Value);
                        this.MailAddress = ConvertToText(m.Groups[3].Value);
                        this.DateTime = m.Groups[4].Value;

                        this.Text = ConvertToText(m.Groups[5].Value);



                        this.ThreadTitle = m.Groups[6].Value;
                        this.ID = m.Groups[7].Value;

                        //HTMLコンバートは最後に行う
                        this.Html = ConvertToHtml(m.Groups[5].Value);

                        return true;
                    }

                    break;
                case BBSStyle.yykakiko:
                case BBSStyle.nichan:
                    m = yyRegex.Match(rawText);
                    if (m.Success)
                    {
                        //this.Number = System.Convert.ToInt32(m.Groups[1].Value);
                        this.Name = ConvertToText(m.Groups[1].Value);
                        this.MailAddress = ConvertToText(m.Groups[2].Value);
                        this.DateTime = m.Groups[3].Value;

                        this.Text = ConvertToText(m.Groups[5].Value);



                        this.ThreadTitle = m.Groups[6].Value;
                        this.ID = m.Groups[4].Value;

                        //HTMLコンバートは最後に行う
                        this.Html = ConvertToHtml(m.Groups[5].Value);

                        return true;
                    }
                    break;
            }

            return false;
        }

        public ListViewItem CreateListViewItem()
        {
            ListViewItem item = new ListViewItem();

            item.Text = Number.ToString();
            item.SubItems.Add(Name);
            item.SubItems.Add(Text);
            item.Tag = this;
            return item;
        }

        static Regex toTextRegexBr = new Regex("<br>", RegexOptions.IgnoreCase);
        static Regex toTextRegexHref = new Regex("<a\\s+href=\".+?\".+?>(.+?)</a>", RegexOptions.IgnoreCase);
        static Regex toTextRegexFont = new Regex("<font.+?>(.+?)</font>", RegexOptions.IgnoreCase);
        static MatchEvaluator toTextMatchEvalGroup1 = new MatchEvaluator(ReplaceGroup1);

        private static string ConvertToText(string content)
        {
            content = toTextRegexHref.Replace(content, toTextMatchEvalGroup1);
            content = toTextRegexFont.Replace(content, toTextMatchEvalGroup1);
            content = toTextRegexBr.Replace(content, "\n");
            try
            {
                content = HttpUtility.HtmlDecode(content);
            }
            catch //(Exception ex)
            {
                //Decodeできない文字列がある?
                //AddLog("cannot decode:{0}", content);
            }

            return content;
        }

        private string ConvertToHtml(string content)
        {
            content = toTextRegexHref.Replace(content, toTextMatchEvalGroup1); //リンクははずす

            string id = "";

            if (Style == BBSStyle.jbbs)
            {
                id = "ID:" + this.ID;
            }

            string headerHtml = string.Format("<a name=\"res{0}\"</a><table border=0 bgcolor=\"#CCCCCC\"><tr><td><font color=\"#000000\">{0}: <a href=\"mailto:{1}\">{2}</a>: {3} {4} </font></td></tr></table>"
                , this.Number
                , this.MailAddress
                , this.Name
                , this.DateTime
                , id);

            return string.Format("{0}<blockquote>{1}</blockquote>", headerHtml, content);
        }

        private static string ReplaceGroup1(Match m)
        {
            return m.Groups[1].Value;
        }


    }
}
