import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class ExternalURLTests extends SpaceCardModelTestCase {
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		assertTrue ModelUtils.flush(p1)
		
		def e1 = WorkCardExternalURL.create(
				[creator:sv,
				 url:'http://www.wingnest.com/']
				 )
		p1.add(e1)		 
		assertNotNull "1", e1
		assertTrue "2", ModelUtils.flush(e1)
		assertNotNull "3", e1.createdDate
		assertEquals  "4", e1.creator, sv
		assertTrue    "5", p1.urls?.size() == 1
		assertTrue "6", e1.remove()
		assertTrue "7", p1.urls?.size() == 0			
    }
}
